/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.NettyMode;
import com.blixx.agent.SocketFactory;
import com.blixx.log.RTLogger;
import com.blixx.shared.BM;
import com.blixx.shared.Cryptor;
import com.blixx.shared.Interval;
import com.blixx.shared.os.SystemUtils;
import com.blixx.shared.utils.SortedProperties;
import com.blixx.shared.utils.StrUtils;
import com.boom.SocketUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class AProperties {
    public static final String LOGFILE_PREFIX = "BOOMAgent_";
    private static final String PROTOCOL_VERSION = "PROTOCOL_VERSION";
    public static final String SOCKET = "SOCKET";
    public static final String TLS = "TLS";
    public static final String HTTPS = "HTTPS";
    public static final String HTTP = "HTTP";
    @Deprecated
    public static final String WEBSOCKET = "WEBSOCKET";
    public static final String WEBSOCKET_ONLY = "WEBSOCKET_ONLY";
    public static final String WEBSOCKET_TLS_ONLY = "WEBSOCKET_TLS_ONLY";
    private static final String HB_INTERVAL = "HB_INTERVAL";
    private static final String HB_CTIMEOUT = "HB_CTIMEOUT";
    private static final String HB_RECONNECT = "HB_RECONNECT";
    private static final String HB_RTIMEOUT = "HB_RTIMEOUT";
    private static final String DISABLED = "DISABLED";
    private static final String PRE_CONFIG_IP = "FIXED_IP";
    private static final String PRE_CONFIG_NAME = "FIXED_NAME";
    private static final String MAIN_SERVER_IP = "MAIN_SERVER_IP";
    private static final String MAIN_SERVER_NAME = "MAIN_SERVER_NAME";
    private static final String MAIN_SERVER_IP_MASK = "MAIN_SERVER_IP_MASK";
    private static final String MAIN_SERVER_PORT = "MAIN_SERVER_PORT";
    private static final String MAIN_SERVER_WS_PORT = "MAIN_SERVER_WS_PORT";
    private static final String BACKUP_SERVER_NAME = "BACKUP_SERVER_NAME";
    private static final String BACKUP_SERVER_IP = "BACKUP_SERVER_IP";
    private static final String BACKUP_SERVER_IP_MASK = "BACKUP_SERVER_IP_MASK";
    private static final String BACKUP_SERVER_PORT = "BACKUP_SERVER_PORT";
    private static final String BACKUP_SERVER_WS_PORT = "BACKUP_SERVER_WS_PORT";
    private static final String CLUSTER_NODES = "CLUSTER_NODES";
    public static final int MAX_CONFIG_FILES_COUNT = 5;
    public static final String VERSIONED_CONFIG_FILE_NAME_PREFIX = BM.CONFFILE + "_";
    private static final String MAX_BUFFERED_MESSAGES = "MAX_BUFFERED_MESSAGES";
    private static final String MAX_BUFFERED_PERFRECS = "MAX_BUFFERED_PERFRECS";
    private static final String AGENT_ID = "AGENT_ID";
    private static final String AGENT_HOST = "AGENT_HOST";
    private static final String AGENT_IP = "AGENT_IP";
    private static final String AGENT_PORT = "AGENT_PORT";
    public static final String AGENT_TLS_PORT = "AGENT_TLS_PORT";
    private static final String MODE = "MODE";
    private static final String CLONING_SUPPORT = "CLONING_SUPPORT";
    private static final String MAX_SYM_MONITOR_CALLS = "MAX_SYM_MONITOR_CALLS";
    private static final String OFFER_DATA_TO_ANY_CLUSTER_NODE = "OFFER_DATA_TO_ANY_CLUSTER_NODE";
    private static final String LOGLEVEL = "LOGLEVEL";
    private static final String LOGDIR = "LOGDIR";
    private static final String LOGCOUNT = "LOGCOUNT";
    private static final String LOGSIZE = "LOGSIZE";
    private static final String ACTIONS_ENABLED = "ACTIONS_ENABLED";
    private static final String MSD_MAX_PER_MINUTE = "MSD_MAX_PER_MINUTE";
    private static final String MSD_BLOCK_MINUTES = "MSD_BLOCK_MINUTES";
    private static final String MSD_QUARANTINE_MINUTES = "MSD_QUARANTINE_MINUTES";
    private static final String COMM_TYPE = "COMM_TYPE";
    private static final String PROXY_TYPE = "PROXY_TYPE";
    private static final String PROXY_HOST = "PROXY_HOST";
    private static final String PROXY_PORT = "PROXY_PORT";
    private static final String PROXY_USER = "PROXY_USER";
    private static final String PROXY_PASS = "PROXY_PASS";
    private static final String PROXY_EnPASS = "PROXY_EnPASS";
    private static final String WAIT_SERVER_SOCKET_SECONDS = "WAIT_SERVER_SOCKET_SECONDS";
    private static final String BKP_IFACE_ENABLED = "BKP_IFACE_ENABLED";
    private static final String BKP_IFACE_START = "BKP_IFACE_START";
    private static final String BKP_IFACE_STOP = "BKP_IFACE_STOP";
    private static final String BKP_IFACE_TIME_THRESHOLD = "BKP_IFACE_TIME_THRESHOLD";
    private static final String NO_DEPLOY_ALLOWED = "NO_DEPLOY_ALLOWED";
    private static final String KEEP_CONNECTION_OPEN = "KEEP_CONNECTION_OPEN";
    private static final String MAX_MONITORSERIES_SIZE = "MAX_MONITORSERIES_SIZE";
    @Deprecated
    private static final String FT_PORT = "FT_PORT";
    @Deprecated
    private static final String WS_PORT = "WS_PORT";
    private static final String WS_PORT_AGENT = "WS_PORT_AGENT";
    @Deprecated
    private static final String FT_PROTOCOL = "FT_PROTOCOL";
    @Deprecated
    private static final String WS_PROTOCOL = "WS_PROTOCOL";
    private static final String FT_DIR = "FT_DIR";
    private static final String FT_TIMEOUT_MINS = "FT_TIMEOUT_MINS";
    private static final String KS_PASS = "KS_PASS";
    private static final String KS_PASS_ENCODED = "KS_PASS_ENCODED";
    private static final String KS_FILE = "KS_FILE";
    private static final String TS_PASS = "TS_PASS";
    private static final String TS_PASS_ENCODED = "TS_PASS_ENCODED";
    private static final String TS_FILE = "TS_FILE";
    private static final String NETTY_MODE = "NETTY_MODE";
    private static final String AGENT_CERT_EXPIRATION_THRESHOLD_DAYS = "AGENT_CERT_EXPIRATION_THRESHOLD_DAYS";
    private static final int DEFAULT_AGENT_CERT_EXPIRATION_THRESHOLD_DAYS = 30;
    private static final String EXT_AGT_INFO = "AGT_EXT_INFO";
    public static final String DUMP_CONF_SEC = "DUMP_CONF_SEC";
    public static final Set<String> MANDATORY_PROPERTIES = new HashSet<String>(Arrays.asList("MAIN_SERVER_NAME", "MAIN_SERVER_IP", "COMM_TYPE"));
    public static final String ATM_MODE_PROP_NAME = "BOOM_AGENT_ATM_MODE";
    private final Set<String> allHostnames = new LinkedHashSet<String>();
    private final Set<String> allIPs = new LinkedHashSet<String>();
    public static String DIR = ".";
    private int maxBufferedMessages = 3000;
    private int maxBufferedPerfRecs = 100;
    private boolean isDisabled = false;
    private boolean useFixIP = false;
    private boolean useFixHostname = false;
    private final SortedProperties sortedProperties = new SortedProperties();
    public static final String m_version = "5.11.0";
    private String thisHostIP = null;
    private int agentPort = BM.AGENT_PORT;
    private String thisHostName = null;
    private String oldMainServerHost = null;
    private final boolean atmMode;
    private String mainServerHost = null;
    private String mainServerIP = null;
    private String mainServerIPMask = "";
    private int mainServerPort = BM.SERVER_PORT;
    private Integer mainServerWsPort = null;
    private String backupServerIP = null;
    private String backupServerHost = null;
    private String backupServerIPMask = null;
    private Integer backupServerPort = null;
    private Integer backupServerWsPort = null;
    private final List<String> clusterNodes = new ArrayList<String>();
    private int mode = 8;
    private int maxSymMonitors = 30;
    private String agentID = null;
    private String agentOS = null;
    private int hbInterval = 5;
    private boolean isCloningSupported = false;
    private int logLevel = 1;
    private int logCount = 7;
    private long logSize = 0xA00000L;
    private String logDir = ".";
    private String sentClonedMessage = null;
    private boolean isActionsEnabled = true;
    private int msdMaxPerMinute = 0;
    private int msdBlockMin = 0;
    private int msdQuarantineMin = 0;
    private int hbConnectTimeoutMs = 10000;
    private int hbReadTimeoutMs = 10000;
    private int hbMaxReconnectToSlave = 5;
    private boolean offerDataToAnyClusterNode = false;
    private String commType = "SOCKET";
    private int protocolVersion = 2;
    private String proxyType = null;
    private String proxyHost = null;
    private int proxyPort = 0;
    private String proxyUser = null;
    private String proxyEnPass = null;
    private Integer wsAgentPort = 23027;
    private String ftDir = null;
    private Integer ftTimeOut = null;
    private int maxWaitServerSocketSec = 0;
    private Boolean bkpIfaceEnabled = null;
    private String bkpIfaceStart = null;
    private String bkpIfaceStop = null;
    private Interval bkpTimeThreshold = null;
    private Boolean deploymentAllowed = null;
    private Boolean keepConnection = null;
    private Integer maxMonitorSeriesSize = null;
    private Integer agentTlsPort = 23031;
    private String ksPassEncoded = null;
    private String ksFile = null;
    private String tsPassEncoded = null;
    private String tsFile = null;
    private NettyMode nettyMode = NettyMode.OFF;
    private int agentCertExpirationThresholdDays;
    private boolean isAgtExtInfo = true;
    private Integer dumpConfigSec = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AProperties(String dir) throws IOException {
        boolean resaveNeeded = false;
        DIR = dir;
        String genUUID = UUID.randomUUID().toString();
        this.agentOS = SystemUtils.osNameStr + ' ' + SystemUtils.osNameFullStr;
        this.atmMode = this.detectATMMode();
        File configDir = new File(dir);
        if (!configDir.exists()) {
            try {
                Files.createDirectories(configDir.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                RTLogger.print(1, "Error creating directories: " + dir, e);
            }
        }
        if (configDir.exists() && configDir.isDirectory()) {
            this.loadLatestValidPropertyFile(configDir);
            this.initLogging(configDir);
            resaveNeeded = this.applyLoadedProperties(genUUID);
        } else {
            RTLogger.storeConfig();
        }
        if (this.isCloningSupported && this.agentID.equals(genUUID) && AProperties.checkIfCloned(this.thisHostIP, this.thisHostName)) {
            this.sentClonedMessage = "Clone detected. Old ID=" + this.agentID + " new ID=" + genUUID;
            this.agentID = genUUID;
            resaveNeeded = true;
        }
        if (!this.useFixIP) {
            try {
                this.thisHostIP = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                RTLogger.print(5, "Error getting LocalHost IP: ", e);
                this.thisHostIP = "127.0.0.1";
            }
            finally {
                RTLogger.print(3, "Resolved Local IP: " + this.thisHostIP);
            }
        } else {
            try (Socket s = new Socket();){
                InetSocketAddress bindpoint = new InetSocketAddress(this.getAgentIP(), 0);
                s.bind(bindpoint);
            }
            catch (Exception e) {
                RTLogger.print(1, "FIXED_IP can't be used! IP: " + this.getAgentIP(), e);
                RTLogger.print(1, "Agent will try to use FIXED_IP, but default socket will be used as fallback.");
            }
        }
        if (!this.useFixHostname) {
            this.resolveHostname();
        }
        if (resaveNeeded || genUUID.equals(this.agentID)) {
            this.save();
        }
        this.checkNetworkInterfaces();
    }

    private void loadLatestValidPropertyFile(File confDir) throws IOException {
        List<File> candidates = this.findConfigFileCandidates(confDir);
        for (File candidate : candidates) {
            if (!this.loadCandidateFile(candidate)) continue;
            return;
        }
        throw new RuntimeException("Configuration file not found. " + confDir.getCanonicalPath());
    }

    private boolean loadCandidateFile(File candidate) throws IOException {
        boolean loaded = false;
        byte[] configBytes = Files.readAllBytes(candidate.toPath());
        SortedProperties tempProperties = new SortedProperties();
        try (ByteArrayInputStream inStream = new ByteArrayInputStream(configBytes);){
            tempProperties.load(inStream);
        }
        if (this.isValidProperties(tempProperties)) {
            inStream = new ByteArrayInputStream(configBytes);
            var6_6 = null;
            try {
                this.sortedProperties.load(inStream);
                loaded = true;
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
            finally {
                if (inStream != null) {
                    if (var6_6 != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        inStream.close();
                    }
                }
            }
        }
        return loaded;
    }

    private List<File> findConfigFileCandidates(File confDir) {
        List<File> candidates = Collections.emptyList();
        File initialConfigFile = AProperties.getInitialConfigFile(confDir);
        if (this.isAtmMode()) {
            List<Integer> suffixes = this.getConfFileSuffixesSortedDesc(confDir);
            candidates = suffixes.stream().map(suffix -> AProperties.getCandidateFile(confDir, suffix)).filter(File::canRead).collect(Collectors.toList());
            if (initialConfigFile.exists() && initialConfigFile.canRead()) {
                candidates.add(initialConfigFile);
            }
        } else if (initialConfigFile.exists() && initialConfigFile.canRead()) {
            candidates = Collections.singletonList(initialConfigFile);
        }
        return candidates;
    }

    public static File getInitialConfigFile(File confDir) {
        return new File(confDir, BM.CONFFILE);
    }

    public static File getCandidateFile(File confDir, Integer suffix) {
        return new File(confDir, VERSIONED_CONFIG_FILE_NAME_PREFIX + suffix);
    }

    private int getNextConfSuffix(File confDir) {
        List<Integer> confFileSuffixes = this.getConfFileSuffixesSortedDesc(confDir);
        int nextSuffix = confFileSuffixes.isEmpty() ? 0 : confFileSuffixes.get(0) + 1;
        return nextSuffix;
    }

    private List<Integer> getConfFileSuffixesSortedDesc(File confDir) {
        File[] files;
        ArrayList<Integer> suffixes = new ArrayList<Integer>();
        for (File file : files = confDir.listFiles((dir, name) -> name.startsWith(VERSIONED_CONFIG_FILE_NAME_PREFIX))) {
            String suffix = file.getName().substring(VERSIONED_CONFIG_FILE_NAME_PREFIX.length());
            try {
                suffixes.add(Integer.parseInt(suffix));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        suffixes.sort(Comparator.reverseOrder());
        return suffixes;
    }

    private boolean isValidProperties(SortedProperties tempProperties) {
        return MANDATORY_PROPERTIES.stream().map(tempProperties::getProperty).noneMatch(value -> value == null || value.trim().isEmpty());
    }

    private boolean applyLoadedProperties(String genUUID) {
        String maxMSSize;
        String valKCO;
        String maxPerfs;
        String fileTransferDir;
        String wsAgentPortStr;
        String agtTlsPort;
        String agentPort;
        String serverPort;
        boolean resaveNeeded = false;
        if (this.sortedProperties.remove("Version") != null) {
            resaveNeeded = true;
        }
        if (this.sortedProperties.remove("VERSION") != null) {
            resaveNeeded = true;
        }
        if (this.sortedProperties.remove("VER") != null) {
            resaveNeeded = true;
        }
        String modeStr = this.sortedProperties.getProperty(MODE, "0");
        this.mode = Integer.parseInt(modeStr.trim());
        String maxMonCalls = this.sortedProperties.getProperty(MAX_SYM_MONITOR_CALLS, "30");
        this.maxSymMonitors = Integer.parseInt(maxMonCalls);
        this.mainServerIP = this.sortedProperties.getProperty(MAIN_SERVER_IP, "");
        this.mainServerIPMask = this.sortedProperties.getProperty(MAIN_SERVER_IP_MASK, "");
        this.mainServerHost = this.sortedProperties.getProperty(MAIN_SERVER_NAME, "localhost");
        if (this.mainServerIP.isEmpty()) {
            try {
                this.mainServerIP = InetAddress.getByName(this.mainServerHost).getHostAddress();
            }
            catch (Exception e) {
                String sb = "MAIN_SERVER_IP parameter is not defined in the config file and MAIN_SERVER_NAME have unresolved hostname: " + this.mainServerHost + ". Please check your DNS settings, or define correct IP for parameter: " + MAIN_SERVER_IP;
                RTLogger.print(1, sb);
            }
        }
        this.agentID = this.sortedProperties.getProperty(AGENT_ID, genUUID);
        if (this.agentID.isEmpty() || this.agentID.trim().isEmpty()) {
            this.agentID = genUUID;
        }
        if ((serverPort = this.sortedProperties.getProperty(MAIN_SERVER_PORT, "" + this.mainServerPort)) != null) {
            try {
                this.mainServerPort = Integer.parseInt(serverPort.trim());
            }
            catch (NumberFormatException e) {
                RTLogger.print(1, "Incorrect MAIN_SERVER_PORT");
            }
        }
        this.backupServerHost = this.sortedProperties.getProperty(BACKUP_SERVER_NAME);
        this.backupServerIP = this.sortedProperties.getProperty(BACKUP_SERVER_IP);
        this.backupServerIPMask = this.sortedProperties.getProperty(BACKUP_SERVER_IP_MASK);
        String bsp = this.sortedProperties.getProperty(BACKUP_SERVER_PORT, "" + this.backupServerPort);
        if (bsp != null) {
            try {
                this.backupServerPort = Integer.parseInt(bsp.trim());
            }
            catch (NumberFormatException e) {
                RTLogger.print(1, "Incorrect BACKUP_SERVER_PORT");
            }
        }
        if ((agentPort = this.sortedProperties.getProperty(AGENT_PORT, "" + this.agentPort)) != null) {
            try {
                this.agentPort = Integer.parseInt(agentPort.trim());
            }
            catch (NumberFormatException e) {
                RTLogger.print(1, "Incorrect AGENT_PORT");
            }
        }
        if ((agtTlsPort = this.sortedProperties.getProperty(AGENT_TLS_PORT)) != null) {
            try {
                this.agentTlsPort = Integer.parseInt(agtTlsPort.trim());
            }
            catch (NumberFormatException e) {
                RTLogger.print(1, "Incorrect AGENT_TLS_PORT");
            }
        }
        if ((wsAgentPortStr = this.sortedProperties.getProperty(WS_PORT_AGENT)) != null) {
            try {
                this.wsAgentPort = Integer.parseInt(wsAgentPortStr.trim());
            }
            catch (NumberFormatException e) {
                RTLogger.print(1, "Incorrect WS_PORT_AGENT");
            }
        }
        this.checkWsPort(this.sortedProperties, i -> {
            this.mainServerWsPort = i;
        }, MAIN_SERVER_WS_PORT, WS_PORT, FT_PORT);
        this.checkWsPort(this.sortedProperties, i -> {
            this.backupServerWsPort = i;
        }, BACKUP_SERVER_WS_PORT, WS_PORT, FT_PORT);
        String fileTransferTimout = this.sortedProperties.getProperty(FT_TIMEOUT_MINS, "1");
        if (fileTransferTimout != null) {
            try {
                this.ftTimeOut = Integer.parseInt(fileTransferTimout.trim());
            }
            catch (NumberFormatException e) {
                RTLogger.print(1, "Incorrect FT_TIMEOUT_MINS");
            }
        }
        if (AProperties.isValidPath(fileTransferDir = this.sortedProperties.getProperty(FT_DIR, this.ftDir))) {
            if (fileTransferDir.isEmpty()) {
                fileTransferDir = ".";
            }
            this.ftDir = fileTransferDir;
        } else {
            RTLogger.print(1, "Incorrect value for FT_DIR read value is : " + fileTransferDir);
            RTLogger.print(1, "Setting defaut value for FT_DIR : " + this.ftDir);
            try {
                File defaultFtDir = new File(this.ftDir);
                Files.createDirectories(defaultFtDir.toPath(), new FileAttribute[0]);
            }
            catch (Exception ex) {
                RTLogger.print(1, "Cannot create FT_DIR for : " + this.ftDir);
            }
        }
        String maxMessages = this.sortedProperties.getProperty(MAX_BUFFERED_MESSAGES, "3000");
        if (maxMessages != null) {
            try {
                this.maxBufferedMessages = Integer.parseInt(maxMessages.trim());
            }
            catch (NumberFormatException e) {
                RTLogger.print(1, "Incorrect MAX_BUFFERED_MESSAGES");
            }
        }
        if ((maxPerfs = this.sortedProperties.getProperty(MAX_BUFFERED_PERFRECS, "100")) != null) {
            try {
                this.maxBufferedPerfRecs = Integer.parseInt(maxPerfs.trim());
            }
            catch (NumberFormatException e) {
                RTLogger.print(1, "Incorrect MAX_BUFFERED_PERFRECS");
            }
        }
        String disabled = this.sortedProperties.getProperty(DISABLED, "false");
        this.isDisabled = Boolean.parseBoolean(disabled);
        String offerToAnyCluster = this.sortedProperties.getProperty(OFFER_DATA_TO_ANY_CLUSTER_NODE, "false");
        this.offerDataToAnyClusterNode = Boolean.parseBoolean(offerToAnyCluster);
        String hbInterval = this.sortedProperties.getProperty(HB_INTERVAL, "5");
        try {
            this.hbInterval = Integer.parseInt(hbInterval.trim());
        }
        catch (Exception e) {
            RTLogger.print(1, "Incorrect value for HB_INTERVAL");
        }
        String hbcto = this.sortedProperties.getProperty(HB_CTIMEOUT, "10000");
        try {
            this.hbConnectTimeoutMs = Integer.parseInt(hbcto.trim());
        }
        catch (Exception e) {
            RTLogger.print(1, "Incorrect value for HB_CTIMEOUT");
        }
        String hbrto = this.sortedProperties.getProperty(HB_RTIMEOUT, "10000");
        try {
            this.hbReadTimeoutMs = Integer.parseInt(hbrto.trim());
        }
        catch (Exception e) {
            RTLogger.print(1, "Incorrect value for HB_RTIMEOUT");
        }
        String hbReconnet = this.sortedProperties.getProperty(HB_RECONNECT, "5");
        try {
            this.hbMaxReconnectToSlave = Integer.parseInt(hbReconnet.trim());
        }
        catch (Exception e) {
            RTLogger.print(1, "Incorrect value for HB_RTIMEOUT");
        }
        String cloningSupport = this.sortedProperties.getProperty(CLONING_SUPPORT, "false");
        try {
            this.isCloningSupported = Boolean.parseBoolean(cloningSupport.toLowerCase());
        }
        catch (Exception e) {
            RTLogger.print(1, "Incorrect value for CLONING_SUPPORT");
        }
        String clusterNodes = this.sortedProperties.getProperty(CLUSTER_NODES, "");
        if (!clusterNodes.isEmpty()) {
            String[] nodes = clusterNodes.split("\\s*,\\s*");
            this.clusterNodes.addAll(Arrays.asList(nodes));
        }
        String preconfIP = this.sortedProperties.getProperty(PRE_CONFIG_IP, "false");
        try {
            this.useFixIP = Boolean.parseBoolean(preconfIP);
        }
        catch (Exception e) {
            RTLogger.print(1, "Error: Incorrect parameter FIXED_IP");
            this.useFixIP = false;
        }
        this.thisHostIP = this.sortedProperties.getProperty(AGENT_IP, "");
        if (this.useFixIP && this.thisHostIP.length() < 4) {
            RTLogger.print(1, "Error: Incorrect IP for FIXED_IP setting!");
            this.useFixIP = false;
        }
        String preconfName = this.sortedProperties.getProperty(PRE_CONFIG_NAME, "false");
        try {
            this.useFixHostname = Boolean.parseBoolean(preconfName);
        }
        catch (Exception e) {
            RTLogger.print(1, "Error: Incorrect parameter FIXED_NAME");
            this.useFixHostname = false;
        }
        this.thisHostName = this.sortedProperties.getProperty(AGENT_HOST, "");
        if (this.useFixHostname && this.thisHostName.isEmpty()) {
            RTLogger.print(1, "Error: Incorrect Hostname for FIXED_NAME setting!");
            this.useFixHostname = false;
        }
        String value = this.sortedProperties.getProperty(ACTIONS_ENABLED, "true");
        try {
            this.isActionsEnabled = Boolean.parseBoolean(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String intVal = this.sortedProperties.getProperty(MSD_MAX_PER_MINUTE);
        try {
            this.msdMaxPerMinute = Integer.parseInt(intVal.trim());
        }
        catch (Exception e) {
            RTLogger.print(1, "Incorrect value for MSD_MAX_PER_MINUTE");
        }
        intVal = this.sortedProperties.getProperty(MSD_BLOCK_MINUTES);
        try {
            this.msdBlockMin = Integer.parseInt(intVal.trim());
        }
        catch (Exception e) {
            RTLogger.print(1, "Incorrect value for MSD_BLOCK_MINUTES");
        }
        intVal = this.sortedProperties.getProperty(MSD_QUARANTINE_MINUTES);
        try {
            if (intVal != null) {
                this.msdQuarantineMin = Integer.parseInt(intVal.trim());
            }
        }
        catch (Exception e) {
            RTLogger.print(1, "Incorrect value for MSD_QUARANTINE_MINUTES");
        }
        intVal = this.sortedProperties.getProperty(WAIT_SERVER_SOCKET_SECONDS);
        try {
            if (intVal != null) {
                this.maxWaitServerSocketSec = Integer.parseInt(intVal.trim());
            }
        }
        catch (Exception e) {
            RTLogger.print(1, "Incorrect value for WAIT_SERVER_SOCKET_SECONDS");
        }
        intVal = this.sortedProperties.getProperty(PROXY_PORT);
        if (intVal != null) {
            try {
                this.proxyPort = Integer.parseInt(intVal.trim());
            }
            catch (Exception e) {
                RTLogger.print(1, "Incorrect value for PROXY_PORT");
            }
        }
        this.proxyType = this.sortedProperties.getProperty(PROXY_TYPE);
        if ("".equals(this.proxyType)) {
            this.proxyType = null;
        }
        this.proxyHost = this.sortedProperties.getProperty(PROXY_HOST);
        if ("".equals(this.proxyHost)) {
            this.proxyHost = null;
        }
        this.proxyUser = this.sortedProperties.getProperty(PROXY_USER);
        this.proxyEnPass = this.sortedProperties.getProperty(PROXY_EnPASS);
        String notEncryptedPass = this.sortedProperties.getProperty(PROXY_PASS);
        if (notEncryptedPass != null && !notEncryptedPass.isEmpty()) {
            this.proxyEnPass = Cryptor.encrypt4(notEncryptedPass);
            this.sortedProperties.remove(PROXY_PASS);
            resaveNeeded = true;
        }
        this.commType = this.sortedProperties.getProperty(COMM_TYPE, SOCKET);
        String protocolVer = this.sortedProperties.getProperty(PROTOCOL_VERSION);
        this.protocolVersion = protocolVer != null && !protocolVer.isEmpty() ? Integer.parseInt(protocolVer.trim()) : 2;
        String val = this.sortedProperties.getProperty(BKP_IFACE_ENABLED);
        if (val != null) {
            this.bkpIfaceEnabled = Boolean.parseBoolean(val);
        }
        if ((val = this.sortedProperties.getProperty(BKP_IFACE_START)) != null) {
            this.bkpIfaceStart = val;
        }
        if ((val = this.sortedProperties.getProperty(BKP_IFACE_STOP)) != null) {
            this.bkpIfaceStop = val;
        }
        if ((val = this.sortedProperties.getProperty(BKP_IFACE_TIME_THRESHOLD)) != null) {
            Interval parsedInterval = Interval.parseInterval(val, -1);
            if (parsedInterval != null && parsedInterval.getIntervalMilliseconds() > 0L) {
                this.bkpTimeThreshold = parsedInterval;
            }
            if (this.isBkpInterfaceEnabled() && this.bkpTimeThreshold == null) {
                String sb = "Parameter: BKP_IFACE_TIME_THRESHOLD has incorrect interval value: " + val + ". Force set default interval of 300 seconds.";
                RTLogger.print(1, sb);
                this.bkpTimeThreshold = Interval.getSimpleInterval(300);
            }
        }
        if ((val = this.sortedProperties.getProperty(NO_DEPLOY_ALLOWED)) != null) {
            try {
                this.deploymentAllowed = Boolean.valueOf(val);
            }
            catch (Exception e) {
                RTLogger.print(1, "Parameter: NO_DEPLOY_ALLOWED has incorrect interval value: " + val + ". ");
            }
        }
        if ((valKCO = this.sortedProperties.getProperty(KEEP_CONNECTION_OPEN)) != null) {
            this.keepConnection = Boolean.valueOf(valKCO);
        }
        if ((maxMSSize = this.sortedProperties.getProperty(MAX_MONITORSERIES_SIZE)) != null) {
            try {
                this.maxMonitorSeriesSize = Integer.valueOf(maxMSSize);
            }
            catch (Exception e) {
                RTLogger.print(1, "Error parsing MAX_MONITORSERIES_SIZE");
            }
        }
        this.ksFile = this.sortedProperties.getProperty(KS_FILE);
        String ksP = this.sortedProperties.getProperty(KS_PASS);
        if (ksP == null || ksP.isEmpty()) {
            this.ksPassEncoded = this.sortedProperties.getProperty(KS_PASS_ENCODED);
        } else {
            this.ksPassEncoded = Cryptor.encrypt4(ksP);
            this.sortedProperties.remove(KS_PASS);
            resaveNeeded = true;
        }
        this.processNettyModeProperty(this.sortedProperties);
        this.tsFile = this.sortedProperties.getProperty(TS_FILE);
        String tsP = this.sortedProperties.getProperty(TS_PASS);
        if (tsP == null || tsP.isEmpty()) {
            this.tsPassEncoded = this.sortedProperties.getProperty(TS_PASS_ENCODED);
        } else {
            this.tsPassEncoded = Cryptor.encrypt4(tsP);
            this.sortedProperties.remove(TS_PASS);
            resaveNeeded = true;
        }
        String certExpiration = this.sortedProperties.getProperty(AGENT_CERT_EXPIRATION_THRESHOLD_DAYS);
        if (certExpiration != null && !certExpiration.isEmpty()) {
            try {
                this.agentCertExpirationThresholdDays = Integer.parseInt(certExpiration.trim());
            }
            catch (NumberFormatException e) {
                RTLogger.print(1, "Error parsing AGENT_CERT_EXPIRATION_THRESHOLD_DAYS");
                this.agentCertExpirationThresholdDays = 30;
            }
        } else {
            this.agentCertExpirationThresholdDays = 30;
        }
        if (this.isTlsActivated()) {
            if (this.sortedProperties.remove(EXT_AGT_INFO) != null) {
                resaveNeeded = true;
            }
        } else {
            String extAgtInfo = this.sortedProperties.getProperty(EXT_AGT_INFO);
            if (extAgtInfo != null) {
                try {
                    this.isAgtExtInfo = Boolean.parseBoolean(extAgtInfo);
                }
                catch (Exception e) {
                    RTLogger.print(1, "Error parsing AGT_EXT_INFO");
                }
            }
        }
        try {
            this.dumpConfigSec = Integer.parseInt(this.sortedProperties.getProperty(DUMP_CONF_SEC));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resaveNeeded;
    }

    private void checkWsPort(Properties props, Consumer<Integer> applyPort, String ... parameterNames) {
        boolean isFound = false;
        for (String param : parameterNames) {
            String val = props.getProperty(param);
            if (val == null) continue;
            try {
                int valInt = Integer.parseInt(val);
                applyPort.accept(valInt);
                isFound = true;
                break;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!isFound) {
            RTLogger.print(1, "Missing value for : " + Arrays.stream(parameterNames).findFirst());
        }
    }

    private void processNettyModeProperty(SortedProperties properties) {
        String nettyModeStr = properties.getProperty(NETTY_MODE);
        try {
            this.nettyMode = nettyModeStr == null ? (this.mainServerWsPort == null ? NettyMode.OFF : NettyMode.CLIENT) : NettyMode.fromString(nettyModeStr);
        }
        catch (IllegalArgumentException e) {
            RTLogger.print(1, "Could not parse netty mode '" + nettyModeStr + "' using default value OFF");
            this.nettyMode = NettyMode.OFF;
        }
    }

    private void initLogging(File configDir) {
        String logsize;
        String logcount;
        String loglevel;
        this.logDir = this.sortedProperties.getProperty(LOGDIR);
        if (this.logDir != null) {
            this.logDir = AProperties.resolveEnvVars(this.logDir);
            this.logDir = new StrUtils().removeQuotes(this.logDir);
        }
        if ((loglevel = this.sortedProperties.getProperty(LOGLEVEL)) != null) {
            try {
                this.logLevel = Integer.parseInt(loglevel.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((logcount = this.sortedProperties.getProperty(LOGCOUNT, "7")) != null) {
            try {
                this.logCount = Integer.parseInt(logcount.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((logsize = this.sortedProperties.getProperty(LOGSIZE, "10")) != null) {
            try {
                this.logSize = RTLogger.parseMaxSize(logsize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            RTLogger.setDir(configDir.getParentFile().getCanonicalPath(), LOGFILE_PREFIX);
        }
        catch (Exception exception) {
            // empty catch block
        }
        RTLogger.setMaxSize(this.logSize);
        RTLogger.setMaxCount(this.logCount);
        RTLogger.setLevel(this.logLevel);
        RTLogger.storeConfig();
    }

    private void checkNetworkInterfaces() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            for (int iFaceCount = 0; interfaces.hasMoreElements() && iFaceCount < 8; ++iFaceCount) {
                NetworkInterface networkInterface = interfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                for (int ipCount = 0; inetAddresses.hasMoreElements() && ipCount < 3; ++ipCount) {
                    InetAddress addr = inetAddresses.nextElement();
                    this.addInterfaceInfo(addr);
                }
            }
            if (!this.allHostnames.contains(this.thisHostName) && !this.allIPs.contains(this.thisHostName)) {
                this.allHostnames.add(this.thisHostName);
            }
            if (!this.allHostnames.contains(this.thisHostIP) && !this.allIPs.contains(this.thisHostIP)) {
                this.allIPs.add(this.thisHostIP);
            }
            RTLogger.print(1, "Hostnames : " + this.allHostnames);
            RTLogger.print(1, "IPs : " + this.allIPs);
        }
        catch (Exception e) {
            RTLogger.print(1, "network interfaces check failed", e);
        }
    }

    private void addInterfaceInfo(InetAddress addr) {
        try {
            if (!addr.isLoopbackAddress()) {
                if (addr instanceof Inet6Address) {
                    Inet6Address addrIPv6 = (Inet6Address)addr;
                    byte[] iip = addrIPv6.getAddress();
                    Inet6Address addrIPv6c = (Inet6Address)Inet6Address.getByAddress(iip);
                    String hAddr = addrIPv6c.getHostAddress();
                    this.allIPs.add(hAddr);
                    String hostN = addrIPv6c.getCanonicalHostName();
                    if (!hostN.equals(hAddr)) {
                        this.allHostnames.add(hostN);
                    }
                } else {
                    String hAddr = addr.getHostAddress();
                    this.allIPs.add(hAddr);
                    String hostN = addr.getCanonicalHostName();
                    if (!hostN.equals(hAddr)) {
                        this.allHostnames.add(hostN);
                    }
                }
            }
        }
        catch (UnknownHostException e) {
            RTLogger.print(3, "error inet addr " + addr, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveHostname() {
        block28: {
            try {
                this.thisHostName = InetAddress.getLocalHost().getCanonicalHostName();
                String ip = InetAddress.getByName(this.thisHostName).getHostAddress();
                if (this.thisHostName.equals(ip)) {
                    throw new RuntimeException("no dns");
                }
                try {
                    InetAddress[] arr;
                    if (this.useFixIP) break block28;
                    for (InetAddress inetAddress : arr = InetAddress.getAllByName(this.thisHostName)) {
                        if (inetAddress.isLoopbackAddress()) continue;
                        this.thisHostIP = inetAddress.getHostAddress();
                        break;
                    }
                }
                catch (Exception e) {
                    RTLogger.print(3, "Error detecting IPs", e);
                }
            }
            catch (Exception e) {
                try {
                    this.thisHostName = InetAddress.getLocalHost().getHostName();
                }
                catch (Throwable e1) {
                    RTLogger.print(5, "Error getting HostName: ", e);
                    Socket s = null;
                    try {
                        s = SocketFactory.getSocket((InetSocketAddress)null, 60000);
                        try {
                            InetSocketAddress srvAddrByHost = new InetSocketAddress(this.mainServerHost, this.getMainServerPort());
                            if (srvAddrByHost.isUnresolved()) {
                                throw new SocketException("Hostname unresolved");
                            }
                            s.connect(srvAddrByHost, 60000);
                            this.thisHostName = s.getLocalAddress().getHostName();
                            if (!this.useFixIP) {
                                try {
                                    this.thisHostIP = s.getLocalAddress().getHostAddress();
                                }
                                catch (Exception e2) {
                                    RTLogger.print(3, "Error detecting local addr", e);
                                }
                            }
                        }
                        catch (SocketException e22) {
                            try {
                                SocketUtils.closeSocket(s, new AutoCloseable[0]);
                                s = SocketFactory.getSocket((InetSocketAddress)null, 60000);
                                s.connect(new InetSocketAddress(this.mainServerIP, this.getMainServerPort()), 60000);
                                this.thisHostName = s.getLocalAddress().getHostName();
                                if (!this.useFixIP) {
                                    try {
                                        this.thisHostIP = s.getLocalAddress().getHostAddress();
                                    }
                                    catch (Exception e2) {
                                        RTLogger.print(3, "Error-2 detecting IPs", e);
                                    }
                                }
                            }
                            catch (SocketException e2) {
                                this.thisHostName = "localhost";
                            }
                        }
                        this.save();
                    }
                    catch (Exception e3) {
                        RTLogger.print(1, "Error getting local hostname. Please check DNS settings.");
                        this.thisHostIP = this.thisHostName = "127.0.0.1";
                    }
                    finally {
                        if (s != null) {
                            SocketUtils.closeSocket(s, new AutoCloseable[0]);
                        }
                    }
                }
            }
            finally {
                RTLogger.print(3, "Resolved local hostname: " + this.thisHostName);
            }
        }
    }

    public static boolean isValidPath(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                return true;
            }
            try {
                Path p = Files.createDirectories(file.toPath(), new FileAttribute[0]);
                return Files.exists(p, new LinkOption[0]);
            }
            catch (Exception e) {
                return false;
            }
        }
        catch (NullPointerException | InvalidPathException ex) {
            return false;
        }
    }

    public String getMainServerHost() {
        return this.mainServerHost;
    }

    public String getMainServerIP() {
        if ("".equals(this.mainServerIP)) {
            try {
                this.mainServerIP = InetAddress.getByName(this.mainServerHost).getHostAddress();
            }
            catch (Exception e) {
                RTLogger.print(3, "Error getting IP for " + this.mainServerHost, e);
            }
        }
        return this.mainServerIP;
    }

    public int getMainServerPort() {
        return this.mainServerPort;
    }

    public String getMainServerIpMask() {
        return this.mainServerIPMask;
    }

    public int getMaxMessages() {
        return this.maxBufferedMessages;
    }

    public int getMaxPerfRecords() {
        return this.maxBufferedPerfRecs;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public Integer getAgentTlsPort() {
        return this.agentTlsPort;
    }

    public void setAgentTlsPort(Integer agentTlsPort) {
        this.agentTlsPort = agentTlsPort;
    }

    public String getAgentIP() {
        return this.thisHostIP;
    }

    public String getAgentID() {
        return this.agentID;
    }

    public void setAgentID(String id) {
        this.agentID = id;
    }

    public String getAgentOS() {
        return this.agentOS;
    }

    public void setAgentIP(String IP) {
        if (!this.isFixedIP()) {
            this.thisHostIP = IP;
        }
    }

    public void setAgentHost(String host) {
        if (!this.isFixedName()) {
            this.thisHostName = host;
        }
    }

    public boolean isFixedIP() {
        return this.useFixIP;
    }

    public boolean isFixedName() {
        return this.useFixHostname;
    }

    public boolean isActionsEnabled() {
        return this.isActionsEnabled;
    }

    public void setActionsEnabled(boolean enable) {
        this.isActionsEnabled = enable;
    }

    public boolean getDisabled() {
        return this.isDisabled;
    }

    public void setDisabled(boolean disabled) {
        this.isDisabled = disabled;
    }

    public void setMainServerHost(String hostname) {
        this.mainServerHost = hostname;
        try {
            this.mainServerIP = InetAddress.getByName(this.mainServerHost).getHostAddress();
        }
        catch (Exception e) {
            throw new RuntimeException("MAIN_SERVER_NAME can not be resolved: " + this.mainServerHost + ". Please check your DNS settings");
        }
    }

    public boolean isOfferDataToAnyClusterNode() {
        return this.offerDataToAnyClusterNode;
    }

    public void setOfferDataToAnyClusterNode(boolean offerDataToAnyClusterNode) {
        this.offerDataToAnyClusterNode = offerDataToAnyClusterNode;
    }

    public void save() {
        File configDir = new File(DIR);
        if (configDir.exists() && configDir.isDirectory()) {
            File prTmp = new File(configDir, BM.CONFFILE + ".tmp");
            File pr = this.isAtmMode() ? AProperties.getCandidateFile(configDir, this.getNextConfSuffix(configDir)) : AProperties.getInitialConfigFile(configDir);
            if (!pr.exists() || pr.canWrite()) {
                try {
                    this.fillPropertiesWithNewValues();
                    try (FileOutputStream fileOutputStream = new FileOutputStream(prTmp);){
                        this.sortedProperties.store(fileOutputStream, "");
                    }
                    Files.move(prTmp.toPath(), pr.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                    if (this.isAtmMode()) {
                        this.removeOldConfigFiles(configDir);
                    }
                }
                catch (Exception e) {
                    RTLogger.print(2, "", e);
                }
            }
        }
    }

    private void removeOldConfigFiles(File dir) {
        List<Integer> suffixes = this.getConfFileSuffixesSortedDesc(dir);
        int filesToRemove = suffixes.size() - 5;
        ListIterator<Integer> fileIterator = suffixes.listIterator(suffixes.size());
        while (fileIterator.hasPrevious() && filesToRemove > 0) {
            Integer suffix = fileIterator.previous();
            if (suffix <= 0) continue;
            File candidateFile = AProperties.getCandidateFile(dir, suffix);
            try {
                Files.delete(candidateFile.toPath());
            }
            catch (IOException e) {
                RTLogger.print(1, "Error: Could not remove config file " + candidateFile.getName(), e);
            }
            --filesToRemove;
        }
    }

    public boolean detectATMMode() {
        boolean atmMode;
        String envAtmMode = System.getProperty(ATM_MODE_PROP_NAME);
        if (envAtmMode != null && !envAtmMode.isEmpty()) {
            atmMode = envAtmMode.equalsIgnoreCase("true");
        } else {
            try {
                Class.forName("com.blixx.agent.AgentListener");
                atmMode = false;
            }
            catch (ClassNotFoundException e) {
                atmMode = true;
            }
        }
        return atmMode;
    }

    public boolean isAtmMode() {
        return this.atmMode;
    }

    private void fillPropertiesWithNewValues() {
        this.sortedProperties.remove("Version");
        this.sortedProperties.remove("VERSION");
        this.sortedProperties.remove("VER");
        this.sortedProperties.setProperty(MAIN_SERVER_IP, this.mainServerIP);
        this.sortedProperties.setProperty(MAIN_SERVER_IP_MASK, this.mainServerIPMask);
        this.sortedProperties.setProperty(MAIN_SERVER_NAME, this.mainServerHost);
        this.sortedProperties.setProperty(MAIN_SERVER_PORT, "" + this.mainServerPort);
        if (this.backupServerHost != null) {
            this.sortedProperties.setProperty(BACKUP_SERVER_NAME, this.backupServerHost);
        }
        if (this.backupServerIP != null) {
            this.sortedProperties.setProperty(BACKUP_SERVER_IP, this.backupServerIP);
        }
        if (this.backupServerIPMask != null) {
            this.sortedProperties.setProperty(BACKUP_SERVER_IP_MASK, this.backupServerIPMask);
        }
        if (this.backupServerPort != null) {
            this.sortedProperties.setProperty(BACKUP_SERVER_PORT, "" + this.backupServerPort);
        }
        this.sortedProperties.setProperty(MAX_BUFFERED_MESSAGES, "" + this.maxBufferedMessages);
        if (this.maxBufferedPerfRecs != 100) {
            this.sortedProperties.setProperty(MAX_BUFFERED_PERFRECS, "" + this.maxBufferedPerfRecs);
        } else {
            this.sortedProperties.remove(MAX_BUFFERED_PERFRECS);
        }
        this.sortedProperties.setProperty(AGENT_HOST, this.thisHostName);
        this.sortedProperties.setProperty(AGENT_ID, this.agentID);
        this.sortedProperties.setProperty(AGENT_IP, this.thisHostIP);
        this.sortedProperties.setProperty(AGENT_PORT, "" + this.agentPort);
        if (this.agentTlsPort != null) {
            this.sortedProperties.setProperty(AGENT_TLS_PORT, this.agentTlsPort.toString());
        }
        if (this.mainServerWsPort != null) {
            this.sortedProperties.setProperty(MAIN_SERVER_WS_PORT, "" + this.mainServerWsPort);
        }
        if (this.backupServerWsPort != null) {
            this.sortedProperties.setProperty(BACKUP_SERVER_WS_PORT, "" + this.backupServerWsPort);
        }
        if (this.wsAgentPort != null) {
            this.sortedProperties.setProperty(WS_PORT_AGENT, "" + this.wsAgentPort);
        }
        this.sortedProperties.remove(WS_PROTOCOL);
        this.sortedProperties.remove(FT_PROTOCOL);
        if (this.ftTimeOut != null) {
            this.sortedProperties.setProperty(FT_TIMEOUT_MINS, "" + this.ftTimeOut);
        }
        if (this.ftDir != null) {
            this.sortedProperties.setProperty(FT_DIR, this.ftDir);
        }
        if (this.mode >= 7) {
            this.sortedProperties.setProperty(MODE, "7");
        } else {
            this.sortedProperties.setProperty(MODE, "0");
        }
        this.sortedProperties.setProperty(MAX_SYM_MONITOR_CALLS, "" + this.maxSymMonitors);
        this.sortedProperties.setProperty(DISABLED, "" + this.getDisabled());
        if (this.offerDataToAnyClusterNode) {
            this.sortedProperties.setProperty(OFFER_DATA_TO_ANY_CLUSTER_NODE, "" + this.isOfferDataToAnyClusterNode());
        } else {
            this.sortedProperties.remove(OFFER_DATA_TO_ANY_CLUSTER_NODE);
        }
        this.sortedProperties.setProperty(LOGLEVEL, "" + RTLogger.getCurrentLevel());
        this.sortedProperties.setProperty(HB_INTERVAL, "" + this.hbInterval);
        this.sortedProperties.setProperty(HB_CTIMEOUT, "" + this.hbConnectTimeoutMs);
        this.sortedProperties.setProperty(HB_RTIMEOUT, "" + this.hbReadTimeoutMs);
        this.sortedProperties.setProperty(HB_RECONNECT, "" + this.hbMaxReconnectToSlave);
        this.sortedProperties.setProperty(PRE_CONFIG_IP, "" + this.useFixIP);
        this.sortedProperties.setProperty(PRE_CONFIG_NAME, "" + this.useFixHostname);
        this.sortedProperties.setProperty(CLONING_SUPPORT, "" + this.isCloningSupported);
        try {
            if (!this.clusterNodes.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.clusterNodes.size(); ++i) {
                    sb.append(this.clusterNodes.get(i).trim());
                    if (i >= this.clusterNodes.size() - 1) continue;
                    sb.append(',');
                }
                this.sortedProperties.setProperty(CLUSTER_NODES, sb.toString());
            }
        }
        catch (Exception e) {
            RTLogger.print(3, CLUSTER_NODES, e);
        }
        if (this.logDir != null) {
            this.sortedProperties.setProperty(LOGDIR, this.logDir);
        } else {
            this.sortedProperties.remove(LOGDIR);
        }
        this.sortedProperties.setProperty(LOGCOUNT, "" + RTLogger.getMaxFileCount());
        this.sortedProperties.setProperty(LOGSIZE, "" + RTLogger.getMaxSizeMB());
        if (!this.isActionsEnabled) {
            this.sortedProperties.setProperty(ACTIONS_ENABLED, "false");
        } else {
            this.sortedProperties.remove(ACTIONS_ENABLED);
        }
        this.sortedProperties.setProperty(MSD_MAX_PER_MINUTE, "" + this.msdMaxPerMinute);
        this.sortedProperties.setProperty(MSD_BLOCK_MINUTES, "" + this.msdBlockMin);
        if (this.proxyPort > 0) {
            this.sortedProperties.setProperty(PROXY_PORT, "" + this.proxyPort);
        } else {
            this.sortedProperties.remove(PROXY_PORT);
        }
        if (this.proxyType != null) {
            this.sortedProperties.setProperty(PROXY_TYPE, this.proxyType);
        } else {
            this.sortedProperties.remove(PROXY_TYPE);
        }
        if (this.proxyHost != null) {
            this.sortedProperties.setProperty(PROXY_HOST, this.proxyHost);
        } else {
            this.sortedProperties.remove(PROXY_HOST);
        }
        if (this.proxyUser != null) {
            this.sortedProperties.setProperty(PROXY_USER, this.proxyUser);
        } else {
            this.sortedProperties.remove(PROXY_USER);
        }
        if (this.proxyEnPass != null) {
            this.sortedProperties.setProperty(PROXY_EnPASS, this.proxyEnPass);
        } else {
            this.sortedProperties.remove(PROXY_EnPASS);
        }
        if (this.maxWaitServerSocketSec > 0) {
            this.sortedProperties.setProperty(WAIT_SERVER_SOCKET_SECONDS, "" + this.maxWaitServerSocketSec);
        } else {
            this.sortedProperties.remove(WAIT_SERVER_SOCKET_SECONDS);
        }
        this.sortedProperties.setProperty(COMM_TYPE, this.commType);
        if (this.bkpIfaceEnabled != null) {
            this.sortedProperties.setProperty(BKP_IFACE_ENABLED, "" + this.bkpIfaceEnabled);
        }
        if (this.bkpIfaceStart != null) {
            this.sortedProperties.setProperty(BKP_IFACE_START, this.bkpIfaceStart);
        }
        if (this.bkpIfaceStop != null) {
            this.sortedProperties.setProperty(BKP_IFACE_STOP, this.bkpIfaceStop);
        }
        if (this.bkpTimeThreshold != null) {
            this.sortedProperties.setProperty(BKP_IFACE_TIME_THRESHOLD, this.bkpTimeThreshold.toString());
        }
        if (this.keepConnection != null) {
            this.sortedProperties.setProperty(KEEP_CONNECTION_OPEN, this.keepConnection.toString());
        }
        if (this.maxMonitorSeriesSize != null) {
            this.sortedProperties.setProperty(MAX_MONITORSERIES_SIZE, this.maxMonitorSeriesSize.toString());
        }
        if (this.ksFile == null) {
            this.sortedProperties.remove(KS_FILE);
        } else {
            this.sortedProperties.setProperty(KS_FILE, this.ksFile);
        }
        if (this.tsFile == null) {
            this.sortedProperties.remove(TS_FILE);
        } else {
            this.sortedProperties.setProperty(TS_FILE, this.tsFile);
        }
        if (this.ksPassEncoded == null) {
            this.sortedProperties.remove(KS_PASS_ENCODED);
        } else {
            this.sortedProperties.setProperty(KS_PASS_ENCODED, this.ksPassEncoded);
        }
        if (this.tsPassEncoded == null) {
            this.sortedProperties.remove(TS_PASS_ENCODED);
        } else {
            this.sortedProperties.setProperty(TS_PASS_ENCODED, this.tsPassEncoded);
        }
        this.sortedProperties.setProperty(PROTOCOL_VERSION, Integer.toString(this.protocolVersion));
    }

    public int getHbConnectTimeoutMs() {
        return this.hbConnectTimeoutMs;
    }

    public void setHbConnectTimeoutMs(int hbCtimeout) {
        this.hbConnectTimeoutMs = hbCtimeout;
    }

    public int getHbReadTimeoutMs() {
        return this.hbReadTimeoutMs;
    }

    public void setHbReadTimeoutMs(int hbRtimeout) {
        this.hbReadTimeoutMs = hbRtimeout;
    }

    public String getBackupServerIp() {
        return this.backupServerIP;
    }

    public String getBackupServerHost() {
        return this.backupServerHost;
    }

    public String getBackupServerIpMask() {
        return this.backupServerIPMask;
    }

    public Integer getBackupServerPort() {
        return this.backupServerPort;
    }

    public static String resolveEnvVars(String in) {
        Set<String> keys = System.getenv().keySet();
        for (String key : keys) {
            String val = System.getenv(key);
            if (val == null) {
                val = "";
            }
            if (SystemUtils.OS == 1) {
                in = in.replace("%" + key + "%", val);
                continue;
            }
            in = in.replace("${" + key + "}", val);
            in = in.replace("$" + key, val);
        }
        return in;
    }

    public static boolean checkIfCloned(String configuredIP, String configuredHost) throws UnknownHostException {
        InetAddress[] iarr;
        boolean isHostnamefound = false;
        boolean isIPFound = false;
        String hostName = "localhost";
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e1) {
                try {
                    hostName = InetAddress.getLocalHost().getHostAddress();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        for (InetAddress inetAddress : iarr = InetAddress.getAllByName(hostName)) {
            try {
                if (configuredIP.equals(inetAddress.getHostAddress())) {
                    isIPFound = true;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (configuredHost.equalsIgnoreCase(inetAddress.getCanonicalHostName())) {
                    isHostnamefound = true;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (!configuredHost.equalsIgnoreCase(inetAddress.getHostName())) continue;
                isHostnamefound = true;
                break;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return !isHostnamefound && !isIPFound;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(String proxy_type) {
        this.proxyType = proxy_type;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyEnPass() {
        return this.proxyEnPass;
    }

    public void setProxyEnPass(String proxyEnPass) {
        this.proxyEnPass = proxyEnPass;
    }

    public void setProxyNonEnPass(String proxyPass) {
        this.proxyEnPass = Cryptor.encrypt4(proxyPass);
    }

    public int getMaxWaitServerSocketSec() {
        return this.maxWaitServerSocketSec;
    }

    public void setMaxWaitServerSocketSec(int waitServerSocketSec) {
        this.maxWaitServerSocketSec = waitServerSocketSec;
    }

    public String getCommType() {
        return this.commType;
    }

    public void setCommType(String commType) {
        this.commType = HTTPS.equalsIgnoreCase(commType) ? HTTPS : (SOCKET.equalsIgnoreCase(commType) ? SOCKET : (HTTP.equalsIgnoreCase(commType) ? HTTP : (TLS.equalsIgnoreCase(commType) ? TLS : (WEBSOCKET.equalsIgnoreCase(commType) ? WEBSOCKET : (WEBSOCKET_TLS_ONLY.equalsIgnoreCase(commType) ? WEBSOCKET_TLS_ONLY : (WEBSOCKET_ONLY.equalsIgnoreCase(commType) ? WEBSOCKET_ONLY : SOCKET))))));
    }

    public boolean isBkpInterfaceEnabled() {
        return this.bkpIfaceEnabled != null && this.bkpIfaceEnabled != false;
    }

    public void setBkpInterfaceEnabled(boolean enabled) {
        this.bkpIfaceEnabled = enabled;
    }

    public String getBkpInterfaceStart() {
        return this.bkpIfaceStart;
    }

    public void setBkpInterfaceStart(String start) {
        this.bkpIfaceStart = start;
    }

    public String getBkpInterfaceStop() {
        return this.bkpIfaceStop;
    }

    public void setBkpInterfaceStop(String stop) {
        this.bkpIfaceStop = stop;
    }

    public Interval getBkpInterfaceTimeThreshold() {
        return this.bkpTimeThreshold;
    }

    public void setBkpInterfaceTimeThreshold(Interval interval) {
        this.bkpTimeThreshold = interval;
    }

    public boolean getNoDeployAllowed() {
        return this.deploymentAllowed != null && this.deploymentAllowed != false;
    }

    public void setNoDeployAllowed(Boolean noDeployAllowed) {
        this.deploymentAllowed = noDeployAllowed;
    }

    public Boolean getKeepConnectionOpenVar() {
        return this.keepConnection;
    }

    public boolean getKeepConnectionOpen() {
        return this.keepConnection != null && this.keepConnection != false;
    }

    public void setKeepConnectionOpen(boolean keepConnectionOpen) {
        this.keepConnection = keepConnectionOpen;
    }

    public int getMaxMonitorSeriesSize() {
        return this.maxMonitorSeriesSize == null ? 300 : this.maxMonitorSeriesSize;
    }

    public void setMaxMonitorSeriesSize(int maxMonitorSeriesSize) {
        this.maxMonitorSeriesSize = maxMonitorSeriesSize;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public int getHbReconnect() {
        return this.hbMaxReconnectToSlave;
    }

    public int getHbInterval() {
        return this.hbInterval;
    }

    public void setHbInterval(int sec) {
        this.hbInterval = sec;
    }

    public Integer getMainServerWsPort() {
        return this.mainServerWsPort;
    }

    public Integer getBackupServerWsPort() {
        return this.backupServerWsPort;
    }

    public Integer getWsAgentPort() {
        return this.wsAgentPort;
    }

    public void setWsAgentPort(Integer wsAgentPort) {
        this.wsAgentPort = wsAgentPort;
    }

    public void setMainServerWsPort(int mainServerWsPort) {
        this.mainServerWsPort = mainServerWsPort;
    }

    public void setBackupServerWsPort(int bkpServerWsPort) {
        this.backupServerWsPort = bkpServerWsPort;
    }

    public String getFtDir() {
        return this.ftDir;
    }

    public void setFtDir(String ftDir) {
        this.ftDir = ftDir;
    }

    public int getFtTimeOut() {
        return this.ftTimeOut;
    }

    public void setFtTimeOut(int ftTimeOut) {
        this.ftTimeOut = ftTimeOut;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public int getMsdMaxPerMin() {
        return this.msdMaxPerMinute;
    }

    public void setMsgMaxPerMin(int maxMsgPerMin) {
        this.msdMaxPerMinute = maxMsgPerMin;
    }

    public int getMsdBlockMin() {
        return this.msdBlockMin;
    }

    public void setMsdBlockMin(int blockMin) {
        this.msdBlockMin = blockMin;
    }

    public int getMsdQuarantineMin() {
        return this.msdQuarantineMin;
    }

    public void setMsdQuarantineMin(int qaMin) {
        this.msdQuarantineMin = qaMin;
    }

    public String getSentAgentClonedMsg() {
        return this.sentClonedMessage;
    }

    public void setSentAgentClonedMsg(String clonedMsgSent) {
        this.sentClonedMessage = clonedMsgSent;
    }

    public String getThisHostname() {
        return this.thisHostName;
    }

    public List<String> getClusterNodes() {
        return this.clusterNodes;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public String getOldMainServer() {
        return this.oldMainServerHost;
    }

    public void setOldMainServer(String srv) {
        this.oldMainServerHost = srv;
    }

    public int getMaxSymMonitors() {
        return this.maxSymMonitors;
    }

    public boolean isTlsActivated() {
        return TLS.equals(this.getCommType()) || WEBSOCKET_TLS_ONLY.equals(this.getCommType());
    }

    public Set<String> getAllHostnames() {
        return this.allHostnames;
    }

    public Set<String> getAllIPs() {
        return this.allIPs;
    }

    public String getKsPassEncoded() {
        return this.ksPassEncoded;
    }

    public void setKsPassEncoded(String ksPassEncoded) {
        this.ksPassEncoded = ksPassEncoded;
    }

    public String getKsFile() {
        return this.ksFile;
    }

    public void setKsFile(String ksFile) {
        this.ksFile = ksFile;
    }

    public String getTsPassEncoded() {
        return this.tsPassEncoded;
    }

    public void setTsPassEncoded(String tsPassEncoded) {
        this.tsPassEncoded = tsPassEncoded;
    }

    public String getTsFile() {
        return this.tsFile;
    }

    public void setTsFile(String tsFile) {
        this.tsFile = tsFile;
    }

    public boolean isAgtExtInfo() {
        return this.isAgtExtInfo;
    }

    public NettyMode getNettyMode() {
        return this.nettyMode;
    }

    public void setNettyMode(NettyMode mode) {
        this.nettyMode = mode;
    }

    public int getAgentCertExpirationThresholdDays() {
        return this.agentCertExpirationThresholdDays;
    }

    public void setAgentCertExpirationThresholdDays(int agentCertExpirationThresholdDays) {
        this.agentCertExpirationThresholdDays = agentCertExpirationThresholdDays;
    }

    public Integer getDumpConfigSec() {
        return this.dumpConfigSec;
    }
}

