/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.Env;
import com.blixx.agent.MonitorValue;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.IPerfMetric;
import com.blixx.log.RTLogger;
import com.blixx.sa.SchedulerTask;
import com.boom.netty.service.events.PerfAgt;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractMonTask
extends SchedulerTask
implements IMonitorSubmitter,
IPerfLog {
    public String m_host = null;
    public String m_object = null;
    public boolean m_isPerformanceCollectionActivated = true;
    public List<PerfAgt> m_perfDataArray = new LinkedList<PerfAgt>();

    public AbstractMonTask(String TaskName) {
        super(TaskName);
    }

    @Override
    public void submitMonitorValue(String monitor, double value, String object, HashMap optionalVariables) {
        MonitorValue mv = new MonitorValue(value, System.currentTimeMillis(), monitor, object, optionalVariables);
        if (this.m_host != null && this.m_host.length() > 0) {
            mv.p10_node = this.m_host;
        }
        if (this.m_object != null && this.m_object.length() > 0) {
            mv.p3_object = this.m_object;
        }
        RTLogger.print(5, "mon value submitted. {" + mv + "}");
        AgentEngine.getInstance().getSubmitter().submit(mv);
    }

    @Override
    public void submitPerfRow(String perfClass, long time, List<IPerfMetric> values) {
        if (!this.m_isPerformanceCollectionActivated || values == null || values.size() == 0) {
            return;
        }
        PerfAgt record = new PerfAgt(perfClass, time);
        for (IPerfMetric metric : values) {
            if (metric.getValue() == null || metric.getName() == null || metric.getType() == null) continue;
            PerfAgt.PerfValue val = new PerfAgt.PerfValue(metric.getName(), metric.getType(), metric.getLength(), "" + metric.getValue());
            record.getRecordSet().put(val.getFieldName(), val);
        }
        this.m_perfDataArray.add(record);
    }

    public String replaceGlobalVariables(String line) {
        if (line.contains("<$")) {
            Map<String, String> variables = Env.getInstance().getVariables();
            for (Map.Entry<String, String> en : variables.entrySet()) {
                if ((line = line.replace("<$" + en.getKey() + '>', en.getValue())).contains("<$")) continue;
                break;
            }
        }
        return line;
    }
}

