/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.IAgentListener;
import com.blixx.log.RTLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;

public class Agent
implements Runnable {
    IAgentListener listenerRef;
    private Map<String, String> acceptedHosts;
    private static final String LISTENER_CLASS = "com.blixx.agent.AgentListener";
    Method shutDownMethod;
    Method addValidHostMethod;
    Method getHostsMethod;
    Method removeHostMethod;
    private boolean startTlsSocket = true;
    private boolean startPlainSocket = true;
    private boolean plainSocketOnlyLocalIP = false;

    public Agent(Map<String, String> acceptedHosts) {
        this(acceptedHosts, true, true, false);
    }

    public Agent(Map<String, String> acceptedHosts, boolean startTlsSocket, boolean startPlainSocket, boolean plainSocketOnlyLocalIP) {
        this.startPlainSocket = startPlainSocket;
        this.startTlsSocket = startTlsSocket;
        this.acceptedHosts = acceptedHosts;
        RTLogger.print(2, "Accepted hosts: " + acceptedHosts);
    }

    @Override
    public void run() {
        ClassLoader parentClassLoader = Agent.class.getClassLoader();
        try {
            Class<?> listener = parentClassLoader.loadClass(LISTENER_CLASS);
            Class[] paramDefs = new Class[]{Map.class, Boolean.TYPE};
            Constructor<?> constructor = listener.getConstructor(paramDefs);
            this.listenerRef = (IAgentListener)constructor.newInstance(this.acceptedHosts, this.plainSocketOnlyLocalIP);
            this.addValidHostMethod = listener.getDeclaredMethod("addValidHost", String.class);
            this.getHostsMethod = listener.getDeclaredMethod("getHosts", new Class[0]);
            this.shutDownMethod = listener.getDeclaredMethod("shutdown", new Class[0]);
            this.removeHostMethod = listener.getDeclaredMethod("removeHost", String.class);
            if (this.startPlainSocket) {
                Method runMethod1 = listener.getDeclaredMethod("runPlainSocket", new Class[0]);
                runMethod1.invoke((Object)this.listenerRef, new Object[0]);
                RTLogger.print(1, "Plain Server socket started");
            }
            if (this.startTlsSocket) {
                Method runMethod2 = listener.getDeclaredMethod("runTlsSocket", new Class[0]);
                runMethod2.invoke((Object)this.listenerRef, new Object[0]);
                RTLogger.print(1, "TLS Server socket started");
            }
        }
        catch (Exception e) {
            RTLogger.print(1, "Listener not found. " + e.getMessage());
        }
    }

    public void shutdown() {
        if (this.listenerRef == null) {
            return;
        }
        if (this.shutDownMethod == null) {
            return;
        }
        try {
            this.shutDownMethod.invoke((Object)this.listenerRef, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            RTLogger.print(5, "Error while executing shutdown on listener. " + e.getMessage());
        }
    }

    public void addValidHost(String hostName) {
        if (this.listenerRef == null) {
            return;
        }
        if (this.addValidHostMethod == null) {
            return;
        }
        try {
            this.addValidHostMethod.invoke((Object)this.listenerRef, hostName);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            RTLogger.print(5, "Error while executing addHosts on listener. " + e.getMessage());
        }
    }

    public Map<String, String> getAcceptedHosts() {
        if (this.listenerRef == null) {
            return Collections.emptyMap();
        }
        if (this.getHostsMethod == null) {
            return Collections.emptyMap();
        }
        try {
            return (Map)this.getHostsMethod.invoke((Object)this.listenerRef, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            RTLogger.print(5, "Error while executing addHosts on listener. " + e.getMessage());
            return Collections.emptyMap();
        }
    }

    public void removeHost(String host) {
        if (this.listenerRef == null) {
            return;
        }
        if (this.removeHostMethod == null) {
            return;
        }
        try {
            this.removeHostMethod.invoke((Object)this.listenerRef, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            RTLogger.print(5, "Error while executing removeHost on listener. " + e.getMessage());
        }
    }
}

