/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AProperties;
import com.blixx.agent.AgentCertStateIndicationHelper;
import com.blixx.agent.AgentEngine;
import com.blixx.agent.AgentHealth;
import com.blixx.agent.ConnectionCheckAfterKSSwitchTask;
import com.blixx.agent.ConnectionSettingsBackupHelper;
import com.blixx.agent.Env;
import com.blixx.agent.Message;
import com.blixx.agent.NullMonSubmitter;
import com.blixx.agent.PolicyRepository;
import com.blixx.ext.IAction;
import com.blixx.ext.ILookup;
import com.blixx.log.RTLogger;
import com.blixx.sa.BMClassLoader;
import com.blixx.sa.ExecResult;
import com.blixx.sa.ExecUtils;
import com.blixx.sa.Scheduler;
import com.blixx.sa.SchedulerTask;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.MonitorSerie;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.ServerInfo;
import com.blixx.shared.exceptions.JavaMonitorExeption;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.os.SystemUtils;
import com.blixx.shared.utils.FileSyncUtils;
import com.blixx.shared.utils.StrUtils;
import com.boom.TlsUtils;
import com.boom.crt.CertificateManager;
import com.boom.crt.CertificateManagerInitializationException;
import com.boom.crt.KeyStoreClient;
import com.boom.crt.TrustStoreClient;
import com.boom.crt.hlp.BasicCertificateInfo;
import com.boom.crt.hlp.CertificateSerializationHelper;
import com.boom.netty.service.cmds.AgentActionResponse;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class AgentActionExecutor {
    private static final String AGENT_CMD_GET_MSD_SETTINGS = "GET_MSD_SETTINGS";
    private static final String AGENT_CMD_OD2ACN_OFF = "OD2ACN_OFF";
    private static final String AGENT_CMD_OD2ACN_ON = "OD2ACN_ON";
    private static final String AGENT_CMD_DISABLE_ACTIONS = "DISABLE_ACTIONS";
    private static final String AGENT_CMD_SETVAR = "SETVAR";
    private static final String AGENT_CMD_GETVAR = "GETVAR";
    private static final String AGENT_CMD_REMVAR = "REMVAR";
    private static final String DISABLED = "D";
    private static final String ENABLED = "E";
    private static final String AGENT_CMD_STATUS = "STATUS";
    private static final String AGENT_CMD_GET_IP = "GET_IP";
    private static final String AGENT_CMD_SHARED_IP = "SHARED_IP";
    private static final String AGENT_CMD_SET_HB_INTERVAL = "SET_HB_INTERVAL";
    private static final String AGENT_CMD_SET_HB_CTIMEOUT = "SET_HB_CTIMEOUT";
    private static final String AGENT_CMD_SET_HB_RTIMEOUT = "SET_HB_RTIMEOUT";
    private static final String AGENT_CMD_FLUSH_CE = "FLUSH_CE";
    private static final String AGENT_CMD_GET_ACTIVE_VALUES = "GET_ACTIVE_VALUES";
    private static final String AGENT_CMD_SET_LOGLEVEL = "SET_LOGLEVEL";
    private static final String AGENT_CMD_SET_LOGLIMITS = "SET_LOGLIMITS";
    private static final String AGENT_CMD_GET_LOGLEVEL = "GET_LOGLEVEL";
    private static final String AGENT_CMD_SET_SERVER = "SET_SERVER";
    private static final String AGENT_CMD_GET_VERSION = "GET_VERSION";
    private static final String AGENT_CMD_GET_PID = "GET_PID";
    private static final String AGENT_CMD_GET_ID = "GET_ID";
    private static final String AGENT_CMD_DISABLE_POLICY = "DISABLE_POLICY";
    private static final String AGENT_CMD_DISABLE_AGENT = "DISABLE_AGENT";
    private static final String AGENT_CMD_ENABLE_POLICY = "ENABLE_POLICY";
    private static final String AGENT_CMD_POLICIES = "POLICIES";
    private static final String AGENT_CMD_ENABLE_AGENT = "ENABLE_AGENT";
    private static final String AGENT_CMD_GET_DETAILS = "GET_DETAILS";
    private static final String AGENT_CMD_EMULATE_JAVAMONCALL = "EMULATE_JAVAMONCALL";
    private static final String AGENT_CMD_SET_MODE7 = "SET_MODE7";
    private static final String AGENT_CMD_SET_MODE0 = "SET_MODE0";
    private static final String AGENT_CMD_GET_CLUSTERNODES = "GET_CLUSTERNODES";
    private static final String AGENT_CMD_SET_CLUSTERNODES = "SET_CLUSTERNODES";
    private static final String AGENT_CMD_SET_PLOG = "SET_PLOG";
    private static final String AGENT_CMD_SET_MSD_SETTINGS = "SET_MSD_SETTINGS";
    private static final String AGENT_CMD_GET_MONITOR_HISTORY = "GET_MONITOR_HISTORY";
    private static final String AGENT_CMD_GET_MAX_MONITORSERIES_SIZE = "GET_MAX_MSSIZE";
    private static final String AGENT_CMD_SET_MAX_MONITORSERIES_SIZE = "SET_MAX_MSSIZE";
    private static final String AGENT_CMD_CLEAR_MONITORSERIES = "CLEAR_MS";
    private static final String AGENT_CMD_SET_FTDIR = "SET_FTDIR";
    private static final String AGENT_CMD_STORE_SIGNED_CERT = "STORE_SIGNED_CERT";
    private static final String AGENT_CMD_UPDATE_CA_CERT = "UPDATE_CA_CERT";
    private static final String AGENT_CMD_GET_CERT_INFO = "GET_CERT_INFO";
    private static final String AGENT_CMD_STORE_TRUSTED_CERT = "STORE_TRUSTED_CERT";
    private static final String AGENT_CMD_PING_AGENT = "PING_AGENT";
    public static final String CONNECTION_BACKUP_PROPS = "conn_bkp.props";
    private AgentEngine agentEngine = AgentEngine.getInstance();

    public void processJavaAction(SDataOutputStream out, String[] commandArr, int secondsToWait) throws IOException {
        if (commandArr.length > 1) {
            List<String> arguments = AgentActionExecutor.parseParams2(commandArr);
            arguments.remove(0);
            String className = arguments.remove(0);
            AgentActionResponse resp = this.processJavaAction(null, null, className, arguments, secondsToWait);
            out.writeInt(resp.getResultCode());
            out.writeUTF(resp.getOutput());
        } else {
            out.writeInt(-1);
            out.writeUTF("Wrong format.\nFormat:\nIAction <full qualified java class path> [<param1> <param2>...]");
        }
    }

    public AgentActionResponse processJavaAction(String server, String operationId, String className, List<String> arguments, int secondsToWait) {
        AgentActionResponse resp;
        block9: {
            resp = new AgentActionResponse(server, operationId);
            if (!AgentEngine.getInstance().getAgentProperties().isActionsEnabled()) {
                return resp.setResultCode(3).setOutput("Actions is not allowed");
            }
            try {
                Class actionClass = BMClassLoader.findClass2(className);
                try {
                    Constructor constr = actionClass.getConstructor(new Class[0]);
                    Object instance = constr.newInstance(new Object[0]);
                    if (instance instanceof IAction) {
                        try {
                            String str = ((IAction)instance).run(arguments.toArray(new String[0]), secondsToWait);
                            resp.setResultCode(0);
                            if (str == null) {
                                str = "null";
                            }
                            resp.setOutput(str);
                        }
                        catch (Throwable e) {
                            resp.setResultCode(-5);
                            resp.setOutput("Class " + className + " failed to execute action.\nException:\n" + e.getMessage());
                        }
                        break block9;
                    }
                    resp.setResultCode(-4);
                    resp.setOutput("Class " + className + " has no implementation for IAction interface");
                }
                catch (Exception e) {
                    resp.setResultCode(-3);
                    resp.setOutput("Class " + className + " instantiation failed: " + e.getMessage());
                }
            }
            catch (ClassNotFoundException e) {
                resp.setResultCode(-2);
                resp.setOutput("Class not found: " + className);
            }
        }
        return resp;
    }

    public void processAgentActions(SDataOutputStream out, String[] splitArray, int secondsToWait) throws IOException {
        AgentActionResponse resp = this.processAgentActions(null, null, splitArray, secondsToWait);
        out.writeInt(resp.getResultCode());
        out.writeUTF(resp.getOutput());
        RTLogger.print(5, "Action ok " + (splitArray == null || splitArray.length == 0 ? "?" : splitArray[0]));
    }

    public AgentActionResponse processAgentActions(String server, String operationId, String[] splitArray, int secondsToWait) throws IOException {
        AgentActionResponse resp = new AgentActionResponse(server, operationId);
        StringBuilder sb = new StringBuilder();
        Scheduler scheduler = this.agentEngine.getScheduler();
        PolicyRepository policyRepository = this.agentEngine.getPolicyRepository();
        if (splitArray.length > 1) {
            String cmd = splitArray[1];
            RTLogger.print(4, "IAAction cmd: " + Arrays.asList(splitArray));
            if (cmd.equals(AGENT_CMD_GET_VERSION)) {
                resp.setOutput(this.agentEngine.getAgentVersion());
            } else if (cmd.equals(AGENT_CMD_GET_PID)) {
                resp.setOutput(AgentEngine.PID);
            } else if (cmd.equals(AGENT_CMD_GET_ID)) {
                resp.setOutput(this.agentEngine.getAgentID());
            } else if (cmd.equals(AGENT_CMD_SET_LOGLEVEL)) {
                this.cmdSetLogLevel(resp, sb, splitArray[2]);
            } else if (cmd.equals(AGENT_CMD_SET_LOGLIMITS)) {
                this.cmdSetLogLimits(resp, sb, splitArray);
            } else if (cmd.equals(AGENT_CMD_GET_LOGLEVEL)) {
                this.cmdGetLogLevel(resp);
            } else if (cmd.equals(AGENT_CMD_SET_SERVER)) {
                this.cmdSetServer(resp, sb, splitArray);
            } else if (cmd.equals(AGENT_CMD_GET_CLUSTERNODES)) {
                resp.setOutput(this.printClusterNodes("Current cluster nodes:"));
            } else if (cmd.equals(AGENT_CMD_SET_CLUSTERNODES)) {
                this.cmdSetClusterNodes(resp, sb, splitArray);
            } else if (cmd.equals(AGENT_CMD_SET_HB_INTERVAL)) {
                this.cmdSetHbInterval(resp, sb, splitArray, scheduler);
            } else if (cmd.equals(AGENT_CMD_SET_HB_CTIMEOUT)) {
                this.cmdSetHbCTimeout(resp, sb, splitArray);
            } else if (cmd.equals(AGENT_CMD_SET_HB_RTIMEOUT)) {
                this.cmdSetHbRTimeout(resp, sb, splitArray);
            } else if (cmd.equals(AGENT_CMD_FLUSH_CE)) {
                this.agentEngine.getCalcEngine().flashActiveStatuses();
                resp.setOutput("Flush calc engine: OK");
            } else if (cmd.equals(AGENT_CMD_GET_ACTIVE_VALUES)) {
                this.cmdGetActiveValues(resp, sb);
            } else if (cmd.equals(AGENT_CMD_GET_MONITOR_HISTORY)) {
                this.cmdGetMonitorHistory(resp, splitArray);
            } else if (cmd.equals(AGENT_CMD_DISABLE_POLICY)) {
                this.cmdDisablePolicy(resp, sb, splitArray, policyRepository);
            } else if (cmd.equals(AGENT_CMD_ENABLE_POLICY)) {
                this.cmdEnablePolicy(resp, sb, splitArray, policyRepository);
            } else if (cmd.equals(AGENT_CMD_POLICIES)) {
                this.cmdPolicies(resp, sb, policyRepository);
            } else if (cmd.equals(AGENT_CMD_DISABLE_AGENT)) {
                this.agentEngine.setDisabled(true);
                resp.setOutput("Agent disabled");
            } else if (cmd.equals(AGENT_CMD_ENABLE_AGENT)) {
                this.agentEngine.setDisabled(false);
                resp.setOutput("Agent enabled");
            } else if (cmd.equals(AGENT_CMD_SHARED_IP)) {
                this.cmdSetSharedIP(resp, splitArray);
            } else if (cmd.equals(AGENT_CMD_GET_DETAILS)) {
                AgentEngine.inventory(sb, true);
                resp.setOutput(sb.toString());
            } else if (cmd.equals(AGENT_CMD_EMULATE_JAVAMONCALL)) {
                this.cmdEmulateJavaMonCall(secondsToWait, resp, splitArray);
            } else if (cmd.equals(AGENT_CMD_SET_MODE7)) {
                this.agentEngine.setMode(7);
                this.agentEngine.storeProps();
                scheduler.removeTask(this.agentEngine.sendTask.getName());
                scheduler.removeTask(this.agentEngine.m_hb.getName());
                if (this.agentEngine.getAgentProperties().getCommType().contains("WEBSOCKET")) {
                    this.agentEngine.getNettyEndpoint().stopSendTaskNetty();
                }
                resp.setOutput("Agent is now set to MODE=7");
            } else if (cmd.equals(AGENT_CMD_SET_MODE0)) {
                this.agentEngine.setMode(0);
                this.agentEngine.storeProps();
                this.agentEngine.initHB();
                this.agentEngine.startSendTask();
                if (this.agentEngine.getAgentProperties().getCommType().contains("WEBSOCKET")) {
                    this.agentEngine.getNettyEndpoint().startSendTaskNetty();
                }
                resp.setOutput("Agent is now set to MODE=0");
            } else if (cmd.equals(AGENT_CMD_GET_IP)) {
                resp.setOutput(this.agentEngine.getAgentIP());
            } else if (cmd.equals(AGENT_CMD_STATUS)) {
                this.cmdGetStatus(resp, sb, policyRepository);
            } else if (cmd.equals(AGENT_CMD_SET_PLOG)) {
                this.cmdSetPLog(resp, sb, splitArray, policyRepository);
            } else if (cmd.equals(AGENT_CMD_SETVAR)) {
                this.processVariables(splitArray);
                resp.setOutput(Env.getInstance().toString());
            } else if (cmd.equals(AGENT_CMD_GETVAR)) {
                this.cmdGetVar(resp, splitArray);
            } else if (cmd.equals(AGENT_CMD_DISABLE_ACTIONS)) {
                this.agentEngine.getAgentProperties().setActionsEnabled(false);
                this.agentEngine.storeProps();
                resp.setOutput("Remote actions disabled");
            } else if (cmd.equals(AGENT_CMD_REMVAR)) {
                this.cmdRemoveVar(resp, splitArray);
            } else if (cmd.startsWith(AGENT_CMD_SET_MSD_SETTINGS)) {
                this.cmdSetMSD(resp, sb, splitArray);
            } else if (cmd.startsWith(AGENT_CMD_GET_MSD_SETTINGS)) {
                sb.append("Maximum message per minute: ").append(this.agentEngine.getAgentProperties().getMsdMaxPerMin()).append('\n');
                sb.append("Blocking period (minutes): ").append(this.agentEngine.getAgentProperties().getMsdBlockMin()).append('\n');
                resp.setOutput(sb.toString());
            } else if (cmd.startsWith("@@@ID")) {
                Message m = new Message("BOOM_AGENT", "TEST", "TEST", System.currentTimeMillis());
                m.setOptional(1, "BOOM_AGENT", AgentEngine.getInstance().getAgentHostname());
                m.p8_messageKey = AgentEngine.getInstance().getAgentHostname() + ":" + "BOOM_AGENT" + ":INVENTORY";
                m.p9_ackKey = AgentEngine.getInstance().getAgentHostname() + ":" + "BOOM_AGENT" + ":INVENTORY";
                m.p11_2_autoActionTimeout = 30;
                m.m_internalMsg = true;
                m.p00_uuid = "00000000-0000-0000-0000-100000000000";
                AgentEngine.getInstance().getMsgSubmitter().submitInternal(m);
                resp.setOutput(m.p00_uuid + " " + m.m_orig_text);
            } else if (cmd.equals(AGENT_CMD_OD2ACN_ON)) {
                this.agentEngine.getAgentProperties().setOfferDataToAnyClusterNode(true);
                this.agentEngine.getAgentProperties().save();
                RTLogger.print(1, "OFFER_DATA_TO_ANY_CLUSTER_NODE=TRUE");
                resp.setOutput("OFFER_DATA_TO_ANY_CLUSTER_NODE=TRUE stored and activated");
            } else if (cmd.equals(AGENT_CMD_OD2ACN_OFF)) {
                this.agentEngine.getAgentProperties().setOfferDataToAnyClusterNode(false);
                this.agentEngine.getAgentProperties().save();
                RTLogger.print(1, "OFFER_DATA_TO_ANY_CLUSTER_NODE=FALSE");
                resp.setOutput("OFFER_DATA_TO_ANY_CLUSTER_NODE=FALSE stored and activated");
            } else if (cmd.equals("CLEAR_MON_BUFFER")) {
                AgentEngine.getInstance().getMonitorQueue().m_queue.clear();
                resp.setOutput("OK");
            } else if (cmd.equals("CLEAR_MSG_BUFFER")) {
                AgentEngine.getInstance().getMessageQueue().m_queue.clear();
                resp.setOutput("OK");
            } else if (cmd.equals("CLEAR_FA_BUFFER")) {
                AgentEngine.getInstance().getFAQueue().m_queue.clear();
                resp.setOutput("OK");
            } else if (cmd.equals("CLEAR_PERF_BUFFER")) {
                AgentEngine.getInstance().getPerfQueue().m_queue.clear();
                resp.setOutput("OK");
            } else if (cmd.equals("TRIGGER_POLICY_NOW")) {
                this.cmdTriggerPolicyNow(resp, sb, splitArray);
            } else if (cmd.startsWith("GETHASH=")) {
                this.cmdGetHash(cmd, resp);
            } else if (cmd.equals("GET_LOOKUP_SERVICES")) {
                this.cmdLookupService(resp, sb);
            } else if (cmd.equals("GET_LOOKUP_SERVICE_DATA")) {
                this.cmdLookupServiceData(resp, sb, splitArray);
            } else if (cmd.equals(AGENT_CMD_GET_MAX_MONITORSERIES_SIZE)) {
                sb.append("MaxMsSize=").append(this.agentEngine.getAgentProperties().getMaxMonitorSeriesSize());
                resp.setOutput(sb.toString());
            } else if (cmd.equals(AGENT_CMD_SET_MAX_MONITORSERIES_SIZE)) {
                this.cmdSetMaxMonitorSeriesSize(resp, sb, splitArray);
            } else if (cmd.equals(AGENT_CMD_CLEAR_MONITORSERIES)) {
                this.agentEngine.getCalcEngine().clearMonitorSeries();
                sb.append("done");
                resp.setOutput(sb.toString());
            } else if (cmd.equals(AGENT_CMD_SET_FTDIR)) {
                this.cmdSetFtDir(resp, splitArray[2]);
            } else if (cmd.equals(AGENT_CMD_STORE_SIGNED_CERT)) {
                if (AgentEngine.getInstance().getAgentProperties().isTlsActivated()) {
                    sb.append(this.storeSignedCertificate(splitArray[2]));
                } else {
                    sb.append("TLS is deactivated");
                }
                resp.setOutput(sb.toString());
            } else if (cmd.equals(AGENT_CMD_UPDATE_CA_CERT)) {
                if (AgentEngine.getInstance().getAgentProperties().isTlsActivated()) {
                    String certificate = splitArray[2];
                    if (certificate.length() > 2 && certificate.startsWith("\"") && certificate.endsWith("\"")) {
                        certificate = certificate.substring(1, certificate.length() - 2);
                    }
                    sb.append(this.updateCACertificate(certificate));
                } else {
                    sb.append("TLS is deactivated");
                }
                resp.setOutput(sb.toString());
            } else if (cmd.equals(AGENT_CMD_GET_CERT_INFO)) {
                sb.append(this.getCertificateInfo());
                resp.setOutput(sb.toString());
            } else if (cmd.equals(AGENT_CMD_STORE_TRUSTED_CERT)) {
                if (AgentEngine.getInstance().getAgentProperties().isTlsActivated()) {
                    String certificate = splitArray[2];
                    if (certificate.length() > 2 && certificate.startsWith("\"") && certificate.endsWith("\"")) {
                        certificate = certificate.substring(1, certificate.length() - 2);
                    }
                    sb.append(this.storeTrustedCert(certificate));
                } else {
                    sb.append("TLS deactivated");
                }
                resp.setOutput(sb.toString());
            } else if (cmd.equals(AGENT_CMD_PING_AGENT)) {
                resp.setOutput("PONG");
            } else if (cmd.equals("ENABLE_AGENT_TLS")) {
                sb.append(this.processEnableTLS(splitArray));
                resp.setOutput(sb.toString());
            } else if (cmd.equals("DISABLE_AGENT_TLS")) {
                if (AgentEngine.getInstance().getAgentProperties().getCommType().equals("WEBSOCKET")) {
                    sb.append("ERROR: Current communication type WEBSOCKET cannot be changed");
                } else if (AgentEngine.getInstance().getAgentProperties().isTlsActivated()) {
                    sb.append(this.processDisableAgentTLS(splitArray[2]));
                } else {
                    sb.append("TLS is already deactivated");
                }
                resp.setOutput(sb.toString());
            } else if (cmd.startsWith("SETID=")) {
                String id = cmd.substring(cmd.indexOf(61) + 1);
                this.agentEngine.setID(id);
                RTLogger.print(1, "Server sent new ID: " + id);
                this.agentEngine.getScheduledExecutor().execute(this.agentEngine.getNettyEndpoint()::restart);
            } else if (cmd.startsWith("REDIRECT=")) {
                try {
                    String json = cmd.substring(cmd.indexOf(61) + 1);
                    ServerInfo srvInfo = new GsonBuilder().create().fromJson(json, ServerInfo.class);
                    RTLogger.print(1, "Server sent redirect: " + json);
                    this.agentEngine.getScheduledExecutor().execute(() -> this.agentEngine.setSlaveServerHost(srvInfo));
                }
                catch (Exception e) {
                    resp.setResultCode(1).setOutput(e.getMessage() == null ? e.getClass().toString() : e.getMessage());
                }
            } else if (cmd.startsWith("RESTART=")) {
                try {
                    String message = cmd.substring(cmd.indexOf(61) + 1);
                    RTLogger.print(1, "Server sent restart request: " + message);
                    this.agentEngine.restart();
                }
                catch (Exception e) {
                    resp.setResultCode(1).setOutput(e.getMessage() == null ? e.getClass().toString() : e.getMessage());
                }
            } else {
                RTLogger.print(3, "Unknown Agent command: {" + cmd + "}");
                resp.setResultCode(1).setOutput(this.echoUsage());
            }
        } else {
            resp.setResultCode(1).setOutput(this.echoUsage());
        }
        return resp;
    }

    private String processEnableTLS(String[] splitArray) {
        StringBuilder sb = new StringBuilder();
        if (AgentEngine.getInstance().getAgentProperties().getCommType().equals("WEBSOCKET")) {
            sb.append("ERROR: Current communication type WEBSOCKET cannot be changed");
        } else {
            String certificate = splitArray[2];
            if (certificate.length() > 2 && certificate.startsWith("\"") && certificate.endsWith("\"")) {
                certificate = certificate.substring(1, certificate.length() - 1);
            }
            String tlsPort = splitArray[3];
            if (AgentEngine.getInstance().getAgentProperties().isTlsActivated()) {
                sb.append("TLS is already activated");
            } else {
                sb.append(this.processEnableAgentTLS(certificate, tlsPort));
            }
        }
        return sb.toString();
    }

    private String processEnableAgentTLS(String caCertificate, String tlsPort) {
        Integer agentTlsPort;
        AProperties agentProperties = AgentEngine.getInstance().getAgentProperties();
        try {
            agentTlsPort = Integer.valueOf(tlsPort);
        }
        catch (NumberFormatException e) {
            RTLogger.print(1, "Could not parse tlsPort in order to enable TLS, tlsPort: " + tlsPort, e);
            return "Error parsing tls port";
        }
        Path backupFile = Paths.get(AgentEngine.getInstance().DIR_CONF, CONNECTION_BACKUP_PROPS);
        try {
            ConnectionSettingsBackupHelper.backup(backupFile);
        }
        catch (IOException e) {
            RTLogger.print(1, "Could not backup connection settings", e);
            return "Could not backup connection settings " + e.getMessage();
        }
        String originalCommType = agentProperties.getCommType();
        agentProperties.setAgentTlsPort(agentTlsPort);
        agentProperties.setTsFile("conf/truststore.p12");
        agentProperties.setTsPassEncoded("////+wAAABAyuYmqjIHWMWODdXEl8/bD");
        agentProperties.setKsFile("conf/keystore.p12");
        agentProperties.setKsPassEncoded("////+wAAABAyuYmqjIHWMWODdXEl8/bD");
        agentProperties.setCommType("TLS");
        agentProperties.save();
        try {
            this.agentEngine.initCertificateManager();
        }
        catch (CertificateManagerInitializationException e) {
            RTLogger.print(1, "Could not initialize certificate manager. Rollback to " + originalCommType, e);
            this.processDisableAgentTLS(originalCommType);
            return "Could not initialize certificate manager. " + e.getMessage();
        }
        try {
            this.agentEngine.getCertManager().getTsClient().importTrustedCACertificate(caCertificate.getBytes());
            this.agentEngine.getCertManager().getTsClient().saveKeyStore();
            AgentCertStateIndicationHelper.sendCACertificateImported();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            RTLogger.print(1, "Could not import trusted certificate in order to activate TLS. Rollback to " + originalCommType, e);
            this.processDisableAgentTLS(originalCommType);
            return "Could not import trusted certificate. " + e.getMessage();
        }
        this.sendIndicationConnectivitySettingsAreBeingChanged();
        RTLogger.print(1, "Restarting Agent due to TLS activation.");
        AgentEngine.getInstance().shutdownServerSocket();
        AgentEngine.getInstance().startAgent();
        AgentEngine.getInstance().scheduleConnectionCheckAfterTLSSwitchTask();
        return "done";
    }

    private String processDisableAgentTLS(String connectionType) {
        StringBuilder result = new StringBuilder();
        AProperties agentProperties = AgentEngine.getInstance().getAgentProperties();
        Path backupFile = Paths.get(AgentEngine.getInstance().DIR_CONF, CONNECTION_BACKUP_PROPS);
        try {
            ConnectionSettingsBackupHelper.backup(backupFile);
        }
        catch (IOException e) {
            RTLogger.print(1, "Could not backup connection settings", e);
            result.append("Could not backup connection settings " + e.getMessage());
            return result.toString();
        }
        if (!("SOCKET".equalsIgnoreCase(connectionType) || "HTTPS".equalsIgnoreCase(connectionType) || "HTTP".equalsIgnoreCase(connectionType))) {
            result.append("Unsupported connection type " + connectionType);
            return result.toString();
        }
        agentProperties.setCommType(connectionType);
        String ksFilePath = agentProperties.getKsFile();
        String tsFilePath = agentProperties.getTsFile();
        agentProperties.setKsFile(null);
        agentProperties.setKsPassEncoded(null);
        agentProperties.setTsFile(null);
        agentProperties.setTsPassEncoded(null);
        agentProperties.save();
        ArrayList<Path> filesToDelete = new ArrayList<Path>();
        filesToDelete.add(Paths.get(ksFilePath, new String[0]));
        filesToDelete.add(Paths.get(tsFilePath, new String[0]));
        filesToDelete.add(Paths.get(ksFilePath, new String[0]).toAbsolutePath().getParent().resolve("agent.csr"));
        this.sendIndicationConnectivitySettingsAreBeingChanged();
        RTLogger.print(1, "Restarting Agent due to TLS activation.");
        AgentEngine.getInstance().shutdownServerSocket();
        AgentEngine.getInstance().startAgent();
        AgentEngine.getInstance().scheduleConnectionCheckAfterTLSSwitchTask();
        return "done. AgentPort=" + AgentEngine.getInstance().getAgentPort();
    }

    private void sendIndicationConnectivitySettingsAreBeingChanged() {
        AgentEngine.getInstance().sendMessage(AgentEngine.getInstance().getAgentHostname(), "BOOM_AGENT", "BOOM_AGENT", "Agent_Conn_Settings", "Boom agent connectivity config change is being applied", "normal", new HashMap());
    }

    private String getCertificateInfo() {
        StringBuilder builder = new StringBuilder();
        if (AgentEngine.getInstance().getAgentProperties().isTlsActivated()) {
            try {
                List<BasicCertificateInfo> ksInfoList = AgentEngine.getInstance().getCertManager().getKsClient().getCertificatesInfo();
                List<BasicCertificateInfo> tsInfoList = AgentEngine.getInstance().getCertManager().getTsClient().getCertificatesInfo();
                builder.append("========== Key Store ==========\n");
                String ksInfo = ksInfoList.stream().map(info -> CertificateSerializationHelper.certificateInfoToString(info) + "\n------------------------------\n").collect(Collectors.joining("\n"));
                builder.append(ksInfo).append('\n');
                builder.append("========== Trust Store ==========\n");
                String tsInfo = tsInfoList.stream().map(info -> CertificateSerializationHelper.certificateInfoToString(info) + "\n------------------------------\n").collect(Collectors.joining("\n"));
                builder.append(tsInfo).append('\n');
            }
            catch (Exception e) {
                builder.append("Could not get certificate info. " + e.getMessage());
            }
        } else {
            builder.append("TLS is deactivated");
        }
        return builder.toString();
    }

    private String updateCACertificate(String certificate) {
        String result;
        try {
            CertificateManager certManager = AgentEngine.getInstance().getCertManager();
            TrustStoreClient tsClient = certManager.getTsClient();
            boolean imported = tsClient.importTrustedCACertificate(certificate.getBytes());
            if (imported) {
                RTLogger.print(1, "At least one CA certificate has been imported");
                tsClient.saveKeyStore();
                AgentCertStateIndicationHelper.sendCACertificateImported();
            } else {
                RTLogger.print(1, "Skipped import of the CA certificate, since already imported");
            }
            Certificate[] certificateChain = certManager.getKsClient().getKeyStore().getCertificateChain("agent");
            if (imported || certificateChain.length > 1 && !TlsUtils.isCertificateSignedBy(certificateChain[certificateChain.length - 1], tsClient.getLatestCACertificate())) {
                AgentActionExecutor.createRenewalKeyStore();
            }
            result = "done";
        }
        catch (Exception e) {
            result = e.getMessage();
        }
        return result;
    }

    public static synchronized void createRenewalKeyStore() throws Exception {
        AgentEngine agentEngine = AgentEngine.getInstance();
        AProperties agentProperties = agentEngine.getAgentProperties();
        Path newKsFile = agentEngine.getCertManager().getRenewalKeyStore().getKeyStorePath();
        if (!Files.exists(agentEngine.getCertManager().getRenewalKeyStore().getKeyStorePath(), new LinkOption[0])) {
            CertificateManager tmpCertManager = new CertificateManager();
            tmpCertManager.initAgentKeyStore("agent", agentEngine.getAgentHostname(), newKsFile.toAbsolutePath().toString(), agentProperties.getKsPassEncoded(), agentProperties.getAllIPs(), agentProperties.getAllHostnames());
            byte[] certificateRequest = tmpCertManager.getKsClient().createAgentCertificateRequest("agent", agentProperties.getAllIPs(), agentProperties.getAllHostnames());
            Files.write(Paths.get(agentProperties.getKsFile(), new String[0]).toAbsolutePath().getParent().resolve("agent.csr"), certificateRequest, new OpenOption[0]);
        }
    }

    private String storeTrustedCert(String certificate) {
        String result;
        try {
            CertificateManager certManager = AgentEngine.getInstance().getCertManager();
            TrustStoreClient tsClient = certManager.getTsClient();
            tsClient.importCertificate("cert_" + System.currentTimeMillis(), certificate.getBytes());
            tsClient.saveKeyStore();
            AgentCertStateIndicationHelper.sendTrustedCertificateImported();
            result = "done";
        }
        catch (Exception e) {
            result = e.getMessage();
        }
        return result;
    }

    private String storeSignedCertificate(String certificateWithChain) {
        String result;
        block15: {
            try {
                CertificateManager certManager = AgentEngine.getInstance().getCertManager();
                KeyStoreClient renewalKeyStore = certManager.getRenewalKeyStore();
                if (renewalKeyStore.exists()) {
                    RTLogger.print(1, "Renewal keystore found " + renewalKeyStore.getKeyStorePath());
                    renewalKeyStore.loadKeyStore();
                    if (this.importCert(certificateWithChain, "agent", renewalKeyStore)) {
                        Path keyStorePath = certManager.getKsClient().getKeyStorePath();
                        Path bkpKeyStorePath = certManager.getBackedUpKeyStore().getKeyStorePath();
                        try {
                            RTLogger.print(1, "Starting backup original keystore mv " + keyStorePath + " " + bkpKeyStorePath);
                            Files.move(keyStorePath, bkpKeyStorePath, StandardCopyOption.ATOMIC_MOVE);
                            try {
                                RTLogger.print(1, "Replacing original keystore mv " + renewalKeyStore.getKeyStorePath() + " " + keyStorePath);
                                Files.move(renewalKeyStore.getKeyStorePath(), keyStorePath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                                certManager.getKsClient().loadKeyStore();
                                AgentEngine.getInstance().getScheduledExecutor().schedule(new ConnectionCheckAfterKSSwitchTask(60000L), 3L, TimeUnit.MINUTES);
                                result = "Successfully switched key stores";
                                RTLogger.print(1, result);
                                AgentCertStateIndicationHelper.sendAgentCertificateUpdate("normal", "Successfully updated agent certificate.");
                            }
                            catch (IOException e) {
                                try {
                                    Files.move(bkpKeyStorePath, keyStorePath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                                    certManager.getKsClient().loadKeyStore();
                                    result = "ERROR: Could not switch key stores continue using the existing one.";
                                    AgentCertStateIndicationHelper.sendAgentCertificateUpdate("major", "Could not switch key stores continue using the existing one");
                                }
                                catch (IOException e1) {
                                    result = "ERROR: Could not switch key stores continue, could not restore keystore backup.";
                                    AgentCertStateIndicationHelper.sendAgentCertificateUpdate("critical", "Failed to restore the keystore from backup.");
                                    RTLogger.print(1, "Failed to restore the keystore from backup ", e1);
                                }
                            }
                        }
                        catch (IOException e) {
                            RTLogger.print(1, "Switch of key stores has failed continue using the existing one.", e);
                            result = "Switch of key stores has failed continue using the existing one.";
                            AgentCertStateIndicationHelper.sendAgentCertificateUpdate("major", "Could not switch key stores continue using the existing one");
                        }
                    } else {
                        result = "didn't import certificate since renewal_keystore contains signed cert.";
                        RTLogger.print(1, result);
                    }
                } else {
                    this.importCert(certificateWithChain, "agent", certManager.getKsClient());
                    result = "done";
                }
                if (!"WEBSOCKET_ONLY".equals(this.agentEngine.getAgentProperties().getCommType())) {
                    if (!"WEBSOCKET_TLS_ONLY".equals(this.agentEngine.getAgentProperties().getCommType())) break block15;
                }
                this.agentEngine.getScheduledExecutor().execute(this.agentEngine.getNettyEndpoint()::restart);
            }
            catch (Exception e) {
                RTLogger.print(1, "Could not import signed certificate " + certificateWithChain, e);
                result = "Could not import signed certificate " + e.getMessage();
                AgentCertStateIndicationHelper.sendAgentCertificateUpdate("major", result);
            }
        }
        return result;
    }

    private boolean importCert(String certificateWithChain, String alias, KeyStoreClient ksClient) throws KeyStoreException, CertificateException, IOException, UnrecoverableEntryException, NoSuchAlgorithmException {
        boolean imported = false;
        if (ksClient.isSelfSignedCertificate(alias)) {
            ksClient.importPrivateKeyCertificate(alias, certificateWithChain.getBytes());
            ksClient.saveKeyStore();
            AgentCertStateIndicationHelper.sendAgentCertificateUpdate("normal", "Successfully imported agent certificate.");
            RTLogger.print(1, "Signed agent certificate successfully imported " + ksClient.getKeyStorePath().getFileName().toString());
            imported = true;
        } else {
            AgentCertStateIndicationHelper.sendAgentCertificateUpdate("warning", "Skipped agent certificate import, since certificate in keystore not self signed.");
            RTLogger.print(1, "Skipped agent certificate import, since certificate in keystore not self signed. " + ksClient.getKeyStorePath().getFileName().toString());
        }
        return imported;
    }

    public void processExecAction(SDataOutputStream out, String command, int secondsToWait) throws IOException {
        AgentActionResponse resp = this.processExecAction(null, null, command, secondsToWait);
        out.writeInt(resp.getResultCode());
        out.writeUTF(resp.getOutput());
    }

    public AgentActionResponse processExecAction(String server, String operationId, String command, int secondsToWait) throws IOException {
        String newFirst;
        AgentActionResponse resp = new AgentActionResponse(server, operationId);
        if (!AgentEngine.getInstance().getAgentProperties().isActionsEnabled()) {
            return resp.setResultCode(3).setOutput("Actions is not allowed");
        }
        StringBuilder sb = new StringBuilder();
        StrUtils strUtils = new StrUtils();
        String[] commandArr2 = strUtils.processQuoted(command);
        String firstCmd2 = commandArr2[0];
        if (firstCmd2.indexOf(92) != -1 && SystemUtils.OS != 1) {
            newFirst = firstCmd2.replace('\\', '/');
            command = command.replace(firstCmd2, newFirst);
        }
        if (firstCmd2.indexOf(47) != -1 && SystemUtils.OS == 1) {
            newFirst = firstCmd2.replace('/', '\\');
            command = command.replace(firstCmd2, newFirst);
        }
        ExecResult er = ExecUtils.exec2(command, this.agentEngine.FILE_SPI_DIR, secondsToWait);
        resp.setResultCode(er.resultCode);
        if (er.resultCode != 0) {
            String str;
            int i;
            for (i = 0; i < er.m_errorMessages.size(); ++i) {
                str = er.m_errorMessages.get(i);
                if (str.length() == 0 && i != er.m_errorMessages.size() - 1) continue;
                sb.append(str).append('\n');
            }
            if (er.m_outMessages.size() > 0) {
                sb.append('\n');
                for (i = 0; i < er.m_outMessages.size(); ++i) {
                    str = er.m_outMessages.get(i);
                    if (str.length() == 0 && i != er.m_outMessages.size() - 1) continue;
                    sb.append(str).append('\n');
                }
            }
            resp.setOutput(sb.toString());
        } else {
            String str;
            int i;
            for (i = 0; i < er.m_outMessages.size(); ++i) {
                str = er.m_outMessages.get(i);
                if (str.length() == 0 && i != er.m_outMessages.size() - 1) continue;
                sb.append(str).append('\n');
            }
            for (i = 0; i < er.m_errorMessages.size(); ++i) {
                str = er.m_errorMessages.get(i);
                if (str.length() == 0 && i != er.m_errorMessages.size() - 1) continue;
                sb.append(str).append('\n');
            }
            resp.setOutput(sb.toString());
        }
        RTLogger.print(3, "Action done. RC=" + er.resultCode + " >>>" + sb);
        return resp;
    }

    private void cmdGetLogLevel(AgentActionResponse resp) {
        resp.setOutput("current loglevel = " + RTLogger.getCurrentLevel());
    }

    private void cmdSetLogLevel(AgentActionResponse resp, StringBuilder sb, String s) {
        try {
            int level = Integer.parseInt(s);
            RTLogger.setLevel(level);
            RTLogger.storeConfig();
            sb.append("LOGLEVEL now set to " + level);
            resp.setOutput("LOGLEVEL now set to " + level);
            this.agentEngine.storeProps();
        }
        catch (Throwable e) {
            sb.append(AGENT_CMD_SET_LOGLEVEL).append(" command failed.\n");
            resp.setResultCode(1);
            resp.setOutput(this.echoUsage());
        }
    }

    private void cmdSetLogLimits(AgentActionResponse resp, StringBuilder sb, String[] splitArray) {
        try {
            int count = Integer.parseInt(splitArray[2]);
            long size = RTLogger.parseMaxSize(splitArray[3]);
            RTLogger.setMaxSize(size);
            RTLogger.setMaxCount(count);
            RTLogger.storeConfig();
            sb.append("LOGCOUNT now set to ").append(RTLogger.getMaxFileCount()).append('\n');
            sb.append("LOGSIZE now set to ").append(RTLogger.getMaxSize() / 0x100000L).append("MB");
            resp.setOutput(sb.toString());
            this.agentEngine.storeProps();
        }
        catch (Throwable e) {
            sb.append(AGENT_CMD_SET_LOGLIMITS).append(" command failed.\n");
            resp.setResultCode(1);
            resp.setOutput(this.echoUsage());
        }
    }

    private void cmdSetSharedIP(AgentActionResponse resp, String[] splitArray) {
        boolean isSharedIP = true;
        if (splitArray.length == 3) {
            try {
                isSharedIP = Boolean.parseBoolean(splitArray[2].toLowerCase());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.agentEngine.setSharedIP(isSharedIP);
        resp.setOutput("SHARED_IP has been set to " + isSharedIP);
    }

    private void cmdSetFtDir(AgentActionResponse resp, String ftDir1) {
        String ftDir = ftDir1;
        if (AProperties.isValidPath(ftDir)) {
            if (ftDir.isEmpty()) {
                ftDir = ".";
            }
            this.agentEngine.getAgentProperties().setFtDir(ftDir);
            this.agentEngine.getAgentProperties().save();
            resp.setOutput("FT_DIR updated to " + ftDir);
        } else {
            resp.setOutput("Given value : '" + ftDir + "' is not valid").setResultCode(1);
        }
    }

    private void cmdSetMaxMonitorSeriesSize(AgentActionResponse resp, StringBuilder sb, String[] splitArray) {
        if (splitArray.length != 3) {
            resp.setResultCode(1).setOutput("Invalid parameter");
        } else {
            String maxMsSize = splitArray[2].toLowerCase();
            try {
                int inmaxMsSize = Integer.parseInt(maxMsSize);
                this.agentEngine.getAgentProperties().setMaxMonitorSeriesSize(inmaxMsSize);
                this.agentEngine.getAgentProperties().save();
                this.agentEngine.getCalcEngine().setMaxMonitorSeriesSize(inmaxMsSize);
                sb.append("MaxMsSize=").append(this.agentEngine.getAgentProperties().getMaxMonitorSeriesSize());
                resp.setOutput(sb.toString());
            }
            catch (NumberFormatException e) {
                resp.setResultCode(1).setOutput("Invalid parameter. Integer expected.");
            }
        }
    }

    private void cmdLookupServiceData(AgentActionResponse resp, StringBuilder sb, String[] splitArray) {
        try {
            if (splitArray.length < 2) {
                throw new RuntimeException("Please specify lookup service name");
            }
            ILookup ls = ((Env)Env.getInstance()).getLookupService(splitArray[2]);
            if (ls == null) {
                sb.append("Lookup service not found: " + splitArray[2]).append('\n');
            } else {
                sb.append(ls.getInfo()).append('\n');
                TreeMap<String, List<String>> values = new TreeMap<String, List<String>>(ls.getValues());
                for (Map.Entry en : values.entrySet()) {
                    sb.append((String)en.getKey()).append(" : ").append(en.getValue()).append('\n');
                }
            }
            resp.setOutput(sb.toString());
        }
        catch (Throwable e) {
            resp.setResultCode(1).setOutput(e.getMessage());
        }
    }

    private void cmdLookupService(AgentActionResponse resp, StringBuilder sb) {
        try {
            List<String> services = ((Env)Env.getInstance()).getLookupServices();
            for (String service : services) {
                sb.append(service).append('\n');
            }
            resp.setOutput(sb.toString());
        }
        catch (Throwable e) {
            resp.setResultCode(1).setOutput(e.getMessage());
        }
    }

    private void cmdGetHash(String command, AgentActionResponse resp) {
        String file = command.substring(command.indexOf(61) + 1);
        File fcheck = new File(file);
        try {
            String report = FileSyncUtils.getDigest(fcheck);
            resp.setOutput(report);
        }
        catch (Throwable e) {
            resp.setResultCode(1).setOutput(e.getMessage());
        }
    }

    private void cmdTriggerPolicyNow(AgentActionResponse resp, StringBuilder sb, String[] splitArray) {
        for (int i = 2; i < splitArray.length; ++i) {
            String policyName = splitArray[i];
            SchedulerTask st = AgentEngine.getInstance().getScheduler().getTask(policyName);
            if (st != null) {
                Thread tr = new Thread(st);
                tr.start();
                sb.append("Policy ").append(policyName).append(" runs now.\n");
                continue;
            }
            sb.append("Policy ").append(policyName).append(" not found!\n");
        }
        resp.setOutput(sb.toString());
    }

    private void cmdSetMSD(AgentActionResponse resp, StringBuilder sb, String[] splitArray) {
        int msd_mpm = -1;
        int msd_bp = -1;
        int msd_qp = 0;
        try {
            msd_mpm = Integer.parseInt(splitArray[2]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            msd_bp = Integer.parseInt(splitArray[3]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            msd_qp = Integer.parseInt(splitArray[4]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (msd_mpm == -1 && msd_bp == -1) {
            resp.setResultCode(1).setOutput("Invalid parameters. expected <max_messages_per_minute> <block_time_minutes>");
        } else {
            this.agentEngine.getAgentProperties().setMsgMaxPerMin(msd_mpm);
            this.agentEngine.getAgentProperties().setMsdBlockMin(msd_bp);
            this.agentEngine.getAgentProperties().setMsdQuarantineMin(msd_qp);
            this.agentEngine.storeProps();
            this.agentEngine.getMessageStormFilter().configureDefaults(msd_mpm, msd_bp, msd_qp);
            sb.append("Maximum message per minute: ").append(this.agentEngine.getAgentProperties().getMsdMaxPerMin()).append('\n');
            sb.append("Blocking period (minutes): ").append(this.agentEngine.getAgentProperties().getMsdBlockMin()).append('\n');
            resp.setOutput(sb.toString());
        }
    }

    private void cmdRemoveVar(AgentActionResponse resp, String[] splitArray) {
        StringBuilder sbs = new StringBuilder();
        for (int i = 2; i < splitArray.length; ++i) {
            String varName = new StrUtils().removeQuotesStrict(splitArray[i]);
            if (Env.getInstance().getVariable(varName) != null) {
                Env.getInstance().getVariables().remove(varName);
                sbs.append("var '").append(varName).append("' removed\n");
                continue;
            }
            sbs.append("var '").append(varName).append("' not found\n");
        }
        resp.setOutput(sbs.toString());
    }

    private void cmdGetVar(AgentActionResponse resp, String[] splitArray) {
        String value = "not defined";
        if (splitArray.length > 2) {
            String varname = new StrUtils().removeQuotesStrict(splitArray[2]);
            value = Env.getInstance().getVariable(varname);
            value = value == null ? "VARIABLE_NOT_DEFINED\n" : value + '\n';
        } else {
            value = Env.getInstance().toString();
        }
        resp.setOutput(value);
    }

    private void cmdSetPLog(AgentActionResponse resp, StringBuilder sb, String[] splitArray, PolicyRepository policyRepository) {
        if (splitArray.length >= 4) {
            try {
                String onoff = splitArray[2];
                boolean enabled = "ON".equalsIgnoreCase(onoff);
                int start = 3;
                int count = 0;
                int size = 0;
                if (enabled) {
                    String logcount = splitArray[start++];
                    String logsize = splitArray[start++];
                    count = Integer.parseInt(logcount);
                    size = Integer.parseInt(logsize);
                    if (count <= 0 && size <= 0) {
                        throw new RuntimeException("LOGCOUNT and LOGSIZE values must be > 0");
                    }
                }
                Pattern numb = Pattern.compile("\\d+");
                for (int i = start; i < splitArray.length; ++i) {
                    String msgPolicyName = splitArray[i];
                    if (numb.matcher(msgPolicyName).matches()) continue;
                    MsgPolicy mp = policyRepository.getMsgPolicy(msgPolicyName);
                    if (mp != null) {
                        if (count > 0) {
                            mp.setPlogLogcount(count);
                        }
                        if (size > 0) {
                            mp.setPlogLogsize(size);
                        }
                        mp.setPlogEnabled(enabled);
                        policyRepository.storePolicy(mp);
                        sb.append("Indication Policy ").append(msgPolicyName).append(" set PLOG=").append(onoff).append('\n');
                        continue;
                    }
                    sb.append("Indication Policy ").append(msgPolicyName).append(" not found").append('\n');
                }
                resp.setOutput(sb.toString());
            }
            catch (Throwable e) {
                resp.setResultCode(1).setOutput("Invalid parameters: " + e.getMessage());
            }
        } else {
            resp.setResultCode(1).setOutput("Invalid parameters");
        }
    }

    private void cmdGetStatus(AgentActionResponse resp, StringBuilder sb, PolicyRepository policyRepository) {
        DecimalFormat df = new DecimalFormat("#.##");
        String status = "no";
        if (this.agentEngine.sendTask == null) {
            status = this.agentEngine.pendingUpdates() ? "yes" : "no";
        } else if (this.agentEngine.sendTask.isBuffering) {
            status = "yes";
        }
        sb.append("Version: ").append(this.agentEngine.getAgentVersion()).append('\n');
        sb.append("Started: ").append(AgentHealth.getStartTime()).append('\n');
        sb.append("PID: ").append(AgentEngine.PID).append('\n');
        sb.append("ID: ").append(this.agentEngine.getAgentID()).append('\n');
        sb.append("Enabled: ").append(!this.agentEngine.getDisabled()).append('\n');
        sb.append("FixedHostname: ").append(this.agentEngine.isFixedHostnameUsed()).append('\n');
        sb.append("Hostname: ").append(this.agentEngine.getAgentHostname()).append('\n');
        sb.append("FixedIP: ").append(this.agentEngine.isFixedIPUsed()).append('\n');
        sb.append("IP: ").append(this.agentEngine.getAgentIP()).append('\n');
        sb.append("Port: ").append(this.agentEngine.getAgentPort()).append('\n');
        sb.append("ServerStatus: ");
        int mode = this.agentEngine.getMode();
        switch (mode) {
            case 0: {
                sb.append("Connecting to the server");
                break;
            }
            case 1: {
                sb.append("Server online");
                break;
            }
            case 2: 
            case 3: {
                sb.append("Server offline");
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                sb.append("Server probably firewalled");
                break;
            }
            case 7: {
                sb.append("Waiting connection from the server");
                break;
            }
            case 8: {
                sb.append("Server connected");
                break;
            }
        }
        sb.append('\n');
        sb.append("ServerHostname: ").append(this.agentEngine.getServers().getCurrentServer().getHost()).append('\n');
        sb.append("ServerIP: ").append(this.agentEngine.getServers().getCurrentServer().getPublicIP()).append('\n');
        sb.append("ServerPort: ").append(this.agentEngine.getServers().getCurrentServer().getPort()).append('\n');
        sb.append("Proxy: ");
        if (this.agentEngine.getAgentProperties().getProxyHost() != null) {
            sb.append(this.agentEngine.getAgentProperties().getProxyType()).append(' ').append(this.agentEngine.getAgentProperties().getProxyHost()).append(':').append(this.agentEngine.getAgentProperties().getProxyPort()).append('\n');
        } else {
            sb.append("none\n");
        }
        sb.append("CommType: ").append(this.agentEngine.getAgentProperties().getCommType()).append('\n');
        sb.append("ClusterNodes: ").append(this.agentEngine.getClusterNodes()).append('\n');
        sb.append("Buffering: ").append(status).append('\n');
        sb.append("Buffers limit: ").append(this.agentEngine.getMonitorQueue().m_max_messages).append('\n');
        try {
            if (this.agentEngine.m_hb == null) {
                sb.append("HB interval: ").append(" not running\n");
            } else {
                sb.append("HB interval: ").append(this.agentEngine.m_hb.getInterval() / 1000L).append(" sec\n");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Runtime runtime = Runtime.getRuntime();
        sb.append("IsLowMemory: ").append(AgentHealth.isLowMemory() ? "yes" : "no").append('\n');
        sb.append("FreeMemory: ").append(runtime.freeMemory()).append('\n');
        sb.append("MaxMemory: ").append(runtime.maxMemory()).append('\n');
        sb.append("TotalMemory: ").append(runtime.totalMemory()).append('\n');
        long totalFreeMem = runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
        double tfmmb = (double)totalFreeMem / 1048576.0;
        sb.append("TotalFreeMemoryMB: ").append(df.format(tfmmb)).append('\n');
        double tfmpct = 100.0 * tfmmb / ((double)runtime.maxMemory() / 1048576.0);
        sb.append("TotalFreeMemoryPct: ").append(df.format(tfmpct)).append('\n');
        sb.append("Policies: ").append(policyRepository.m_knownMonitors.size() + policyRepository.m_knownMsgPolicies.size()).append('\n');
        sb.append("MaxLogCount: ").append(RTLogger.getMaxFileCount()).append('\n');
        sb.append("MaxLogSize: ").append(RTLogger.getMaxSizeMB()).append("MB\n");
        sb.append("Logfile: ").append(RTLogger.getCurrentFileName()).append('\n');
        sb.append("Loglevel: ").append(RTLogger.getCurrentLevel()).append('\n');
        sb.append("OS.LABEL=").append(AgentEngine.getInstance().getAgentOS()).append('\n');
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        sb.append("OS.NAME=").append(os.getName()).append('\n');
        sb.append("OS.VERSION=").append(os.getVersion()).append('\n');
        sb.append("OS.ARCH=").append(os.getArch()).append('\n');
        RuntimeMXBean java = ManagementFactory.getRuntimeMXBean();
        sb.append("JAVA.HOME=").append(System.getProperty("java.home")).append('\n');
        sb.append("JAVA.VMNAME=").append(java.getVmName()).append('\n');
        sb.append("JAVA.VMVENDOR=").append(java.getVmVendor()).append('\n');
        sb.append("JAVA.VMVER=").append(java.getVmVersion()).append('\n');
        try {
            sb.append("Locale=").append(Locale.getDefault()).append('\n');
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            sb.append("TimeZoneID=").append(TimeZone.getDefault().getID()).append('\n');
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        sb.append("##################################################\n");
        sb.append("PreProcessingMonQueueSize=").append(AgentHealth.getInQueueSizeAll_Mon()).append('\n');
        sb.append("TotalReceivedMonitorValues=").append(AgentHealth.getMonitorValuesCount()).append('\n');
        long delta = System.currentTimeMillis() - this.agentEngine.m_startTime;
        double riphV = (double)AgentHealth.getMonitorValuesCount() / (double)delta;
        riphV = delta > 3600000L ? (riphV *= 3600000.0) : (double)AgentHealth.getMonitorValuesCount();
        sb.append("ReceivedMonValuesPerHourRatio=").append(df.format(riphV)).append('\n');
        sb.append("TotalNewMonitorValues=").append(AgentHealth.getTotalNewMonitorValues()).append('\n');
        sb.append("PreProcessingIndiQueueSize=").append(AgentHealth.getInQueueSizeAll()).append('\n');
        sb.append("TotalReceivedIndications=").append(AgentHealth.getTotalIn()).append('\n');
        double riph = (double)AgentHealth.getTotalIn() / (double)delta;
        riph = delta > 3600000L ? (riph *= 3600000.0) : (double)AgentHealth.getTotalIn();
        sb.append("ReceivedIndicationsPerHourRatio=").append(df.format(riph)).append('\n');
        sb.append("TotalMatchedIndications=").append(AgentHealth.getTotalMatched()).append('\n');
        sb.append("RI_SnmpTraps=").append(AgentHealth.getSnmpTrapsCount()).append('\n');
        Map<String, AtomicLong> mapCounters = AgentHealth.getPolicyCounts();
        for (Map.Entry<String, AtomicLong> entry : mapCounters.entrySet()) {
            sb.append("RI_4Policy:").append(entry.getKey()).append("=").append(entry.getValue()).append('\n');
        }
        sb.append("RI_Other=").append(AgentHealth.getNonPolicySpecificIndis()).append('\n');
        sb.append("MonOutQueueSize=").append(this.agentEngine.getMonitorQueue().sizeC1()).append('\n');
        sb.append("IndiOutQueueSize=").append(this.agentEngine.getMessageQueue().sizeC1()).append('\n');
        sb.append("PerfOutQueueSize=").append(this.agentEngine.getPerfQueue().sizeC1()).append('\n');
        resp.setOutput(sb.toString());
        if (RTLogger.getCurrentLevel() >= 4) {
            try {
                RTLogger.print(4, "STATUS printed.");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void cmdEmulateJavaMonCall(int secondsToWait, AgentActionResponse resp, String[] splitArray) {
        if (splitArray.length > 2) {
            String monitorName = splitArray[2];
            Policy pol = this.agentEngine.getPolicyRepository().getPolicy(monitorName);
            if (pol != null && pol.getCallType().equals("JAVA")) {
                try {
                    NullMonSubmitter jmt = new NullMonSubmitter(pol);
                    this.emulateRun(secondsToWait, jmt);
                    resp.setOutput(jmt.getOutput());
                }
                catch (JavaMonitorExeption e) {
                    resp.setResultCode(1).setOutput("Invalid parameters");
                }
            } else {
                MsgPolicy mp = this.agentEngine.getPolicyRepository().getMsgPolicy(monitorName);
                if (mp != null && mp.getCallType().equals("JAVA")) {
                    try {
                        NullMonSubmitter jmt = new NullMonSubmitter(mp);
                        this.emulateRun(secondsToWait, jmt);
                        resp.setOutput(jmt.getOutput());
                    }
                    catch (JavaMonitorExeption e) {
                        resp.setResultCode(1).setOutput(e.getMessage());
                    }
                } else {
                    resp.setResultCode(1).setOutput("Policy not found: " + monitorName);
                }
            }
        } else {
            resp.setResultCode(1).setOutput("Invalid parameters");
        }
    }

    private void cmdPolicies(AgentActionResponse resp, StringBuilder sb, PolicyRepository policyRepository) {
        ArrayList<String> assignedMonitors = new ArrayList<String>(policyRepository.getAssignedMonitors());
        Collections.sort(assignedMonitors);
        for (String name : assignedMonitors) {
            Policy p = policyRepository.getPolicy(name);
            sb.append(p.isEnabledCheckRuntime(Env.getInstance()) ? ENABLED : DISABLED);
            sb.append(p.isDeactivationTime(System.currentTimeMillis()) ? (char)'D' : '-');
            sb.append('-');
            sb.append(p.isEnabled() ? ENABLED : DISABLED);
            sb.append(' ').append(p.getName()).append(" (").append(p.getVersion()).append(')');
            sb.append(' ').append(((AbstractPolicy)p).getPolicyType());
            sb.append('\n');
        }
        ArrayList<String> assignedMessages = new ArrayList<String>(policyRepository.getAssignedMessages());
        Collections.sort(assignedMessages);
        for (String name : assignedMessages) {
            MsgPolicy p = policyRepository.getMsgPolicy(name);
            sb.append(p.isEnabledCheckRuntime(Env.getInstance()) ? ENABLED : DISABLED);
            sb.append(p.isDeactivationTime(System.currentTimeMillis()) ? (char)'D' : '-');
            sb.append(p.isPlogEnabled() ? (char)'P' : '-');
            sb.append(p.isEnabled() ? ENABLED : DISABLED);
            sb.append(' ').append(p.getName()).append(" (").append(p.getVersion()).append(')');
            sb.append(' ').append(p.getPolicyType());
            sb.append('\n');
        }
        resp.setOutput(sb.toString());
    }

    private void cmdEnablePolicy(AgentActionResponse resp, StringBuilder sb, String[] splitArray, PolicyRepository policyRepository) {
        if (splitArray.length > 2) {
            sb.append("Policies enabled: ");
            if (splitArray.length == 3 && splitArray[2].equals("*")) {
                LinkedList<String> all = new LinkedList<String>();
                all.add("");
                all.add("");
                all.addAll(policyRepository.getAssignedMessages());
                all.addAll(policyRepository.getAssignedMonitors());
                splitArray = all.toArray(new String[0]);
            }
            StringBuffer notfound = new StringBuffer();
            notfound.append("Policies not found: ");
            boolean somePolNotFound = false;
            for (int i = 2; i < splitArray.length; ++i) {
                String policyName = splitArray[i].trim();
                Policy p = policyRepository.getPolicy(policyName);
                if (p != null) {
                    sb.append(policyName).append(' ');
                    p.setEnabled(true);
                    policyRepository.storePolicy(p);
                    RTLogger.print(2, policyName + " " + ENABLED);
                    continue;
                }
                MsgPolicy mp = policyRepository.getMsgPolicy(policyName);
                if (mp != null) {
                    sb.append(policyName).append(' ');
                    mp.setEnabled(true);
                    policyRepository.storePolicy(mp);
                    RTLogger.print(2, policyName + " " + ENABLED);
                    continue;
                }
                somePolNotFound = true;
                notfound.append(policyName).append(' ');
            }
            if (somePolNotFound) {
                sb.append('\n').append(notfound);
            }
            resp.setOutput(sb.toString());
        } else {
            resp.setResultCode(-1);
            resp.setOutput("Syntax: AGENT ENABLE_POLICY <policy1> <policy2> ...");
        }
    }

    private void cmdDisablePolicy(AgentActionResponse resp, StringBuilder sb, String[] splitArray, PolicyRepository policyRepository) {
        if (splitArray.length > 2) {
            StringBuffer notfound = new StringBuffer();
            notfound.append("Policies not found: ");
            boolean somePolNotFound = false;
            sb.append("Policies disabled: ");
            for (int i = 2; i < splitArray.length; ++i) {
                String policyName = splitArray[i].trim();
                Policy p = policyRepository.getPolicy(policyName);
                if (p != null) {
                    sb.append(policyName).append(' ');
                    p.setEnabled(false);
                    policyRepository.storePolicy(p);
                    RTLogger.print(2, policyName + " " + DISABLED);
                    continue;
                }
                MsgPolicy mp = policyRepository.getMsgPolicy(policyName);
                if (mp != null) {
                    sb.append(policyName).append(' ');
                    mp.setEnabled(false);
                    policyRepository.storePolicy(mp);
                    RTLogger.print(2, policyName + " " + DISABLED);
                    continue;
                }
                somePolNotFound = true;
                notfound.append(policyName).append(' ');
            }
            if (somePolNotFound) {
                sb.append('\n').append(notfound);
            }
            resp.setOutput(sb.toString());
        } else {
            resp.setResultCode(-1);
            resp.setOutput("Syntax: AGENT DISABLE_POLICY <policy1> <policy2> ...");
        }
    }

    private void cmdGetMonitorHistory(AgentActionResponse resp, String[] splitArray) {
        HashSet<String> filters = new HashSet<String>();
        if (splitArray.length > 2) {
            for (int i = 2; i < splitArray.length; ++i) {
                filters.add(splitArray[i]);
            }
        }
        JsonArray array = new JsonArray();
        for (Map.Entry<String, MonitorSerie> en : this.agentEngine.getCalcEngine().monitorSeries.entrySet()) {
            boolean foundMatch = false;
            if (filters.size() > 0) {
                for (String filter : filters) {
                    if (!en.getKey().startsWith(filter)) continue;
                    foundMatch = true;
                    break;
                }
            } else {
                foundMatch = true;
            }
            if (!foundMatch) continue;
            array.add(en.getValue().toJson());
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        resp.setOutput(gson.toJson(array));
    }

    private void cmdGetActiveValues(AgentActionResponse resp, StringBuilder sb) {
        ArrayList<String> keys = new ArrayList<String>(this.agentEngine.getCalcEngine().getMonitorSeries().keySet());
        Collections.sort(keys);
        if (keys.size() > 0) {
            sb.append("# Monitor values:\n");
        } else {
            sb.append("# No monitors deployed.");
        }
        for (String key : keys) {
            MonitorSerie serie = this.agentEngine.getCalcEngine().monitorSeries.get(key);
            if (serie == null) continue;
            sb.append(key).append('=').append(serie.getLatestValueAsString()).append('\n');
        }
        resp.setOutput(sb.toString());
    }

    private void cmdSetHbRTimeout(AgentActionResponse resp, StringBuilder sb, String[] splitArray) {
        try {
            if (splitArray.length != 3) {
                throw new RuntimeException("Invalid parameters");
            }
            String interval = splitArray[2].toLowerCase();
            int in = Integer.parseInt(interval);
            sb.append("Agent HB Read timeout is now: " + in + " ms.");
            resp.setOutput(sb.toString());
            this.agentEngine.getAgentProperties().setHbReadTimeoutMs(in);
            this.agentEngine.storeProps();
        }
        catch (Throwable e) {
            sb.append(AGENT_CMD_SET_HB_CTIMEOUT).append(" command failed.\n").append(e.getMessage());
            resp.setResultCode(1);
            resp.setOutput(this.echoUsage());
        }
    }

    private void cmdSetHbCTimeout(AgentActionResponse resp, StringBuilder sb, String[] splitArray) {
        try {
            if (splitArray.length != 3) {
                throw new RuntimeException("Invalid parameters");
            }
            String interval = splitArray[2].toLowerCase();
            int in = Integer.parseInt(interval);
            sb.append("Agent HB Connect timeout is now: " + in + " ms.");
            resp.setOutput(sb.toString());
            this.agentEngine.getAgentProperties().setHbConnectTimeoutMs(in);
            this.agentEngine.storeProps();
        }
        catch (Throwable e) {
            sb.append(AGENT_CMD_SET_HB_CTIMEOUT).append(" command failed.\n").append(e.getMessage());
            resp.setResultCode(1);
            resp.setOutput(this.echoUsage());
        }
    }

    private void cmdSetHbInterval(AgentActionResponse resp, StringBuilder sb, String[] splitArray, Scheduler scheduler) {
        try {
            if (splitArray.length != 3) {
                throw new RuntimeException("Invalid parameters");
            }
            String interval = splitArray[2].toLowerCase();
            int in = Integer.parseInt(interval);
            sb.append("Agent is switching HB to the new interval: " + in + " sec.");
            resp.setOutput(sb.toString());
            this.agentEngine.getAgentProperties().setHbInterval(in);
            this.agentEngine.storeProps();
            if (this.agentEngine.m_hb != null) {
                scheduler.removeTask(this.agentEngine.m_hb.getName());
            }
            this.agentEngine.initHB();
        }
        catch (Throwable e) {
            sb.append(AGENT_CMD_SET_HB_INTERVAL).append(" command failed.\n").append(e.getMessage());
            resp.setResultCode(1);
            resp.setOutput(this.echoUsage());
        }
    }

    private void cmdSetClusterNodes(AgentActionResponse resp, StringBuilder sb, String[] splitArray) throws IOException {
        if (splitArray.length != 3) {
            sb.append("one parameter expected: \"<comma separated list of hostnames or IPs>\"");
            resp.setOutput(sb.toString());
            resp.setResultCode(2);
        } else {
            this.agentEngine.getAgentProperties().getClusterNodes().clear();
            String clusterNodes = new StrUtils().removeQuotesStrict(splitArray[2]);
            String[] nodes = clusterNodes.split("\\s*,\\s*");
            for (int i = 0; i < nodes.length; ++i) {
                if (nodes[i].length() <= 0) continue;
                this.agentEngine.getAgentProperties().getClusterNodes().add(nodes[i]);
            }
            this.agentEngine.storeProps();
            resp.setOutput(this.printClusterNodes("New cluster nodes:"));
        }
    }

    private void cmdSetServer(AgentActionResponse resp, StringBuilder sb, String[] splitArray) {
        try {
            if (splitArray.length != 3) {
                throw new RuntimeException("Invalid parameters");
            }
            String newServer = splitArray[2].toLowerCase();
            sb.append("Agent is switching to the new server: " + newServer);
            String oldServer = this.agentEngine.getServers().getCurrentServer().getHost();
            try {
                this.agentEngine.getAgentProperties().setMainServerHost(newServer);
                this.agentEngine.getAgentProperties().setOldMainServer(oldServer);
            }
            catch (RuntimeException e) {
                this.agentEngine.getAgentProperties().setMainServerHost(oldServer);
                throw e;
            }
            resp.setOutput(sb.toString());
            if (this.agentEngine.getMode() < 7) {
                this.agentEngine.getAgentProperties().setMode(0);
            }
            this.agentEngine.storeProps();
            this.agentEngine.initHB();
            this.agentEngine.startSendTask();
            this.agentEngine.getAgent().addValidHost("127.0.0.1");
            this.agentEngine.getAgent().addValidHost(this.agentEngine.getAgentHostname().toLowerCase());
            this.agentEngine.getAgent().addValidHost(this.agentEngine.getAgentIP().toLowerCase());
            this.agentEngine.getAgent().addValidHost(this.agentEngine.getServers().getCurrentServer().getHost().toLowerCase());
            this.agentEngine.getAgent().addValidHost(this.agentEngine.getServers().getCurrentServer().getPublicIP().toLowerCase());
            RTLogger.print(2, "Accepted hosts: " + this.agentEngine.getAgent().getAcceptedHosts());
        }
        catch (Throwable e) {
            sb.append(AGENT_CMD_SET_SERVER).append(" command failed.\n").append(e.getMessage());
            resp.setResultCode(1);
            resp.setOutput(this.echoUsage());
        }
    }

    private boolean processVariables(String[] lines) {
        boolean isOK = true;
        StrUtils su = new StrUtils();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            int ch = line.indexOf(61);
            if (ch != -1) {
                try {
                    String name = line.substring(0, ch);
                    name = su.removeQuotesStrict(name);
                    String value = line.substring(ch + 1);
                    value = su.removeQuotesStrict(value);
                    Env.getInstance().addVariable(name, value);
                }
                catch (Throwable e) {
                    isOK = false;
                }
                continue;
            }
            isOK = false;
        }
        return isOK;
    }

    public static List<String> parseParams2(String[] splitArray) {
        ArrayList<String> pa = new ArrayList<String>();
        StringBuilder cs = new StringBuilder();
        StrUtils strUtils = new StrUtils();
        for (int i = 0; i < splitArray.length; ++i) {
            if (splitArray[i].startsWith("\"") && (!splitArray[i].endsWith("\"") || splitArray[i].endsWith("\\\""))) {
                if (cs.length() > 0) {
                    cs.append(' ');
                }
                cs.append(splitArray[i]);
                continue;
            }
            if (splitArray[i].endsWith("\"") && !splitArray[i].endsWith("\\\"") && (splitArray[i].length() == 0 || splitArray[i].charAt(0) != '\"')) {
                if (cs.length() == 0) {
                    pa.add(splitArray[i]);
                    continue;
                }
                if (cs.length() > 0) {
                    cs.append(' ');
                }
                cs.append(splitArray[i]);
                pa.add(strUtils.removeQuotesStrict(cs));
                cs = new StringBuilder();
                continue;
            }
            if (cs.length() > 0) {
                cs.append(' ').append(splitArray[i]);
                if (!splitArray[i].endsWith("\"") || splitArray[i].endsWith("\\\"")) continue;
                pa.add(strUtils.removeQuotesStrict(cs));
                cs = new StringBuilder();
                continue;
            }
            pa.add(strUtils.removeQuotesStrict(splitArray[i]));
        }
        if (cs.length() > 0) {
            pa.add(strUtils.removeQuotesStrict(cs));
        }
        return pa;
    }

    private String printClusterNodes(String firstLine) throws IOException {
        String clusterNodes = "no cluster nodes specified.";
        if (this.agentEngine.getAgentProperties().getClusterNodes().size() > 0) {
            clusterNodes = this.agentEngine.getAgentProperties().getClusterNodes().toString();
            clusterNodes = clusterNodes.replaceAll("[\\[\\]]", "");
        }
        return firstLine + "\n" + clusterNodes;
    }

    private void emulateRun(int secondsToWait, NullMonSubmitter jmt) {
        Thread tr = new Thread((Runnable)jmt, "EmuRun");
        long start = System.currentTimeMillis();
        tr.start();
        while ((long)secondsToWait > (System.currentTimeMillis() - start) / 1000L) {
            try {
                Thread.sleep(1000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (jmt.isRunning()) continue;
        }
        if (jmt.isRunning()) {
            jmt.stopTask();
        }
    }

    private String echoUsage() {
        StringBuilder sb = new StringBuilder().append("Usage: AGENT <command> [<parameters>]\n").append("\tcommands:\n").append("\t\t").append(AGENT_CMD_STATUS).append(" - runtime status of the agent.\n").append("\t\t").append(AGENT_CMD_GET_VERSION).append(" - version of the agent.\n").append("\t\t").append(AGENT_CMD_GET_PID).append(" - current PID of the agent.\n").append("\t\t").append(AGENT_CMD_GET_ID).append(" - ID of the agent.\n").append("\t\t").append(AGENT_CMD_SET_LOGLEVEL).append(" <level> - set log level of the agent.\n").append("\t\t").append(AGENT_CMD_GET_LOGLEVEL).append(" - current log level of the agent.\n").append("\t\t").append(AGENT_CMD_SET_LOGLIMITS).append(" <maxFileCount> <maxSizeInMB> - set log limits.\n").append("\t\t").append(AGENT_CMD_GET_IP).append(" - IP of the agent.\n").append("\t\t").append(AGENT_CMD_GET_CLUSTERNODES).append(" - cluster node names and IPs of the agent.\n").append("\t\t").append(AGENT_CMD_SET_CLUSTERNODES).append(" <name1>,<ip1>,<name2>,<ip2>,... - sets cluster node names and IPs of the agent.\n").append("\t\t").append(AGENT_CMD_FLUSH_CE).append(" - resets calculation engine of the agent.\n").append("\t\t").append(AGENT_CMD_GET_DETAILS).append(" - inventory of the agent.\n").append("\t\t").append(AGENT_CMD_POLICIES).append(" - list and status of the policies deployed on the agent.\n").append("\t\t").append(AGENT_CMD_DISABLE_POLICY).append(" <policyName1> <policyName2> ... - disables given policies.\n").append("\t\t").append(AGENT_CMD_ENABLE_POLICY).append(" <policyName1> <policyName2> ... - enables given policies.\n").append("\t\t").append(AGENT_CMD_ENABLE_AGENT).append(" - enables the agent.\n").append("\t\t").append(AGENT_CMD_DISABLE_AGENT).append(" - disables the agent.\n").append("\t\t").append(AGENT_CMD_SET_HB_INTERVAL).append(" <sec> - sets interval of the agent's heartbeats.\n").append("\t\t").append(AGENT_CMD_SET_HB_CTIMEOUT).append(" <milliseconds> - sets connect timeout of the agent's heartbeats.\n").append("\t\t").append(AGENT_CMD_SET_HB_RTIMEOUT).append(" <milliseconds> - sets read timeout of the agent's heartbeats.\n").append("\t\t").append(AGENT_CMD_SET_MODE0).append(" - sets active mode of the agent.\n").append("\t\t").append(AGENT_CMD_SET_MODE7).append(" - sets passive mode of the agent.\n").append("\t\t").append(AGENT_CMD_SHARED_IP).append(" <true|false> - informs the agent to use AgentID for communication with the server.\n").append("\t\t").append(AGENT_CMD_SETVAR).append(" <varName>=<value> - sets Agent's global variable.\n").append("\t\t").append(AGENT_CMD_REMVAR).append(" <varName> - removes Agent's global variable.\n").append("\t\t").append(AGENT_CMD_SET_PLOG).append(" <ON|OFF> <LOGCOUNT> <LOGSIZE> <polName1> [<polName2> ...] - activates Policy specific logging. Does not work for Monitor policies.\n").append("\t\t").append(AGENT_CMD_OD2ACN_OFF).append(" - Disallows to poll data from any of the Cluster nodes if the Agent can't communicate with Main server.\n").append("\t\t").append(AGENT_CMD_OD2ACN_ON).append(" - Allows to poll data from any of the Cluster nodes if the Agent can't communicate with Main server.\n");
        return sb.toString();
    }
}

