/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentActionExecutor;
import com.blixx.agent.AgentEngine;
import com.blixx.log.RTLogger;
import com.blixx.sa.SchedulerTask;
import com.boom.crt.CertificateManager;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

public class AgentCertExpirationCheckTask
extends SchedulerTask {
    private final CertificateManager certificateManager;
    private final int agentCertExpirationThresholdDays;

    public AgentCertExpirationCheckTask(CertificateManager certificateManager, int agentCertExpirationThresholdDays, String taskName) {
        super(taskName);
        this.certificateManager = certificateManager;
        this.agentCertExpirationThresholdDays = agentCertExpirationThresholdDays;
    }

    @Override
    public boolean onInit() throws Exception {
        return true;
    }

    @Override
    public boolean onStartRun() {
        return true;
    }

    @Override
    public boolean onGetData() {
        try {
            Certificate certificate;
            if (AgentEngine.getInstance().getAgentProperties().isTlsActivated() && (certificate = this.certificateManager.getKsClient().getKeyStore().getCertificate("agent")) instanceof X509Certificate) {
                X509Certificate x509Certificate = (X509Certificate)certificate;
                Date notAfter = x509Certificate.getNotAfter();
                if (System.currentTimeMillis() + TimeUnit.DAYS.toMillis(this.agentCertExpirationThresholdDays) >= notAfter.getTime()) {
                    RTLogger.print(1, "Agent certificate is about to expire Expiration date: " + notAfter);
                    if (this.certificateManager.getRenewalKeyStore().exists()) {
                        RTLogger.print(1, "Renewal keystore already exists");
                    } else {
                        RTLogger.print(1, "Creating renewal keystore already exists");
                        try {
                            AgentEngine.getInstance().sendMessage(AgentEngine.getInstance().getAgentHostname(), "BOOM_AGENT", "BOOM_AGENT", "Agent Cert", "Boom agent certificate is about to expire, creating new agent certificate.", "warning", new HashMap());
                            new AgentActionExecutor();
                            AgentActionExecutor.createRenewalKeyStore();
                        }
                        catch (Exception e) {
                            AgentEngine.getInstance().sendMessage(AgentEngine.getInstance().getAgentHostname(), "BOOM_AGENT", "BOOM_AGENT", "Agent Cert", "Could not create new agent certificate. " + e.getMessage(), "critical", new HashMap());
                            RTLogger.print(1, "Could not create renewal key store", e);
                        }
                    }
                }
            }
        }
        catch (KeyStoreException e) {
            RTLogger.print(1, "Could not check agent certificate from key store for expiration", e);
        }
        return false;
    }

    @Override
    public boolean onStopRun() {
        return true;
    }

    @Override
    protected boolean onStopTask() {
        return true;
    }

    @Override
    public boolean refresh() {
        return true;
    }
}

