/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AProperties;
import com.blixx.agent.Agent;
import com.blixx.agent.AgentCertExpirationCheckTask;
import com.blixx.agent.AgentCertificateHelper;
import com.blixx.agent.AgentOutageSendTask;
import com.blixx.agent.AgentServersInfo;
import com.blixx.agent.AgentShutdownHook;
import com.blixx.agent.AgentWorker;
import com.blixx.agent.CalcEngine;
import com.blixx.agent.ConnectionCheckAfterTLSSwitchTask;
import com.blixx.agent.DDF;
import com.blixx.agent.DailyTask;
import com.blixx.agent.DeploymentHelper;
import com.blixx.agent.Env;
import com.blixx.agent.HB;
import com.blixx.agent.HB_HTTPS;
import com.blixx.agent.MMObject;
import com.blixx.agent.Message;
import com.blixx.agent.MessageStormFilter;
import com.blixx.agent.MsgBuffer;
import com.blixx.agent.MsgCalcEngine;
import com.blixx.agent.MsgSubmitter;
import com.blixx.agent.NettyEndpoint;
import com.blixx.agent.PolicyRepository;
import com.blixx.agent.SendBuffer;
import com.blixx.agent.SendBufferFA;
import com.blixx.agent.SendPerfBuffer;
import com.blixx.agent.SendTask;
import com.blixx.agent.SendTask_HTTP;
import com.blixx.agent.Submitter;
import com.blixx.agent.Tracker;
import com.blixx.ext.IMessage;
import com.blixx.log.RTLogger;
import com.blixx.sa.ClassPathLoader;
import com.blixx.sa.ExecResult;
import com.blixx.sa.ExecUtils;
import com.blixx.sa.Scheduler;
import com.blixx.sa.SchedulerTask;
import com.blixx.shared.BM;
import com.blixx.shared.IHeartbeatAccess;
import com.blixx.shared.IODataStream;
import com.blixx.shared.Interval;
import com.blixx.shared.ServerInfo;
import com.blixx.shared.ServerType;
import com.blixx.shared.Severity;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.os.SystemUtils;
import com.blixx.shared.utils.FileSyncUtils;
import com.blixx.shared.utils.FileUtils;
import com.blixx.shared.utils.ShabalUtils;
import com.boom.AgentInfo;
import com.boom.crt.CertificateManager;
import com.boom.crt.CertificateManagerInitializationException;
import com.boom.crt.KeyStoreClient;
import com.boom.crt.KeyStoreCreationException;
import com.boom.crt.TrustStoreClient;
import com.boom.crt.hlp.BasicCertificateInfo;
import com.boom.crt.hlp.KeyStoreUtils;
import com.boom.netty.server.InetSocketAddressVerifier;
import com.boom.netty.service.cmds.RCmdMessageTypes;
import com.boom.netty.ws.mhf.MessageTypeRegistrationException;
import com.boom.netty.ws.mhf.MessageTypesRepository;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.cert.CertPathValidatorException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.NullConfiguration;

public class AgentEngine
implements IHeartbeatAccess,
IMessage {
    private static boolean test = false;
    private Scheduler m_scheduler = null;
    private Agent m_agent = null;
    private static volatile AgentEngine m_engine = null;
    private SendBuffer monitorQueue = null;
    private SendBufferFA finishAlertsQueue = null;
    public SendTask sendTask;
    private SendPerfBuffer perfQueue = null;
    public CalcEngine m_ce;
    public MsgBuffer msgBuffer = null;
    public MsgCalcEngine m_mce = null;
    public PolicyRepository m_policyRepository;
    public DeploymentHelper deploymentHelper = new DeploymentHelper(this);
    public String DIR_MAIN = BM.agentEngine_dir_main;
    public String DIR_POLICIES = this.DIR_MAIN + File.separator + "policies";
    public String DIR_SPI = this.DIR_MAIN + File.separator + "spi";
    public String DIR_JARS = this.DIR_SPI + File.separator + "jars";
    public String DIR_CONF = this.DIR_MAIN + File.separator + "conf";
    public File FILE_SPI_DIR = null;
    private AProperties m_properties = null;
    private Thread schedulerThread;
    private AgentServersInfo servers;
    private Submitter m_submitter;
    private MsgSubmitter m_msgSubmitter;
    private DDF m_DDF = null;
    public boolean isRestart = false;
    public static String PID = null;
    HB m_hb;
    private long m_lastTimeOnline = 0L;
    private static boolean m_PIDstored = false;
    private MessageStormFilter m_stormDetector = new MessageStormFilter();
    private AgentOutageSendTask m_agentOutagerepository = new AgentOutageSendTask();
    public long m_startTime = System.currentTimeMillis();
    private static AtomicBoolean isStarted = new AtomicBoolean(false);
    private CertificateManager m_certificateManager;
    private ThreadGroup agentThreadGroup = new ThreadGroup("BA");
    private ScheduledExecutorService scheduledExecutor;
    private NettyEndpoint nettyEndpoint;
    private final Thread shutdownHook;
    private long expectedReconnectAfterTLSSwitchMS = TimeUnit.MINUTES.toMillis(30L);
    private long settingsTLSSwitchCheckDelayMS = TimeUnit.MINUTES.toMillis(40L);
    public AtomicBoolean m_isQueueStored = new AtomicBoolean(false);
    private String hashConf = null;

    private AgentEngine() {
        this.shutdownHook = new Thread((Runnable)new AgentShutdownHook(this), "AgentShutdownHook");
    }

    public AgentEngine(Path workingDir, boolean test, PolicyRepository prep) throws IOException {
        m_engine = this;
        this.m_policyRepository = prep;
        this.m_properties = new AProperties(workingDir.resolve("conf").toString());
        if (test) {
            this.initSubmitters();
            this.initScheduler();
        }
        this.monitorQueue = new SendBuffer("monitorQueue.txt", 1000);
        this.msgBuffer = new MsgBuffer("messageQueue.txt", 1000);
        this.perfQueue = new SendPerfBuffer("perfQueue.txt", 1000);
        this.finishAlertsQueue = new SendBufferFA("faQueue.txt", 1000);
        this.shutdownHook = new Thread((Runnable)new AgentShutdownHook(this), "AgentShutdownHook");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AgentEngine getInstance() {
        if (m_engine != null) return m_engine;
        Class<AgentEngine> clazz = AgentEngine.class;
        synchronized (AgentEngine.class) {
            String currDir;
            if (m_engine != null) return m_engine;
            m_engine = new AgentEngine();
            String jlpath = System.getProperty("java.library.path");
            if (jlpath == null) {
                jlpath = "";
            }
            StringBuilder javaLibPath = new StringBuilder(jlpath);
            StringBuilder pathOnly = new StringBuilder();
            File dir = new File(".");
            if (!jlpath.endsWith(File.pathSeparator)) {
                javaLibPath.append(File.pathSeparator);
            }
            if (!(currDir = dir.getAbsolutePath()).endsWith(File.separator)) {
                currDir = currDir + File.separator;
            }
            pathOnly.append(currDir);
            pathOnly.append(File.pathSeparator).append(currDir).append("spi");
            pathOnly.append(File.pathSeparator).append(currDir).append("spi").append(File.separator).append("libs");
            pathOnly.append(File.pathSeparator);
            if (javaLibPath.indexOf(pathOnly.toString()) == -1) {
                String javaLibPathfinal = javaLibPath.append((CharSequence)pathOnly).toString();
                try {
                    System.setProperty("java.library.path", javaLibPathfinal);
                    Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
                    fieldSysPath.setAccessible(true);
                    fieldSysPath.set(null, null);
                }
                catch (Throwable e1) {
                    System.out.println("Failed to change java.library.path=" + jlpath);
                }
            }
            AgentEngine.addTo_LD_LIBRARY_PATH(pathOnly);
            File f = new File(BM.agentEngine_dir_main);
            try {
                AgentEngine.m_engine.DIR_MAIN = f.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            AgentEngine.m_engine.FILE_SPI_DIR = new File(AgentEngine.m_engine.DIR_SPI);
            try {
                m_engine.initParameters();
            }
            catch (IOException e) {
                System.err.println("Can't read conf/agent.conf property file.");
                e.printStackTrace();
                System.exit(AgentEngine.isJUnitTest() ? 0 : -1);
            }
            AgentEngine.setLogDir(m_engine);
            m_engine.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_engine;
        }
    }

    public static AgentEngine getMockInstance(String dirMain, String dirConf) throws IOException {
        test = true;
        if (m_engine != null) {
            m_engine.stop();
        }
        m_engine = new AgentEngine();
        AgentEngine.m_engine.DIR_MAIN = dirMain;
        AgentEngine.m_engine.DIR_CONF = dirConf;
        Path policies = Paths.get(dirMain, new String[0]).resolve("policies");
        Files.createDirectories(policies, new FileAttribute[0]);
        AgentEngine.m_engine.DIR_POLICIES = policies.toAbsolutePath().toString();
        AgentEngine.m_engine.expectedReconnectAfterTLSSwitchMS = TimeUnit.MINUTES.toMillis(1L);
        AgentEngine.m_engine.settingsTLSSwitchCheckDelayMS = TimeUnit.MINUTES.toMillis(2L);
        m_engine.initParameters();
        AgentEngine.setLogDir(m_engine);
        m_engine.init();
        return m_engine;
    }

    public static String getExtendedAgentInfo() {
        AProperties agentProperties = AgentEngine.getInstance().getAgentProperties();
        if (agentProperties.isAgtExtInfo()) {
            String socketType;
            String certificateRequest = null;
            if (agentProperties.isTlsActivated()) {
                try {
                    CertificateManager certManager = AgentEngine.getInstance().getCertManager();
                    certManager.checkKeyStoreCertificate("agent", false);
                    if (!certManager.isCertificateSignedByTheLatestCA("agent") || KeyStoreUtils.isCertificateAboutToExpire(certManager.getKsClient().getKeyStore(), "agent", agentProperties.getAgentCertExpirationThresholdDays())) {
                        certificateRequest = AgentCertificateHelper.getCertificateRequest();
                    }
                }
                catch (CertPathValidatorException e) {
                    certificateRequest = AgentCertificateHelper.getCertificateRequest();
                }
                catch (Exception e) {
                    AgentEngine.getInstance().recreateKeyStore();
                }
            }
            if ("TLS".equals(socketType = agentProperties.getCommType())) {
                CertificateManager certManager = AgentEngine.getInstance().getCertManager();
                try {
                    if (certManager != null) {
                        String alias = "agent";
                        KeyStoreClient ksClient = certManager.getKsClient();
                        socketType = !ksClient.getKeyStore().containsAlias("agent") || ksClient.isSelfSignedCertificate("agent") ? "TLS_CAPABLE" : "TLS_READY";
                    } else {
                        RTLogger.print(2, "CertificateManager is null");
                    }
                }
                catch (Exception e) {
                    RTLogger.print(2, "hb failed(1): " + e.getMessage() + " could not detect TLS readiness");
                }
            }
            AgentInfo info = new AgentInfo(socketType, !AgentEngine.getInstance().getDisabled(), "5.11.0", certificateRequest);
            try {
                info.setActionsEnabled(AgentEngine.getInstance().getAgentProperties().isActionsEnabled());
                info.setDeploymentEnabled(AgentEngine.getInstance().getAgentProperties().getNoDeployAllowed());
                info.setHbInterval(AgentEngine.getInstance().getAgentProperties().getHbInterval());
                info.setOfferDataToAnyClusterNode(AgentEngine.getInstance().getAgentProperties().isOfferDataToAnyClusterNode());
                info.setUseFixHostname(AgentEngine.getInstance().getAgentProperties().isFixedName());
                info.setUseFixIP(AgentEngine.getInstance().getAgentProperties().isFixedIP());
                info.setTlsActive(AgentEngine.getInstance().getAgentProperties().isTlsActivated());
                info.setCurrentMode(AgentEngine.getInstance().getMode());
            }
            catch (Exception e) {
                RTLogger.print(2, "Error adding additional info", e);
            }
            return new GsonBuilder().create().toJson(info);
        }
        return "";
    }

    public AgentOutageSendTask getAgentOutageRepository() {
        return this.m_agentOutagerepository;
    }

    protected static void addTo_LD_LIBRARY_PATH(StringBuilder addDirs) {
        try {
            HashMap<String, String> newENV = new HashMap<String, String>();
            newENV.putAll(System.getenv());
            String LD_PATH = (String)newENV.get("LD_LIBRARY_PATH");
            if (LD_PATH == null || LD_PATH.contains(addDirs)) {
                return;
            }
            StringBuilder sb = new StringBuilder(LD_PATH);
            sb.append((CharSequence)addDirs);
            LD_PATH = sb.toString();
            newENV.put("LD_LIBRARY_PATH", LD_PATH);
            AgentEngine.setEnv(newENV);
        }
        catch (Throwable e) {
            RTLogger.print(3, "LD_PATH", e);
        }
    }

    protected static void setEnv(Map<String, String> newenv) {
        try {
            try {
                Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
                Field theEnvironmentField = processEnvironmentClass.getDeclaredField("theEnvironment");
                theEnvironmentField.setAccessible(true);
                Map env = (Map)theEnvironmentField.get(null);
                env.putAll(newenv);
                Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
                theCaseInsensitiveEnvironmentField.setAccessible(true);
                Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
                cienv.putAll(newenv);
                RTLogger.print(2, "LD_PATH: " + newenv.get("LD_LIBRARY_PATH"));
            }
            catch (NoSuchFieldException e) {
                Class<?>[] classes = Collections.class.getDeclaredClasses();
                Map<String, String> env = System.getenv();
                for (Class<?> cl : classes) {
                    if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
                    Field field = cl.getDeclaredField("m");
                    field.setAccessible(true);
                    Object obj = field.get(env);
                    Map map = (Map)obj;
                    map.clear();
                    map.putAll(newenv);
                    RTLogger.print(2, "LD_PATH: " + newenv.get("LD_LIBRARY_PATH"));
                }
            }
        }
        catch (Throwable e) {
            RTLogger.print(3, "LD_PATH", e);
        }
    }

    private static void setLogDir(AgentEngine instance) {
        block7: {
            if (instance.m_properties.getLogDir() != null) {
                File logdir = new File(instance.m_properties.getLogDir());
                if (!logdir.exists()) {
                    try {
                        boolean isOK = logdir.mkdirs();
                        if (isOK) {
                            RTLogger.setDir(instance.m_properties.getLogDir(), "BOOMAgent_");
                            break block7;
                        }
                        RTLogger.setDir(instance.DIR_MAIN, "BOOMAgent_");
                    }
                    catch (Throwable e) {
                        RTLogger.setDir(instance.DIR_MAIN, "BOOMAgent_");
                    }
                } else {
                    RTLogger.setDir(instance.m_properties.getLogDir(), "BOOMAgent_");
                }
            } else {
                RTLogger.setDir(instance.DIR_MAIN, "BOOMAgent_");
            }
        }
    }

    public static boolean isPIDStored() {
        return m_PIDstored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storePID() {
        FileOutputStream fos = null;
        try {
            PID = ManagementFactory.getRuntimeMXBean().getName();
            PID = PID.substring(0, PID.indexOf(64));
            if (PID.indexOf(91) != -1) {
                PID = PID.substring(PID.indexOf(91) + 1);
            }
            File pidf = new File("BOOM_AGENT".toLowerCase() + ".pid");
            fos = new FileOutputStream(pidf);
            fos.write(PID.getBytes());
            fos.close();
            String str = "FAILED";
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(pidf);
                byte[] arr = new byte[32];
                int c = fis.read(arr);
                str = new String(arr, 0, c);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            m_PIDstored = true;
            RTLogger.print(1, "PID: " + PID + " checked: " + str);
        }
        catch (Throwable e) {
            RTLogger.print(1, "ERROR writing PID:" + PID + " ", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable pidf) {}
            }
        }
    }

    public void init() {
        RTLogger.print(1, "\nAgent starting...");
        this.initAgent();
        ExecUtils.addEnvVariable("BOOM_AGENT_PORT=" + this.m_properties.getAgentPort());
        ExecUtils.addEnvVariable("BOOM_AGENT_PID=" + PID);
        ExecUtils.addEnvVariable("BOOM_AGENT_ID=" + this.getAgentID());
        ExecUtils.addEnvVariable("BOOM_AGENT_HOST=" + this.getAgentHostname());
        ExecUtils.addEnvVariable("BOOM_AGENT_IP=" + this.getAgentIP());
        ExecUtils.addEnvVariable("BOOM_AGENT_PORT=" + this.m_properties.getAgentPort());
        ExecUtils.addEnvVariable("BOOM_AGENT_PID=" + PID);
        ExecUtils.addEnvVariable("BOOM_AGENT_ID=" + this.getAgentID());
        ExecUtils.addEnvVariable("BOOM_AGENT_HOST=" + this.getAgentHostname());
        ExecUtils.addEnvVariable("BOOM_AGENT_IP=" + this.getAgentIP());
        System.setProperty("BOOM_AGENT_PORT", "" + this.m_properties.getAgentPort());
        System.setProperty("BOOM_AGENT_PID", PID);
        System.setProperty("BOOM_AGENT_ID", this.getAgentID());
        System.setProperty("BOOM_AGENT_HOST", this.getAgentHostname());
        System.setProperty("BOOM_AGENT_IP", this.getAgentIP());
        System.setProperty("BOOM_AGENT_PORT", "" + this.m_properties.getAgentPort());
        System.setProperty("BOOM_AGENT_PID", PID);
        System.setProperty("BOOM_AGENT_ID", this.getAgentID());
        System.setProperty("BOOM_AGENT_HOST", this.getAgentHostname());
        System.setProperty("BOOM_AGENT_IP", this.getAgentIP());
        RTLogger.print(1, "OS name full: " + this.getAgentOS());
        try {
            this.initCertificateManager();
        }
        catch (CertificateManagerInitializationException e) {
            e.printStackTrace();
            System.exit(AgentEngine.isJUnitTest() ? 0 : e.getCode());
        }
        this.initScheduler();
        this.initQueues();
        if (this.getAgentProperties().getMsdMaxPerMin() > 0) {
            this.m_stormDetector.configureDefaults(this.getAgentProperties().getMsdMaxPerMin(), this.getAgentProperties().getMsdBlockMin(), this.getAgentProperties().getMsdQuarantineMin());
        }
        try {
            HashMap typesUsedEventWithoutNetty = new HashMap();
            typesUsedEventWithoutNetty.putAll(RCmdMessageTypes.CMD_MESSAGE_TYPES);
            MessageTypesRepository.getInstance().registerMessageTypes(typesUsedEventWithoutNetty);
        }
        catch (MessageTypeRegistrationException e) {
            RTLogger.print(3, "can't register MessageBase types", e);
        }
        this.initSubmitters();
        this.initPolicyRepository();
        this.startSendTask();
        this.startAgent();
        if (this.getAgentProperties().getCommType().contains("WEBSOCKET")) {
            this.initNettyEndpoint();
            this.nettyEndpoint.start();
        }
        if (this.getDisabled()) {
            this.getScheduler().deactivate();
            this.sendInternalMessage("Agent disabled", 2, "BOOM_AGENT", "BOOM_AGENT");
            RTLogger.print(3, "Agent disabled.");
        }
        this.initHB();
        if (this.m_properties.getSentAgentClonedMsg() != null) {
            this.sendInternalMessage(this.m_properties.getSentAgentClonedMsg(), 5, "BOOM_AGENT", "BOOM_AGENT");
            this.m_properties.setSentAgentClonedMsg(null);
        }
        this.m_mce.startCleaningTask();
        Thread inv = new Thread(this.agentThreadGroup, new Runnable(){

            @Override
            public void run() {
                try {
                    AgentEngine.inventory(new StringBuilder(), false);
                }
                catch (Throwable e) {
                    RTLogger.print(3, "Init inventory failed", e);
                }
            }
        });
        inv.start();
        DailyTask task = new DailyTask("DTC");
        task.setInterval(Interval.getDailyInterval(0, 0, 0));
        this.getScheduler().addTask(task, 0L);
        if (this.getAgentProperties().isTlsActivated()) {
            AgentCertExpirationCheckTask checkTask = new AgentCertExpirationCheckTask(this.m_certificateManager, this.m_properties.getAgentCertExpirationThresholdDays(), "AgentCertExpirationCheckTask");
            checkTask.setInterval(Interval.getDailyInterval(0, 0, 0));
            this.getScheduler().addTask(checkTask, 0L);
        }
        this.scheduleConnectionCheckAfterTLSSwitchTask();
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        RTLogger.print(1, "Agent started");
        isStarted.set(true);
        if (this.m_properties.getDumpConfigSec() != null && this.m_properties.getDumpConfigSec() > 0) {
            this.getScheduler().addTask(new DumpConfig(), 0L);
        }
    }

    private void initNettyEndpoint() {
        InetSocketAddressVerifier inetSocketAddressVerifier = new InetSocketAddressVerifier(this.getAcceptedServerHosts(this.DIR_CONF).keySet());
        this.nettyEndpoint = new NettyEndpoint(this.m_certificateManager, this.m_properties, this.m_scheduler, this.deploymentHelper, this.m_policyRepository, this.getServers()::getCurrentServer, inetSocketAddressVerifier, this);
        this.nettyEndpoint.init();
    }

    public void scheduleConnectionCheckAfterTLSSwitchTask() {
        Path backupFile = Paths.get(AgentEngine.getInstance().DIR_CONF, "conn_bkp.props");
        if (Files.exists(backupFile, new LinkOption[0])) {
            ConnectionCheckAfterTLSSwitchTask task = new ConnectionCheckAfterTLSSwitchTask(this.expectedReconnectAfterTLSSwitchMS, backupFile);
            AgentEngine.getInstance().getScheduledExecutor().schedule(task, this.settingsTLSSwitchCheckDelayMS, TimeUnit.MILLISECONDS);
        }
    }

    public static AtomicBoolean getIsStarted() {
        return isStarted;
    }

    public void initCertificateManager() throws CertificateManagerInitializationException {
        if (this.getAgentProperties().isTlsActivated()) {
            Path defaultKeyStorePath;
            Path backupPath;
            this.m_certificateManager = new CertificateManager();
            try {
                this.m_certificateManager.initTrustStore(this.getAgentProperties().getTsFile(), this.getAgentProperties().getTsPassEncoded());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CertificateManagerInitializationException("Error init certificate manager trust store", 41, e);
            }
            String ksFile = this.getAgentProperties().getKsFile();
            if (ksFile != null && Files.exists(backupPath = KeyStoreUtils.getBackupPath(defaultKeyStorePath = Paths.get(ksFile, new String[0])), new LinkOption[0]) && Files.isRegularFile(backupPath, new LinkOption[0])) {
                try {
                    Files.move(backupPath, defaultKeyStorePath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                    RTLogger.print(1, "Restored key store from backup");
                }
                catch (IOException e) {
                    RTLogger.print(1, "Could not replace default key store with the one from backup", e);
                }
            }
            try {
                this.m_certificateManager.initAgentKeyStore("agent", this.getAgentHostname(), this.getAgentProperties().getKsFile(), this.getAgentProperties().getKsPassEncoded(), this.getAgentProperties().getAllIPs(), this.getAgentProperties().getAllHostnames());
            }
            catch (KeyStoreCreationException e) {
                try {
                    Files.deleteIfExists(Paths.get(this.getAgentProperties().getKsFile(), new String[0]));
                }
                catch (IOException ex) {
                    RTLogger.print(1, "Could not remove key store " + this.getAgentProperties().getKsFile() + " on failed key store creation", ex);
                }
                throw new CertificateManagerInitializationException("Error init certificate manager key store", 44, e);
            }
            catch (Exception e) {
                throw new CertificateManagerInitializationException("Error init certificate manager key store", 44, e);
            }
            try {
                byte[] certificateRequest = this.m_certificateManager.getKsClient().createAgentCertificateRequest("agent", this.getAgentProperties().getAllIPs(), this.getAgentProperties().getAllHostnames());
                Files.write(Paths.get(this.getAgentProperties().getKsFile(), new String[0]).toAbsolutePath().getParent().resolve("agent.csr"), certificateRequest, new OpenOption[0]);
            }
            catch (Exception e) {
                throw new CertificateManagerInitializationException("Error init certificate manager key store", 43, e);
            }
        }
        RTLogger.print(1, "TLS is not enabled");
    }

    public void recreateKeyStore() {
        RTLogger.print(1, "Recreating key store");
        try {
            Files.delete(this.getCertManager().getKsClient().getKeyStorePath());
            this.initCertificateManager();
        }
        catch (CertificateManagerInitializationException e) {
            RTLogger.print(1, "Could not initialize certificate manager", e);
        }
        catch (IOException e) {
            RTLogger.print(1, "Could not recreate key store", e);
        }
    }

    public void initParameters() throws IOException {
        this.printConfToLog(true);
        this.m_properties = new AProperties(this.DIR_CONF);
        System.out.println("Agent starting. Hostname:" + this.m_properties.getThisHostname() + " IP:" + this.m_properties.getAgentIP() + " ID:" + this.m_properties.getAgentID());
        Env.getInstance();
        this.loadJars();
        this.m_DDF = new DDF(BM.agentDDF_file);
        ServerInfo mainServer = new ServerInfo(this.m_properties.getMainServerHost(), this.m_properties.getMainServerIP(), this.m_properties.getMainServerPort(), this.m_properties.getMainServerWsPort() == null ? -1 : this.m_properties.getMainServerWsPort(), ServerType.STANDARD, this.m_properties.getMainServerIpMask(), null, this.m_properties.isTlsActivated() ? "wss" : "ws", this.m_properties.getHbInterval());
        this.servers = new AgentServersInfo(mainServer, this.m_properties.getHbReconnect());
        if (!(this.m_properties.getBackupServerHost() == null || this.m_properties.getBackupServerIp() == null || this.m_properties.getBackupServerPort() == null || this.m_properties.getBackupServerHost().isEmpty() && this.m_properties.getBackupServerIp().isEmpty())) {
            ServerInfo backUpServer = new ServerInfo(this.m_properties.getBackupServerHost(), this.m_properties.getBackupServerIp(), this.m_properties.getBackupServerPort(), this.m_properties.getMainServerWsPort() == null ? -1 : this.m_properties.getMainServerWsPort(), ServerType.BACKUP, this.m_properties.getBackupServerIpMask(), null, this.m_properties.isTlsActivated() ? "wss" : "ws", this.m_properties.getHbInterval());
            this.servers.setBackupMasterServer(backUpServer);
        }
    }

    public void loadJars() {
        File jarsDir = new File(this.DIR_JARS);
        if (!jarsDir.exists()) {
            jarsDir.mkdirs();
        }
        File[] lfiles = jarsDir.listFiles();
        ArrayList<File> jarsOnly = new ArrayList<File>();
        for (File lfile : lfiles) {
            if (!lfile.getName().endsWith(".jar")) continue;
            jarsOnly.add(lfile);
        }
        try {
            StringBuilder sb = new StringBuilder(System.getProperty("java.library.path"));
            int ldpathL = sb.length();
            ExecUtils.addSubDirs(sb, new File("spi"));
            System.setProperty("java.library.path", sb.toString());
            Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
            fieldSysPath.setAccessible(true);
            fieldSysPath.set(null, null);
            if (ldpathL != sb.length()) {
                RTLogger.print(2, "LDP now: " + sb.toString());
            }
        }
        catch (Throwable sb) {
            // empty catch block
        }
        try {
            ClassPathLoader.addFiles(jarsOnly);
        }
        catch (IOException e) {
            RTLogger.print(2, "Reloading of JAR files failed", e);
        }
    }

    public void initScheduler() {
        this.m_scheduler = new Scheduler(this.getMaxActiveMonitorsAllowed());
        this.schedulerThread = new Thread(this.agentThreadGroup, this.m_scheduler);
        this.schedulerThread.setName("AgentScheduler");
        this.schedulerThread.start();
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    public Thread getSchedulerThread() {
        return this.schedulerThread;
    }

    public synchronized void initHB() {
        if (this.m_hb != null) {
            this.getScheduler().removeTask(this.m_hb.getName());
        }
        if (!"WEBSOCKET_ONLY".equals(this.m_properties.getCommType()) && !"WEBSOCKET_TLS_ONLY".equals(this.m_properties.getCommType())) {
            if (this.m_properties.getMode() < 7) {
                if ("HTTPS".equalsIgnoreCase(this.m_properties.getCommType()) || "HTTP".equalsIgnoreCase(this.m_properties.getCommType())) {
                    this.m_hb = new HB_HTTPS();
                    RTLogger.print(2, this.m_properties.getCommType() + " heartbeat started");
                    this.getScheduler().removeTask(this.m_hb.getName());
                    this.getScheduler().addTask(this.m_hb, System.currentTimeMillis() - this.m_hb.getInterval());
                } else {
                    this.m_hb = new HB();
                    this.getScheduler().removeTask(this.m_hb.getName());
                    this.getScheduler().addTask(this.m_hb, System.currentTimeMillis() - this.m_hb.getInterval());
                }
            }
        } else {
            RTLogger.print(2, "   ignore starting HB for WEBSOCKET_ONLY comm type");
        }
    }

    public void initAgent() {
        AgentEngine.storePID();
        boolean startPlainSocket = this.m_properties.getAgentPort() > 0;
        boolean startTlsSocket = this.m_properties.getAgentTlsPort() > 0;
        boolean plainSocketOnlyLocalIP = false;
        if (startTlsSocket && ("WEBSOCKET_ONLY".equals(this.m_properties.getCommType()) || "WEBSOCKET_TLS_ONLY".equals(this.m_properties.getCommType()))) {
            startTlsSocket = false;
            plainSocketOnlyLocalIP = true;
            RTLogger.print(1, "Pure TLS port listener will be not activated with COMM_TYPE=" + this.m_properties.getCommType());
            RTLogger.print(1, "Plain port will be activated only on local IP");
        }
        this.m_agent = new Agent(this.getAcceptedServerHosts(this.DIR_CONF), startTlsSocket, startPlainSocket, plainSocketOnlyLocalIP);
    }

    public void startAgent() {
        if (this.m_properties.getAgentPort() > 0) {
            Thread tr = new Thread(this.agentThreadGroup, this.m_agent, "AgentSocketServer");
            tr.start();
        } else {
            RTLogger.print(1, "Agent port: (%s) - no socket listener started", this.m_properties.getAgentPort());
        }
    }

    public void initQueues() {
        this.monitorQueue = new SendBuffer(Paths.get(this.DIR_MAIN, new String[0]).resolve("monq.dat").toString(), this.m_properties.getMaxMessages());
        this.msgBuffer = new MsgBuffer(Paths.get(this.DIR_MAIN, new String[0]).resolve(BM.msgBuffer_msgq_dat).toString(), this.m_properties.getMaxMessages());
        this.finishAlertsQueue = new SendBufferFA(null, this.m_properties.getMaxMessages());
        this.perfQueue = new SendPerfBuffer(Paths.get(this.DIR_MAIN, new String[0]).resolve(BM.perfBuffer_msgq_dat).toString(), this.m_properties.getMaxPerfRecords());
    }

    void startSendTask() {
        if (this.sendTask != null) {
            this.m_scheduler.removeTask(this.sendTask.getName());
        }
        if (this.getMode() < 7) {
            if ("HTTPS".equalsIgnoreCase(this.m_properties.getCommType()) || "HTTP".equalsIgnoreCase(this.m_properties.getCommType())) {
                this.sendTask = new SendTask_HTTP(this);
                this.m_scheduler.addTask(this.sendTask, 0L);
                RTLogger.print(2, this.m_properties.getCommType() + " submitter started.");
            } else if ("SOCKET".equalsIgnoreCase(this.m_properties.getCommType()) || "TLS".equalsIgnoreCase(this.m_properties.getCommType())) {
                this.sendTask = new SendTask();
                this.m_scheduler.addTask(this.sendTask, 0L);
                RTLogger.print(2, this.m_properties.getCommType() + " submitter started.");
            } else {
                RTLogger.print(2, this.m_properties.getCommType() + " submitter found");
            }
        }
    }

    public void initPolicyRepository() {
        this.m_policyRepository = PolicyRepository.getInstance();
        this.initCalcEngines(this.m_policyRepository);
        this.m_policyRepository.init();
        RTLogger.print(1, "Monitor Policies found: " + this.m_policyRepository.m_knownMonitors.size());
        RTLogger.print(1, "Indication Policies found: " + this.m_policyRepository.m_knownMsgPolicies.size());
    }

    public void initCalcEngines(PolicyRepository pr) {
        this.m_ce = new CalcEngine(pr);
        this.m_mce = new MsgCalcEngine(pr);
    }

    public void initSubmitters() {
        this.m_submitter = new Submitter();
        Thread tr = new Thread(this.agentThreadGroup, this.m_submitter, "MonSubmitter");
        tr.start();
        this.m_msgSubmitter = new MsgSubmitter();
        Thread tr1 = new Thread(this.agentThreadGroup, this.m_msgSubmitter, "MsgSubmitter");
        tr1.start();
    }

    public int getProtocolVersion() {
        return this.m_properties.isTlsActivated() ? 1 : this.m_properties.getProtocolVersion();
    }

    public MessageStormFilter getMessageStormFilter() {
        return this.m_stormDetector;
    }

    public Submitter getSubmitter() {
        return this.m_submitter;
    }

    public MsgSubmitter getMsgSubmitter() {
        return this.m_msgSubmitter;
    }

    public SendBuffer getMonitorQueue() {
        return this.monitorQueue;
    }

    public SendPerfBuffer getPerfQueue() {
        return this.perfQueue;
    }

    public SendBufferFA getFAQueue() {
        return this.finishAlertsQueue;
    }

    public MsgBuffer getMessageQueue() {
        return this.msgBuffer;
    }

    public String getAgentHostname() {
        if (this.m_properties == null) {
            return "localhost";
        }
        if (this.m_properties.getThisHostname().equals("localhost") && !this.m_properties.isFixedName()) {
            this.m_properties.resolveHostname();
        }
        return this.m_properties.getThisHostname();
    }

    public String getAgentIP() {
        return this.m_properties.getAgentIP();
    }

    public String getAgentID() {
        return this.m_properties.getAgentID();
    }

    public String getAgentOS() {
        return this.m_properties.getAgentOS();
    }

    public int getAgentPort() {
        return this.m_properties.getAgentPort();
    }

    public String getAgentVersion() {
        return "5.11.0";
    }

    public AProperties getAgentProperties() {
        return this.m_properties;
    }

    public Scheduler getScheduler() {
        return this.m_scheduler;
    }

    public CalcEngine getCalcEngine() {
        return this.m_ce;
    }

    public MsgCalcEngine getMsgCalcEngine() {
        return this.m_mce;
    }

    public PolicyRepository getPolicyRepository() {
        return this.m_policyRepository;
    }

    public List<String> getClusterNodes() {
        return this.m_properties.getClusterNodes();
    }

    public DDF getDDF() {
        return this.m_DDF;
    }

    public boolean getDisabled() {
        return this.m_properties.getDisabled();
    }

    public boolean isFixedIPUsed() {
        return this.m_properties.isFixedIP();
    }

    public boolean isFixedHostnameUsed() {
        return this.m_properties.isFixedName();
    }

    public void setDisabled(boolean disabled) {
        if (this.m_properties.getDisabled() != disabled) {
            this.m_properties.setDisabled(disabled);
            this.m_properties.save();
            if (disabled) {
                this.getScheduler().deactivate();
                Tracker.m_expectedEvents.clear();
                this.sendInternalMessage("Agent disabled", 2, "BOOM_AGENT", "BOOM_AGENT");
                RTLogger.print(3, "Agent deactivated.");
            } else {
                this.getScheduler().activate();
                this.sendInternalMessage("Agent enabled", 1, "BOOM_AGENT", "BOOM_AGENT");
                RTLogger.print(3, "Agent re-activated.");
            }
        }
    }

    public void setID(String id) {
        this.m_properties.setAgentID(id);
        this.m_properties.save();
    }

    @Override
    public int getMode() {
        return this.m_properties.getMode();
    }

    @Override
    public void setMode(int modeStatus) {
        this.m_properties.setMode(modeStatus);
    }

    public void setSharedIP(boolean isSharedIP) {
    }

    public void setAgentIP(String ip) {
        this.m_properties.setAgentIP(ip);
        this.m_properties.save();
        RTLogger.print(2, "new IP stored: " + ip);
    }

    public void setAgentHost(String host) {
        this.m_properties.setAgentHost(host);
        this.m_properties.save();
        RTLogger.print(2, "new local Hostname stored: " + host);
    }

    @Override
    public boolean pendingUpdates() {
        try {
            if (this.getMode() < 7 && (this.m_hb == null || this.m_hb.isStopped())) {
                this.initHB();
                return true;
            }
            if (this.getMonitorQueue().sizeC1() > 0 || this.getMessageQueue().sizeC1() > 0) {
                MMObject mmo;
                long minTime = Integer.MAX_VALUE;
                IODataStream obj = this.getMonitorQueue().m_queue.peek();
                if (obj != null && obj instanceof MMObject) {
                    mmo = (MMObject)obj;
                    minTime = Math.min(minTime, mmo.p1_time);
                }
                if ((obj = (IODataStream)this.getMessageQueue().m_queue.peek()) != null && obj instanceof MMObject) {
                    mmo = (MMObject)obj;
                    minTime = Math.min(minTime, mmo.p1_time);
                }
                long maxTime = (long)this.getAgentProperties().getHbInterval() * 1000L * 3L;
                if (minTime < System.currentTimeMillis() - maxTime) {
                    RTLogger.print(2, "Polling activated.");
                    return true;
                }
            }
        }
        catch (Throwable e) {
            RTLogger.print(3, "error 510", e);
        }
        boolean buffersAreNotEmpty = this.monitorQueue.sizeC1() > 0 || this.msgBuffer.sizeC1() > 0 || this.finishAlertsQueue.sizeC1() > 0 || this.perfQueue.sizeC1() > 0;
        return this.getMode() >= 2 && buffersAreNotEmpty;
    }

    @Override
    public void fetchRemoteUpdates(SDataInputStream in, SDataOutputStream out) {
        try {
            AgentWorker aw = new AgentWorker(null, Collections.EMPTY_MAP);
            int countMax = 1000;
            do {
                if (countMax <= 0 || this.deploymentHelper.isDeploymentRunning()) {
                    out.write(48);
                    break;
                }
                out.write(51);
                aw.processIncomingData(out, in);
                --countMax;
            } while (in.read() == 50);
        }
        catch (IOException e) {
            RTLogger.print(2, "Error read server socket", e);
        }
    }

    public int getMaxActiveMonitorsAllowed() {
        return this.m_properties.getMaxSymMonitors();
    }

    public void sendInternalMessage(String text, int severity, String msggrp, String object) {
        if (this.getMsgSubmitter() != null) {
            Message m = new Message("BOOM_AGENT", object, text, System.currentTimeMillis());
            m.setOptional(severity, msggrp, this.getAgentHostname());
            this.getMsgSubmitter().submitInternal(m);
        }
    }

    public void sendInternalMessageDupl(String text, int severity, String msggrp, String object) {
        if (this.getMsgSubmitter() != null) {
            Message m = new Message("BOOM_AGENT", object, text, System.currentTimeMillis());
            m.setOptional(severity, msggrp, this.getAgentHostname());
            m.p8_messageKey = this.getAgentHostname() + ':' + "BOOM_AGENT" + ':' + msggrp + ':' + object;
            this.getMsgSubmitter().submitInternal(m);
        }
    }

    public void sendEmergency(String text, int severity, String msggrp, String object) {
        Message m = new Message("BOOM_AGENT", object, text, System.currentTimeMillis());
        m.setOptional(severity, msggrp, this.getAgentHostname());
        m.p8_messageKey = this.getAgentHostname() + ':' + "BOOM_AGENT" + ':' + msggrp + ':' + object + ':' + Severity.getSeverity(severity);
        m.p9_ackKey = this.getAgentHostname() + ':' + "BOOM_AGENT" + ':' + msggrp + ':' + object + ':' + "<*>";
        AgentEngine.getInstance().getMessageQueue().putEmergency(m);
    }

    @Override
    public void sendMessage(String node, String application, String msggrp, String object, String text, String severity, HashMap optVars) {
        if (application == null) {
            application = "";
        }
        if (msggrp == null) {
            msggrp = "";
        }
        if (object == null) {
            object = "";
        }
        if (severity == null) {
            severity = "unknown";
        }
        Message m = new Message(application, object, text, System.currentTimeMillis());
        if (node == null || node.length() == 0) {
            node = this.getAgentHostname();
        }
        m.setOptional(severity, msggrp, node);
        if (optVars != null && !optVars.isEmpty()) {
            for (Map.Entry entry : optVars.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) {
                    m.putOptions("" + entry.getKey(), "" + entry.getValue());
                    continue;
                }
                m.putOptions((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.getMsgSubmitter().submit(m);
    }

    public void storeProps() {
        this.m_properties.save();
    }

    public int stop() {
        this.getScheduler().deactivate();
        this.shutdownServerSocket();
        this.storeQueues();
        if (this.nettyEndpoint != null) {
            this.nettyEndpoint.stop();
        }
        if (this.agentThreadGroup != null) {
            this.agentThreadGroup.interrupt();
        }
        if (this.m_stormDetector != null) {
            this.m_stormDetector.stop();
        }
        this.getScheduler().stopScheduler();
        this.scheduledExecutor.shutdownNow();
        if (this.shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        LoggerContext initialize = Configurator.initialize(new NullConfiguration());
        Throwable throwable = null;
        if (initialize != null) {
            if (throwable != null) {
                try {
                    initialize.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                initialize.close();
            }
        }
        return 0;
    }

    public void shutdownServerSocket() {
        if (this.m_agent != null) {
            this.m_agent.shutdown();
        }
        RTLogger.print(1, "Main socket closed");
    }

    public void storeQueues() {
        if (this.m_isQueueStored.compareAndSet(false, true)) {
            if (this.getMessageQueue() != null) {
                this.getMessageQueue().storeInFile();
            }
            if (this.getMonitorQueue() != null) {
                this.getMonitorQueue().storeInFile();
            }
            if (this.getPerfQueue() != null) {
                this.getPerfQueue().storeInFile();
            }
        }
    }

    public void setLastTimeOnline() {
        this.m_lastTimeOnline = System.currentTimeMillis();
    }

    public long getTimeFromLastServerPing() {
        return System.currentTimeMillis() - this.m_lastTimeOnline;
    }

    @Override
    public boolean needsToBeChecked() {
        return System.currentTimeMillis() - this.m_lastTimeOnline > (long)(this.getAgentProperties().getHbInterval() * 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void inventory(StringBuilder sb, boolean serverRequest) throws IOException {
        sb.append("ID=" + m_engine.getAgentID()).append('\n');
        sb.append("VERSION=" + m_engine.getAgentVersion()).append('\n');
        sb.append("HOSTNAME=" + m_engine.getAgentHostname()).append('\n');
        sb.append("IP=" + m_engine.getAgentIP()).append('\n');
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        sb.append("OS.NAME=" + os.getName()).append('\n');
        sb.append("OS.VERSION=" + os.getVersion()).append('\n');
        sb.append("OS.ARCH=" + os.getArch()).append('\n');
        sb.append("HW.CPUN=" + os.getAvailableProcessors()).append('\n');
        RuntimeMXBean java = ManagementFactory.getRuntimeMXBean();
        sb.append("JAVA.HOME=" + System.getProperty("java.home")).append('\n');
        sb.append("JAVA.VMNAME=" + java.getVmName()).append('\n');
        sb.append("JAVA.VMVENDOR=" + java.getVmVendor()).append('\n');
        sb.append("JAVA.VMVER=" + java.getVmVersion()).append('\n');
        String commType = AgentEngine.getInstance().getAgentProperties().getCommType();
        sb.append("COMM_TYPE=").append(commType).append("\n");
        if (commType.startsWith("TLS")) {
            sb.append(AgentEngine.getAgentCertificateInventory());
        }
        ExecResult er = null;
        er = SystemUtils.OS != 1 ? ExecUtils.exec2("sh inventory/go.sh", AgentEngine.m_engine.FILE_SPI_DIR, 300) : ExecUtils.exec2("inventory\\go.cmd", AgentEngine.m_engine.FILE_SPI_DIR, 300);
        if (er.resultCode == 0) {
            for (String str : er.m_outMessages) {
                sb.append(str).append('\n');
            }
            for (String str : er.m_errorMessages) {
                RTLogger.print(3, "Inventory silently failed: " + str);
            }
        } else {
            RTLogger.print(3, "Inventory failed: " + er.getOutputSingleLine());
        }
        String inventoryFilename = AgentEngine.m_engine.DIR_CONF + File.separator + "inventory.dat";
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            String runtime = ShabalUtils.getMD5(sb.toString());
            String stored = null;
            File st = new File(inventoryFilename);
            if (st.exists()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                fis = new FileInputStream(st);
                byte[] buff = new byte[512];
                int c = -1;
                while ((c = fis.read(buff)) != -1) {
                    bos.write(buff, 0, c);
                }
                stored = bos.toString();
                if (!runtime.equals(stored)) {
                    if (!serverRequest) {
                        AgentEngine.sendInventoryMessage(runtime);
                    }
                    fos = new FileOutputStream(st);
                    fos.write(runtime.getBytes());
                }
            } else {
                if (!serverRequest) {
                    AgentEngine.sendInventoryMessage(runtime);
                }
                fos = new FileOutputStream(st);
                fos.write(runtime.getBytes());
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static String getAgentCertificateInventory() {
        StringBuilder sb = new StringBuilder();
        try {
            CertificateManager certManager = AgentEngine.getInstance().getCertManager();
            if (certManager != null) {
                KeyStoreClient ksClient;
                TrustStoreClient tsClient = certManager.getTsClient();
                if (tsClient != null) {
                    List<BasicCertificateInfo> certificatesInfo = tsClient.getCertificatesInfo();
                    String tsInfo = certificatesInfo.stream().map(info -> AgentEngine.certInfoToInventory("TS.", info)).collect(Collectors.joining());
                    sb.append(tsInfo);
                }
                if ((ksClient = certManager.getKsClient()) != null) {
                    List<BasicCertificateInfo> certificatesInfo = ksClient.getCertificatesInfo();
                    String ksInfo = certificatesInfo.stream().map(info -> AgentEngine.certInfoToInventory("KS.", info)).collect(Collectors.joining());
                    sb.append(ksInfo);
                }
            }
        }
        catch (Exception e) {
            RTLogger.print(3, "Could not get certificate info inventory", e);
        }
        return sb.toString();
    }

    private static String certInfoToInventory(String prefix, BasicCertificateInfo info) {
        StringBuilder sb = new StringBuilder();
        LocalDate ld = info.getValidTo().toInstant().atOffset(ZoneOffset.UTC).toLocalDate();
        String expirationDate = DateTimeFormatter.ISO_LOCAL_DATE.format(ld);
        sb.append(prefix).append(info.getAlias()).append(".ISSUER=").append(info.getIssuerName()).append("\n");
        sb.append(prefix).append(info.getAlias()).append(".EXPIRATION=").append(expirationDate).append("\n");
        sb.append(prefix).append(info.getAlias()).append(".SHA256=").append(info.getSHA256Fingerprint()).append("\n");
        return sb.toString();
    }

    private static void sendInventoryMessage(String md5) {
        Message m = new Message("BOOM_AGENT", "INVENTORY", "Inventory change detected\n" + md5, System.currentTimeMillis());
        m.setOptional(1, "BOOM_AGENT", m_engine.getAgentHostname());
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        String date = sdf.format(new Date());
        String keyMain = m_engine.getAgentHostname() + ":" + "BOOM_AGENT" + ":INVENTORY:";
        m.p8_messageKey = keyMain + md5;
        m.p9_ackKey = keyMain + "<*>";
        m.p11_2_autoActionTimeout = 30;
        m.p11_autoAction = "BOOM_AGENT GET_DETAILS";
        m.m_internalMsg = true;
        m.putOptions("MD5", md5);
        m.putOptions("DATE", date);
        AgentEngine.getInstance().getMsgSubmitter().submitInternal(m);
    }

    public HB getHB() {
        return this.m_hb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            if (args != null && args.length == 1 && args[0].equalsIgnoreCase("-version")) {
                System.out.println("5.11.0");
                System.exit(0);
            }
            AgentEngine ae = AgentEngine.getInstance();
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(5000L);
                        if (!m_engine.getScheduler().isStopped()) continue;
                        RTLogger.print(1, "Trying to restart Scheduler");
                        Thread sch = new Thread(AgentEngine.m_engine.agentThreadGroup, m_engine.getScheduler());
                        sch.setName("Scheduler");
                        sch.start();
                    }
                }
                catch (Exception e) {
                    RTLogger.print(1, "Error", e);
                    try {
                        RTLogger.print(1, "Trying to send data to the server");
                        AgentEngine.getInstance().sendTask.onGetData();
                    }
                    catch (Exception e1) {
                        RTLogger.print(1, "Error", e1);
                    }
                    continue;
                }
                break;
            }
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            System.err.println(String.format("Wrong jre (?): %s version: %s", System.getProperty("java.vendor"), System.getProperty("java.version")));
            RTLogger.print(1, "AGENT TERMINATED.");
            RTLogger.flush();
        }
        catch (Exception e) {
            try {
                try {
                    e.printStackTrace();
                    RTLogger.setDir(".", "BOOMAgent_ERROR");
                    RTLogger.print(1, "Error init", e);
                    RTLogger.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                RTLogger.print(1, "AGENT TERMINATED.");
                RTLogger.flush();
            }
        }
    }

    public void setSlaveServerHost(ServerInfo slaveServer) {
        slaveServer.setType(ServerType.SLAVE);
        if (slaveServer.getPublicIP() == null || slaveServer.getPublicIP().isEmpty()) {
            RTLogger.print(2, "Slave server IP cannot be null.");
            return;
        }
        if (slaveServer.getHost() == null || slaveServer.getHost().isEmpty()) {
            slaveServer.setHost(slaveServer.getPublicIP());
        }
        if (slaveServer.getNettyPort() <= 0) {
            slaveServer.setNettyPort(AgentEngine.getInstance().getAgentProperties().getMainServerWsPort());
        }
        RTLogger.print(1, "Slave server info: " + slaveServer.getHost() + ":" + slaveServer.getPort() + " (" + slaveServer.getPublicIP() + ")");
        RTLogger.print(2, "Slave server extended info: nettyPort=" + slaveServer.getNettyPort() + " protocol=" + slaveServer.getProtocol());
        this.servers.setSlaveServer(slaveServer);
        this.getAgent().addValidHost(slaveServer.getPublicIP());
        if (this.nettyEndpoint == null) {
            if (slaveServer.getProtocol() != null) {
                this.initNettyEndpoint();
                this.nettyEndpoint.start();
            } else {
                RTLogger.print(1, "Netty endpoint is not initialized. Switch to the new server without WS/WSS channel ?");
            }
        } else {
            this.nettyEndpoint.start();
        }
    }

    public Agent getAgent() {
        return this.m_agent;
    }

    public AgentServersInfo getServers() {
        return this.servers;
    }

    public CertificateManager getCertManager() {
        return this.m_certificateManager;
    }

    public DeploymentHelper getDeploymentHelper() {
        return this.deploymentHelper;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    public void restart() throws IOException {
        RTLogger.print(1, "Agent restarting.");
        this.sendInternalMessage("Agent restarting.", 1, "RESTART", "AGENT");
        File f = new File(".");
        try {
            Thread.sleep(1000L);
            this.storeQueues();
        }
        catch (Throwable e1) {
            RTLogger.print(1, "-e-", e1);
        }
        String osName = "undefined";
        try {
            OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
            osName = os.getName();
            RTLogger.print(1, "OS: " + osName);
        }
        catch (Throwable os) {
            // empty catch block
        }
        ExecResult er = null;
        try {
            if (SystemUtils.OS == 2) {
                er = "freebsd".equalsIgnoreCase(osName) ? ExecUtils.exec2("sh -c \"nohup ./" + BM.PRODUCT_lowercase + "_agt -restart 1>/dev/null 2>&1 &\"", f, 10) : ExecUtils.exec2("sh -c \"./" + BM.PRODUCT_lowercase + "_agt -restart\"", f, 10);
                RTLogger.print(1, "Restart command RC: " + er.resultCode);
                RTLogger.print(1, "Restart command OUT: " + er.getOutput());
                if (er.resultCode != 0) {
                    this.sendInternalMessage("Agent restart failed. " + er.getOutput(), 2, "RESTART", "AGENT");
                }
            } else if (SystemUtils.OS == 1) {
                RTLogger.print(1, "Calling: cmd.exe /C start /i " + BM.PRODUCT_lowercase + "_agt.cmd -restart");
                Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", "start /i " + BM.PRODUCT_lowercase + "_agt.cmd -restart"});
            }
        }
        catch (Throwable e) {
            RTLogger.print(1, "-e-", e);
        }
        if ("freebsd".equalsIgnoreCase(osName)) {
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            RTLogger.print(1, "Restart command did not work.");
            if (er != null) {
                RTLogger.print(1, "RC=" + er.resultCode + " STDOUT: " + er.toString() + " STDERR: " + er.toStringOnError());
            }
            try {
                this.initAgent();
                this.startAgent();
            }
            catch (Throwable e) {
                RTLogger.print(2, "", e);
            }
        }
    }

    public long getLastTimeOnline() {
        return Math.max(this.m_lastTimeOnline, this.m_hb == null ? 0L : this.m_hb.getLastTimeRealOnline());
    }

    private static boolean isJUnitTest() {
        return test;
    }

    public NettyEndpoint getNettyEndpoint() {
        return this.nettyEndpoint;
    }

    public Map<String, String> getAcceptedServerHosts(String confDir) {
        HashMap<String, String> hosts = new HashMap<String, String>();
        File f = new File(confDir);
        File cfg = new File(f, "hosts.cfg");
        if (cfg.exists()) {
            try (FileReader in = new FileReader(cfg);){
                BufferedReader br = new BufferedReader(in);
                Object object = null;
                try {
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        hosts.put(line.trim().toLowerCase(), null);
                    }
                }
                catch (Throwable line) {
                    object = line;
                    throw line;
                }
                finally {
                    if (br != null) {
                        if (object != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable line) {
                                ((Throwable)object).addSuppressed(line);
                            }
                        } else {
                            br.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                RTLogger.print(4, "Reading configuration error.", e);
            }
        }
        AProperties props = AgentEngine.getInstance().getAgentProperties();
        hosts.put("127.0.0.1", null);
        hosts.put("localhost", null);
        hosts.put("0:0:0:0:0:0:0:1", null);
        hosts.put("::1 ", null);
        hosts.put(AgentEngine.getInstance().getAgentHostname().toLowerCase(), null);
        hosts.put(props.getAgentIP().toLowerCase(), null);
        ServerInfo mainServer = AgentEngine.getInstance().getServers().getMainServer();
        if (mainServer != null) {
            if (mainServer.getHost() != null) {
                hosts.put(mainServer.getHost().toLowerCase(), null);
            }
            if (mainServer.getPublicIP() != null) {
                hosts.put(mainServer.getPublicIP().toLowerCase(), null);
            }
        }
        if (props.getBackupServerIp() != null) {
            hosts.put(props.getBackupServerIp(), null);
        }
        if (props.getBackupServerHost() != null) {
            hosts.put(props.getBackupServerHost(), null);
        }
        List<String> clusterNodes = AgentEngine.getInstance().getClusterNodes();
        for (String clusterNode : clusterNodes) {
            if (clusterNode == null) continue;
            hosts.put(clusterNode.toLowerCase(), null);
        }
        return hosts;
    }

    public void printConfToLog(boolean force) {
        try {
            Path agentConf = Paths.get(this.DIR_CONF, new String[0]).resolve("agent.conf");
            String digest = FileSyncUtils.getDigest(agentConf.toFile());
            if (this.hashConf == null || !this.hashConf.equals(digest)) {
                String conf = FileUtils.readFile(agentConf.toFile());
                RTLogger.print(1, digest + "\n" + conf);
                this.hashConf = digest;
            } else {
                RTLogger.print(5, digest);
            }
        }
        catch (Exception e) {
            RTLogger.print(5, "", e);
        }
    }

    public class DumpConfig
    extends SchedulerTask {
        public DumpConfig() {
            super("dumpconf");
            this.setInterval(Interval.getSimpleInterval(AgentEngine.this.m_properties.getDumpConfigSec()));
        }

        @Override
        public boolean onInit() throws Exception {
            return true;
        }

        @Override
        public boolean onStartRun() {
            return true;
        }

        @Override
        public boolean onGetData() {
            AgentEngine.this.printConfToLog(false);
            return true;
        }

        @Override
        public boolean onStopRun() {
            return true;
        }

        @Override
        protected boolean onStopTask() {
            return true;
        }

        @Override
        public boolean refresh() {
            return true;
        }
    }
}

