/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.AgentHealth;
import com.blixx.log.RTLogger;
import com.blixx.shared.ServerInfo;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;

public class AgentEngineMonitor {
    private static final String AGENT_NOT_STARTED = "Boom agent not started.";
    private static AgentEngine engine = null;
    private static long signOfLife = Integer.MAX_VALUE;

    public static int run() {
        if (engine != null) {
            return 5;
        }
        int result = 1;
        try {
            AgentEngineMonitor.startEngine();
            long maxPidTracing = System.currentTimeMillis() + 3L + 60000L;
            while (!AgentEngine.isPIDStored() && !AgentEngine.getIsStarted().get() && maxPidTracing > System.currentTimeMillis()) {
                Thread.sleep(500L);
            }
            if (!AgentEngine.isPIDStored()) {
                RTLogger.print(1, "[Lisa] boom agent can't store PID file");
                result = 6;
            } else if (!AgentEngine.getIsStarted().get()) {
                RTLogger.print(1, "[Lisa] boom agent can't start");
                result = 7;
            } else {
                RTLogger.print(1, "[Lisa] boom agent started. " + engine);
                signOfLife = 120L;
                engine.getSchedulerThread().join();
                Thread.sleep(1000L);
                RTLogger.print(1, "[Lisa] boom agent stopped");
                Thread.getAllStackTraces().keySet().forEach(tr -> {
                    if (Thread.currentThread() != tr) {
                        RTLogger.print(1, "not yet stopped thread: " + tr.getName() + " (" + (Object)((Object)tr.getState()) + ")");
                        for (StackTraceElement ste : tr.getStackTrace()) {
                            RTLogger.print(1, "   " + ste.getClassName() + ": " + ste.getMethodName() + ":" + ste.getLineNumber());
                        }
                    }
                });
                result = 0;
            }
        }
        catch (Exception e) {
            RTLogger.print(1, "[Lisa] boom agent failed to run", e);
            result = 22;
        }
        AgentEngineMonitor.delayedJvmHalt();
        return result;
    }

    private static void delayedJvmHalt() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                RTLogger.print(1, "[Lisa] runtime.halt");
                Runtime.getRuntime().halt(0);
            }
        }, 500L);
    }

    public static String getVersion() {
        RTLogger.print(1, "[Lisa] getVersion=5.11.0");
        return "5.11.0";
    }

    public static void stop() {
        RTLogger.print(1, "[Lisa] stopping boom agent... " + engine);
        engine.stop();
        LogManager.shutdown();
    }

    public static void lockLogs() {
        RTLogger.print(1, "[Lisa] locks logs.");
        RTLogger.lockLogs();
    }

    public static void unlockLogs() {
        RTLogger.unLockLogs();
    }

    public static int getStatus() {
        int status = 0;
        if (engine != null && engine.getHB() != null) {
            boolean isRunning = engine.getHB().isRunning();
            boolean isConnected = engine.getHB().isConnected() && engine.getNettyEndpoint() != null && engine.getNettyEndpoint().isNettyConnected();
            boolean isStopped = engine.getHB().isStopped();
            status = isRunning ? 1 : (isConnected ? 0 : (isStopped ? 3 : 2));
        }
        RTLogger.print(1, "[Lisa] getStatus=" + status);
        return status;
    }

    public static long readSignOfLifeDelay() {
        if (engine != null) {
            if (engine.getScheduler() != null && engine.getScheduler().isStopped()) {
                RTLogger.print(1, "Scheduler is stopped. SoL=0");
                signOfLife = 0L;
            } else if (AgentHealth.isLowMemory()) {
                long minutes;
                long lmStart = AgentHealth.getLowMemoryStartTime();
                if (lmStart > 0L && (minutes = (System.currentTimeMillis() - lmStart) / 3600000L) > 2L) {
                    RTLogger.print(1, "low memory is more than 2 minutes. SoL=0");
                    signOfLife = 0L;
                }
            } else if (signOfLife == 0L) {
                RTLogger.print(1, "low memory state recovered. SoL=120");
                signOfLife = 120L;
            }
        }
        RTLogger.print(1, "[Lisa] readSignOfLifeDelay=" + signOfLife);
        return signOfLife;
    }

    public static boolean checkHost() {
        if (engine != null) {
            return engine.getHB().isConnected();
        }
        return false;
    }

    public static String getConnectedHost() {
        String result = AGENT_NOT_STARTED;
        if (engine != null) {
            ServerInfo srv = engine.getServers().getCurrentServer();
            if (srv == null) {
                return "null";
            }
            result = srv.getHost() + ":" + srv.getPort();
        }
        RTLogger.print(1, "[Lisa] getConnectedHost=" + result);
        return result;
    }

    private static void startEngine() {
        engine = AgentEngine.getInstance();
    }
}

