/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.MsgSubmitter;
import com.blixx.agent.Submitter;
import com.blixx.log.RTLogger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class AgentHealth {
    static Runtime rt = Runtime.getRuntime();
    static int MB = 0x100000;
    static AtomicBoolean m_lowMemoryMode = new AtomicBoolean(false);
    static long m_criticalFreeMemory = 5L * (long)MB;
    static long m_normalFreeMmemory = Math.max(7L * (long)MB, (long)((double)rt.maxMemory() * 0.05));
    static AtomicLong m_totalIncomingIndis = new AtomicLong(0L);
    static AtomicLong m_totalMatchedIndis = new AtomicLong(0L);
    static AtomicLong m_totalMatchedMonitorValues = new AtomicLong(0L);
    static AtomicLong m_totalMonitorValues = new AtomicLong(0L);
    static AtomicLong m_nonPolicySpecificIndis = new AtomicLong(0L);
    static AtomicLong m_snmpTraps = new AtomicLong(0L);
    static AtomicLong lowMemoryStart = new AtomicLong(0L);
    private static Map<String, AtomicLong> m_specificCounters = new ConcurrentHashMap<String, AtomicLong>(10);

    public static long getAvailableFreeMemoryMB() {
        long unallocated = (rt.maxMemory() - rt.totalMemory()) / (long)MB;
        long free = rt.freeMemory() / (long)MB;
        return unallocated + free;
    }

    public static long getAvailableFreeMemoryBytes() {
        long unallocated = rt.maxMemory() - rt.totalMemory();
        long free = rt.freeMemory();
        return unallocated + free;
    }

    public static double getAvailableFreeMemoryPCT() {
        return ((double)(rt.maxMemory() - rt.totalMemory()) + (double)rt.freeMemory()) / (double)rt.maxMemory();
    }

    public static boolean isLowMemory() {
        if (AgentHealth.getAvailableFreeMemoryBytes() < m_criticalFreeMemory) {
            if (m_lowMemoryMode.compareAndSet(false, true)) {
                lowMemoryStart.set(System.currentTimeMillis());
                AgentEngine.getInstance().sendEmergency("Agent has " + AgentHealth.getAvailableFreeMemoryMB() + "MB memory left", 5, "BOOM_AGENT", "BOOM_AGENT");
                RTLogger.print(1, "LowMemory detected! Agent free memory (bytes): " + AgentHealth.getAvailableFreeMemoryBytes());
            }
        } else if (AgentHealth.getAvailableFreeMemoryBytes() > m_normalFreeMmemory && m_lowMemoryMode.compareAndSet(true, false)) {
            lowMemoryStart.set(0L);
            AgentEngine.getInstance().sendEmergency("Agent has " + AgentHealth.getAvailableFreeMemoryMB() + "MB memory left", 1, "BOOM_AGENT", "BOOM_AGENT");
            RTLogger.print(1, "Agent Memory is OK now! Agent free memory (bytes): " + AgentHealth.getAvailableFreeMemoryBytes());
        }
        return m_lowMemoryMode.get();
    }

    public static long getTotalIn() {
        return m_totalIncomingIndis.get();
    }

    public static long getTotalMatched() {
        return m_totalMatchedIndis.get();
    }

    public static long getTotalNewMonitorValues() {
        return m_totalMatchedMonitorValues.get();
    }

    public static int getInQueueSizeAll() {
        int total = 0;
        MsgSubmitter ms = AgentEngine.getInstance().getMsgSubmitter();
        if (ms != null) {
            total = ms.getQueueSizeAll();
        }
        return total;
    }

    public static int getInQueueSizeAll_Mon() {
        int total = 0;
        Submitter ms = AgentEngine.getInstance().getSubmitter();
        if (ms != null) {
            total = ms.queue.size();
        }
        return total;
    }

    public static String getStartTime() {
        Date d = new Date(AgentEngine.getInstance().m_startTime);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(d);
    }

    public static void countSpecific(String policyName) {
        AtomicLong ab = m_specificCounters.get(policyName);
        if (ab == null) {
            ab = new AtomicLong(1L);
            m_specificCounters.put(policyName, ab);
        } else {
            ab.incrementAndGet();
        }
    }

    public static void countSnmpTraps() {
        m_snmpTraps.incrementAndGet();
    }

    public static long getSnmpTrapsCount() {
        return m_snmpTraps.get();
    }

    public static Map<String, AtomicLong> getPolicyCounts() {
        return m_specificCounters;
    }

    public static long getMonitorValuesCount() {
        return m_totalMonitorValues.get();
    }

    public static long getNonPolicySpecificIndis() {
        return m_nonPolicySpecificIndis.get();
    }

    public static long getLowMemoryStartTime() {
        return lowMemoryStart.get();
    }
}

