/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.AgentWorker;
import com.blixx.agent.IAgentListener;
import com.blixx.log.RTLogger;
import com.blixx.sa.BMThreadFactory;
import com.blixx.shared.BM;
import com.boom.SocketUtils;
import com.boom.TlsUtils;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AgentListener
implements IAgentListener {
    private final Map<String, String> hosts;
    private final Map<String, String> tlsHosts;
    private ServerSocket serverSocket;
    private ServerSocket tlsServerSocket = null;
    private boolean isRun;
    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(2, 20, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private final boolean deActivateTlsClientAuth = "false".equalsIgnoreCase(System.getenv("BOOMTLSCLIENTAUTH"));
    private final boolean isPlainSocketOnlyLocalIP;

    public AgentListener(Map<String, String> hosts, boolean plainSocketOnlyLocalIP) {
        this.isPlainSocketOnlyLocalIP = plainSocketOnlyLocalIP;
        this.hosts = new HashMap<String, String>(hosts);
        this.tlsHosts = new HashMap<String, String>(hosts);
        long startWaitingSocketTime = System.currentTimeMillis();
        this.executor.setThreadFactory(new BMThreadFactory("agentWorker_"));
        this.serverSocket = null;
        int port = AgentEngine.getInstance().getAgentPort();
        if (port > 0) {
            this.initServerSocket(port, startWaitingSocketTime);
        } else {
            RTLogger.print(1, "Server socket not started: " + port);
        }
        if (AgentEngine.getInstance().getAgentProperties().isTlsActivated()) {
            Integer tlsPort = AgentEngine.getInstance().getAgentProperties().getAgentTlsPort();
            if (tlsPort == null) {
                RTLogger.print(1, "Communication type defined as 'TLS', but property AGENT_TLS_PORT is not set or invalid port number! ");
                RTLogger.print(1, "Agent stops.");
                System.exit(31);
            }
            this.initTlsServerSocket(tlsPort, startWaitingSocketTime);
        } else {
            RTLogger.print(1, "TLS server socket not started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initServerSocket(int port, long startWaitingSocketTime) {
        int waitServerSocketSec = AgentEngine.getInstance().getAgentProperties().getMaxWaitServerSocketSec();
        while (true) {
            try {
                this.serverSocket = new ServerSocket();
                this.serverSocket.setReuseAddress(true);
                InetSocketAddress endpoint = new InetSocketAddress(port);
                if (this.isPlainSocketOnlyLocalIP) {
                    endpoint = new InetSocketAddress(InetAddress.getLoopbackAddress(), port);
                    this.hosts.clear();
                    this.hosts.put("127.0.0.1", null);
                    this.hosts.put("localhost", null);
                    this.hosts.put("0:0:0:0:0:0:0:1", null);
                    this.hosts.put("::1 ", null);
                }
                this.serverSocket.bind(endpoint);
                RTLogger.print(1, "Listener Port: " + port + " is started");
            }
            catch (Exception e) {
                RTLogger.print(1, "Required Agent port: " + port + " is busy...");
                RTLogger.print(5, "", e);
                try {
                    AgentListener agentListener = this;
                    synchronized (agentListener) {
                        this.wait(1000L);
                    }
                    this.serverSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (waitServerSocketSec <= 0 || System.currentTimeMillis() - startWaitingSocketTime <= (long)waitServerSocketSec * 1000L) continue;
                RTLogger.print(1, "Server socket is not available in maximum wait seconds specified: " + waitServerSocketSec);
                RTLogger.print(1, "Agent stops.");
                System.exit(23021);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTlsServerSocket(int port, long startWaitingSocketTime) {
        int waitServerSocketSec = AgentEngine.getInstance().getAgentProperties().getMaxWaitServerSocketSec();
        while (true) {
            try {
                this.tlsServerSocket = new ServerSocket();
                this.tlsServerSocket.setReuseAddress(true);
                InetSocketAddress endpoint = new InetSocketAddress(port);
                this.tlsServerSocket.bind(endpoint);
                RTLogger.print(1, "Listener (TLS) Port: " + port + " is started.");
            }
            catch (Exception e) {
                RTLogger.print(1, "Required TLS Agent port: " + port + " is busy...");
                try {
                    AgentListener agentListener = this;
                    synchronized (agentListener) {
                        this.wait(1000L);
                    }
                    this.tlsServerSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (waitServerSocketSec <= 0 || System.currentTimeMillis() - startWaitingSocketTime <= (long)waitServerSocketSec * 1000L) continue;
                RTLogger.print(1, "TLS Server socket is not available in maximum wait seconds specified: " + waitServerSocketSec);
                RTLogger.print(1, "Agent stops.");
                System.exit(23031);
                continue;
            }
            break;
        }
    }

    @Override
    public void runPlainSocket() {
        if (this.serverSocket != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    AgentListener.this.run(AgentListener.this.serverSocket, AgentListener.this.hosts, false);
                }
            }, "AgentServerSocket").start();
        }
    }

    @Override
    public void runTlsSocket() {
        if (this.tlsServerSocket != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    AgentListener.this.run(AgentListener.this.tlsServerSocket, AgentListener.this.tlsHosts, true);
                }
            }, "AgentTlsServerSocket").start();
        }
    }

    private void run(ServerSocket serverSocket, Map<String, String> hosts, boolean isTLS) {
        RTLogger.print(1, "Port " + serverSocket.getLocalPort() + " hosts: " + hosts.keySet());
        Socket clientSocket = null;
        this.isRun = true;
        while (this.isRun) {
            try {
                clientSocket = serverSocket.accept();
                clientSocket.setSoTimeout(this.isRun ? BM.agent_timeout : 1);
                clientSocket.setTcpNoDelay(true);
                clientSocket.setSoLinger(true, 1);
                InetAddress ia = clientSocket.getInetAddress();
                if (ia.isLoopbackAddress()) {
                    RTLogger.print(6, "Client from " + ia.getHostAddress() + " accepted.");
                } else {
                    String hostnameIncoming;
                    String ipIncoming = ia.getHostAddress();
                    if (ipIncoming.equals(hostnameIncoming = ia.getHostName().toLowerCase())) {
                        hostnameIncoming = ia.getCanonicalHostName().toLowerCase();
                    }
                    if (hosts.containsKey(ipIncoming) || hosts.containsKey(hostnameIncoming)) {
                        RTLogger.print(3, "Client from " + hostnameIncoming + " - " + ipIncoming);
                    } else {
                        RTLogger.print(1, "Client from " + hostnameIncoming + " - " + ipIncoming + " rejected.");
                        try (OutputStream os = clientSocket.getOutputStream();){
                            String reject = "!Access Denied from IP:" + ipIncoming + ' ' + "time=" + System.currentTimeMillis();
                            os.write(reject.getBytes());
                            os.flush();
                        }
                        SocketUtils.closeSocketServerSide(clientSocket, new AutoCloseable[0]);
                        continue;
                    }
                }
                if (isTLS) {
                    clientSocket = TlsUtils.upgradeServerSocket(clientSocket, AgentEngine.getInstance().getCertManager(), !this.deActivateTlsClientAuth, false);
                }
                this.runClient(clientSocket, hosts);
            }
            catch (Exception e) {
                RTLogger.print(2, "Error creation Client Socket", e);
                SocketUtils.closeSocketServerSide(clientSocket, new AutoCloseable[0]);
            }
        }
        SocketUtils.closeSocketServerSide(clientSocket, new AutoCloseable[0]);
    }

    public void runClient(Socket clientSocket, Map<String, String> hosts) {
        block2: {
            try {
                AgentWorker client = new AgentWorker(clientSocket, hosts);
                this.executor.execute(client);
            }
            catch (Exception e) {
                if (RTLogger.getCurrentLevel() < 4) break block2;
                RTLogger.print(5, "error staring AgentWorker. " + e.getMessage());
            }
        }
    }

    @Override
    public void shutdown() {
        this.isRun = false;
        this.stopServerSocket(this.serverSocket);
        this.stopServerSocket(this.tlsServerSocket);
        try {
            this.executor.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stopServerSocket(ServerSocket serverSocket) {
        try {
            if (serverSocket != null) {
                serverSocket.setSoTimeout(1);
                serverSocket.close();
                RTLogger.print(1, "server socket closed: " + serverSocket.getLocalPort());
            }
        }
        catch (Exception e) {
            RTLogger.print(1, "error closing server socket: " + serverSocket.getLocalPort(), e);
        }
    }

    @Override
    public void addValidHost(String hostName) {
        this.hosts.putIfAbsent(hostName, null);
    }

    public void removeHost(String hostName) {
        this.hosts.remove(hostName);
    }

    @Override
    public Map<String, String> getHosts() {
        return this.hosts;
    }
}

