/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.AgentOutage;
import com.blixx.agent.AgentOutageFinished;
import com.blixx.log.RTLogger;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class AgentOutageSendTask {
    public static final String CMD_STOPOUTAGE = "STOPOUTAGE";
    public static final String CMD_STARTOUTAGE = "STARTOUTAGE";
    protected Queue<AgentOutage> m_toSendStartOutage = new ConcurrentLinkedQueue<AgentOutage>();
    protected Queue<AgentOutageFinished> m_toSendFinishOutage = new ConcurrentLinkedQueue<AgentOutageFinished>();

    public void markToSend(AgentOutage p) {
        if (p instanceof AgentOutageFinished) {
            this.m_toSendFinishOutage.add((AgentOutageFinished)p);
        } else {
            this.m_toSendStartOutage.add(p);
        }
    }

    public boolean needToSend() {
        return this.needToSendFinishOutages() || this.needToSendStartOutages();
    }

    public boolean needToSendStartOutages() {
        return this.m_toSendStartOutage.size() > 0;
    }

    public boolean needToSendFinishOutages() {
        return this.m_toSendFinishOutage.size() > 0;
    }

    public void send(SDataOutputStream out, SDataInputStream in) throws IOException {
        if (this.needToSendStartOutages()) {
            this.sendStartOutages(out, in);
        }
        if (this.needToSendFinishOutages()) {
            this.sendFinishOutages(out, in);
        }
    }

    public void sendFinishOutages(SDataOutputStream out, SDataInputStream in) throws IOException {
        out.write(79);
        AgentOutageFinished[] tosend = this.m_toSendFinishOutage.toArray(new AgentOutageFinished[0]);
        int countFinished = this.sendArray(CMD_STOPOUTAGE, out, tosend);
        String res = in.readUTF();
        if (res.equalsIgnoreCase("T") || res.equalsIgnoreCase("N")) {
            if (res.equalsIgnoreCase("N")) {
                RTLogger.print(2, "Server does not support outages");
            }
            for (int i = 0; i < countFinished; ++i) {
                this.m_toSendFinishOutage.poll();
            }
        }
    }

    public void sendStartOutages(SDataOutputStream out, SDataInputStream in) throws IOException {
        out.write(79);
        AgentOutage[] tosend = this.m_toSendStartOutage.toArray(new AgentOutage[0]);
        int countNew = this.sendArray(CMD_STARTOUTAGE, out, tosend);
        String res = in.readUTF();
        if (res.equalsIgnoreCase("T") || res.equalsIgnoreCase("N")) {
            if (res.equalsIgnoreCase("N")) {
                RTLogger.print(2, "Server does not support outages");
            }
            for (int i = 0; i < countNew; ++i) {
                this.m_toSendStartOutage.poll();
            }
        }
    }

    private int sendArray(String command, SDataOutputStream out, AgentOutage[] tosend) throws IOException {
        int count = 0;
        out.writeUTF(command);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SDataOutputStream outTemp = new SDataOutputStream(bos, AgentEngine.getInstance().getProtocolVersion());
        for (int i = 0; i < tosend.length; ++i) {
            outTemp.writeBoolean(true);
            AgentOutage ao = tosend[i];
            outTemp.writeUTF(ao.id);
            outTemp.writeLong(ao.duration);
            outTemp.writeLong(ao.interval);
            outTemp.writeInt(ao.action);
            outTemp.writeInt(ao.postactiion);
            outTemp.writeUTF(ao.m_filters.toString());
            ++count;
        }
        outTemp.writeBoolean(false);
        out.writeInt(bos.size());
        bos.writeTo(out.getOutputStream());
        out.writeInt(-1);
        return count;
    }

    private int sendArray(String command, SDataOutputStream out, AgentOutageFinished[] tosend) throws IOException {
        int count = 0;
        out.writeUTF(command);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        SDataOutputStream outTemp = new SDataOutputStream(bos, AgentEngine.getInstance().getProtocolVersion());
        for (int i = 0; i < tosend.length; ++i) {
            outTemp.writeBoolean(true);
            AgentOutageFinished ao = tosend[i];
            outTemp.writeUTF(ao.id);
            ++count;
        }
        outTemp.writeBoolean(false);
        out.writeInt(bos.size());
        bos.writeTo(out.getOutputStream());
        out.writeInt(-1);
        return count;
    }

    public List<AgentOutage> getAgentOutages() {
        return new ArrayList<AgentOutage>(Arrays.asList(this.m_toSendStartOutage.toArray(new AgentOutage[0])));
    }

    public List<AgentOutageFinished> getAgentOutagesFinished() {
        return new ArrayList<AgentOutageFinished>(Arrays.asList(this.m_toSendFinishOutage.toArray(new AgentOutageFinished[0])));
    }

    public void remove(List<?> objects) {
        this.m_toSendStartOutage.removeAll(objects);
        this.m_toSendFinishOutage.removeAll(objects);
    }
}

