/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.log.RTLogger;
import com.blixx.shared.ServerInfo;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class AgentServersInfo {
    private ServerInfo mainServer;
    private ServerInfo backupMasterServer;
    private ServerInfo slaveServer;
    private ServerInfo current = null;
    private int maxRetryCount = 5;
    private AtomicBoolean isCurrentServerConnected = new AtomicBoolean(false);
    private AtomicInteger failedConnectionAttempts = new AtomicInteger(0);

    public AgentServersInfo(ServerInfo mainServer, int maxRetryCount) {
        this.current = this.mainServer = mainServer;
        this.maxRetryCount = maxRetryCount;
    }

    public ServerInfo getMainServer() {
        return this.mainServer;
    }

    public void setMainServer(ServerInfo mainServer) {
        this.mainServer = mainServer;
    }

    public ServerInfo getBackupMasterServer() {
        return this.backupMasterServer;
    }

    public void setBackupMasterServer(ServerInfo backupMasterServer) {
        this.backupMasterServer = backupMasterServer;
    }

    public ServerInfo getSlaveServer() {
        return this.slaveServer;
    }

    public void setSlaveServer(ServerInfo slaveServer) {
        this.slaveServer = slaveServer;
        if (slaveServer != null) {
            this.current = this.slaveServer;
            this.failedConnectionAttempts.set(0);
            RTLogger.print(1, "switched to Slave server " + this.current.getHost() + ":" + this.current.getPort());
        }
    }

    public boolean isCurrentServerOK() {
        return this.isCurrentServerConnected.get();
    }

    public void updateCurrentServerStatus(boolean connected) {
        if (this.isCurrentServerConnected.compareAndSet(!connected, connected)) {
            RTLogger.getStaticLogger().info("Server connected={} {}", (Object)connected, (Object)this.current);
        }
        if (connected) {
            this.failedConnectionAttempts.set(0);
        } else {
            this.failedConnectionAttempts.incrementAndGet();
            if (this.failedConnectionAttempts.get() % 60 == 0) {
                System.out.println(this.current + " count = " + this.failedConnectionAttempts.get());
            }
            if (this.failedConnectionAttempts.get() > this.maxRetryCount && this.fallbackSwitchServer() && AgentEngine.getInstance().getNettyEndpoint() != null) {
                AgentEngine.getInstance().getNettyEndpoint().startNettyClient(this.getCurrentServer());
            }
        }
    }

    public ServerInfo getCurrentServer() {
        return this.current;
    }

    public boolean fallbackSwitchServer() {
        boolean switched = false;
        if (this.current == this.mainServer && this.backupMasterServer != null) {
            this.failedConnectionAttempts.set(0);
            this.current = this.backupMasterServer;
            switched = true;
            RTLogger.print(1, "switched to Backup server " + this.current.getHost() + ":" + this.current.getPort());
        } else if (this.current != this.mainServer) {
            this.failedConnectionAttempts.set(0);
            this.current = this.mainServer;
            switched = true;
            RTLogger.print(1, "switched to Main server " + this.current.getHost() + ":" + this.current.getPort());
        } else {
            this.failedConnectionAttempts.set(0);
            RTLogger.print(1, "reset fail count on server " + this.current.getHost() + ":" + this.current.getPort());
        }
        return switched;
    }
}

