/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentActionExecutor;
import com.blixx.agent.AgentEngine;
import com.blixx.agent.AgentOutage;
import com.blixx.agent.AgentOutageFinished;
import com.blixx.agent.DDF;
import com.blixx.agent.DeploymentHelper;
import com.blixx.agent.Env;
import com.blixx.agent.HB;
import com.blixx.agent.Message;
import com.blixx.agent.MonParser;
import com.blixx.agent.MonitorValue;
import com.blixx.agent.MsgBuffer;
import com.blixx.agent.MsgParser;
import com.blixx.agent.PolicyRepository;
import com.blixx.agent.SClient;
import com.blixx.agent.SendBuffer;
import com.blixx.agent.SendBufferFA;
import com.blixx.agent.SendPerfBuffer;
import com.blixx.agent.SendPerfToServer;
import com.blixx.log.RTLogger;
import com.blixx.sa.perf.DDFTable;
import com.blixx.sa.perf.PerfClassParser;
import com.blixx.shared.BM;
import com.blixx.shared.Interval;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.PatternB;
import com.blixx.shared.Policy;
import com.blixx.shared.ext.ForwardFilter;
import com.blixx.shared.ext.ServerPolicyTemplate;
import com.blixx.shared.io.Pipe;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.blixx.shared.os.SystemUtils;
import com.blixx.shared.utils.FileSyncUtils;
import com.blixx.shared.utils.StrUtils;
import com.boom.SocketUtils;
import com.boom.netty.service.cmds.AgentActionResponse;
import com.boom.netty.service.events.PerfAgt;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;

public class AgentWorker
implements Runnable {
    private static final IOException IO_EXCEPTION_SERVER_BUSY = new IOException("ServerBusy");
    public static final String DISABLED = "D";
    private static final String IACTION = "IAction";
    private static final int MAX_MESSAGE = 10240;
    private Socket socket = null;
    AgentEngine ae = AgentEngine.getInstance();
    private final Map<String, String> hosts;
    private DeploymentHelper deploymentHelper = this.ae.getDeploymentHelper();

    public AgentWorker(Socket socket, Map<String, String> hosts) {
        this.hosts = hosts;
        this.socket = socket;
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(20000);
                this.socket.setTcpNoDelay(true);
                this.socket.setSoLinger(true, 1);
                this.socket.setReuseAddress(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SDataOutputStream out = null;
        SDataInputStream in = null;
        try {
            out = new SDataOutputStream(this.socket.getOutputStream(), this.ae.getProtocolVersion());
            in = new SDataInputStream(this.socket.getInputStream());
            this.processIncomingData(out, in);
        }
        catch (Exception tr) {
            try {
                RTLogger.print(3, "Client aborted. Can't get IO streams", tr);
            }
            catch (Throwable throwable) {
                SocketUtils.closeSocketServerSide(this.socket, out, in);
                throw throwable;
            }
            SocketUtils.closeSocketServerSide(this.socket, out, in);
        }
        SocketUtils.closeSocketServerSide(this.socket, out, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char processIncomingData(SDataOutputStream out, SDataInputStream in) throws IOException {
        int ch = 125;
        int read = -1;
        try {
            try {
                for (int i = 0; i < 100 && (read = in.read()) == -1; ++i) {
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ch = (char)read;
            }
            catch (SocketTimeoutException i) {
                // empty catch block
            }
            block8 : switch (ch) {
                case 123: {
                    while (ch != 125) {
                        ch = this.processIncomingData(out, in);
                    }
                    break;
                }
                case 125: {
                    break;
                }
                case 65: {
                    this.processAction(out, in);
                    break;
                }
                case 97: {
                    this.processActionInteractive(out, in);
                    break;
                }
                case 77: {
                    this.processGetValue(out, in);
                    break;
                }
                case 67: {
                    this.processCommand(out, in);
                    break;
                }
                case 69: {
                    this.processMessage(out, in);
                    break;
                }
                case 80: {
                    this.getAssignedPolicies(out, in);
                    break;
                }
                case 82: {
                    this.processPerfLog(out, in);
                    break;
                }
                case 79: {
                    this.processPerfComp(out, in);
                    break;
                }
                case 66: {
                    if (!this.ae.getAgentProperties().getNoDeployAllowed()) {
                        long start = System.currentTimeMillis();
                        while (!this.deploymentHelper.startDeployment()) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (Exception exception) {}
                        }
                        long deltaWait = System.currentTimeMillis() - start;
                        try {
                            if (deltaWait > 100L) {
                                RTLogger.print(5, "- wait time deployment processing (ms):" + deltaWait);
                            }
                            this.beforeProcessBinary(out, in);
                            break;
                        }
                        finally {
                            this.deploymentHelper.finishDeployment();
                        }
                    }
                    this.ae.sendInternalMessageDupl("Deployment/Undeployment rejected due to agent configuration", 2, "BOOM_AGENT", "");
                    break;
                }
                case 49: {
                    this.logIPs();
                    this.beforeProcessPing(out, in);
                    break;
                }
                case 78: {
                    this.processNewMonitorValue(out, in);
                    break;
                }
                case 90: {
                    this.flashEngines(out);
                    break;
                }
                case 85: {
                    if (!this.ae.getAgentProperties().getNoDeployAllowed()) {
                        long start = System.currentTimeMillis();
                        while (!this.deploymentHelper.startDeployment()) {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (Throwable deltaWait) {}
                        }
                        long deltaWait = System.currentTimeMillis() - start;
                        try {
                            if (deltaWait > 100L) {
                                RTLogger.print(5, "- wait time undeployment processing (ms):" + deltaWait);
                            }
                            this.processUnDeploy(out, in);
                            break;
                        }
                        finally {
                            this.deploymentHelper.finishDeployment();
                        }
                    }
                    this.ae.sendInternalMessageDupl("Deployment/Undeployment rejected due to agent configuration", 2, "BOOM_AGENT", "");
                    break;
                }
                case 71: {
                    this.processSubmitOutage(out, in);
                    break;
                }
                case 103: {
                    break;
                }
                case 89: {
                    this.processRestart(out, in);
                    break;
                }
                case 86: {
                    this.processVariables(out, in);
                    break;
                }
                case 68: {
                    String command = this.readSocket(in, 100L);
                    command = command.replaceAll("\r*\n", "");
                    String[] array = new StrUtils().processQuoted(command);
                    AgentActionResponse resp = new AgentActionExecutor().processAgentActions(null, null, array, 30);
                    StringBuilder sb = new StringBuilder();
                    sb.append(resp.getResultCode() == 0 ? (char)'T' : 'F');
                    sb.append(resp.getOutput() == null ? "" : resp.getOutput());
                    if (RTLogger.getCurrentLevel() >= 4) {
                        RTLogger.print(4, ">> " + sb.toString());
                    }
                    String resultStr = sb.toString();
                    out.write(resultStr.getBytes());
                    out.flush();
                    break;
                }
                case 55: {
                    HB.pendingRequest(out);
                    break;
                }
                case 56: {
                    if (RTLogger.getCurrentLevel() >= 5) {
                        try {
                            if (this.socket != null) {
                                this.logIPs();
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    HB.getSlaveServerInfo(out, in);
                    ch = 125;
                    break;
                }
                case 76: {
                    this.socket.setSoTimeout(600000);
                    out.write(84);
                    char updateType = (char)in.read();
                    switch (updateType) {
                        case 'O': {
                            boolean nsfo;
                            out.write(84);
                            boolean nsso = this.ae.getAgentOutageRepository().needToSendStartOutages();
                            if (nsso) {
                                out.writeBoolean(true);
                                this.ae.getAgentOutageRepository().sendStartOutages(out, in);
                            }
                            if (nsfo = this.ae.getAgentOutageRepository().needToSendFinishOutages()) {
                                out.writeBoolean(true);
                                this.ae.getAgentOutageRepository().sendFinishOutages(out, in);
                            }
                            out.writeBoolean(false);
                            break block8;
                        }
                    }
                    out.write(70);
                    break;
                }
                case 74: {
                    out.write(70);
                    break;
                }
                default: {
                    RTLogger.print(5, "char " + (char)ch + " int " + read);
                    ch = 125;
                }
            }
        }
        catch (RuntimeException e) {
            ch = 125;
            RTLogger.print(2, "Client was aborted due to socket exception.", e);
        }
        return (char)ch;
    }

    private void logIPs() {
        if (RTLogger.getCurrentLevel() >= 5) {
            try {
                RTLogger.print(5, "  AW working with local ip: " + this.socket.getLocalAddress().getHostAddress() + " remote ip: " + this.socket.getInetAddress().getHostAddress());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void processSubmitOutage(SDataOutputStream out, SDataInputStream in) throws IOException {
        String ID = null;
        boolean isEnable = true;
        long duration = -1L;
        long interval = Long.MAX_VALUE;
        int action = -1;
        int postaction = 0;
        StrUtils su = new StrUtils();
        LinkedList<String> filters = new LinkedList<String>();
        try {
            String submitted = this.read(in);
            submitted = submitted.replaceAll("\r*\n", "");
            String[] params = su.processQuoted(submitted);
            for (int i = 0; i < params.length; ++i) {
                String p = params[i];
                if ((p = su.removeQuotesStrict(p)).startsWith("-")) {
                    String actionLabel;
                    String actionS;
                    Interval itvl;
                    if ("-e".equals(p)) {
                        isEnable = true;
                        continue;
                    }
                    if ("-d".equals(p)) {
                        isEnable = false;
                        continue;
                    }
                    if ("-id".equals(p)) {
                        ID = su.removeQuotesStrict(params[++i]);
                        try {
                            UUID.fromString(ID);
                            continue;
                        }
                        catch (Throwable e) {
                            ID = "ERROR: invalid id: " + ID;
                            break;
                        }
                    }
                    if ("-ed".equals(p)) {
                        String ivlStr;
                        if ((duration = (itvl = Interval.parseInterval(su.removeQuotesStrict(ivlStr = params[++i]), -1)).getIntervalMilliseconds()) >= 60000L) continue;
                        ID = "ERROR: Invalid expected duration: " + ivlStr;
                        break;
                    }
                    if ("-du".equals(p)) {
                        String durStr;
                        if ((interval = (itvl = Interval.parseInterval(su.removeQuotesStrict(durStr = params[++i]), -1)).getIntervalMilliseconds()) >= 60000L) continue;
                        ID = "ERROR: Invalid duration: " + durStr;
                        break;
                    }
                    if ("-ac".equals(p)) {
                        actionS = su.removeQuotesStrict(params[++i]);
                        try {
                            action = Integer.parseInt(actionS);
                            actionLabel = ServerPolicyTemplate.getActionLabel(action);
                            if (!"UNKNOWN".equals(actionLabel)) continue;
                            ID = "ERROR: Unknown action: " + actionS;
                        }
                        catch (NumberFormatException e) {
                            action = ServerPolicyTemplate.getAction(actionS);
                            if (action != -1) continue;
                            ID = "ERROR: Unknown action: " + actionS;
                        }
                        break;
                    }
                    if (!"-pa".equals(p)) continue;
                    actionS = su.removeQuotesStrict(params[++i]);
                    try {
                        postaction = Integer.parseInt(actionS);
                        actionLabel = ServerPolicyTemplate.getActionLabel(postaction);
                        if (!"UNKNOWN".equals(actionLabel)) continue;
                        ID = "ERROR: Unknown action: " + actionS;
                    }
                    catch (NumberFormatException e) {
                        postaction = ServerPolicyTemplate.getAction(actionS);
                        if (postaction != -1) continue;
                        ID = "ERROR: Unknown action: " + actionS;
                    }
                    break;
                }
                if (p.indexOf(61) == -1) continue;
                try {
                    int eqp = p.indexOf(61);
                    String attribute = p.substring(0, eqp);
                    String pattern = p.substring(eqp + 1);
                    try {
                        PatternB.getPattern(pattern);
                    }
                    catch (Throwable e) {
                        ID = "ERROR: Invalid pattern: " + pattern;
                        break;
                    }
                    pattern = su.removeQuotesStrict(pattern);
                    Properties prop = new Properties();
                    prop.setProperty("NAME", "");
                    prop.setProperty("DESCRIPTION", "");
                    prop.setProperty("FILTER_NUMBER", "" + filters.size() + 1);
                    prop.setProperty("ATTRIBUTE", attribute);
                    prop.setProperty("PATTERN", pattern);
                    ForwardFilter ff = ForwardFilter.getInstance(prop);
                    filters.add(p);
                    continue;
                }
                catch (Throwable e) {
                    ID = "ERROR: Invalid filter: " + p;
                    break;
                }
            }
            if (ID == null) {
                ID = isEnable ? UUID.randomUUID().toString() : "ERROR: ID is required.";
            }
            if (!ID.startsWith("ERROR:") && isEnable) {
                if (filters == null || filters.size() == 0) {
                    ID = "ERROR: At least one filter is required.";
                } else if (action != 1 && action != 3) {
                    ID = "ERROR: valid ACTION is required (-ac [HIDE|DROP]).";
                } else if (action == 1) {
                    switch (postaction) {
                        case 0: {
                            break;
                        }
                        default: {
                            ID = "ERROR: for specified ACTION=DROP, the POSTACTION must be 'NONE'.";
                            break;
                        }
                    }
                } else if (action == 3) {
                    switch (postaction) {
                        case 0: 
                        case 1: 
                        case 5: {
                            break;
                        }
                        default: {
                            ID = "ERROR: for specified ACTION=HIDE, the POSTACTION (-pa) must be one of the: 'NONE', 'DROP', 'PUBLISH'.";
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            ID = "ERROR: parsing arguments";
        }
        if (!ID.startsWith("ERROR:")) {
            AgentOutage ao;
            if (isEnable) {
                ao = new AgentOutage();
                ao.id = ID;
                ao.duration = duration;
                ao.interval = interval;
                ao.action = action;
                ao.postactiion = postaction;
                for (String filter : filters) {
                    ao.m_filters.append(filter).append('\n');
                }
                this.ae.getAgentOutageRepository().markToSend(ao);
            } else {
                ao = new AgentOutageFinished();
                ao.id = ID;
                this.ae.getAgentOutageRepository().markToSend(ao);
            }
        }
        out.write(ID.getBytes());
    }

    private void processVariables(SDataOutputStream out, SDataInputStream in) throws IOException {
        String submitted = this.read(in);
        StrUtils su = new StrUtils();
        String[] lines = submitted.split("\r*\n");
        boolean isError = false;
        for (int i = 0; i < lines.length; ++i) {
            if (this.processVariables(su.processQuoted(lines[i]))) continue;
            isError = true;
        }
        if (isError) {
            out.write(70);
        } else {
            out.write(84);
        }
    }

    private boolean processVariables(String[] lines) {
        boolean isOK = true;
        StrUtils su = new StrUtils();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            int ch = line.indexOf(61);
            if (ch != -1) {
                try {
                    String name = line.substring(0, ch);
                    name = su.removeQuotesStrict(name);
                    String value = line.substring(ch + 1);
                    value = su.removeQuotesStrict(value);
                    Env.getInstance().addVariable(name, value);
                }
                catch (Throwable e) {
                    isOK = false;
                }
                continue;
            }
            isOK = false;
        }
        return isOK;
    }

    private String read(SDataInputStream in) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while (bos.size() < 10240 && in.available() > 0) {
            byte[] arr = new byte[in.available()];
            int count = in.read(arr);
            if (count <= 0) continue;
            bos.write(arr, 0, count);
        }
        String submitted = bos.toString();
        return submitted;
    }

    private void processRestart(SDataOutputStream out, SDataInputStream in) throws IOException {
        out.write(84);
        SocketUtils.closeSocket(this.socket, out, in);
        this.ae.restart();
        if (SystemUtils.OS == 1) {
            RTLogger.print(1, "(1)Agent waits for kill signal.");
        }
    }

    private void flashEngines(SDataOutputStream out) throws IOException {
        this.ae.getCalcEngine().flashActiveStatuses();
        this.ae.getMsgCalcEngine().flashSuppression();
        out.write(84);
    }

    private void beforeProcessPing(SDataOutputStream out, SDataInputStream in) throws IOException {
        if (this.socket != null) {
            String serverIP = this.socket.getInetAddress().getHostAddress();
            String serverHost = this.socket.getInetAddress().getHostName();
            if (this.ae.getServers().getCurrentServer().getHost().equalsIgnoreCase(serverHost) || this.ae.getServers().getCurrentServer().getPublicIP().equalsIgnoreCase(serverIP) || this.ae.getServers().getCurrentServer().getHost().equalsIgnoreCase(serverIP) || this.ae.getServers().getCurrentServer().getPublicIP().equalsIgnoreCase(serverHost)) {
                this.ae.setLastTimeOnline();
                this.processPing(out, in);
            } else {
                List<String> clusterNodes = this.ae.getClusterNodes();
                if (clusterNodes.contains(serverHost) || clusterNodes.contains(serverIP) || this.ae.getAgentProperties().getOldMainServer() != null && this.ae.getAgentProperties().getOldMainServer().equalsIgnoreCase(serverHost)) {
                    if (this.ae.getAgentProperties().isOfferDataToAnyClusterNode() && this.ae.getTimeFromLastServerPing() > 3000L * (long)this.ae.getAgentProperties().getHbInterval()) {
                        this.processPing(out, in);
                    } else {
                        out.write(48);
                    }
                } else if (this.hosts.containsKey(serverHost) || this.hosts.containsKey(serverIP)) {
                    this.ae.setLastTimeOnline();
                    this.processPing(out, in);
                } else {
                    RTLogger.print(1, "Rejected unknown host: " + serverHost + " IP: " + serverIP);
                    out.write(33);
                }
            }
        } else {
            this.ae.setLastTimeOnline();
            this.processPing(out, in);
        }
    }

    private void beforeProcessBinary(SDataOutputStream out, SDataInputStream in) throws IOException {
        int size = in.readInt();
        boolean isStartReloadClasses = false;
        try {
            for (int i = 0; i < size; ++i) {
                RTLogger.print(3, "process binary " + i);
                isStartReloadClasses = this.processBinary(out, in) || isStartReloadClasses;
                out.writeInt(i);
            }
            out.write(84);
        }
        catch (Throwable e) {
            RTLogger.print(5, "Error process deployment", e);
            out.writeInt(-1);
            out.write(70);
        }
        if (isStartReloadClasses) {
            this.ae.loadJars();
            this.ae.getPolicyRepository().reRegisterJavaMonitors();
        }
    }

    private void processPerfComp(SDataOutputStream out, SDataInputStream in) throws IOException {
        String line = this.readSocket(in, 0L);
        line = line.replace("\r", "");
        RTLogger.print(5, "PERFCOMP " + line);
        try {
            String[] arr = new StrUtils().processQuoted(line);
            String filename = arr[0].trim();
            filename = new StrUtils().removeQuotesStrict(filename);
            PerfClassParser pcp = new PerfClassParser();
            DDFTable table = pcp.parseFile(filename);
            DDF ddf = this.ae.getDDF();
            ddf.addClass(table);
            out.write(84);
        }
        catch (Throwable e) {
            out.write(70);
            RTLogger.print(4, "PERFCOMP failed.", e);
        }
    }

    private void processPerfLog(SDataOutputStream out, SDataInputStream in) throws IOException {
        String allLines = this.readSocket(in, 100L);
        if (allLines == null) {
            RTLogger.print(2, "PERFLOG: nothing to process");
            out.write(70);
        } else {
            allLines = allLines.replace("\r", "");
            String[] arrL = allLines.split("\n");
            for (int i = 0; i < arrL.length; ++i) {
                String line = arrL[i];
                RTLogger.print(5, "PERFLOG: " + line);
                SendPerfToServer sts = new SendPerfToServer();
                ArrayList<PerfAgt> list = new ArrayList<PerfAgt>(1);
                String[] arr = new StrUtils().processQuoted(line);
                String className = new StrUtils().removeQuotesStrict(arr[1]);
                List<PerfAgt.PerfValue> fields = this.ae.getDDF().getFieldsAsPerfVal(className);
                if (fields == null) {
                    out.write(70);
                    RTLogger.print(2, "Submitted values for class=" + className + " droped. Class was not registered.");
                    continue;
                }
                int fsize = fields.size();
                if (fsize != arr.length - 2) {
                    out.write(70);
                    RTLogger.print(2, "Submitted values for class=" + className + " droped. Expected size=" + fsize + " does not match with submitted.");
                    continue;
                }
                try {
                    PerfAgt perfRecord = new PerfAgt(className, System.currentTimeMillis());
                    for (int j = 0; j < fields.size(); ++j) {
                        PerfAgt.PerfValue val = fields.get(j);
                        String incomingValue = new StrUtils().removeQuotesStrict(arr[j + 2]);
                        if ("DOUBLE".equals(val.getType())) {
                            try {
                                Double.parseDouble(incomingValue.replace(',', '.'));
                            }
                            catch (NumberFormatException e) {
                                throw new NumberFormatException("Incoming value " + incomingValue + " is not a double on the position: " + j + ". " + e.getMessage());
                            }
                        } else if ("BIGINT".equals(val.getType())) {
                            try {
                                Long.parseLong(incomingValue);
                            }
                            catch (NumberFormatException e) {
                                throw new NumberFormatException("Incoming value " + incomingValue + " is not a long on the position: " + j + ". " + e.getMessage());
                            }
                        } else if ("VARCHAR".equals(val.getType()) && incomingValue.length() > val.getLength()) {
                            incomingValue = incomingValue.substring(0, val.getLength());
                        }
                        val.setValue(incomingValue);
                        perfRecord.getRecordSet().put(val.getFieldName(), val);
                    }
                    list.add(perfRecord);
                    sts.enqueuePerfRecord(list);
                    out.write(84);
                    continue;
                }
                catch (Exception e) {
                    RTLogger.print(3, "Error submit perf values.", e);
                    out.write(70);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommand(SDataOutputStream out, SDataInputStream in) throws IOException {
        String command = in.readUTF();
        if (command.equals("DISABLE")) {
            this.ae.setDisabled(true);
            RTLogger.print(1, "Agent is disabled.");
        } else if (command.equals("ENABLE")) {
            this.ae.setDisabled(false);
            RTLogger.print(3, "Agent is enabled.");
        } else if (command.startsWith("SETID=")) {
            String id = command.substring(command.indexOf(61) + 1);
            this.ae.setID(id);
            RTLogger.print(1, "Server sent new ID: " + id);
        } else if (command.startsWith("GETFILE=")) {
            String file = command.substring(command.indexOf(61) + 1);
            File fcheck = new File(file);
            if (fcheck.exists() && fcheck.canRead()) {
                out.writeLong(fcheck.length());
                FileInputStream fis = new FileInputStream(fcheck);
                try {
                    out.writeFile(fis);
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            out.writeLong(-1L);
        } else if (command.startsWith("PUTFILE=")) {
            String file = command.substring(command.indexOf(61) + 1);
            int res = 0;
            try {
                if (!in.readFile(file)) {
                    res = -2;
                }
            }
            catch (Throwable e) {
                res = -1;
            }
            out.write(res);
        } else if (command.startsWith("GETHASH=")) {
            String file = command.substring(command.indexOf(61) + 1);
            File fcheck = new File(file);
            try {
                String report = FileSyncUtils.getDigest(fcheck);
                out.writeUTF(report);
            }
            catch (Throwable e) {
                out.writeUTF("" + e.getMessage());
            }
        }
        out.write(84);
    }

    private void processPing(SDataOutputStream out, SDataInputStream in) throws IOException {
        int mode = this.ae.getMode();
        if (mode >= 3) {
            // empty if block
        }
        if (this.ae.pendingUpdates()) {
            out.write(50);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.processGetValue(out, in);
            }
            catch (IOException e) {
                if (IO_EXCEPTION_SERVER_BUSY != e) {
                    throw e;
                }
                return;
            }
            this.processGetMessages(out, in);
            this.processGetFAs(out, in);
            this.processGetPerf(out, in);
        } else {
            out.write(48);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processGetValue(SDataOutputStream out, SDataInputStream in) throws IOException {
        block6: {
            block7: {
                String what = "";
                try {
                    what = in.readUTF();
                }
                catch (Throwable e1) {
                    throw IO_EXCEPTION_SERVER_BUSY;
                }
                if (!"*".equals(what)) break block7;
                SendBuffer buffer = null;
                int sent = 0;
                try {
                    SClient sc = new SClient(this.socket, in, out);
                    buffer = this.ae.getMonitorQueue();
                    sent = buffer.sendBlock(sc);
                    RTLogger.print(3, "MV forwarded: " + sent + " failed: " + (buffer == null ? "buffer=null" : Integer.valueOf(buffer.sizeC1())));
                }
                catch (Throwable throwable) {
                    RTLogger.print(3, "MV forwarded: " + sent + " failed: " + (buffer == null ? "buffer=null" : Integer.valueOf(buffer.sizeC1())));
                    break block6;
                    catch (Throwable throwable2) {
                        RTLogger.print(3, "MV forwarded: " + sent + " failed: " + (buffer == null ? "buffer=null" : Integer.valueOf(buffer.sizeC1())));
                        throw throwable2;
                    }
                }
                break block6;
            }
            throw new IOException("can't read from agent's input stream");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processGetMessages(SDataOutputStream out, SDataInputStream in) throws IOException {
        MsgBuffer buffer = null;
        int sent = 0;
        try {
            SClient sc = new SClient(this.socket, in, out);
            buffer = this.ae.getMessageQueue();
            sent = ((SendBuffer)buffer).sendBlock(sc);
            RTLogger.print(3, "MSG forwarded: " + sent + " failed: " + (buffer == null ? "buffer=null" : Integer.valueOf(buffer.sizeC1())));
        }
        catch (Throwable throwable) {
            RTLogger.print(3, "MSG forwarded: " + sent + " failed: " + (buffer == null ? "buffer=null" : Integer.valueOf(buffer.sizeC1())));
            catch (Throwable throwable2) {
                RTLogger.print(3, "MSG forwarded: " + sent + " failed: " + (buffer == null ? "buffer=null" : Integer.valueOf(buffer.sizeC1())));
                throw throwable2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processGetFAs(SDataOutputStream out, SDataInputStream in) throws IOException {
        SendBufferFA buffer = null;
        int sent = 0;
        try {
            SClient sc = new SClient(this.socket, in, out);
            buffer = this.ae.getFAQueue();
            sent = buffer.sendBlock(sc);
            RTLogger.print(3, "FA forwarded: " + sent + " failed: " + (buffer == null ? "buffer=null" : Integer.valueOf(buffer.sizeC1())));
        }
        catch (Throwable throwable) {
            RTLogger.print(3, "FA forwarded: " + sent + " failed: " + (buffer == null ? "buffer=null" : Integer.valueOf(buffer.sizeC1())));
            catch (Throwable throwable2) {
                RTLogger.print(3, "FA forwarded: " + sent + " failed: " + (buffer == null ? "buffer=null" : Integer.valueOf(buffer.sizeC1())));
                throw throwable2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void processGetPerf(SDataOutputStream out, SDataInputStream in) throws IOException {
        SendPerfBuffer perfbuffer = null;
        int sent = 0;
        try {
            SClient sc = new SClient(this.socket, in, out);
            perfbuffer = this.ae.getPerfQueue();
            sent = perfbuffer.sendBlock(sc);
            RTLogger.print(3, "Perf forwarded: " + sent + " failed: " + (perfbuffer == null ? "buffer=null" : Integer.valueOf(perfbuffer.sizeC1())));
        }
        catch (Throwable throwable) {
            RTLogger.print(3, "Perf forwarded: " + sent + " failed: " + (perfbuffer == null ? "buffer=null" : Integer.valueOf(perfbuffer.sizeC1())));
            catch (Throwable throwable2) {
                RTLogger.print(3, "Perf forwarded: " + sent + " failed: " + (perfbuffer == null ? "buffer=null" : Integer.valueOf(perfbuffer.sizeC1())));
                throw throwable2;
            }
        }
    }

    private void processMessage(SDataOutputStream out, SDataInputStream in) throws IOException {
        int available = in.available();
        if (available > 10240) {
            out.writeChar(70);
            RTLogger.print(1, "Message > 10240 ignored");
            return;
        }
        MsgParser mp = new MsgParser();
        String msg = this.readSocket(in, 5L);
        Message m = mp.parseMesssage(msg.trim());
        if (m != null) {
            out.write(84);
            if (RTLogger.getCurrentLevel() >= 6) {
                RTLogger.print(6, "Local msg received. {" + m + "}");
            }
            out.flush();
            if (!this.ae.getDisabled()) {
                this.ae.getMsgSubmitter().submit(m);
            }
        } else {
            out.write(70);
            RTLogger.print(3, "Local msg has wrong format. {" + msg + "}");
            out.flush();
        }
    }

    private void processNewMonitorValue(SDataOutputStream out, SDataInputStream in) throws IOException {
        int available = in.available();
        if (available > 10240) {
            out.write(70);
            RTLogger.print(1, "MV. incoming data is too long");
            return;
        }
        String lines = this.read(in);
        lines = lines.replace("\r", "");
        String[] split = lines.split("\n");
        for (int i = 0; i < split.length; ++i) {
            MonParser mp = new MonParser();
            MonitorValue mv = mp.parse(split[i]);
            if (mv != null) {
                out.write(84);
                out.flush();
                if (this.ae.getDisabled()) continue;
                this.ae.getSubmitter().submit(mv);
                continue;
            }
            out.write(70);
            RTLogger.print(3, "mon value has wrong format. {" + split[i] + "}");
            out.flush();
        }
    }

    private void processAction(SDataOutputStream out, SDataInputStream in) throws IOException {
        try {
            String command = in.readUTF();
            int secondsToWait = in.readInt();
            String firstCmd = "";
            String[] commandArr = new StrUtils().processQuoted(command);
            firstCmd = new StrUtils().removeQuotesStrict(commandArr[0]);
            if (this.socket != null) {
                int timeout = secondsToWait * 1000 + 10000;
                this.socket.setSoTimeout(timeout);
                this.socket.setTcpNoDelay(true);
                this.socket.setSoLinger(true, 1);
            }
            if (firstCmd.equals("BOOM_AGENT")) {
                new AgentActionExecutor().processAgentActions(out, commandArr, secondsToWait);
            } else if (firstCmd.equalsIgnoreCase(IACTION)) {
                new AgentActionExecutor().processJavaAction(out, commandArr, secondsToWait);
            } else {
                new AgentActionExecutor().processExecAction(out, command, secondsToWait);
            }
        }
        catch (OutOfMemoryError e) {
            out.writeInt(5);
            out.writeUTF("" + e.getMessage());
        }
        catch (Throwable tr) {
            RTLogger.print(3, "Action failed. ", tr);
            out.writeInt(5);
            out.writeUTF("Action failed. " + tr.getMessage());
        }
    }

    private void processActionInteractive(SDataOutputStream out, SDataInputStream in) throws IOException {
        ProcessBuilder pb;
        this.socket.setSoTimeout(300000);
        boolean skipCR = false;
        Process shell = null;
        if (SystemUtils.OS != 1) {
            skipCR = true;
            pb = new ProcessBuilder("sh", "-i");
            pb.redirectErrorStream(true);
            shell = pb.start();
        } else {
            pb = new ProcessBuilder("cmd.exe", "/k");
            pb.redirectErrorStream(true);
            shell = pb.start();
        }
        try {
            Pipe processIS = new Pipe(false, "<", shell.getInputStream(), out.getOutputStream(), false);
            Thread tr = new Thread(processIS);
            tr.setName("PipeA_ExSO2A");
            tr.start();
            Pipe cmdPipe = new Pipe(skipCR, ">", in.getInputStream(), shell.getOutputStream(), false);
            Thread cmdT = new Thread(cmdPipe);
            cmdT.setName("PipeA_A2Ex");
            cmdT.start();
            tr.join();
        }
        catch (Throwable e) {
            RTLogger.print(4, "error in interactive shell ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processBinary(SDataOutputStream out, SDataInputStream in) throws Throwable {
        boolean isClassLoaderMustBeUpdated;
        block15: {
            String filename;
            String what;
            block19: {
                block14: {
                    block18: {
                        block17: {
                            block16: {
                                isClassLoaderMustBeUpdated = false;
                                what = in.readUTF();
                                filename = in.readUTF();
                                if (!what.equals("JAR")) break block16;
                                String full_path = this.ae.DIR_SPI + File.separator + "jars" + File.separator + filename;
                                in.readFile(full_path);
                                isClassLoaderMustBeUpdated = true;
                                break block15;
                            }
                            if (!what.equalsIgnoreCase("UPKG")) break block17;
                            this.processUNDeployBinaries(in, filename);
                            break block15;
                        }
                        if (!what.equalsIgnoreCase("pkg")) break block18;
                        boolean bl = isClassLoaderMustBeUpdated = isClassLoaderMustBeUpdated || this.processDeployBinaries(in, filename);
                        if (isClassLoaderMustBeUpdated) {
                            RTLogger.print(3, "Jar file found in package");
                        }
                        break block15;
                    }
                    if (!what.equals("BOOM_AGENT") && !what.equals("AGENT")) break block19;
                    String file_path = "./" + BM.PRODUCT_lowercase + "_agent.jar.tmp";
                    try {
                        in.readFile(file_path);
                        out.writeInt(0);
                        out.write(84);
                        try {
                            this.socket.setSoTimeout(5000);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.ae.restart();
                        if (SystemUtils.OS != 1) break block14;
                        RTLogger.print(1, "(3)Agent exit.");
                        System.exit(0);
                    }
                    catch (Throwable e1) {
                        try {
                            try {
                                File f = new File(file_path);
                                f.delete();
                                RTLogger.print(2, "Ignored upgrade Agent. The jar file was not transferred correctly.");
                                this.ae.sendInternalMessageDupl("Ignored upgrade Agent. The jar file was not transferred correctly.", 2, "RESTART", "AGENT");
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                out.writeInt(0);
                                out.write(70);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        catch (Throwable throwable) {
                            SocketUtils.closeSocketServerSide(this.socket, out, in);
                            throw throwable;
                        }
                        SocketUtils.closeSocketServerSide(this.socket, out, in);
                        break block15;
                    }
                }
                SocketUtils.closeSocketServerSide(this.socket, out, in);
                break block15;
            }
            if (what.equals("POLICY")) {
                String full_path = this.ae.DIR_POLICIES + File.separator + filename;
                try {
                    in.readFile(full_path);
                    File f = new File(full_path);
                    this.ae.getPolicyRepository().updatePolicy(f);
                }
                catch (Throwable e) {
                    this.ae.sendInternalMessageDupl("Deployment of policy " + filename + " failed. " + e.getMessage(), 4, "DEPLOY", filename);
                    throw e;
                }
            }
        }
        return isClassLoaderMustBeUpdated;
    }

    private boolean processDeployBinaries(SDataInputStream in, String filename) throws Throwable {
        boolean isClassLoaderMustBeUpdated = false;
        String full_path = this.ae.DIR_SPI + File.separator + filename;
        RTLogger.print(1, "Processing incoming binary package: " + full_path);
        File f = new File(full_path);
        String pkgName = filename.substring(0, filename.lastIndexOf(95));
        try {
            in.readFile(full_path);
            isClassLoaderMustBeUpdated = this.deploymentHelper.deployBinaries(f, pkgName);
        }
        catch (Throwable e) {
            this.ae.sendInternalMessageDupl("Deployment of package " + pkgName + " failed. " + e.getMessage(), 4, "DEPLOY", pkgName);
            if (!f.delete()) {
                f.delete();
            }
            throw e;
        }
        return isClassLoaderMustBeUpdated;
    }

    private void processUNDeployBinaries(SDataInputStream in, String filename) throws Throwable {
        String full_path = this.ae.DIR_SPI + File.separator + filename;
        File f = new File(full_path);
        String pkgName = filename.substring(0, filename.lastIndexOf(95));
        try {
            in.readFile(full_path);
            this.deploymentHelper.undeployBinary(f, pkgName);
        }
        catch (Throwable e) {
            this.ae.sendInternalMessageDupl("Undeployment of package " + pkgName + " failed." + e.getMessage(), 4, "UNDEPLOY", pkgName);
            throw e;
        }
        finally {
            if (!f.delete()) {
                f.delete();
            }
        }
    }

    private void getAssignedPolicies(SDataOutputStream out, SDataInputStream in) throws IOException {
        PolicyRepository policyRepository = this.ae.getPolicyRepository();
        Set<String> mons = policyRepository.getAssignedMonitors();
        ArrayList<String> al = new ArrayList<String>(mons);
        out.writeUTF("mon");
        out.writeInt(al.size());
        for (int i = 0; i < al.size(); ++i) {
            String nameM = al.get(i);
            out.writeUTF(nameM);
            Policy p = policyRepository.getPolicy(nameM);
            out.writeUTF(p.getVersion());
        }
        Set<String> msgs = policyRepository.getAssignedMessages();
        al = new ArrayList<String>(msgs);
        out.writeUTF("msg");
        out.writeInt(al.size());
        for (int i = 0; i < al.size(); ++i) {
            String nameM = al.get(i);
            out.writeUTF(nameM);
            MsgPolicy mp = policyRepository.getMsgPolicy(nameM);
            out.writeUTF(mp.getVersion());
        }
    }

    private void processUnDeploy(SDataOutputStream out, SDataInputStream in) throws IOException {
        String name;
        int i;
        PolicyRepository policyRepository = this.ae.getPolicyRepository();
        String type = in.readUTF();
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            name = in.readUTF();
            policyRepository.removePolicy(name);
        }
        type = in.readUTF();
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            name = in.readUTF();
            policyRepository.removeMsgPolicy(name);
        }
        out.write(84);
    }

    private String readSocket(SDataInputStream in, long sleep) throws IOException {
        int available = in.available();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(available);
        byte[] aa = new byte[2048];
        while (available > 0) {
            int count = in.read(aa);
            bos.write(aa, 0, count);
            if (sleep > 0L) {
                try {
                    Thread.sleep(sleep);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            available = in.available();
        }
        String r = bos.toString();
        return r;
    }

    public class ActionSDataOutStream
    extends SDataOutputStream {
        public int m_result_code = 0;
        public String m_resultString = null;

        @Override
        public void close() throws IOException {
        }

        @Override
        public void writeInt(int i) throws IOException {
            this.m_result_code = i;
        }

        @Override
        public void writeUTF(String msg) throws IOException {
            this.m_resultString = msg;
        }
    }
}

