/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.AgentHealth;
import com.blixx.agent.CalcStatus;
import com.blixx.agent.Env;
import com.blixx.agent.MessageStormFilter;
import com.blixx.agent.MonitorValue;
import com.blixx.agent.PerfDataCollection;
import com.blixx.agent.PolicyRepository;
import com.blixx.agent.da.DaConfig;
import com.blixx.agent.da.DeviationAnalyzer;
import com.blixx.agent.da.IDeviationAnalyzer;
import com.blixx.agent.utils.IMonitorSubmitListener;
import com.blixx.agent.utils.SupportedVariables;
import com.blixx.log.RTLogger;
import com.blixx.sa.FA;
import com.blixx.sa.Opts;
import com.blixx.shared.AbstractCondition;
import com.blixx.shared.Condition;
import com.blixx.shared.MonitorSerie;
import com.blixx.shared.PatternB;
import com.blixx.shared.PatternMatchResult;
import com.blixx.shared.PatternMatcherThread;
import com.blixx.shared.Policy;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class CalcEngine {
    private static final String dummy = "dummy";
    private final Map<String, CalcStatus> m_activeStatus = new ConcurrentHashMap<String, CalcStatus>(10, 0.9f, 3);
    protected Map<String, MonitorSerie> monitorSeries = new ConcurrentHashMap<String, MonitorSerie>(10, 0.9f, 3);
    private final Map<String, MonitorValue> lastSentValues = new ConcurrentHashMap<String, MonitorValue>(10, 0.9f, 3);
    private final Map<String, Integer> m_counters = new ConcurrentHashMap<String, Integer>(10, 0.9f, 3);
    private final PolicyRepository m_policies;
    private final SupportedVariables m_variables = new SupportedVariables();
    private final PerfDataCollection m_PDC;
    private IDeviationAnalyzer m_deviationAnalyzer = null;
    private final List<IMonitorSubmitListener> m_listeners = new LinkedList<IMonitorSubmitListener>();

    public CalcEngine(PolicyRepository pr) {
        this.m_policies = pr;
        try {
            this.m_deviationAnalyzer = new DeviationAnalyzer();
            Properties config = new Properties();
            config.setProperty("DA_WDIR", AgentEngine.getInstance().DIR_MAIN + File.separator + "da");
            this.m_deviationAnalyzer.setConfig(config);
            this.m_deviationAnalyzer.init();
        }
        catch (Throwable e) {
            RTLogger.print(1, "DeviationAnalyzer init failed", e);
        }
        this.m_PDC = new PerfDataCollection(AgentEngine.getInstance().getAgentHostname());
    }

    public void addMonitorSubmitListener(IMonitorSubmitListener msl) {
        if (!this.m_listeners.contains(msl)) {
            this.m_listeners.add(msl);
        }
    }

    public void removeMonitorListener(IMonitorSubmitListener msl) {
        this.m_listeners.remove(msl);
    }

    public void flashActiveStatuses() {
        this.m_activeStatus.clear();
        this.lastSentValues.clear();
        this.m_counters.clear();
    }

    public void flashActiveStatus(String monitor) {
        String prefix = monitor + "@@";
        for (String monValueKey : this.m_activeStatus.keySet()) {
            if (!monValueKey.startsWith(prefix)) continue;
            RTLogger.print(5, "flash status for " + monValueKey);
            this.m_activeStatus.remove(monValueKey);
            this.lastSentValues.remove(monValueKey);
            this.m_counters.remove(monValueKey);
        }
    }

    public void clearMonitorSeries() {
        this.monitorSeries.clear();
    }

    public void setMaxMonitorSeriesSize(int maxSize) {
        for (MonitorSerie ms : this.monitorSeries.values()) {
            ms.setMaxSize(maxSize);
        }
    }

    public void dropOldMonitorSeries(long oldestTimeInMillis) {
        this.monitorSeries.entrySet().removeIf(en -> en.getValue() != null && ((MonitorSerie)en.getValue()).getLatestValue().getTime() < oldestTimeInMillis);
    }

    public void addPolicy(Policy p) {
        this.m_policies.addPolicy(p);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isUpdate(MonitorValue mv) {
        boolean isUpdate = false;
        for (IMonitorSubmitListener iMonitorSubmitListener : this.m_listeners) {
            iMonitorSubmitListener.submitMonitorValue(mv);
        }
        Policy p = this.m_policies.getPolicy(mv.p2_policyName);
        if (p == null) {
            if (RTLogger.getCurrentLevel() < 3) return false;
            RTLogger.print(3, "Monitor " + mv.p2_policyName + " rejected (Policy not found).");
            return false;
        }
        if (p.isPerfActive()) {
            for (PatternB perfPB : p.getClassMap().keySet()) {
                PatternMatchResult matchesR = PatternMatcherThread.match(perfPB, mv.p3_object);
                if (matchesR == null || !matchesR.isMatch()) continue;
                StringBuilder sb = new StringBuilder();
                if (matchesR.getVariableMap() != null) {
                    Map<String, String> vars = matchesR.getVariableMap();
                    AbstractCondition.lookup(vars, Env.getInstance());
                    Iterator<Map.Entry<String, String>> it2 = vars.entrySet().iterator();
                    while (it2.hasNext()) {
                        Map.Entry<String, String> en = it2.next();
                        String val = en.getValue();
                        sb.append(val);
                        if (!it2.hasNext()) continue;
                        sb.append('_');
                    }
                }
                this.m_PDC.addValue(p.getClassMap().get(perfPB), sb.toString(), mv.getNode(), mv.p0_value);
                break;
            }
        }
        if (!p.isEnabledCheckRuntime(Env.getInstance()) || p.isDeactivationTime(mv.p1_time)) {
            RTLogger.print(3, "Monitor " + mv.p2_policyName + " rejected (Policy disabled).");
            return false;
        }
        mv.putOptions("ORIG_OBJECT", mv.p3_object);
        ArrayList<Condition> arrayList = new ArrayList<Condition>(1);
        if ("STDDEV".equals(p.getType()) || "STDDEVMIN".equals(p.getType())) {
            double distance = this.m_deviationAnalyzer.process(p.getName(), mv.p3_object, mv.p0_value);
            DaConfig dc = this.m_deviationAnalyzer.getConfig(p.getName(), mv.p3_object);
            DeviationAnalyzer.DataSet dataSet = this.m_deviationAnalyzer.getDataSet(p.getName(), mv.p3_object);
            if (dc.count < (long)dataSet.initialThreshold) {
                RTLogger.print(5, "Policy %s (%s) - count of values: %d in not yet reached learning threshold: %d", p.getName(), p.getType(), dc.count, dataSet.initialThreshold);
                return false;
            }
            if ("STDDEV".equals(p.getType())) {
                distance = Math.abs(distance);
            }
            mv.getOptions().put("DA_STDDEV", "" + dc.stdDev);
            mv.getOptions().put("DA_AVERAGE", "" + dc.average);
            mv.getOptions().put("DA_COUNT", "" + dc.count);
            mv.getOptions().put("ORIG_VALUE", "" + mv.p0_value);
            mv.p0_value = distance;
        }
        Condition c = p.getSeverity(mv.p0_value, mv.p3_object, mv.getOptions(), arrayList);
        MonitorValue mv1 = new MonitorValue(mv.p0_value, mv.p1_time, mv.p2_policyName, mv.p3_object, mv.getOptions());
        if (c != null) {
            mv.setSource(c.getAsSourceString(p.getName()), c.getCustomAttributes(), p.getName());
        }
        if (c != null && c.isOverrideNode()) {
            mv.setNode(c.getSetNode(), this.m_variables);
        }
        if (c != null && c.isOverrideObject()) {
            mv.setObject(c.getSetObject(), this.m_variables);
        }
        String mvkey = mv.getKey();
        CalcStatus status = this.m_activeStatus.get(mvkey);
        if (!arrayList.isEmpty()) {
            Condition prevCond;
            Condition condition = prevCond = status == null ? null : status.getCondition();
            if (prevCond == null || !prevCond.equals(c)) {
                c = (Condition)arrayList.get(0);
                mv = mv1;
                if (c != null) {
                    mv.setSource(c.getAsSourceString(p.getName()), c.getCustomAttributes(), p.getName());
                    if (c.isOverrideNode()) {
                        mv.setNode(c.getSetNode(), this.m_variables);
                    }
                    if (c.isOverrideObject()) {
                        mv.setObject(c.getSetObject(), this.m_variables);
                    }
                }
            }
        }
        if (c == null || c.getActionType().equals("STOP")) {
            if (this.sendFinishAlert(mv, mvkey)) {
                this.updateMonitorSerie(mv, mvkey);
                return false;
            } else {
                if (c == null && mv.p3_object != null) {
                    if (!mv.p3_object.isEmpty()) return false;
                }
                this.updateMonitorSerie(mv, mvkey);
            }
            return false;
        }
        MonitorSerie serie = this.updateMonitorSerie(mv, mvkey);
        long msSinceLast = 0L;
        MonitorValue mvLastSent = this.lastSentValues.get(mvkey);
        if (mvLastSent != null) {
            msSinceLast = mv.p1_time - mvLastSent.p1_time;
        } else if (status != null) {
            msSinceLast = mv.p1_time - status.getTime();
        }
        if (c.getResetStateMinutes() > 0 && 60000L * (long)c.getResetStateMinutes() <= msSinceLast) {
            status = null;
            this.m_activeStatus.remove(mvkey);
            this.lastSentValues.remove(mvkey);
            this.m_counters.remove(mvkey);
            RTLogger.print(4, "reset condition interval for : %s", mvkey);
        }
        if (p.getType().equals("MAXONLYCHANGES") || p.getType().equals("MINONLYCHANGES")) {
            MonitorSerie.TimeValue previuosValue = serie.getValues().size() < 2 ? null : serie.getValues().get(1);
            boolean result = true;
            if (status != null && previuosValue != null && Double.compare(previuosValue.getValue(), mv.p0_value) == 0) {
                return false;
            }
            this.m_activeStatus.put(mvkey, new CalcStatus(c, mv.p1_time));
            this.lastSentValues.put(mvkey, mv);
            return result;
        }
        if (p.isReset() || c.getSilenceCount() > 0L) {
            Condition last;
            if (c.isIgnoreReset() && c.getSilenceCount() == 0L) {
                this.m_activeStatus.put(mvkey, new CalcStatus(c, mv.p1_time));
                this.lastSentValues.put(mvkey, mv);
                return true;
            }
            Condition condition = last = status == null ? null : status.getCondition();
            if (last != null) {
                if (c.equals(last)) {
                    if (c.getSilenceCount() <= 0L) return false;
                    if (this.m_counters.containsKey(mvkey)) {
                        Integer v = this.m_counters.get(mvkey);
                        int currentCount = v + 1;
                        if ((long)currentCount >= c.getSilenceCount()) {
                            if (c.isIgnoreReset() || !p.isReset()) {
                                if (RTLogger.getCurrentLevel() >= 4) {
                                    RTLogger.print(4, "Monitor %s.%s=%f IgnoreReset found. sending...", mv.p2_policyName, mv.p3_object, mv.p0_value);
                                }
                                this.m_counters.put(mvkey, -1);
                                isUpdate = true;
                            } else {
                                if ((long)currentCount == c.getSilenceCount()) {
                                    isUpdate = true;
                                    if (RTLogger.getCurrentLevel() >= 4) {
                                        RTLogger.print(4, "Monitor %s.%s=%f count reached. Count=%d", mv.p2_policyName, mv.p3_object, mv.p0_value, currentCount);
                                    }
                                } else if (RTLogger.getCurrentLevel() >= 4) {
                                    RTLogger.print(4, "Monitor %s.%s=%f Count=%d. do not send.", mv.p2_policyName, mv.p3_object, mv.p0_value, currentCount);
                                }
                                this.m_counters.put(mvkey, currentCount);
                            }
                        } else {
                            this.m_counters.put(mvkey, currentCount);
                            if (RTLogger.getCurrentLevel() >= 4) {
                                RTLogger.print(4, "Monitor %s.%s=%f count not reached. Count=%d", mv.p2_policyName, mv.p3_object, mv.p0_value, currentCount);
                            }
                        }
                    }
                } else if (c.getSilenceCount() > 0L) {
                    this.m_counters.put(mvkey, 0);
                } else {
                    isUpdate = true;
                    if (c.isIgnoreReset() || !p.isReset()) {
                        isUpdate = c.isSendFirst();
                    }
                }
            } else {
                isUpdate = true;
                if (c.getSilenceCount() > 0L) {
                    this.m_counters.put(mvkey, 0);
                    RTLogger.print(4, "Monitor %s.%s=%f (Silence Count=0).", mv.p2_policyName, mv.p3_object, mv.p0_value);
                    isUpdate = false;
                    if (c.isIgnoreReset() || !p.isReset()) {
                        isUpdate = c.isSendFirst();
                    }
                    if (!isUpdate) {
                        --mv.p1_time;
                        mv.p12_source = dummy;
                        this.lastSentValues.put(mvkey, mv);
                    }
                }
            }
        } else {
            isUpdate = true;
        }
        this.m_activeStatus.put(mvkey, new CalcStatus(c, mv.p1_time));
        MonitorValue lastSent = this.lastSentValues.get(mvkey);
        if (lastSent != null && !c.isIgnoreReset() && p.isReset() && lastSent.p12_source.contains(c.getConditionId())) {
            isUpdate = false;
            RTLogger.print(4, "skip resend for key: " + mvkey);
        }
        if (!isUpdate) return isUpdate;
        this.lastSentValues.put(mvkey, mv);
        return isUpdate;
    }

    private MonitorSerie updateMonitorSerie(MonitorValue mv, String mvkey) {
        MonitorSerie serie = this.monitorSeries.get(mvkey);
        if (serie == null) {
            serie = new MonitorSerie(mv.p2_policyName, mv.p3_object, mv.getNode().equalsIgnoreCase(AgentEngine.getInstance().getAgentHostname()) ? null : mv.getNode(), AgentEngine.getInstance().getAgentProperties().getMaxMonitorSeriesSize());
            this.monitorSeries.put(mvkey, serie);
        }
        serie.add(mv.p0_value, mv.p1_time);
        return serie;
    }

    private boolean sendFinishAlert(MonitorValue mv, String mvkey) {
        String lastUUID;
        boolean isFASent = false;
        MonitorValue monitorValue = this.lastSentValues.get(mvkey);
        if (monitorValue != null && (lastUUID = monitorValue.p00_uuid) != null) {
            this.lastSentValues.remove(mvkey);
            this.m_activeStatus.remove(mvkey);
            this.monitorSeries.remove(mvkey);
            if (!dummy.equals(mv.p12_source)) {
                FA fa = new FA(lastUUID, mv.p1_time, mv.p0_value);
                try {
                    AgentEngine.getInstance().getFAQueue().put(fa);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                isFASent = true;
            }
        }
        return isFASent;
    }

    public Condition getActualCondition(MonitorValue mv) {
        CalcStatus status = this.m_activeStatus.get(mv.getKey());
        return status == null ? null : status.getCondition();
    }

    public void sendValue(MonitorValue mv) throws InterruptedException {
        if (this.isUpdate(mv)) {
            Condition c = this.getActualCondition(mv);
            if (c == null) {
                if (RTLogger.getCurrentLevel() >= 2) {
                    RTLogger.print(2, "no condition for MonValue: %s.%s=%f", mv.p2_policyName, mv.p3_object, mv.p0_value);
                }
                return;
            }
            Policy p = this.m_policies.getPolicy(mv.p2_policyName);
            mv.putOptions("THRESHOLD", "" + c.getThreshold());
            mv.p4_severity = c.getSetSeverity();
            mv.p11_2_autoActionTimeout = c.getAutoActionTimeout();
            mv.px_autoActionOnDuplicate = c.getAutoActionOnDuplicate();
            mv.p6_instructionID = c.getHelptextId();
            mv.setTypeA(c.getTypeA());
            mv.setTypeK(c.getTypeK());
            mv.setDedupl(c.isDedupl());
            String setApplication = c.isOverrideApplication() ? c.getSetApplication() : p.getSetApplication();
            String setGroup = c.isOverrideGroup() ? c.getSetGroup() : p.getSetGroup();
            setApplication = this.m_variables.replaceAll(setApplication, mv);
            setApplication = setApplication.replace("<$APPLICATION>", p.getSetApplication());
            setApplication = setApplication.replace("<$MSG_APPL>", p.getSetApplication());
            setApplication = setApplication.replace("<$GROUP>", p.getSetGroup());
            setApplication = setApplication.replace("<$MSG_GRP>", p.getSetGroup());
            mv.putOptions("MSG_APPL", setApplication);
            mv.putOptions("APPLICATION", setApplication);
            setGroup = this.m_variables.replaceAll(setGroup, mv);
            setGroup = setGroup.replace("<$APPLICATION>", p.getSetApplication());
            setGroup = setGroup.replace("<$MSG_APPL>", p.getSetApplication());
            setGroup = setGroup.replace("<$GROUP>", p.getSetGroup());
            setGroup = setGroup.replace("<$MSG_GRP>", p.getSetGroup());
            mv.putOptions("MSG_GRP", setGroup);
            mv.putOptions("GROUP", setGroup);
            mv.p5_msg_text = this.getMessageText(c, mv);
            mv.p8_messageKey = this.getMessageKey(p, c, mv);
            mv.p9_ackKey = this.getAckKey(c, mv, p.getCloseMask());
            mv.p11_autoAction = this.getAutoAction(c, mv);
            mv.p11_1_autoActionNode = this.getAutoActionNode(c, mv);
            mv.p13_opAction = this.getOpAction(c, mv);
            if (c.isDeduplKeyOnly() && mv.p8_messageKey != null && !mv.p8_messageKey.isEmpty()) {
                mv.m_CAs.put(Opts.DEDUPL_KEYONLY, "true");
                mv.p23_deduplicationKeyOnly = true;
            }
            if (c.getAutoActionOnDuplicate() != 0) {
                mv.m_CAs.put(Opts.AUTOACTION_START_ON_DUPLICATE, "" + c.getAutoActionOnDuplicate());
            }
            if (c.getInsertClosed() > 0) {
                mv.p30_state = "A";
            }
            mv.m_CAs.put("<$APPLICATION>", setApplication);
            mv.m_CAs.put("<$GROUP>", setGroup);
            if (c.getInstructionAction() != null && !c.getInstructionAction().isEmpty()) {
                mv.m_CAs.put(Opts.INSTRUCTION_ACTION, this.m_variables.replaceAll(c.getInstructionAction(), mv));
            }
            if (AgentEngine.getInstance().getMessageStormFilter().filterMessage(mv.p2_policyName) == MessageStormFilter.PolicyState.OK) {
                AgentEngine.getInstance().getMonitorQueue().put(mv);
            }
            if (RTLogger.getCurrentLevel() >= 5) {
                RTLogger.print(5, "Monitor %s.%s=%f new value", mv.p2_policyName, mv.p3_object, mv.p0_value);
            }
            AgentHealth.m_totalMatchedMonitorValues.incrementAndGet();
        } else if (RTLogger.getCurrentLevel() >= 5) {
            RTLogger.print(5, "Monitor %s.%s=%f is droped", mv.p2_policyName, mv.p3_object, mv.p0_value);
        }
    }

    public String getAckKey(Condition c, MonitorValue mv, String policyGlobalCloseMask) {
        String closeMask;
        String string = closeMask = policyGlobalCloseMask == null ? "" : policyGlobalCloseMask;
        if (c.isOverrideCloseMask()) {
            closeMask = c.getCloseMask();
        }
        return this.m_variables.replaceAllForPattern(closeMask, mv);
    }

    public String getAutoAction(Condition c, MonitorValue mv) {
        return this.m_variables.replaceAll(c.getAutoAction(), mv);
    }

    public String getAutoActionNode(Condition c, MonitorValue mv) {
        return this.m_variables.replaceAll(c.getAutoAction_Node(), mv);
    }

    public String getOpAction(Condition c, MonitorValue mv) {
        return this.m_variables.replaceAll(c.getOpAction(), mv);
    }

    public String getMessageKey(Policy p, Condition c, MonitorValue mv) {
        String key;
        String string = key = p.getKey() == null ? "" : p.getKey();
        if (c.isOverrideKey()) {
            key = c.getKey();
        }
        return this.m_variables.replaceAll(key, mv);
    }

    public String getMessageText(Condition c, MonitorValue mv) {
        return this.m_variables.replaceAll(c.getSetText(), mv);
    }

    public Map<String, MonitorSerie> getMonitorSeries() {
        return this.monitorSeries;
    }

    public MonitorSerie getMonitorSerie(String mvkey) {
        return this.monitorSeries.get(mvkey);
    }

    public Map<String, Integer> getCounters() {
        return this.m_counters;
    }
}

