/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.log.RTLogger;
import com.boom.crt.hlp.KeyStoreUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class ConnectionCheckAfterKSSwitchTask
implements Runnable {
    private long initialTimestampOnline = AgentEngine.getInstance().getLastTimeOnline();
    private long minTimestampOffsetMs;

    public ConnectionCheckAfterKSSwitchTask(long minTimestampOffsetMs) {
        this.minTimestampOffsetMs = minTimestampOffsetMs;
    }

    @Override
    public void run() {
        if (!AgentEngine.getInstance().getAgentProperties().isTlsActivated()) {
            RTLogger.print(1, "Do not execute ConnectionCheckAfterKSSwitchTask since TLS is deactivated");
            return;
        }
        long lastTimeRealOnline = AgentEngine.getInstance().getLastTimeOnline();
        Path defaultKSPath = Paths.get(AgentEngine.getInstance().getAgentProperties().getKsFile(), new String[0]);
        Path backupKSPath = KeyStoreUtils.getBackupPath(defaultKSPath);
        if (lastTimeRealOnline > this.initialTimestampOnline + this.minTimestampOffsetMs) {
            RTLogger.print(1, "Successful connection after keystore switch detected. initialTimestampOnline=" + this.initialTimestampOnline + " lastTimeRealOnline=" + lastTimeRealOnline);
            try {
                Files.deleteIfExists(backupKSPath);
                RTLogger.print(1, "Backup keystore successfully removed " + backupKSPath.toAbsolutePath().toString());
            }
            catch (IOException e) {
                RTLogger.print(1, "Could not remove backup keystore " + backupKSPath.toAbsolutePath().toString(), e);
            }
        } else {
            RTLogger.print(1, "Connection after keystore switch could not be established, performing key store rollback. initialTimestampOnline=" + this.initialTimestampOnline + " lastTimeRealOnline=" + lastTimeRealOnline);
            if (Files.exists(backupKSPath, new LinkOption[0]) && Files.isRegularFile(backupKSPath, new LinkOption[0])) {
                try {
                    Files.move(backupKSPath, defaultKSPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                    AgentEngine.getInstance().getCertManager().getKsClient().loadKeyStore();
                }
                catch (IOException e) {
                    RTLogger.print(1, "Could not replace default key store with the one from backup", e);
                }
                catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    RTLogger.print(1, "Could not load the default key store after rollback", e);
                }
            } else {
                RTLogger.print(1, "Key store backup doesn't exist, cannot rollback the key store switch!");
            }
        }
    }
}

