/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.ConnectionSettingsBackupHelper;
import com.blixx.log.RTLogger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class ConnectionCheckAfterTLSSwitchTask
implements Runnable {
    private long minTimestampOffsetMs;
    private Path backupSettingsFile;

    public ConnectionCheckAfterTLSSwitchTask(long minTimestampOffsetMs, Path backupSettingsFile) {
        this.minTimestampOffsetMs = minTimestampOffsetMs;
        this.backupSettingsFile = backupSettingsFile;
    }

    @Override
    public void run() {
        long lastTimeRealOnline = AgentEngine.getInstance().getLastTimeOnline();
        if (lastTimeRealOnline + this.minTimestampOffsetMs >= System.currentTimeMillis()) {
            this.handleSuccessfulConnect(lastTimeRealOnline);
        } else {
            this.handleRollback(lastTimeRealOnline);
        }
    }

    private void handleRollback(long lastTimeRealOnline) {
        RTLogger.print(1, "Connection after connectivity change could not be established, performing settings rollback. lastTimeRealOnline=" + lastTimeRealOnline);
        if (Files.exists(this.backupSettingsFile, new LinkOption[0]) && Files.isRegularFile(this.backupSettingsFile, new LinkOption[0])) {
            try {
                ConnectionSettingsBackupHelper.restore(this.backupSettingsFile);
                RTLogger.print(1, "Restarting Agent due to TLS settings rollback.");
                AgentEngine.getInstance().shutdownServerSocket();
                AgentEngine.getInstance().startAgent();
                this.deleteBackupPropertiesFile();
                AgentEngine.getInstance().sendMessage(AgentEngine.getInstance().getAgentHostname(), "BOOM_AGENT", "BOOM_AGENT", "Agent_Conn_Settings", "Boom agent connectivity change has been rolled back", "warning", new HashMap());
            }
            catch (IOException e) {
                RTLogger.print(1, "Could not replace connectivity settings with the ones from backup", e);
                AgentEngine.getInstance().sendMessage(AgentEngine.getInstance().getAgentHostname(), "BOOM_AGENT", "BOOM_AGENT", "Agent_Conn_Settings", "Boom agent connectivity change could not be rolled back", "critical", new HashMap());
            }
        } else {
            RTLogger.print(1, "Settings backup doesn't exist, cannot rollback the connectivity settings change!");
            AgentEngine.getInstance().sendMessage(AgentEngine.getInstance().getAgentHostname(), "BOOM_AGENT", "BOOM_AGENT", "Agent_Conn_Settings", "Boom agent connectivity change could not be rolled back. Settings backup doesn't exist.", "critical", new HashMap());
        }
    }

    private void handleSuccessfulConnect(long lastTimeRealOnline) {
        RTLogger.print(1, "Successful connection after connectivity change detected. lastTimeRealOnline=" + lastTimeRealOnline);
        try {
            List<String> filesToRemove = ConnectionSettingsBackupHelper.getFilesToRemove(this.backupSettingsFile);
            List pathsToRemove = filesToRemove.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
            for (Path file : pathsToRemove) {
                try {
                    Files.deleteIfExists(file);
                    RTLogger.print(1, "Obsolete file successfully removed " + file.toAbsolutePath());
                }
                catch (IOException e) {
                    RTLogger.print(1, "Could not remove obsolete file " + file.toAbsolutePath(), e);
                }
            }
        }
        catch (IOException e) {
            RTLogger.print(1, "Could not read backup file " + this.backupSettingsFile.toAbsolutePath(), e);
        }
        this.deleteBackupPropertiesFile();
        AgentEngine.getInstance().sendMessage(AgentEngine.getInstance().getAgentHostname(), "BOOM_AGENT", "BOOM_AGENT", "Agent_Conn_Settings", "Boom agent connectivity change has been successfully finished", "normal", new HashMap());
    }

    private void deleteBackupPropertiesFile() {
        try {
            Files.deleteIfExists(this.backupSettingsFile);
            RTLogger.print(1, "Backup keystore successfully removed " + this.backupSettingsFile.toAbsolutePath());
        }
        catch (IOException e) {
            RTLogger.print(1, "Could not remove backup settings file " + this.backupSettingsFile.toAbsolutePath(), e);
        }
    }
}

