/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AProperties;
import com.blixx.agent.AgentEngine;
import com.blixx.log.RTLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ConnectionSettingsBackupHelper {
    private static final String TS_FILE = "TS_FILE";
    private static final String TS_PASS_ENCODED = "TS_PASS_ENCODED";
    private static final String KS_FILE = "KS_FILE";
    private static final String KS_PASS_ENCODED = "KS_PASS_ENCODED";
    private static final String COMM_TYPE = "COMM_TYPE";
    private static final String AGENT_TLS_PORT = "AGENT_TLS_PORT";

    private ConnectionSettingsBackupHelper() {
    }

    public static void backup(Path backupFile) throws IOException {
        AProperties properties = AgentEngine.getInstance().getAgentProperties();
        Properties propertiesBackup = new Properties();
        String tsFile = properties.getTsFile();
        String tsPassEncoded = properties.getTsPassEncoded();
        String ksFile = properties.getKsFile();
        String ksPassEncoded = properties.getKsPassEncoded();
        String commType = properties.getCommType();
        Integer agentTlsPort = properties.getAgentTlsPort();
        if (tsFile != null) {
            propertiesBackup.setProperty(TS_FILE, tsFile);
        }
        if (tsPassEncoded != null) {
            propertiesBackup.setProperty(TS_PASS_ENCODED, tsPassEncoded);
        }
        if (ksFile != null) {
            propertiesBackup.setProperty(KS_FILE, ksFile);
        }
        if (ksPassEncoded != null) {
            propertiesBackup.setProperty(KS_PASS_ENCODED, ksPassEncoded);
        }
        if (commType != null) {
            propertiesBackup.setProperty(COMM_TYPE, commType);
        }
        if (agentTlsPort != null) {
            propertiesBackup.setProperty(AGENT_TLS_PORT, agentTlsPort.toString());
        }
        try (OutputStream outputStream = Files.newOutputStream(backupFile, new OpenOption[0]);){
            propertiesBackup.store(outputStream, "Backup of connectivity properties");
        }
    }

    public static List<String> getFilesToRemove(Path backupFile) throws IOException {
        String tsFile;
        Properties propertiesBackup = new Properties();
        try (InputStream inputStream = Files.newInputStream(backupFile, new OpenOption[0]);){
            propertiesBackup.load(inputStream);
        }
        ArrayList<String> filesToRemove = new ArrayList<String>();
        String ksFile = propertiesBackup.getProperty(KS_FILE);
        if (ksFile != null) {
            filesToRemove.add(ksFile);
        }
        if ((tsFile = propertiesBackup.getProperty(TS_FILE)) != null) {
            filesToRemove.add(tsFile);
        }
        return filesToRemove;
    }

    public static void restore(Path backupFile) throws IOException {
        AProperties agentProperties = AgentEngine.getInstance().getAgentProperties();
        Properties propertiesBackup = new Properties();
        try (InputStream inputStream = Files.newInputStream(backupFile, new OpenOption[0]);){
            propertiesBackup.load(inputStream);
        }
        agentProperties.setKsFile(propertiesBackup.getProperty(KS_FILE));
        agentProperties.setTsFile(propertiesBackup.getProperty(TS_FILE));
        agentProperties.setKsPassEncoded(propertiesBackup.getProperty(KS_PASS_ENCODED));
        agentProperties.setTsPassEncoded(propertiesBackup.getProperty(TS_PASS_ENCODED));
        agentProperties.setCommType(propertiesBackup.getProperty(COMM_TYPE));
        try {
            agentProperties.setAgentTlsPort(Integer.valueOf(propertiesBackup.getProperty(AGENT_TLS_PORT)));
        }
        catch (NumberFormatException e) {
            RTLogger.print(1, "Could not parse AGENT_TLS_PORT property from " + backupFile.getFileName());
        }
        agentProperties.save();
    }
}

