/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.log.RTLogger;
import com.blixx.sa.perf.DDFTable;
import com.boom.netty.service.events.PerfAgt;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DDF {
    private Properties m_props = new Properties();
    private String m_filename = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DDF(String filename) {
        FileInputStream fis = null;
        try {
            this.m_filename = filename;
            fis = new FileInputStream(this.m_filename);
            this.m_props.load(fis);
        }
        catch (FileNotFoundException e) {
            RTLogger.print(2, "DDF properties not found");
        }
        catch (Exception e) {
            RTLogger.print(2, "DDF properties loading failed", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClass(DDFTable table) {
        this.m_props.setProperty(table.m_tableName, table.getFieldNames());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.m_filename);
            this.m_props.store(fos, "don't edit this file");
            fos.close();
        }
        catch (Exception e) {
            RTLogger.print(2, "DDF properties can't be saved", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public String getFields(String className) {
        String fields = this.m_props.getProperty(className);
        return fields;
    }

    public List<PerfAgt.PerfValue> getFieldsAsPerfVal(String className) {
        Pattern fieldPattern = Pattern.compile("\\s*(\\S+)/\\*(\\S+)\\|(\\d+)\\*/\\s*");
        LinkedList<PerfAgt.PerfValue> list = null;
        try {
            String fields = this.getFields(className);
            if (fields != null) {
                String[] array;
                list = new LinkedList<PerfAgt.PerfValue>();
                for (String field : array = fields.split(",")) {
                    Matcher m = fieldPattern.matcher(field);
                    if (!m.matches() || "_TIME".equals(m.group(1))) continue;
                    list.add(new PerfAgt.PerfValue(m.group(1), m.group(2), Integer.parseInt(m.group(3)), null));
                }
            }
        }
        catch (NumberFormatException e) {
            RTLogger.print(2, " error parsing fields for perfclass " + className + ". fields: " + this.getFields(className));
        }
        return list;
    }
}

