/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.log.RTLogger;
import com.blixx.sa.ExecResult;
import com.blixx.sa.ExecUtils;
import com.blixx.shared.os.SystemUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DeploymentHelper {
    private AtomicBoolean deploymentRunning = new AtomicBoolean(false);
    private AgentEngine agentEngine;

    public boolean startDeployment() {
        return this.deploymentRunning.compareAndSet(false, true);
    }

    public void finishDeployment() {
        this.deploymentRunning.set(false);
    }

    public boolean isDeploymentRunning() {
        return this.deploymentRunning.get();
    }

    public DeploymentHelper(AgentEngine agentEngine) {
        this.agentEngine = agentEngine;
    }

    public boolean deployBinaries(File f, String pkgName) throws IOException {
        ExecResult er;
        boolean isClassLoaderMustBeUpdated = false;
        Properties props = this.getConfFile(f.getAbsolutePath());
        String stopStr = null;
        String startStr = null;
        int secondsToWait = 30;
        if (props.size() > 0) {
            stopStr = props.getProperty("STOP");
            startStr = props.getProperty("START");
            String seconds = props.getProperty("TIMEOUT");
            if (seconds != null) {
                try {
                    secondsToWait = Integer.parseInt(seconds);
                }
                catch (Throwable e) {
                    RTLogger.print(2, "Package property conatins unparsable TIMEOUT=" + seconds + ". Agent will use default 120 sec.");
                }
            }
        }
        if (stopStr != null) {
            er = ExecUtils.exec2(stopStr, this.agentEngine.FILE_SPI_DIR, secondsToWait);
            RTLogger.print(1, "STOP command on the package {" + pkgName + "} ResultCode=" + er.resultCode);
        }
        boolean bl = isClassLoaderMustBeUpdated = this.unzip(pkgName, f.getAbsolutePath(), this.agentEngine.DIR_SPI, 12, 5000L) || isClassLoaderMustBeUpdated;
        if (!f.delete()) {
            f.delete();
        }
        if (startStr != null) {
            er = ExecUtils.exec2(startStr, this.agentEngine.FILE_SPI_DIR, secondsToWait);
            RTLogger.print(1, "START command on the package {" + pkgName + "} ResultCode=" + er.resultCode);
        }
        this.agentEngine.sendInternalMessage("Package " + pkgName + " successfully deployed.", 1, "DEPLOY", pkgName);
        return isClassLoaderMustBeUpdated;
    }

    public void undeployBinary(File f, String pkgName) throws IOException {
        Properties props = this.getConfFile(f.getAbsolutePath());
        String stopStr = null;
        int secondsToWait = 30;
        if (props.size() > 0) {
            stopStr = props.getProperty("STOP");
            String seconds = props.getProperty("TIMEOUT");
            if (seconds != null) {
                try {
                    secondsToWait = Integer.parseInt(seconds);
                }
                catch (Throwable e) {
                    RTLogger.print(2, "Package property conatins unparsable TIMEOUT=" + seconds + ". Agent will use default 120 sec.");
                }
            }
        }
        if (stopStr != null) {
            ExecResult er = ExecUtils.exec2(stopStr, this.agentEngine.FILE_SPI_DIR, secondsToWait);
            RTLogger.print(1, "STOP command on the package {" + pkgName + "} ResultCode=" + er.resultCode);
        }
        String res = this.deleteWhatInZip(pkgName, f.getAbsolutePath(), this.agentEngine.DIR_SPI, 12, 5000L);
        if (!f.delete()) {
            f.delete();
        }
        this.agentEngine.sendInternalMessage("Package " + pkgName + " successfully undeployed.\n" + res, 1, "UNDEPLOY", pkgName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getConfFile(String zipfile) {
        Properties pr = new Properties();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zipfile);
            File z = new File(zipfile);
            String name2 = z.getName();
            String pkgName = name2.substring(0, name2.lastIndexOf(95));
            ZipEntry propEntry = zipFile.getEntry(pkgName + ".props");
            if (propEntry != null) {
                pr.load(zipFile.getInputStream(propEntry));
            }
        }
        catch (IOException e) {
            RTLogger.print(5, "zip error while reading prop file.", e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return pr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unzip(String pkgName, String zipfile, String targetDir, int numberOfTries, long delay) throws IOException {
        boolean isJarsFound = false;
        File targetD = new File(targetDir);
        if (!targetD.exists()) {
            targetD.mkdirs();
        }
        ZipFile zipFile = new ZipFile(zipfile);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            block22: while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                RTLogger.print(5, "unzip: " + entry.getName());
                String entryShortName = entry.getName();
                if (SystemUtils.OS == 2) {
                    entryShortName = entryShortName.replace('\\', '/');
                }
                File file = new File(targetD, entryShortName);
                String entryLongName = file.getCanonicalPath();
                if (entryShortName.endsWith(".jar")) {
                    isJarsFound = true;
                    if (entryLongName.endsWith("jars/" + entryShortName) || entryLongName.endsWith("jars\\" + entryShortName)) {
                        isJarsFound = true;
                    }
                }
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                File nf = file;
                if (!nf.canWrite()) {
                    this.chmod(file.getParent());
                    this.chmod(nf.getParent());
                }
                FileOutputStream fileOutputStream = null;
                boolean isFinished = false;
                int count = 0;
                while (count < numberOfTries) {
                    ++count;
                    try {
                        fileOutputStream = new FileOutputStream(nf, false);
                    }
                    catch (Throwable e) {
                        try {
                            this.agentEngine.sendInternalMessageDupl("File " + entryShortName + " is locked. The Agent will try to redo action", 2, "DEPLOY", pkgName);
                            Thread.sleep(delay);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    InputStream inputStream = null;
                    try {
                        inputStream = zipFile.getInputStream(entry);
                        this.copyInputStream(inputStream, new BufferedOutputStream(fileOutputStream));
                        isFinished = true;
                    }
                    finally {
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (Throwable throwable) {}
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    if (!isFinished) continue;
                    continue block22;
                }
            }
        }
        finally {
            try {
                zipFile.close();
            }
            catch (Throwable throwable) {}
        }
        this.chmod(targetDir);
        return isJarsFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteWhatInZip(String pkgName, String zipfile, String targetDir, int numberOfTries, long delay) throws IOException {
        StringBuffer sb = new StringBuffer();
        File targetD = new File(targetDir);
        ZipFile zipFile = null;
        ArrayList<File> directoriesToDelete = new ArrayList<File>();
        try {
            zipFile = new ZipFile(zipfile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryShortName = entry.getName();
                if (SystemUtils.OS == 2) {
                    entryShortName = entryShortName.replace('\\', '/');
                }
                File file = new File(targetD, entryShortName);
                if (entry.isDirectory() && file.exists()) {
                    directoriesToDelete.add(file);
                    continue;
                }
                if (!file.delete()) {
                    sb.append("File: ").append(file.getCanonicalPath()).append(" not deleted.\n");
                    continue;
                }
                sb.append("File: ").append(file.getCanonicalPath()).append(" deleted.\n");
            }
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Throwable entries) {}
            }
        }
        for (int i = directoriesToDelete.size() - 1; i >= 0; --i) {
            File file = (File)directoriesToDelete.get(i);
            if (!file.delete()) {
                sb.append("Directory: ").append(file.getCanonicalPath()).append(" not deleted.\n");
                continue;
            }
            sb.append("Directory: ").append(file.getCanonicalPath()).append(" deleted.\n");
        }
        return sb.toString();
    }

    private void chmod(String entryLongName) {
        if (entryLongName != null && SystemUtils.OS == 2) {
            try {
                ExecUtils.exec2("chmod -R 755 " + entryLongName, null, 20);
            }
            catch (Throwable e) {
                RTLogger.print(1, "Can't change mode for file: " + entryLongName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyInputStream(InputStream in, OutputStream out) throws IOException {
        try {
            byte[] buffer = new byte[64000];
            int len = 0;
            while ((len = in.read(buffer)) >= 0) {
                try {
                    out.write(buffer, 0, len);
                }
                catch (Throwable e) {
                    String message = "Error copying files. ";
                    if (e.getMessage() == null) throw new IOException(message);
                    message = message + e.getMessage();
                    throw new IOException(message);
                    return;
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable throwable) {}
            try {
                out.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

