/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AProperties;
import com.blixx.agent.utils.SupportedVariables;
import com.blixx.ext.ILookup;
import com.blixx.log.RTLogger;
import com.blixx.shared.IEnv;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class Env
implements IEnv {
    public static String ENVFILE = "global.props";
    private static volatile Env m_env = null;
    private Map<String, String> m_vars = new ConcurrentHashMap<String, String>();
    private ConcurrentHashMap<String, ILookup> m_lookupServices = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IEnv getInstance() {
        if (m_env != null) return m_env;
        Class<Env> clazz = Env.class;
        synchronized (Env.class) {
            if (m_env != null) return m_env;
            m_env = new Env();
            m_env.load();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_env;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        File dir = new File(AProperties.DIR);
        if (dir.exists()) {
            File conf = new File(dir, ENVFILE);
            if (conf.exists() && conf.canRead()) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(conf);
                    Properties p = new Properties();
                    p.load(fis);
                    fis.close();
                    this.m_vars.clear();
                    for (Map.Entry<Object, Object> entry : p.entrySet()) {
                        if (entry.getValue() == null) continue;
                        this.m_vars.put(entry.getKey().toString(), entry.getValue().toString());
                    }
                    RTLogger.print(1, "Loaded global.props");
                }
                catch (Throwable e) {
                    RTLogger.print(1, "Error reading global.props");
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable p) {}
                    }
                }
            } else {
                RTLogger.print(1, "global.props not found or unreadable");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() {
        File dir = new File(AProperties.DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File conf = new File(dir, ENVFILE);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(conf);
            Properties p = new Properties();
            p.putAll(this.m_vars);
            p.store(fos, "");
            fos.close();
            RTLogger.print(3, "Stored global.props");
        }
        catch (Throwable e) {
            RTLogger.print(1, "Error writing global.props");
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable p) {}
            }
        }
    }

    @Override
    public void addVariable(String varName, String value) {
        this.m_vars.put(varName, value);
        this.store();
    }

    @Override
    public void addVariables(Map<String, String> vars) {
        this.m_vars.putAll(vars);
        this.store();
    }

    @Override
    public Map<String, String> getVariables() {
        return this.m_vars;
    }

    @Override
    public String getVariable(String name) {
        if (name == null) {
            return null;
        }
        String value = this.m_vars.get(name);
        if (value == null && name.contains("<$") && (value = new SupportedVariables().replaceOptVars(name, this.m_vars)).equals(name)) {
            value = null;
        }
        return value;
    }

    @Override
    public void registerLookupService(ILookup service) {
        this.m_lookupServices.put(service.getName(), service);
    }

    @Override
    public ILookup getLookupService(String name) {
        return this.m_lookupServices.get(name);
    }

    @Override
    public ILookup unregisterLookupService(String name) {
        return this.m_lookupServices.remove(name);
    }

    @Override
    public List<String> getLookupServices() {
        return new ArrayList<String>(this.m_lookupServices.keySet());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> names = new ArrayList<String>(this.m_vars.keySet());
        Collections.sort(names);
        for (String string : names) {
            sb.append(string).append('=').append(this.getVariable(string)).append('\n');
        }
        return sb.toString();
    }
}

