/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.HBCheckOnce;
import com.blixx.agent.SocketFactory;
import com.blixx.log.RTLogger;
import com.blixx.sa.SchedulerTask;
import com.blixx.shared.ServerInfo;
import com.blixx.shared.ServerType;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.SocketUtils;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class HB
extends SchedulerTask {
    public static final SocketException SKIP_BAD_HOSTNAME = new SocketException("skip bad hostname");
    protected AgentEngine agent = AgentEngine.getInstance();
    protected int countFails = 0;
    public static AtomicInteger countPendingRequests = new AtomicInteger(0);
    protected long lastTimeRealPing = 0L;
    protected boolean connected = false;
    protected boolean lastConnectedViaHostname = false;

    public HB() {
        super("HB___@@INTERNAL");
    }

    @Override
    public long getInterval() {
        int hbIntervalSec = this.agent.getServers().getCurrentServer().getHbIntervalSec();
        return hbIntervalSec <= 0 ? 10000L : (long)hbIntervalSec * 1000L;
    }

    public long getLastTimeRealOnline() {
        return this.lastTimeRealPing;
    }

    public long getTimeFromLastRealPing() {
        return System.currentTimeMillis() - this.getLastTimeRealOnline();
    }

    public boolean isPingNecessary() {
        return System.currentTimeMillis() - this.lastTimeRealPing > this.getInterval();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onGetData() {
        boolean isOK = false;
        if (!this.agent.needsToBeChecked() && System.currentTimeMillis() - this.lastTimeRealPing < 60000L) {
            return true;
        }
        Socket s = null;
        try {
            s = SocketFactory.getSocket(this.agent, this.getReadTimeOut());
            SocketFactory.bindSocket(this.agent, s);
            ServerInfo serverInfo = this.agent.getServers().getCurrentServer();
            String host = serverInfo.getHost();
            RTLogger.print(6, "Trying to connect : " + host + " on port : " + serverInfo.getPort());
            try {
                if (this.connected && !this.lastConnectedViaHostname) {
                    throw SKIP_BAD_HOSTNAME;
                }
                InetSocketAddress serverAddrByHost = new InetSocketAddress(host, serverInfo.getPort());
                if (serverAddrByHost.isUnresolved()) {
                    throw new SocketException("Unresolved hostname : " + host);
                }
                s.connect(serverAddrByHost, this.getConnectTimeOut());
                this.connected = true;
                this.lastConnectedViaHostname = true;
                RTLogger.print(6, "Connected to : " + host);
            }
            catch (SocketException | SocketTimeoutException e) {
                SocketUtils.closeSocket(s, new AutoCloseable[0]);
                this.lastConnectedViaHostname = false;
                this.connected = false;
                RTLogger.print(5, "Failed to connect : " + host);
                try {
                    s = SocketFactory.getSocket(this.agent, this.getReadTimeOut());
                    SocketFactory.bindSocket(this.agent, s);
                    RTLogger.print(5, "Trying to connect : " + serverInfo.getPublicIP() + " on port : " + serverInfo.getPort() + " ServerType: " + (Object)((Object)serverInfo.getType()));
                    InetSocketAddress serverAddrByIP = new InetSocketAddress(serverInfo.getPublicIP(), serverInfo.getPort());
                    s.connect(serverAddrByIP, this.getConnectTimeOut());
                    this.connected = true;
                }
                catch (SocketException | SocketTimeoutException e2) {
                    SocketUtils.closeSocket(s, new AutoCloseable[0]);
                    this.connected = false;
                    RTLogger.print(5, "Failed to connect : " + serverInfo.getPublicIP());
                    this.agent.getServers().updateCurrentServerStatus(false);
                }
            }
            if (!this.connected) {
                boolean e = isOK;
                return e;
            }
            InetAddress localAddress = s.getLocalAddress();
            String localIP = localAddress.getHostAddress();
            s.setSoLinger(true, 1);
            if (RTLogger.getCurrentLevel() >= 5) {
                try {
                    RTLogger.print(5, "  HB working with local ip: " + localIP + " port: " + s.getLocalPort() + " remote ip: " + s.getInetAddress().getHostAddress() + " port:" + s.getPort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            InputStream is = s.getInputStream();
            OutputStream os = s.getOutputStream();
            SDataOutputStream dataOutputStream = new SDataOutputStream(os, this.agent.getProtocolVersion());
            SDataInputStream in = new SDataInputStream(is);
            if (this.agent.getAgentProperties().isTlsActivated()) {
                s = SocketFactory.upgradeToTLS(s);
            }
            dataOutputStream.write(86);
            int protocolVersion = this.agent.getProtocolVersion();
            dataOutputStream.writeInt(protocolVersion);
            dataOutputStream.write(70);
            dataOutputStream.writeUTF(this.agent.getAgentID());
            if (!localAddress.isLoopbackAddress() && !localIP.equals(this.agent.getAgentIP())) {
                this.agent.setAgentIP(localIP);
            }
            dataOutputStream.write(49);
            char a = (char)is.read();
            if (a == '!') {
                throw new ServerReject();
            }
            if (a == '0') {
                this.setLastRealPingTime();
                this.agent.setMode(1);
            } else if (a == '2') {
                this.setLastRealPingTime();
                this.agent.setMode(1);
                RTLogger.print(3, "processing server updates. " + this.agent.getAgentHostname());
                this.agent.fetchRemoteUpdates(in, dataOutputStream);
            } else if (a == '7') {
                HB.pendingRequest(dataOutputStream);
                for (int sleepCounter = 1; sleepCounter < 10; ++sleepCounter) {
                    Thread.sleep(100L);
                    if (in.available() <= 0 && !s.isClosed()) continue;
                }
                if (in.available() > 0) {
                    a = (char)is.read();
                    if (a == '8') {
                        HB.getSlaveServerInfo(dataOutputStream, in);
                    } else if (a == '2') {
                        this.agent.fetchRemoteUpdates(in, dataOutputStream);
                    }
                }
                if (this.getLastTimeRealOnline() == 0L) {
                    RTLogger.print(1, "Registration request is pending.");
                    try {
                        RTLogger.print(1, "Socket binded to local hostname: " + s.getLocalAddress().getHostName());
                    }
                    catch (Exception exception) {}
                }
            } else if (a == '8') {
                HB.getSlaveServerInfo(dataOutputStream, in);
            } else {
                RTLogger.print(3, "Unsupported int " + a);
                throw new ProtocolMissmatch();
            }
            this.countFails = 0;
            this.agent.getServers().updateCurrentServerStatus(true);
        }
        catch (ServerReject e) {
            RTLogger.print(1, "Got Reject from server: " + this.agent.getServers().getCurrentServer());
            this.agent.getServers().fallbackSwitchServer();
        }
        catch (Exception e) {
            if (this.agent.isFixedIPUsed()) {
                RTLogger.print(2, "hb failed(1): " + e.getMessage() + " host=" + this.agent.getServers().getCurrentServer() + " localIP:" + this.agent.getAgentIP());
            } else {
                RTLogger.print(2, "hb failed(1): " + e.getMessage() + " host=" + this.agent.getServers().getCurrentServer());
            }
            if (this.countFails > 2) {
                this.agent.setMode(3);
                if (this.countFails == 3) {
                    RTLogger.print(5, "hb ", e);
                }
            } else {
                this.agent.setMode(2);
                ++this.countFails;
            }
            this.agent.getServers().updateCurrentServerStatus(false);
        }
        finally {
            SocketUtils.closeSocket(s, new AutoCloseable[0]);
        }
        if (this.connected && this.agent.getServers().getMainServer() != null && ServerType.BACKUP == this.agent.getServers().getCurrentServer().getType() && !this.agent.getScheduler().hasTask("CheckMainServerAvailability")) {
            this.agent.getScheduler().addTask(new HBCheckOnce(), 0L);
        }
        return isOK;
    }

    protected void setLastRealPingTime() {
        if (this.lastTimeRealPing == 0L) {
            RTLogger.print(2, "HB: Server is online");
        }
        this.lastTimeRealPing = System.currentTimeMillis();
        countPendingRequests.set(0);
    }

    public static void pendingRequest(SDataOutputStream out) throws IOException {
        boolean isTLS = AgentEngine.getInstance().getAgentProperties().isTlsActivated();
        countPendingRequests.incrementAndGet();
        String agentID = AgentEngine.getInstance().getAgentID();
        out.setVersion(isTLS ? 1 : 2);
        out.writeUTF(agentID);
        out.writeUTF(AgentEngine.getInstance().getAgentOS());
        out.writeUTF(AgentEngine.getInstance().getAgentHostname() + ":" + (isTLS ? AgentEngine.getInstance().getAgentProperties().getAgentTlsPort().intValue() : AgentEngine.getInstance().getAgentPort()) + AgentEngine.getExtendedAgentInfo());
        if (AgentEngine.getInstance().getAgentProperties().getAgentPort() == -2) {
            out.writeInt(2);
            out.writeUTF("");
            out.writeBoolean(AgentEngine.getInstance().getDisabled());
            out.writeInt(AgentEngine.getInstance().getAgentProperties().getHbInterval());
            out.writeUTF(AgentEngine.getInstance().getAgentProperties().getCommType());
        }
    }

    protected static void getSlaveServerInfo(SDataOutputStream out, SDataInputStream in) throws IOException {
        try {
            String objectJson = in.readUTF();
            Gson gson = new Gson();
            ServerInfo slaveServer = gson.fromJson(objectJson, ServerInfo.class);
            AgentEngine.getInstance().setSlaveServerHost(slaveServer);
            out.write(84);
        }
        catch (Exception e) {
            RTLogger.print(2, "Server information could not retrieved due to socket exception.", e);
            try {
                out.write(70);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean onInit() throws Exception {
        return true;
    }

    @Override
    public boolean onStartRun() {
        return true;
    }

    @Override
    public boolean onStopRun() {
        return true;
    }

    @Override
    protected boolean onStopTask() {
        return true;
    }

    @Override
    public boolean refresh() {
        return true;
    }

    protected int getConnectTimeOut() {
        return this.agent.getAgentProperties().getHbConnectTimeoutMs();
    }

    protected int getReadTimeOut() {
        return this.agent.getAgentProperties().getHbReadTimeoutMs();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public static class ServerReject
    extends IOException {
        public ServerReject() {
            super("Unexpected data received");
        }
    }

    public static class ProtocolMissmatch
    extends IOException {
        public ProtocolMissmatch() {
            super("Unexpected data received");
        }
    }
}

