/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.SocketFactory;
import com.blixx.log.RTLogger;
import com.blixx.sa.SchedulerTask;
import com.blixx.shared.Interval;
import com.blixx.shared.ServerInfo;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.SocketUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class HBCheckOnce
extends SchedulerTask {
    public static final String NAME = "CheckMainServerAvailability";

    public HBCheckOnce() {
        super(NAME);
        this.setInterval(Interval.getSimpleInterval(60));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkHB(ServerInfo srvInfo) {
        boolean isOK = false;
        if (srvInfo == null || srvInfo.getPort() <= 0) return isOK;
        AgentEngine agent = AgentEngine.getInstance();
        Socket s = null;
        try {
            s = SocketFactory.getSocket(agent, 5000);
            try {
                s.connect(new InetSocketAddress(srvInfo.getHost(), srvInfo.getPort()), 5000);
                RTLogger.print(1, "MAIN server is back (H)?");
            }
            catch (Exception e) {
                SocketUtils.closeSocket(s, new AutoCloseable[0]);
                s = SocketFactory.getSocket(agent, 5000);
                s.connect(new InetSocketAddress(srvInfo.getPublicIP(), srvInfo.getPort()), 5000);
                RTLogger.print(1, "MAIN server is back (I)?");
            }
            InputStream is = s.getInputStream();
            OutputStream os = s.getOutputStream();
            SDataOutputStream dataOutputStream = new SDataOutputStream(os, agent.getProtocolVersion());
            if (agent.getAgentProperties().isTlsActivated()) {
                s = SocketFactory.upgradeToTLS(s);
            }
            dataOutputStream.write(86);
            int protocolVersion = agent.getProtocolVersion();
            dataOutputStream.writeInt(protocolVersion);
            dataOutputStream.write(70);
            dataOutputStream.writeUTF(agent.getAgentID());
            dataOutputStream.write(49);
            char a = (char)is.read();
            switch (a) {
                case '0': 
                case '2': 
                case '7': {
                    isOK = true;
                    RTLogger.print(1, "MAIN server is back (P-ok).");
                    return isOK;
                }
                default: {
                    throw new RuntimeException("not boom server is running remote port?");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return isOK;
        }
        finally {
            SocketUtils.closeSocket(s, new AutoCloseable[0]);
        }
    }

    @Override
    public boolean onInit() throws Exception {
        return true;
    }

    @Override
    public boolean onStartRun() {
        return true;
    }

    @Override
    public boolean onGetData() {
        if (this.checkHB(AgentEngine.getInstance().getServers().getMainServer())) {
            AgentEngine.getInstance().getServers().fallbackSwitchServer();
            AgentEngine.getInstance().getScheduler().removeTask(NAME);
        }
        return true;
    }

    @Override
    public boolean onStopRun() {
        return true;
    }

    @Override
    protected boolean onStopTask() {
        return true;
    }

    @Override
    public boolean refresh() {
        return true;
    }
}

