/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.log.RTLogger;
import com.blixx.shared.Cryptor;
import com.blixx.shared.io.SDataInputStream;
import com.sun.net.ssl.HostnameVerifier;
import com.sun.net.ssl.internal.ssl.Provider;
import com.sun.net.ssl.internal.www.protocol.https.HttpsURLConnectionOldImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpRequest;

public class HTTPOut {
    public static final int SC_PROXY_AUTHENTICATION_REQUIRED = 407;
    Proxy m_proxy = null;
    AgentEngine m_ha = null;
    int m_connectionTimeout = 10000;
    int m_soTimeout = 120000;
    int m_lastResponse = 0;
    String m_sessionID = null;
    private Authenticator m_authenticator;
    private ClientConnectionManager m_clientConnectionManager;

    public HTTPOut(Proxy proxy, AgentEngine ae, int connectionTimeout, int soTimeout) {
        this.m_proxy = proxy;
        this.m_connectionTimeout = connectionTimeout;
        this.m_soTimeout = soTimeout;
        this.m_ha = ae;
    }

    public SDataInputStream sendData(String urlSuffix, String session, byte[] encodedData) throws Exception {
        return this._sendDataApache(urlSuffix, session, encodedData);
    }

    private SDataInputStream _sendDataApache(String urlSuffix, String session, byte[] encodedData) throws Exception, IOException {
        AbstractHttpClient httpclient = null;
        try {
            if (this.m_clientConnectionManager == null) {
                this.initClientConnectionManagerApache();
            }
            httpclient = this.getHttpClient();
            HttpPost httpPOST = new HttpPost(urlSuffix);
            this.setDefaultApache(httpPOST);
            if (encodedData != null && encodedData.length > 0) {
                httpPOST.setEntity(new ByteArrayEntity(encodedData));
            }
            if (session != null) {
                httpPOST.setHeader("BOOMAGENTSESSIONID", session);
            }
            HttpHost targetHost = new HttpHost(this.m_ha.getServers().getCurrentServer().getHost(), this.m_ha.getServers().getCurrentServer().getPort(), this.m_ha.getAgentProperties().getCommType());
            long start = System.currentTimeMillis();
            HttpResponse response = httpclient.execute(targetHost, httpPOST);
            this.m_lastResponse = response.getStatusLine().getStatusCode();
            Header sessionheader = response.getFirstHeader("BOOMAGENTSESSIONID");
            this.m_sessionID = sessionheader != null ? sessionheader.getValue() : null;
            HttpEntity entity = response.getEntity();
            byte[] result = this.read(entity.getContent(), entity.getContentLength());
            ByteArrayInputStream bis = new ByteArrayInputStream(result);
            entity.getContent().close();
            SDataInputStream sDataInputStream = new SDataInputStream(bis);
            return sDataInputStream;
        }
        catch (RuntimeException e) {
            RTLogger.print(3, "", e);
            throw e;
        }
        catch (Exception e) {
            RTLogger.print(3, "", e);
            throw e;
        }
        finally {
            httpclient.getConnectionManager().closeIdleConnections(20L, TimeUnit.SECONDS);
            httpclient.getConnectionManager().closeExpiredConnections();
        }
    }

    private DefaultHttpClient getHttpClient() {
        DefaultHttpClient httpclient = new DefaultHttpClient(this.m_clientConnectionManager);
        if (this.m_ha.getAgentProperties().getProxyType() != null) {
            NTCredentials credentials = new NTCredentials(this.m_ha.getAgentProperties().getProxyUser() + ':' + Cryptor.decrypt(this.m_ha.getAgentProperties().getProxyEnPass()));
            String domain = credentials.getDomain();
            if (domain == null) {
                domain = "";
            }
            credentials = new NTCredentials(credentials.getUserName(), credentials.getPassword(), this.m_ha.getAgentHostname(), domain);
            httpclient.getCredentialsProvider().setCredentials(new AuthScope(this.m_ha.getAgentProperties().getProxyHost(), this.m_ha.getAgentProperties().getProxyPort(), AuthScope.ANY_REALM), credentials);
            HttpHost proxy = new HttpHost(this.m_ha.getAgentProperties().getProxyHost(), this.m_ha.getAgentProperties().getProxyPort());
            httpclient.getParams().setParameter("http.route.default-proxy", proxy);
        }
        if (this.m_sessionID != null) {
            httpclient.getParams().setParameter("BOOMAGENTSESSIONID", this.m_sessionID);
        } else {
            httpclient.getParams().removeParameter("BOOMAGENTSESSIONID");
        }
        httpclient.getParams().setParameter("http.socket.timeout", new Integer(this.m_soTimeout));
        httpclient.getParams().setParameter("http.socket.linger", new Integer(0));
        httpclient.getParams().setParameter("http.connection.timeout", new Integer(this.m_connectionTimeout));
        httpclient.getParams().setParameter("http.useragent", "BOOMAgent/5.0");
        return httpclient;
    }

    private void initClientConnectionManagerApache() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, KeyManagementException, UnrecoverableKeyException, Exception {
        SchemeRegistry registry = new SchemeRegistry();
        if ("HTTP".equalsIgnoreCase(this.m_ha.getAgentProperties().getCommType())) {
            registry.register(new Scheme("http", this.m_ha.getServers().getCurrentServer().getPort(), PlainSocketFactory.getSocketFactory()));
            if (this.m_ha.getAgentProperties().getProxyType() != null) {
                try {
                    registry.register(new Scheme("http", this.m_ha.getAgentProperties().getProxyPort(), PlainSocketFactory.getSocketFactory()));
                }
                catch (Throwable e) {
                    RTLogger.print(1, "HTTP initialization", e);
                }
            }
        } else if ("HTTPS".equalsIgnoreCase(this.m_ha.getAgentProperties().getCommType())) {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, HTTPOut.getTrustManagers(), new SecureRandom());
            SSLSocketFactory sf = new SSLSocketFactory(sc);
            sf.setHostnameVerifier(new X509HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslsession) {
                    return true;
                }

                @Override
                public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                }

                @Override
                public void verify(String host, X509Certificate cert) throws SSLException {
                }

                @Override
                public void verify(String host, SSLSocket ssl) throws IOException {
                }
            });
            registry.register(new Scheme("https", this.m_ha.getServers().getCurrentServer().getPort(), sf));
            if (this.m_ha.getAgentProperties().getProxyType() != null) {
                registry.register(new Scheme("https", this.m_ha.getAgentProperties().getProxyPort(), sf));
                registry.register(new Scheme("http", this.m_ha.getAgentProperties().getProxyPort(), PlainSocketFactory.getSocketFactory()));
            }
        } else {
            throw new Exception("Unsupported communication protocol: " + this.m_ha.getAgentProperties().getCommType());
        }
        PoolingClientConnectionManager clientConnectionManager = new PoolingClientConnectionManager(registry, 10L, TimeUnit.SECONDS);
        clientConnectionManager.setDefaultMaxPerRoute(4);
        this.m_clientConnectionManager = clientConnectionManager;
    }

    @Deprecated
    private SDataInputStream _sendData(String urlSuffix, String session, byte[] encodedData) throws Exception, IOException {
        int len;
        this.m_lastResponse = 0;
        this.m_sessionID = null;
        URLConnection conn = this.getUrlConnection(urlSuffix);
        this.setDefault(conn);
        if (session != null) {
            conn.setRequestProperty("BOOMAGENTSESSIONID", session);
        }
        try {
            len = this.sendRequest(conn, encodedData);
        }
        catch (ReconnectMeException e) {
            len = this._authenticateAndSendData(conn, session, encodedData);
        }
        byte[] result = this.read(conn.getInputStream(), len);
        this.m_sessionID = conn.getHeaderField("BOOMAGENTSESSIONID");
        this.disconnect(conn);
        ByteArrayInputStream bis = new ByteArrayInputStream(result);
        return new SDataInputStream(bis);
    }

    protected int _authenticateAndSendData(URLConnection conn, String session, byte[] encodedData) throws Exception {
        this.m_lastResponse = 0;
        this.m_sessionID = null;
        String urlPrev = conn.getURL().toString();
        String proxyAuthRequest = conn.getHeaderField("Proxy-Authenticate");
        this.disconnect(conn);
        BasicHttpRequest request = new BasicHttpRequest("POST", urlPrev);
        DigestScheme ds = new DigestScheme(ChallengeState.PROXY);
        BasicHeader incomingHeader = new BasicHeader("Proxy-Authenticate", proxyAuthRequest);
        ds.processChallenge(incomingHeader);
        Header authHeaderResponse = ds.authenticate(new UsernamePasswordCredentials(this.m_ha.getAgentProperties().getProxyUser(), Cryptor.decrypt(this.m_ha.getAgentProperties().getProxyEnPass())), request, null);
        URL url = new URL(urlPrev);
        conn = url.openConnection(this.m_proxy);
        conn.setAllowUserInteraction(true);
        this.setDefault(conn);
        if (session != null) {
            conn.setRequestProperty("BOOMAGENTSESSIONID", session);
        }
        conn.setRequestProperty(authHeaderResponse.getName(), authHeaderResponse.getValue());
        return this.sendRequest(conn, encodedData);
    }

    protected int sendRequest(URLConnection conn, byte[] data) throws Exception {
        int len = 0;
        try {
            block16: {
                if (conn instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)conn).setRequestMethod("POST");
                } else if (conn instanceof HttpsURLConnectionOldImpl) {
                    ((HttpsURLConnectionOldImpl)conn).setRequestMethod("POST");
                }
                if (data == null) {
                    conn.setRequestProperty("Content-length", "0");
                } else {
                    conn.setRequestProperty("Content-length", String.valueOf(data.length));
                }
                conn.setRequestProperty("Content-Type", "application/octet-stream");
                try {
                    conn.connect();
                }
                catch (IOException e) {
                    if (conn instanceof HttpsURLConnection) {
                        this.m_lastResponse = ((HttpsURLConnection)conn).getResponseCode();
                    } else if (conn instanceof HttpsURLConnectionOldImpl) {
                        this.m_lastResponse = ((HttpsURLConnectionOldImpl)conn).getResponseCode();
                    }
                    if (this.m_lastResponse != 407) break block16;
                    throw new ReconnectMeException();
                }
            }
            if (data != null && data.length != 0) {
                conn.getOutputStream().write(data);
                conn.getOutputStream().flush();
            }
            if (conn instanceof HttpsURLConnection) {
                this.m_lastResponse = ((HttpsURLConnection)conn).getResponseCode();
                len = ((HttpsURLConnection)conn).getContentLength();
            } else if (conn instanceof HttpsURLConnectionOldImpl) {
                this.m_lastResponse = ((HttpsURLConnectionOldImpl)conn).getResponseCode();
                len = ((HttpsURLConnectionOldImpl)conn).getContentLength();
            }
        }
        catch (Exception e) {
            RTLogger.print(3, "", e);
            throw e;
        }
        return len;
    }

    protected URLConnection getUrlConnection(String urlPath) throws Exception {
        URLConnection conn = null;
        StringBuffer sb = new StringBuffer(30);
        sb.append("https://").append(this.m_ha.getServers().getCurrentServer().getHost()).append(':').append(this.m_ha.getServers().getCurrentServer().getPort()).append(urlPath);
        URL url = new URL(sb.toString());
        try {
            if (this.m_authenticator == null && this.m_ha.getAgentProperties().getProxyUser() != null && this.m_ha.getAgentProperties().getProxyEnPass() != null) {
                this.m_authenticator = new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(HTTPOut.this.m_ha.getAgentProperties().getProxyUser(), Cryptor.decrypt(HTTPOut.this.m_ha.getAgentProperties().getProxyEnPass()).toCharArray());
                    }
                };
                Authenticator.setDefault(this.m_authenticator);
            }
            conn = url.openConnection(this.m_proxy);
        }
        catch (Throwable e) {
            sb = new StringBuffer();
            sb.append("https://").append(this.m_ha.getServers().getCurrentServer().getPublicIP()).append(':').append(this.m_ha.getServers().getCurrentServer().getPort()).append(urlPath);
            url = new URL(sb.toString());
            try {
                conn = url.openConnection(this.m_proxy);
            }
            catch (Throwable e1) {
                RTLogger.print(1, sb);
                RTLogger.print(1, "IP based connection failed", e1);
                RTLogger.print(2, "Host based connection failed", e);
            }
        }
        this.setDefault(conn);
        return conn;
    }

    protected void disconnect(URLConnection conn) {
        if (conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).disconnect();
        } else if (conn instanceof HttpsURLConnectionOldImpl) {
            ((HttpsURLConnectionOldImpl)conn).disconnect();
        }
    }

    protected void setDefault(URLConnection conn) {
        conn.setConnectTimeout(this.m_connectionTimeout);
        conn.setReadTimeout(this.m_soTimeout);
        conn.setRequestProperty("User-Agent", "BOOMAgent/5.0");
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.addRequestProperty("BOOMAGENTID", this.m_ha.getAgentID());
        conn.addRequestProperty("BOOMAGENTHOST", this.m_ha.getAgentHostname());
        conn.addRequestProperty("BOOMAGENTIPLOCAL", this.m_ha.getAgentIP());
        conn.addRequestProperty("BOOMAGENTOSNAME", this.m_ha.getAgentOS());
        conn.addRequestProperty("BOOMAGENTPORT", "" + this.m_ha.getAgentPort());
        conn.addRequestProperty("BOOMAGENTVERSION", this.m_ha.getAgentVersion());
        conn.addRequestProperty("BOOMAGENTPROXY", this.m_ha.getAgentProperties().getProxyHost());
        conn.addRequestProperty("random", "" + System.currentTimeMillis());
    }

    protected void setDefaultApache(AbstractHttpMessage getOrPost) {
        getOrPost.getParams().setParameter("http.socket.timeout", new Integer(this.m_soTimeout));
        getOrPost.setHeader("BOOMAGENTID", this.m_ha.getAgentID());
        getOrPost.setHeader("BOOMAGENTHOST", this.m_ha.getAgentHostname());
        getOrPost.setHeader("BOOMAGENTIPLOCAL", this.m_ha.getAgentIP());
        getOrPost.setHeader("BOOMAGENTOSNAME", this.m_ha.getAgentOS());
        getOrPost.setHeader("BOOMAGENTPORT", "" + this.m_ha.getAgentPort());
        getOrPost.setHeader("BOOMAGENTVERSION", this.m_ha.getAgentVersion());
        getOrPost.setHeader("BOOMAGENTPROXY", this.m_ha.getAgentProperties().getProxyHost());
        getOrPost.setHeader("random", "" + System.currentTimeMillis());
    }

    protected byte[] read(InputStream inputStream, long length) throws IOException {
        byte[] arr = new byte[64000];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int len = -1;
        while ((long)bos.size() < length && (len = inputStream.read(arr)) != -1) {
            if (bos.size() != 0 || len > 3) {
                // empty if block
            }
            bos.write(arr, 0, len);
        }
        return bos.toByteArray();
    }

    public int getLastResponse() {
        return this.m_lastResponse;
    }

    public String getLastSessionID() {
        return this.m_sessionID;
    }

    protected static void trustAllHttpsCertificates() throws Exception {
        Security.addProvider((java.security.Provider)new Provider());
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(new X509KeyManager[0], HTTPOut.getTrustManagers(), new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnectionOldImpl.setDefaultSSLSocketFactory((javax.net.ssl.SSLSocketFactory)sc.getSocketFactory());
        javax.net.ssl.HostnameVerifier hv = HTTPOut.getHostVerifier();
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
        HttpsURLConnectionOldImpl.setDefaultHostnameVerifier((HostnameVerifier)new HostnameVerifier(){

            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }

            public boolean verify(String urlHostname, String certHostname) {
                return true;
            }
        });
    }

    private static javax.net.ssl.HostnameVerifier getHostVerifier() {
        javax.net.ssl.HostnameVerifier hv = new javax.net.ssl.HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }

            public boolean verify(String urlHostname, String certHostname) {
                return true;
            }
        };
        return hv;
    }

    public static TrustManager[] getTrustManagers() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){
            protected X509Certificate[] accepted = null;

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return this.accepted;
            }

            public boolean isServerTrusted(X509Certificate[] certs) {
                return true;
            }

            public boolean isClientTrusted(X509Certificate[] certs) {
                Object t = null;
                return true;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                this.accepted = chain;
            }
        }};
        return trustAllCerts;
    }

    static {
        try {
            HTTPOut.trustAllHttpsCertificates();
        }
        catch (Exception e) {
            RTLogger.print(3, "", e);
        }
    }

    public static class ReconnectMeException
    extends Exception {
        public ReconnectMeException() {
        }

        public ReconnectMeException(String message, Throwable cause) {
            super(message, cause);
        }

        public ReconnectMeException(String message) {
            super(message);
        }

        public ReconnectMeException(Throwable cause) {
            super(cause);
        }
    }
}

