/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AbstractMonTask;
import com.blixx.agent.AgentEngine;
import com.blixx.agent.Env;
import com.blixx.agent.MonParser;
import com.blixx.agent.MonitorValue;
import com.blixx.agent.NullMessageSubmitter;
import com.blixx.agent.NullMonSubmitter;
import com.blixx.agent.SendPerfToServer;
import com.blixx.agent.Tracker;
import com.blixx.ext.ILookup;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitor;
import com.blixx.ext.IMonitorExt;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.log.RTLogger;
import com.blixx.sa.BMClassLoader;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.Interval;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.exceptions.JavaMonitorExeption;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

public class JavaMonTask
extends AbstractMonTask {
    public static final NullMessageSubmitter NULL_MESSAGE_SUBMITTER = new NullMessageSubmitter();
    public static final String NOPERF = "NOPERF";
    private Class m_monitor = null;
    private ArrayList<IMonitor> m_instances = new ArrayList();
    private ArrayList<String> m_hosts = new ArrayList();
    private ArrayList<String> m_objects = new ArrayList();
    private String[] m_parameters = null;
    private boolean m_isHybrid = false;
    private String m_policyName = null;
    public AbstractPolicy m_policy = null;

    public JavaMonTask(MsgPolicy pol) throws JavaMonitorExeption {
        super(pol.getName());
        this.m_policy = pol;
        this.setInterval(Interval.parseInterval(pol.getIntervalStr(), 60));
        this.setType(1);
        this.m_policyName = pol.getName();
        this.m_isHybrid = true;
        try {
            this.m_parameters = pol.getParameters();
            this.initJavaMonitor(pol.getName(), pol.getBinary(), this.m_parameters);
        }
        catch (Throwable e) {
            RTLogger.print(3, "JAVAMON_INIT: ", e);
            if (e instanceof JavaMonitorExeption) {
                throw (JavaMonitorExeption)e;
            }
            throw new JavaMonitorExeption("Java Monitor can't be initialized");
        }
    }

    public JavaMonTask(Policy pol) throws JavaMonitorExeption {
        super(pol.getName());
        this.m_policyName = pol.getName();
        this.m_policy = pol;
        this.setInterval(Interval.parseInterval(pol.getIntervalStr(), 60));
        this.setType(1);
        try {
            String str = pol.getMonprog();
            int fisrtSpace = str.indexOf(" ");
            int firstNL = str.indexOf(10);
            String parameters = null;
            if (fisrtSpace == -1 || firstNL != -1) {
                String[] params = new String[]{};
                String className = str;
                if (str.indexOf(10) != -1) {
                    str = str.replace("\r", "");
                    String[] all = str.split("[\n]");
                    className = all[0];
                    if (all.length > 1) {
                        params = new String[all.length - 1];
                        for (int i = 1; i < all.length; ++i) {
                            params[i - 1] = all[i];
                        }
                    }
                }
                this.m_parameters = params;
                this.initJavaMonitor(pol.getName(), className, this.m_parameters);
            } else {
                String className = str.substring(0, fisrtSpace);
                parameters = str.substring(fisrtSpace + 1);
                this.m_parameters = new String[]{parameters};
                this.initJavaMonitor(pol.getName(), className, this.m_parameters);
            }
        }
        catch (Throwable e) {
            RTLogger.print(3, "JAVAMON_INIT: ", e);
            if (e instanceof JavaMonitorExeption) {
                throw (JavaMonitorExeption)e;
            }
            throw new JavaMonitorExeption("Java Monitor can't be initialized");
        }
    }

    public String getClassName() {
        return "" + this.m_monitor.getName();
    }

    private void initJavaMonitor(String monName, String className, String[] parameters) throws JavaMonitorExeption {
        try {
            String pdca;
            int pipe = className.indexOf(124);
            if (pipe != -1 && (pdca = (className = className.substring(0, pipe)).substring(pipe + 1)).trim().equalsIgnoreCase(NOPERF)) {
                this.m_isPerformanceCollectionActivated = false;
            }
            className = className.trim();
            monName = monName.trim();
            this.m_monitor = BMClassLoader.findClass2(className);
            Thread.currentThread().setContextClassLoader(BMClassLoader.getInstance());
            if (!(IMonitor.class.isAssignableFrom(this.m_monitor) || IMonitorExt.class.isAssignableFrom(this.m_monitor) || IMonitorExtPerf.class.isAssignableFrom(this.m_monitor))) {
                throw new JavaMonitorExeption("JM002 Class " + className + " is invalid. Must implement at least IMonitor interface.");
            }
            try {
                this.onInit();
            }
            catch (Exception e1) {
                throw new JavaMonitorExeption("JM008 onInit exec failed.");
            }
            if ((this.m_flagMask & 4) != 0 || (this.m_flagMask & 8) != 0) {
                String origTextObj = null;
                String[] objects = new String[]{""};
                if ((this.m_flagMask & 4) != 0) {
                    origTextObj = (String)this.m_onObjects.keySet().iterator().next();
                    objects = (String[])this.m_onObjects.get(origTextObj);
                }
                String origTextNode = null;
                String[] nodes = new String[]{AgentEngine.getInstance().getAgentHostname()};
                if ((this.m_flagMask & 8) != 0) {
                    origTextNode = (String)this.m_onNodes.keySet().iterator().next();
                    nodes = (String[])this.m_onNodes.get(origTextNode);
                }
                for (int i = 0; i < nodes.length; ++i) {
                    for (int j = 0; j < objects.length; ++j) {
                        String[] nParameters = new String[parameters.length];
                        for (int k = 0; k < parameters.length; ++k) {
                            nParameters[k] = parameters[k];
                            if (origTextObj != null) {
                                nParameters[k] = nParameters[k].replace(origTextObj, objects[j]);
                            }
                            if (origTextNode == null) continue;
                            nParameters[k] = nParameters[k].replace(origTextNode, nodes[i]);
                        }
                        this.createMonitor(monName, nParameters, nodes[i], objects[j]);
                    }
                }
            } else {
                this.createMonitor(monName, parameters, null, null);
            }
        }
        catch (UnsupportedClassVersionError bv) {
            throw new JavaMonitorExeption("JM016 " + bv.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new JavaMonitorExeption("JM001 Class " + className + " not found.");
        }
    }

    private void createMonitor(String monName, String[] parameters, String host, String object) throws JavaMonitorExeption {
        try {
            Method m = null;
            try {
                m = this.m_monitor.getMethod("getInstance", String.class, String[].class);
                IMonitor instance = (IMonitor)m.invoke(null, monName, parameters);
                this.m_instances.add(instance);
                this.m_hosts.add(host);
                this.m_objects.add(object);
                try {
                    this.setMessageSubmitter(instance);
                    if (instance instanceof IMonitorExt) {
                        ((IMonitorExt)instance).setInterval(this.getInterval());
                        ((IMonitorExt)instance).setMonitorSubmitter(this);
                    }
                    if (instance instanceof IMonitorExtPerf) {
                        ((IMonitorExtPerf)instance).setPerfSubmitter(this);
                    }
                }
                catch (Throwable te) {
                    RTLogger.print(2, "JM009 ", te);
                    throw new JavaMonitorExeption("JM009 Monitor does not support Monitor submitter. " + this.getClassName());
                }
                if (ILookup.class.isAssignableFrom(this.m_monitor)) {
                    ((Env)Env.getInstance()).registerLookupService((ILookup)((Object)instance));
                }
            }
            catch (NoSuchMethodException e) {
                m = this.m_monitor.getMethod("getInstance", String.class, String.class);
                StringBuffer inBuff = new StringBuffer();
                for (int i = 0; i < parameters.length; ++i) {
                    inBuff.append(parameters[i]).append(' ');
                }
                IMonitor instance = (IMonitor)m.invoke(null, monName, inBuff.toString().trim());
                this.m_instances.add(instance);
                this.m_hosts.add(host);
                this.m_objects.add(object);
                try {
                    instance.setMessageSubmitter(AgentEngine.getInstance());
                    if (instance instanceof IMonitorExt) {
                        ((IMonitorExt)instance).setInterval(this.getInterval());
                        ((IMonitorExt)instance).setMonitorSubmitter(this);
                    }
                    if (instance instanceof IMonitorExtPerf) {
                        ((IMonitorExtPerf)instance).setPerfSubmitter(this);
                    }
                }
                catch (Throwable te) {
                    RTLogger.print(2, "JM007 ", te);
                    throw new JavaMonitorExeption("JM007 Does not support Message submitter. " + this.getClassName());
                }
            }
        }
        catch (SecurityException e) {
            throw new JavaMonitorExeption("JM003 security exception on getInstance");
        }
        catch (NoSuchMethodException e) {
            throw new JavaMonitorExeption("JM004 None of 2 acceptable getInstance methods are implemented");
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                throw new JavaMonitorExeption("JM005 method invocation failed.\n->" + e.getTargetException().getMessage() + "\nCaused by:\n" + this.getStackTrace(e.getTargetException()));
            }
            throw new JavaMonitorExeption("JM005 method invocation failed");
        }
        catch (IllegalAccessException e) {
            throw new JavaMonitorExeption("JM006 IllegalAccessException");
        }
    }

    private void setMessageSubmitter(IMonitor instance) {
        IMessage submitter = NULL_MESSAGE_SUBMITTER;
        if (this.m_policy.isEnabledCheckRuntime(Env.getInstance()) && !this.m_policy.isDeactivationTime(System.currentTimeMillis())) {
            submitter = AgentEngine.getInstance();
        }
        instance.setMessageSubmitter(submitter);
    }

    @Override
    public boolean onGetData() {
        if (!(this.m_isHybrid && (this.m_monitor.getSimpleName().startsWith("LogFile") || this.m_monitor.getSimpleName().startsWith("MPathLogFile")) || this instanceof NullMonSubmitter || this.m_policy.isEnabledCheckRuntime(Env.getInstance()) && !this.m_policy.isDeactivationTime(System.currentTimeMillis()))) {
            return true;
        }
        for (int i = 0; i < this.m_instances.size(); ++i) {
            this.m_host = this.m_hosts.get(i);
            this.m_object = this.m_objects.get(i);
            this.runMonitor(this.m_instances.get(i));
        }
        return true;
    }

    private void runMonitor(IMonitor instance) {
        try {
            String result = instance.runMonitor();
            if (result != null) {
                if (this.m_isHybrid) {
                    if (!this.m_monitor.getSimpleName().startsWith("LogFile") && !this.m_monitor.getSimpleName().startsWith("MPathLogFile")) {
                        this.doMessage(result);
                    } else {
                        MonitorValue mv = new MonitorValue(0.0, System.currentTimeMillis(), this.m_policyName, "");
                        AgentEngine.getInstance().getSubmitter().submit(mv);
                    }
                } else {
                    MonParser mp = new MonParser();
                    if (result.indexOf(10) != -1) {
                        String[] arr = result.split("\\Q\n\\E");
                        for (int i = 0; i < arr.length; ++i) {
                            if (arr[i].trim().length() < 0) continue;
                            this.submitValue(arr[i], mp);
                        }
                    } else {
                        this.submitValue(result, mp);
                    }
                }
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(2, "", e);
            AgentEngine.getInstance().sendMessage(AgentEngine.getInstance().getAgentHostname(), "BOOM_AGENT", "JAVA_MONITOR", this.m_policyName, "Java monitor failed during execution.\n" + e.getMessage() + "\n" + this.getStackTrace(e), "minor", null);
        }
    }

    private void doMessage(String result) {
        MonitorValue mv = new MonitorValue(0.0, System.currentTimeMillis(), this.m_policyName, "");
        AgentEngine.getInstance().getSubmitter().submit(mv);
        String msg = result;
        if (msg.length() > 2048) {
            msg = msg.substring(0, 2042) + "@MAX@";
        }
        RTLogger.print(6, "NAGIN OUT: " + msg);
        String severity = "unknown";
        HashMap<String, String> optVars = new HashMap<String, String>();
        optVars.put("POLICY_NAME", this.m_policyName);
        if (this.m_parameters != null && this.m_parameters.length > 1) {
            optVars.put("POLICY_CALL", this.m_parameters[0]);
        }
        AgentEngine.getInstance().sendMessage(AgentEngine.getInstance().getAgentHostname(), "NAGIN", "NAGIN", "", msg, severity, optVars);
    }

    private void submitValue(String result, MonParser mp) {
        MonitorValue mv = mp.parse(result);
        if (mv != null) {
            RTLogger.print(3, "mon value received. {" + result + "}");
            if (this.m_host != null) {
                mv.p10_node = this.m_host;
            }
            if (this.m_object != null) {
                mv.p3_object = this.m_object;
            }
            AgentEngine.getInstance().getSubmitter().submit(mv);
        } else {
            RTLogger.print(3, "mon value has wrong format. {" + result + "}");
        }
    }

    @Override
    public boolean onInit() throws Exception {
        if (this.m_parameters != null) {
            for (int i = 0; i < this.m_parameters.length; ++i) {
                this.m_parameters[i] = this.m_parameters[i].replaceAll("\\Q<$NAME>\\E", this.getName());
                this.m_parameters[i] = this.m_parameters[i].replaceAll("\\Q<$INTERVAL>\\E", "" + this.getInterval() / 1000L);
                this.m_parameters[i] = this.replaceGlobalVariables(this.m_parameters[i]);
                int flagMask = this.fillInitStartExecs(this.m_parameters[i]);
                if (flagMask > 0) {
                    if ((flagMask & 1) != 0) {
                        this.m_parameters[i] = this.resolvePreExecs(this.getOnInitExec(), this.m_parameters[i], "onInit", AgentEngine.getInstance().FILE_SPI_DIR);
                    }
                    if ((flagMask & 0x10) != 0) {
                        this.m_parameters[i] = this.resolvePreExecs(this.getTriggerExec(), this.m_parameters[i], "trigger", AgentEngine.getInstance().FILE_SPI_DIR);
                    }
                    if ((flagMask & 0x20) != 0) {
                        this.m_parameters[i] = this.resolvePreExecs(this.getStopperExec(), this.m_parameters[i], "stopper", AgentEngine.getInstance().FILE_SPI_DIR);
                    }
                }
                this.m_flagMask |= flagMask;
            }
        }
        return true;
    }

    @Override
    public boolean onStartRun() {
        if (this.m_policy.isEnabledCheckRuntime(Env.getInstance()) && !this.m_policy.isDeactivationTime(System.currentTimeMillis())) {
            RTLogger.print(5, "Start monitor " + this.getName());
            long expirationTime = System.currentTimeMillis() + this.getInterval() - 1000L;
            Tracker.registerLastMonitorCall(this.getName(), expirationTime);
        }
        for (int i = 0; i < this.m_instances.size(); ++i) {
            this.setMessageSubmitter(this.m_instances.get(i));
        }
        return true;
    }

    @Override
    public boolean onStopRun() {
        RTLogger.print(5, "Stop monitor " + this.getName());
        if (!this.m_policy.isEnabledCheckRuntime(Env.getInstance()) || this.m_policy.isDeactivationTime(System.currentTimeMillis())) {
            long expirationTime = System.currentTimeMillis() + this.getInterval() + 50000L;
            Tracker.unregisterMonitor(this.getName(), expirationTime);
        }
        if (this.m_perfDataArray.size() > 0) {
            SendPerfToServer sts = new SendPerfToServer();
            sts.enqueuePerfRecord(this.m_perfDataArray);
            this.m_perfDataArray.clear();
        }
        return true;
    }

    @Override
    protected boolean onStopTask() {
        for (int i = 0; i < this.m_instances.size(); ++i) {
            IMonitor iMonitor = this.m_instances.get(i);
            try {
                iMonitor.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (!(iMonitor instanceof ILookup)) continue;
                ((Env)Env.getInstance()).unregisterLookupService(((ILookup)((Object)iMonitor)).getName());
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public boolean refresh() {
        return true;
    }

    public String getStackTrace(Throwable e) {
        StringBuffer sb = new StringBuffer();
        if (e != null) {
            sb.append(e.getClass()).append(": ");
            StackTraceElement[] els = e.getStackTrace();
            if (els != null) {
                for (int i = 0; i < els.length; ++i) {
                    sb.append(els[i].toString()).append('\n');
                }
            }
        }
        return sb.toString();
    }
}

