/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.MMObject;
import com.blixx.agent.utils.SupportedVariables;
import com.blixx.log.RTLogger;
import com.blixx.sa.Opts;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.Severity;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;

public class Message
extends MMObject {
    public static final String CONCATENATOR_ATAT = "@@";
    public String m_orig_text = null;
    public boolean m_internalMsg = false;
    public String m_tempPolicyName = null;

    @Deprecated
    public Message(String uuid) {
        this.p00_uuid = uuid;
    }

    public Message() {
        this.genUUID();
        this.p1_time = System.currentTimeMillis();
    }

    public Message(String appl, String obj, String msg_text, long time) {
        this();
        this.p1_time = time;
        this.p2_application = appl;
        if (this.p2_application != null && this.p2_application.length() > 1024) {
            this.p2_application = this.p2_application.substring(0, 1024);
        }
        this.p3_object = obj;
        if (this.p3_object != null && this.p3_object.length() > 1024) {
            this.p3_object = this.p3_object.substring(0, 1024);
        }
        this.p5_msg_text = msg_text;
        if (this.p5_msg_text != null && this.p5_msg_text.length() > 2048) {
            this.p5_msg_text = this.p5_msg_text.substring(0, 2048);
        }
        this.m_orig_text = this.p5_msg_text;
    }

    public void setOptional(String severity, String msggrp, String node) {
        if (severity != null) {
            this.p4_severity = Severity.getSeverity(severity);
        }
        this.p7_msg_grp = msggrp;
        if (this.p7_msg_grp != null && this.p7_msg_grp.length() > 1024) {
            this.p7_msg_grp = this.p7_msg_grp.substring(0, 1024);
        }
        this.p10_node = node;
        if (this.p10_node != null && this.p10_node.length() > 1024) {
            this.p10_node = this.p10_node.substring(0, 1024);
        }
    }

    public void setOptional(int severity, String msggrp, String node) {
        this.setOptional(Severity.getSeverity(severity), msggrp, node);
    }

    @Override
    public Object read(SDataInputStream dis) throws IOException {
        String type = null;
        this.p00_uuid = dis.readUTF();
        if (this.p00_uuid.length() > 36) {
            type = this.p00_uuid.substring(36);
            this.p00_uuid = this.p00_uuid.substring(0, 36);
        }
        this.p1_time = dis.readLong();
        this.p2_application = dis.readUTF();
        this.p3_object = dis.readUTF();
        this.p4_severity = dis.readInt();
        this.m_orig_text = this.p5_msg_text = dis.readUTF();
        this.p6_instructionID = dis.readUTF();
        this.p7_msg_grp = dis.readUTF();
        this.p8_messageKey = dis.readUTF();
        this.p9_ackKey = dis.readUTF();
        this.p10_node = dis.readUTF();
        this.p11_autoAction = dis.readUTF();
        this.p11_1_autoActionNode = dis.readUTF();
        this.p11_2_autoActionTimeout = dis.readInt();
        this.p12_source = dis.readUTF();
        this.p13_opAction = dis.readUTF();
        this.p21_typeA = dis.readInt();
        this.p22_typeK = dis.readInt();
        this.p23_deduplication = dis.readBoolean();
        if (type != null) {
            this.p30_state = "" + type.charAt(0);
            String optVars = type.substring(1);
            this.m_options = Opts.getFromString(optVars);
        }
        return this;
    }

    @Override
    public void send(SDataOutputStream dos) throws IOException {
        StringBuilder sb = new StringBuilder(this.p00_uuid);
        sb.append(this.p30_state);
        Opts.toString(sb, this.m_CAs);
        dos.writeUTF(sb.toString());
        dos.writeLong(this.p1_time);
        if (this.p2_application != null && this.p2_application.length() > 1024) {
            dos.writeUTF(this.p2_application.substring(0, 1024));
        } else {
            dos.writeUTF(this.p2_application);
        }
        if (this.p3_object != null && this.p3_object.length() > 1024) {
            dos.writeUTF(this.p3_object.substring(0, 1024));
        } else {
            dos.writeUTF(this.p3_object);
        }
        dos.writeInt(this.p4_severity);
        if (this.p5_msg_text != null && this.p5_msg_text.length() > 2048) {
            dos.writeUTF(this.p5_msg_text.substring(0, 2048));
        } else {
            dos.writeUTF(this.p5_msg_text);
        }
        dos.writeUTF(this.p6_instructionID);
        if (this.p7_msg_grp != null && this.p7_msg_grp.length() > 1024) {
            dos.writeUTF(this.p7_msg_grp.substring(0, 1024));
        } else {
            dos.writeUTF(this.p7_msg_grp);
        }
        if (this.p8_messageKey != null && this.p8_messageKey.length() > 1024) {
            dos.writeUTF(this.p8_messageKey.substring(0, 1024));
        } else {
            dos.writeUTF(this.p8_messageKey);
        }
        if (this.p9_ackKey != null && this.p9_ackKey.length() > 1024) {
            dos.writeUTF(this.p9_ackKey.substring(0, 1024));
        } else {
            dos.writeUTF(this.p9_ackKey);
        }
        if (this.p10_node != null && this.p10_node.length() > 255) {
            dos.writeUTF(this.p10_node.substring(0, 255));
        } else {
            dos.writeUTF(this.p10_node);
        }
        if (this.p11_autoAction != null && this.p11_autoAction.length() > 1024) {
            dos.writeUTF(this.p11_autoAction.substring(0, 1024));
        } else {
            dos.writeUTF(this.p11_autoAction);
        }
        if (this.p11_1_autoActionNode != null && this.p11_1_autoActionNode.length() > 255) {
            dos.writeUTF(this.p11_1_autoActionNode.substring(0, 255));
        } else {
            dos.writeUTF(this.p11_1_autoActionNode);
        }
        dos.writeInt(this.p11_2_autoActionTimeout);
        dos.writeUTF(this.p12_source);
        if (this.p13_opAction != null && this.p13_opAction.length() > 1024) {
            dos.writeUTF(this.p13_opAction.substring(0, 1024));
        } else {
            dos.writeUTF(this.p13_opAction);
        }
        dos.writeInt(this.p21_typeA);
        dos.writeInt(this.p22_typeK);
        dos.writeBoolean(this.p23_deduplication);
        dos.flush();
    }

    public String getFullMessage() {
        StringBuilder sb = new StringBuilder();
        this.groupOther(sb);
        sb.append(this.p5_msg_text);
        return sb.toString();
    }

    public String getOther() {
        StringBuilder sb = new StringBuilder();
        this.groupOther(sb);
        return sb.toString();
    }

    private void groupOther(StringBuilder sb) {
        sb.append(this.p10_node);
        sb.append(CONCATENATOR_ATAT);
        sb.append(this.p7_msg_grp);
        sb.append(CONCATENATOR_ATAT);
        sb.append(this.p2_application);
        sb.append(CONCATENATOR_ATAT);
        sb.append(this.p3_object);
        sb.append(CONCATENATOR_ATAT);
        sb.append(Severity.getSeverity(this.p4_severity));
        sb.append(CONCATENATOR_ATAT);
    }

    public Message getCopy(AbstractPolicy policy, MsgCondition mc) {
        String closemask;
        String key;
        SupportedVariables sv = new SupportedVariables();
        Message nm = new Message();
        nm.m_tempPolicyName = policy.getName();
        nm.p2_policyName = policy.getName();
        nm.m_orig_text = this.p5_msg_text;
        nm.putOptions("ORIG_APPLICATION", this.p2_application);
        nm.putOptions("ORIG_GROUP", this.p7_msg_grp);
        nm.putOptions("ORIG_OBJECT", this.p3_object);
        nm.putOptions("ORIG_NODE", this.p10_node);
        nm.p1_time = this.p1_time;
        nm.p6_instructionID = mc.getHelptextId();
        nm.putOptions(this.m_options);
        nm.p4_severity = this.p4_severity;
        if (mc.getSetSeverity() != null) {
            nm.p4_severity = Severity.getSeverity(mc.getSetSeverity());
        }
        String setApplication = mc.isOverrideApplication() ? sv.replaceAll(mc.getSetApplication(), nm) : sv.replaceAll(policy.getSetApplication(), nm);
        nm.p2_application = this.p2_application;
        if (setApplication != null && setApplication.trim().length() > 0) {
            nm.p2_application = sv.replaceAll(setApplication, nm);
        }
        String setMsggrp = mc.isOverrideGroup() ? sv.replaceAll(mc.getSetGroup(), nm) : sv.replaceAll(policy.getSetGroup(), nm);
        nm.p7_msg_grp = this.p7_msg_grp;
        if (setMsggrp != null && setMsggrp.trim().length() > 0) {
            nm.p7_msg_grp = sv.replaceAll(setMsggrp, nm);
        }
        nm.p3_object = this.p3_object;
        if (mc.isOverrideObject()) {
            nm.p3_object = sv.replaceAll(mc.getSetObject(), nm);
        }
        nm.p10_node = this.p10_node;
        if (mc.isOverrideNode()) {
            nm.p10_node = sv.replaceAll(mc.getSetNode(), nm);
        }
        nm.p5_msg_text = this.p5_msg_text;
        if (mc.isOverrideText()) {
            nm.p5_msg_text = sv.replaceAll(mc.getSetText(), nm);
        }
        String string = key = policy.getKey() == null ? "" : policy.getKey();
        if (mc.isOverrideKey()) {
            key = mc.getKey();
        }
        nm.p8_messageKey = sv.replaceAll(key, nm);
        String string2 = closemask = policy.getCloseMask() == null ? "" : policy.getCloseMask();
        if (mc.isOverrideCloseMask()) {
            closemask = mc.getCloseMask();
        }
        nm.p9_ackKey = sv.replaceAllForPattern(closemask, nm);
        if (mc.getAutoAction() != null && mc.getAutoAction().length() > 0) {
            nm.p11_autoAction = sv.replaceAll(mc.getAutoAction(), nm);
        } else if (this.m_internalMsg) {
            nm.p11_autoAction = this.p11_autoAction;
        }
        nm.p11_1_autoActionNode = mc.getAutoAction_Node();
        if (nm.p11_1_autoActionNode == null) {
            nm.p11_1_autoActionNode = "";
        }
        if (nm.p11_1_autoActionNode.length() > 0) {
            nm.p11_1_autoActionNode = sv.replaceAll(mc.getAutoAction_Node(), nm);
        }
        nm.p11_2_autoActionTimeout = mc.getAutoActionTimeout();
        nm.px_autoActionOnDuplicate = mc.getAutoActionOnDuplicate();
        if (this.m_internalMsg) {
            nm.p11_2_autoActionTimeout = this.p11_2_autoActionTimeout;
        }
        if (mc.getOpAction() != null && mc.getOpAction().length() > 0) {
            nm.p13_opAction = sv.replaceAll(mc.getOpAction(), nm);
        }
        nm.p21_typeA = mc.getTypeA();
        nm.p22_typeK = mc.getTypeK();
        nm.p23_deduplication = mc.isDedupl();
        if (mc.isDeduplKeyOnly() && nm.p8_messageKey != null && nm.p8_messageKey.length() > 0) {
            nm.m_CAs.put(Opts.DEDUPL_KEYONLY, "true");
            nm.p23_deduplicationKeyOnly = true;
        }
        if (mc.getAutoActionOnDuplicate() != 0) {
            nm.m_CAs.put(Opts.AUTOACTION_START_ON_DUPLICATE, "" + mc.getAutoActionOnDuplicate());
        }
        nm.setSource(mc.getAsSourceString(policy.getName()), mc.getCustomAttributes(), policy.getName());
        if (mc.getInstructionAction() != null && mc.getInstructionAction().length() > 0) {
            nm.m_CAs.put(Opts.INSTRUCTION_ACTION, sv.replaceAll_URLEncode(mc.getInstructionAction(), nm));
        }
        if (RTLogger.getCurrentLevel() >= 7) {
            RTLogger.print(7, "Source: " + nm.p12_source);
        }
        return nm;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("A=").append(this.p2_application).append(" O=").append(this.p3_object).append(" G=").append(this.p7_msg_grp).append(" N=").append(this.p10_node).append(" S=").append(this.p4_severity + " T=").append(this.p5_msg_text).append(" OPTS=").append(this.m_options);
        return sb.toString();
    }
}

