/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class MessageStormFilter {
    private Timer javaTimer;
    public static final long MINUTE_MILLIS = 60000L;
    private final ConcurrentHashMap<String, PolicyCfg> configs = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, PolicyFilter> filters = new ConcurrentHashMap();
    private FilterTimer timer;
    private PolicyCfg defaultCfg = null;

    public void start() {
        if (this.timer == null) {
            this.timer = new FilterTimer();
            this.javaTimer = new Timer("MessageStormFilter");
            this.javaTimer.scheduleAtFixedRate((TimerTask)this.timer, 60000L, 30000L);
        }
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.javaTimer != null) {
            this.javaTimer.cancel();
        }
    }

    public PolicyState getPolicyState(String policyName) {
        PolicyFilter f = this.filters.get(policyName);
        return f != null ? f.state : PolicyState.OK;
    }

    public void configurePolicy(String name, int maxMsgPerInt, int blockPeriod, int quarantinePeriod) {
        this.start();
        PolicyCfg cfg = new PolicyCfg();
        cfg.longThreshold = 5L * (long)maxMsgPerInt;
        cfg.shortThreshold = maxMsgPerInt;
        cfg.blockPeriod = 60000L * (long)blockPeriod;
        cfg.quarantinePeriod = 60000L * (long)quarantinePeriod;
        this.configs.put(name, cfg);
    }

    public void removePolicyCfg(String polName) {
        this.configs.remove(polName);
    }

    public void configureDefaults(int maxMsgPerInt, int blockPeriod, int quarantinePeriod) {
        if (maxMsgPerInt <= 0) {
            this.stop();
            return;
        }
        this.start();
        PolicyCfg cfg = new PolicyCfg();
        cfg.longThreshold = 5L * (long)maxMsgPerInt;
        cfg.shortThreshold = maxMsgPerInt;
        cfg.blockPeriod = 60000L * (long)blockPeriod;
        cfg.quarantinePeriod = 60000L * (long)quarantinePeriod;
        this.defaultCfg = cfg;
    }

    public PolicyState filterMessage(String policyName) {
        PolicyCfg cfg = this.getCfg(policyName);
        if (cfg == null) {
            return PolicyState.OK;
        }
        if (cfg.shortThreshold <= 0L) {
            return PolicyState.OK;
        }
        PolicyFilter f = this.filters.get(policyName);
        if (f == null) {
            f = new PolicyFilter(policyName);
            this.filters.put(policyName, f);
        }
        long shortRate = f.shortMsgCount.incrementAndGet();
        long longRate = f.longMsgCount.incrementAndGet();
        if (shortRate > cfg.shortThreshold || longRate > cfg.longThreshold) {
            this.stormDetected(f, cfg);
        }
        return f.state;
    }

    private void sendMsgNormal(String policy, PolicyState newState, String msg) {
        AgentEngine.getInstance().sendEmergency(msg, 1, "Storm Detection", policy);
    }

    private void sendMsgCritical(String policy, PolicyState newState, String msg) {
        AgentEngine.getInstance().sendEmergency(msg, 5, "Storm Detection", policy);
    }

    private void stormDetected(PolicyFilter f, PolicyCfg cfg) {
        if (f.state == PolicyState.OK) {
            f.state = PolicyState.BLOCKED;
            f.blockDate = System.currentTimeMillis() + cfg.blockPeriod;
            try {
                this.sendMsgCritical(f.name, f.state, "Policy blocked. Message Storm Detected");
            }
            catch (Throwable throwable) {}
        } else if (f.state == PolicyState.QUARANTINE) {
            f.blockDate = System.currentTimeMillis() + cfg.quarantinePeriod;
        }
    }

    private PolicyCfg getCfg(String name) {
        PolicyCfg cfg = this.configs.get(name);
        if (cfg == null) {
            cfg = this.defaultCfg;
        }
        if (cfg != null && cfg.shortThreshold <= 0L) {
            cfg = null;
        }
        return cfg;
    }

    class FilterTimer
    extends TimerTask {
        FilterTimer() {
        }

        @Override
        public void run() {
            for (PolicyFilter f : MessageStormFilter.this.filters.values()) {
                long now = System.currentTimeMillis();
                PolicyCfg cfg = MessageStormFilter.this.getCfg(f.name);
                if (cfg == null) continue;
                if (f.shortDate < now) {
                    f.shortMsgCount.set(0L);
                    f.shortDate = now + cfg.shortPeriod;
                }
                if (f.longDate < now) {
                    f.longMsgCount.set(0L);
                    f.longDate = now + cfg.longPeriod;
                }
                if (f.blockDate >= now) continue;
                switch (f.state) {
                    case BLOCKED: 
                    case QUARANTINE: {
                        f.state = PolicyState.OK;
                        f.shortMsgCount.set(0L);
                        f.longMsgCount.set(0L);
                        MessageStormFilter.this.sendMsgNormal(f.name, f.state, "Policy unblocked");
                        break;
                    }
                }
            }
        }
    }

    static class PolicyFilter {
        final String name;
        PolicyState state = PolicyState.OK;
        long longDate;
        long shortDate;
        long blockDate;
        AtomicLong longMsgCount = new AtomicLong(-1L);
        AtomicLong shortMsgCount = new AtomicLong(-1L);

        PolicyFilter(String name) {
            this.name = name;
        }
    }

    static class PolicyCfg {
        long longThreshold = 0L;
        long shortThreshold = 0L;
        long longPeriod = 600000L;
        long shortPeriod = 60000L;
        long blockPeriod = 300000L;
        long quarantinePeriod = 300000L;

        PolicyCfg() {
        }
    }

    public static enum PolicyState {
        OK,
        QUARANTINE,
        BLOCKED;

    }
}

