/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AbstractMonTask;
import com.blixx.agent.AgentEngine;
import com.blixx.agent.Env;
import com.blixx.agent.MonParser;
import com.blixx.agent.MonitorValue;
import com.blixx.agent.Tracker;
import com.blixx.log.RTLogger;
import com.blixx.sa.ExecResult;
import com.blixx.sa.ExecUtils;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.Interval;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.os.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class MonTask
extends AbstractMonTask {
    public String m_exec = null;
    public long m_lastStarted = 0L;
    public AbstractPolicy m_policy = null;

    public MonTask(MsgPolicy mp) {
        super(mp.getName());
        this.m_policy = mp;
        String exec = mp.getMonprog();
        this.setInterval(Interval.parseInterval(mp.getIntervalStr(), 60));
        if (exec == null || exec.length() == 0) {
            throw new RuntimeException("Nothing to execute.");
        }
        if (exec.charAt(0) == '#') {
            this.m_exec = exec.substring(1);
        } else {
            String spidir = AgentEngine.getInstance().DIR_MAIN + File.separator + "spi";
            this.m_exec = spidir + File.separator + exec;
            if (SystemUtils.OS == 1) {
                spidir = spidir.substring(0, 2) + "\"" + spidir.substring(2) + "\"";
                this.m_exec = spidir + File.separator + exec;
            }
        }
        String replace = this.m_exec.replace('\n', ' ');
        this.m_exec = replace = replace.replace("\r", "");
        try {
            this.onInit();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public MonTask(Policy pol) {
        super(pol.getName());
        this.m_policy = pol;
        this.setInterval(Interval.parseInterval(pol.getIntervalStr(), 60));
        if (pol.getMonprog() == null || pol.getMonprog().length() == 0) {
            throw new RuntimeException("Nothing to execute.");
        }
        if (pol.getMonprog().charAt(0) == '#') {
            this.m_exec = pol.getMonprog().substring(1);
        } else {
            String spidir = AgentEngine.getInstance().DIR_MAIN + File.separator + "spi";
            this.m_exec = spidir + File.separator + pol.getMonprog();
            if (SystemUtils.OS == 1) {
                spidir = spidir.substring(0, 2) + "\"" + spidir.substring(2) + "\"";
                this.m_exec = spidir + File.separator + pol.getMonprog();
            }
        }
        this.m_exec = this.m_exec.replaceAll("\\Q<$NAME>\\E", pol.getName());
        String replace = this.m_exec.replace('\n', ' ');
        this.m_exec = replace = replace.replace("\r", "");
        try {
            this.onInit();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public boolean onGetData() {
        if (!this.m_policy.isEnabledCheckRuntime(Env.getInstance()) || this.m_policy.isDeactivationTime(System.currentTimeMillis())) {
            return true;
        }
        String exec = this.m_exec;
        Map<String, String> onStart = this.getOnStartExec();
        if (onStart != null && onStart.size() > 0) {
            try {
                exec = this.resolvePreExecs(onStart, exec, "onStart", AgentEngine.getInstance().FILE_SPI_DIR);
            }
            catch (Throwable e) {
                AgentEngine.getInstance().sendInternalMessageDupl("Monitor failed to start.\n" + e.getMessage(), 2, "MONITOR", this.getName());
                return false;
            }
        }
        boolean isOK = false;
        if ((this.m_flagMask & 4) != 0 || (this.m_flagMask & 8) != 0) {
            String origTextObj = null;
            String[] objects = new String[]{""};
            if ((this.m_flagMask & 4) != 0) {
                origTextObj = (String)this.m_onObjects.keySet().iterator().next();
                objects = (String[])this.m_onObjects.get(origTextObj);
            }
            String origTextNode = null;
            String[] nodes = new String[]{AgentEngine.getInstance().getAgentHostname()};
            if ((this.m_flagMask & 8) != 0) {
                origTextNode = (String)this.m_onNodes.keySet().iterator().next();
                nodes = (String[])this.m_onNodes.get(origTextNode);
            }
            for (int i = 0; i < nodes.length; ++i) {
                for (int j = 0; j < objects.length; ++j) {
                    exec = "" + this.m_exec;
                    if (origTextObj != null) {
                        exec = exec.replace(origTextObj, objects[j]);
                    }
                    if (origTextNode != null) {
                        exec = exec.replace(origTextNode, nodes[i]);
                    }
                    isOK = this.execute(exec, isOK, objects[j], nodes[i]);
                }
            }
        } else {
            isOK = this.execute(exec, isOK, null, null);
        }
        return isOK;
    }

    private boolean execute(String exec, boolean isOK, String object, String node) {
        try {
            ExecResult er = ExecUtils.exec2(exec, AgentEngine.getInstance().FILE_SPI_DIR, (int)(this.getInterval() / 1000L));
            if (er == null || er.resultCode != 0) {
                RTLogger.print(2, "Monitor " + this.getName() + " failed. " + er);
                StringBuffer err = new StringBuffer();
                for (int i = 0; er != null && er.m_errorMessages != null && i < er.m_errorMessages.size(); ++i) {
                    err.append(er.m_errorMessages.get(i));
                    if (i >= er.m_errorMessages.size() - 1) continue;
                    err.append('\n');
                }
                RTLogger.print(3, err.toString());
                if (er != null && er.resultCode == -1073741502) {
                    AgentEngine.getInstance().getScheduler().repeatMe(this);
                } else {
                    AgentEngine.getInstance().sendInternalMessageDupl("Monitor failed to start.\n" + err.toString(), 2, "MONITOR", this.getName());
                }
            } else {
                MonParser mp = new MonParser();
                for (int i = 0; i < er.m_outMessages.size(); ++i) {
                    MonitorValue mv = mp.parse(er.m_outMessages.get(i));
                    if (object != null && (mv.p3_object == null || mv.p3_object.length() == 0)) {
                        mv.p3_object = object;
                    }
                    if (node != null && (mv.p10_node == null || mv.p10_node.length() == 0)) {
                        mv.p10_node = node;
                    }
                    RTLogger.print(3, "mon value received. {" + mv + "}");
                    if (mv == null) continue;
                    AgentEngine.getInstance().getSubmitter().submit(mv);
                }
                isOK = true;
            }
        }
        catch (IOException e) {
            RTLogger.print(1, "cant start monitor " + this.getName(), e);
            AgentEngine.getInstance().sendInternalMessage("Monitor failed to start.\n" + e.getMessage(), 2, "MONITOR", this.getName());
        }
        return isOK;
    }

    @Override
    public boolean onInit() throws Exception {
        this.m_exec = this.m_exec.replaceAll("\\Q<$NAME>\\E", this.getName());
        this.m_exec = this.m_exec.replaceAll("\\Q<$INTERVAL>\\E", "" + this.getInterval() / 1000L);
        this.m_exec = this.replaceGlobalVariables(this.m_exec);
        this.m_flagMask = this.fillInitStartExecs(this.m_exec);
        if (this.m_flagMask > 0) {
            if ((this.m_flagMask & 1) != 0) {
                this.m_exec = this.resolvePreExecs(this.getOnInitExec(), this.m_exec, "onInit", AgentEngine.getInstance().FILE_SPI_DIR);
            }
            if ((this.m_flagMask & 0x10) != 0) {
                this.m_exec = this.resolvePreExecs(this.getTriggerExec(), this.m_exec, "trigger", AgentEngine.getInstance().FILE_SPI_DIR);
            }
            if ((this.m_flagMask & 0x20) != 0) {
                this.m_exec = this.resolvePreExecs(this.getStopperExec(), this.m_exec, "stopper", AgentEngine.getInstance().FILE_SPI_DIR);
            }
        }
        return true;
    }

    @Override
    public boolean onStartRun() {
        if (this.m_policy.isEnabledCheckRuntime(Env.getInstance()) && !this.m_policy.isDeactivationTime(System.currentTimeMillis())) {
            RTLogger.print(5, "Start monitor " + this.getName());
            long expirationTime = System.currentTimeMillis() + this.getInterval() - 1000L;
            Tracker.registerLastMonitorCall(this.getName(), expirationTime);
        }
        return true;
    }

    @Override
    public boolean onStopRun() {
        RTLogger.print(5, "Stop monitor " + this.getName());
        if (!this.m_policy.isEnabledCheckRuntime(Env.getInstance()) || this.m_policy.isDeactivationTime(System.currentTimeMillis())) {
            long expirationTime = System.currentTimeMillis() + this.getInterval() + 50000L;
            Tracker.unregisterMonitor(this.getName(), expirationTime);
        }
        return true;
    }

    @Override
    protected boolean onStopTask() {
        return true;
    }

    @Override
    public boolean refresh() {
        return true;
    }
}

