/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.MMObject;
import com.blixx.agent.utils.SupportedVariables;
import com.blixx.sa.Opts;
import com.blixx.shared.Severity;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.util.Map;

public class MonitorValue
extends MMObject {
    public double p0_value = -1.0;

    public MonitorValue() {
        this.genUUID();
    }

    public MonitorValue(double value, long time, String monitor, String object) {
        this(value, time, monitor, object, null);
    }

    public MonitorValue(double value, long time, String monitor, String object, Map options) {
        this.init(value, time, monitor, object);
        this.genUUID();
        if (options != null) {
            for (Map.Entry en : options.entrySet()) {
                if (en.getValue() instanceof String) {
                    this.m_options.put(en.getKey(), (String)en.getValue());
                    continue;
                }
                this.m_options.put(en.getKey(), "" + en.getValue());
            }
        }
    }

    private void init(double value, long time, String monitor, String object) {
        this.p0_value = value;
        this.p1_time = time;
        this.p2_policyName = monitor;
        if (object != null) {
            this.p3_object = object.replace("\r", "");
            if (this.p3_object.length() > 1024) {
                this.p3_object = this.p3_object.substring(0, 1024);
            }
        }
    }

    @Override
    public void putOptions(String var, String value) {
        this.m_options.put(var, value);
    }

    @Override
    public void send(SDataOutputStream dos) throws IOException {
        StringBuilder sb = new StringBuilder(this.p00_uuid);
        sb.append(this.p30_state);
        Opts.toString(sb, this.m_CAs);
        dos.writeUTF(sb.toString());
        dos.writeDouble(this.p0_value);
        dos.writeLong(this.p1_time);
        dos.writeUTF(this.p2_policyName);
        if (this.p3_object.length() > 1024) {
            dos.writeUTF(this.p3_object.substring(0, 1024));
        } else {
            dos.writeUTF(this.p3_object);
        }
        dos.writeInt(this.p4_severity);
        if (this.p5_msg_text != null && this.p5_msg_text.length() > 2048) {
            dos.writeUTF(this.p5_msg_text.substring(0, 2048));
        } else {
            dos.writeUTF(this.p5_msg_text);
        }
        dos.writeUTF(this.p6_instructionID);
        if (this.p8_messageKey != null && this.p8_messageKey.length() > 1024) {
            dos.writeUTF(this.p8_messageKey.substring(0, 1024));
        } else {
            dos.writeUTF(this.p8_messageKey);
        }
        if (this.p9_ackKey != null && this.p9_ackKey.length() > 1024) {
            dos.writeUTF(this.p9_ackKey.substring(0, 1024));
        } else {
            dos.writeUTF(this.p9_ackKey);
        }
        if (this.p10_node != null && this.p10_node.length() > 255) {
            dos.writeUTF(this.p10_node.substring(0, 255));
        } else {
            dos.writeUTF(this.p10_node);
        }
        if (this.p11_autoAction != null && this.p11_autoAction.length() > 1024) {
            dos.writeUTF(this.p11_autoAction.substring(0, 1024));
        } else {
            dos.writeUTF(this.p11_autoAction);
        }
        if (this.p11_1_autoActionNode != null && this.p11_1_autoActionNode.length() > 255) {
            dos.writeUTF(this.p11_1_autoActionNode.substring(0, 255));
        } else {
            dos.writeUTF(this.p11_1_autoActionNode);
        }
        dos.writeInt(this.p11_2_autoActionTimeout);
        dos.writeUTF(this.p12_source);
        if (this.p13_opAction != null && this.p13_opAction.length() > 1024) {
            dos.writeUTF(this.p13_opAction.substring(0, 1024));
        } else {
            dos.writeUTF(this.p13_opAction);
        }
        dos.writeInt(this.p21_typeA);
        dos.writeInt(this.p22_typeK);
        dos.writeBoolean(this.p23_deduplication);
        dos.flush();
    }

    @Override
    public Object read(SDataInputStream dis) throws IOException {
        String type = null;
        this.p00_uuid = dis.readUTF();
        if (this.p00_uuid.length() > 36) {
            type = this.p00_uuid.substring(36);
            this.p00_uuid = this.p00_uuid.substring(0, 36);
        }
        this.p0_value = dis.readDouble();
        this.p1_time = dis.readLong();
        this.p2_policyName = dis.readUTF();
        this.p3_object = dis.readUTF();
        this.p4_severity = dis.readInt();
        this.p5_msg_text = dis.readUTF();
        this.p6_instructionID = dis.readUTF();
        this.p8_messageKey = dis.readUTF();
        this.p9_ackKey = dis.readUTF();
        this.p10_node = dis.readUTF();
        this.p11_autoAction = dis.readUTF();
        this.p11_1_autoActionNode = dis.readUTF();
        this.p11_2_autoActionTimeout = dis.readInt();
        this.p12_source = dis.readUTF();
        this.p13_opAction = dis.readUTF();
        this.p21_typeA = dis.readInt();
        this.p22_typeK = dis.readInt();
        this.p23_deduplication = dis.readBoolean();
        if (type != null) {
            this.p30_state = "" + type.charAt(0);
            String optVars = type.substring(1);
            this.m_options = Opts.getFromString(optVars);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.p00_uuid).append(' ').append(this.p2_policyName).append("@@").append(this.p3_object);
        sb.append('=').append(this.p0_value).append(' ').append(this.p1_time).append(' ');
        sb.append(Severity.getSeverity(this.p4_severity));
        sb.append(" msg_text=").append(this.p5_msg_text).append(" instr:").append(this.p6_instructionID);
        sb.append(" mkey:").append(this.p8_messageKey);
        sb.append(" ackk:").append(this.p9_ackKey);
        return sb.toString();
    }

    public String getKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.p2_policyName).append("@@").append(this.p3_object).append("@@").append(this.p10_node);
        return sb.toString();
    }

    public void setNode(String nodeIP, SupportedVariables sv) {
        this.p10_node = sv.replaceAll(nodeIP, this);
        this.p10_node = this.p10_node.replace("\r", "");
        if (this.p10_node.length() > 255) {
            this.p10_node = this.p10_node.substring(0, 255);
        }
    }

    public void setObject(String setObjectStr, SupportedVariables sv) {
        this.p3_object = setObjectStr.indexOf(36) != -1 ? sv.replaceAll(setObjectStr, this) : setObjectStr;
        if (this.p3_object.length() > 1024) {
            this.p3_object = this.p3_object.substring(0, 1024);
        }
    }
}

