/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.ISendStream;
import com.blixx.agent.Message;
import com.blixx.agent.SendBuffer;
import com.blixx.log.RTLogger;
import com.blixx.shared.BM;
import com.blixx.shared.IODataStream;
import com.blixx.shared.exceptions.CommunicationException;
import com.blixx.shared.io.SDataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;

public class MsgBuffer
extends SendBuffer {
    public MsgBuffer(String filename, int maxMessages) {
        this.m_max_messages = maxMessages;
        this.m_queue = new ArrayBlockingQueue(this.m_max_messages);
        this.bufferFileName = filename != null ? filename : BM.msgBuffer_msgq_dat;
        RTLogger.print(5, "Buffer " + this.bufferFileName + " initialized with limit:" + this.m_max_messages);
        this.bufferFile = new File(this.bufferFileName);
        this.init();
    }

    @Override
    protected void loadQueueFromFile() throws FileNotFoundException, IOException {
        if (this.bufferFile.canRead()) {
            try (SDataInputStream dis = new SDataInputStream(new FileInputStream(this.bufferFile));){
                int i;
                for (i = 0; i < this.m_max_messages; ++i) {
                    Message mv = new Message();
                    if (dis.available() == 0) break;
                    mv.read(dis);
                    while (!this.m_queue.offer(mv)) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                RTLogger.print(5, "Loaded msgs: " + i);
            }
            catch (Throwable e) {
                RTLogger.print(5, "Msg buffer file corrupted.");
            }
            boolean isOK = false;
            try {
                isOK = this.bufferFile.delete();
                isOK = this.bufferFile.createNewFile();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!isOK) {
                RTLogger.print(1, "can't empty file Msg Buffer file");
            }
        }
    }

    @Override
    public synchronized int sendBlock(ISendStream sc) throws CommunicationException {
        int res = -1;
        IODataStream[] array = new IODataStream[]{};
        array = this.m_queue.toArray(array);
        try {
            sc.send(array, 'E', this.m_emergency);
            res = array.length;
            for (int i = 0; i < res; ++i) {
                this.m_queue.poll();
            }
        }
        catch (CommunicationException e) {
            if (e.success > 0) {
                for (int i = 0; i < e.success; ++i) {
                    this.m_queue.poll();
                }
                res = e.success;
            }
            throw e;
        }
        return res;
    }
}

