/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.AgentHealth;
import com.blixx.agent.Env;
import com.blixx.agent.MatchAllException;
import com.blixx.agent.Message;
import com.blixx.agent.MessageStormFilter;
import com.blixx.agent.MsgSuppressTracker;
import com.blixx.agent.MsgSuppressTrackerCleaning;
import com.blixx.agent.PolicyRepository;
import com.blixx.agent.utils.Cube;
import com.blixx.agent.utils.PLogger;
import com.blixx.agent.utils.SupportedVariables;
import com.blixx.log.RTLogger;
import com.blixx.sa.HashCode;
import com.blixx.shared.AbstractCondition;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.MsgConditions;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.PatternMatchTimeout;
import com.blixx.shared.Severity;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class MsgCalcEngine {
    private static final MatchAllException MATCH_ALL_EXCEPTION = new MatchAllException();
    private Cube m_cube = null;
    private static volatile MsgCalcEngine m_instance = null;
    private SupportedVariables m_variables = new SupportedVariables();
    private MsgSuppressTracker m_suppression = new MsgSuppressTracker();
    public MsgSuppressTrackerCleaning m_cleaningTask = null;
    public Pattern m_empty = Pattern.compile("[\\s\\r\\n]+");
    public Map<String, PLogger> m_ploggers = new ConcurrentHashMap<String, PLogger>();

    private MsgCalcEngine() {
    }

    public MsgCalcEngine(PolicyRepository pr) {
        this.m_cube = pr.m_msgCube;
        this.m_cleaningTask = new MsgSuppressTrackerCleaning("MsgSuppressTrackerCleaningTask", this.m_suppression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MsgCalcEngine getInstance() {
        if (m_instance != null) return m_instance;
        Class<MsgCalcEngine> clazz = MsgCalcEngine.class;
        synchronized (MsgCalcEngine.class) {
            if (m_instance != null) return m_instance;
            m_instance = new MsgCalcEngine(AgentEngine.getInstance().getPolicyRepository());
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_instance;
        }
    }

    public void startCleaningTask() {
        AgentEngine.getInstance().getScheduler().addTask(this.m_cleaningTask, 0L);
    }

    public void flashSuppression() {
        this.m_suppression.flashSuppression();
    }

    public void registerMsgPolicy(MsgPolicy p) {
        MsgCalcEngine.getInstance().m_cube.add(p);
    }

    public void unregisterMsgPolicy(String name) {
        MsgCalcEngine.getInstance().m_cube.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkAll(Message m) {
        String policyName;
        int matchedMsg = 0;
        boolean isPolicyNameEnabled = false;
        HashSet<Object> policies = null;
        if (m.getOptions() != null && m.getOptions().containsKey("POLICY_NAME")) {
            policies = new HashSet();
            policyName = m.getOptions().get("POLICY_NAME");
            policies.add(policyName);
            ++matchedMsg;
            isPolicyNameEnabled = true;
        } else if (m.getOptions() != null && m.getOptions().containsKey("MSG_POLICY_NAME")) {
            policies = new HashSet();
            policyName = m.getOptions().get("MSG_POLICY_NAME");
            policies.add(policyName);
            ++matchedMsg;
            isPolicyNameEnabled = true;
        } else {
            policies = this.m_cube.getFilteresPolicies(m.p2_application, m.p7_msg_grp);
        }
        if (RTLogger.getCurrentLevel() >= 5) {
            RTLogger.print(5, "Msg: " + m.getFullMessage());
            RTLogger.print(5, "MsgPolicies candidates: " + policies.size() + " " + policies);
        }
        Iterator<Object> it = policies.iterator();
        MsgCondition MATCH_ALL = null;
        MsgPolicy MATCH_ALL_POLICY = null;
        PLogger PLOG = null;
        while (it.hasNext()) {
            String policyName2 = (String)it.next();
            MsgPolicy p = AgentEngine.getInstance().getPolicyRepository().getMsgPolicy(policyName2);
            boolean isOK = false;
            if (p == null) continue;
            PLOG = this.getPLogger(p);
            MsgConditions cnds = p.getConditions();
            if (cnds == null) continue;
            if (RTLogger.getCurrentLevel() >= 5) {
                RTLogger.print(5, "MsgCondition candidates: " + cnds.getConditionList().size());
            }
            Iterator it2 = cnds.getConditionList().iterator();
            int prevCounter = matchedMsg;
            while (it2.hasNext()) {
                MsgCondition mc;
                boolean vfilterOK;
                block47: {
                    vfilterOK = true;
                    mc = (MsgCondition)it2.next();
                    if (mc.isEvilPatternDetected()) continue;
                    try {
                        isOK = this.isMatch(m, mc);
                        if (isOK && mc.isVfilterActive() && mc.getVfilterString() != null) {
                            String strvar = this.m_variables.replaceAll(mc.getVfilterString(), m);
                            MsgCondition msgCondition = mc;
                            synchronized (msgCondition) {
                                if (RTLogger.getCurrentLevel() >= 6) {
                                    RTLogger.print(6, new StringBuffer("VFilter: ").append(mc.getVfilterAsInPolicy()).append(" mcID:").append(mc.getConditionId()).append(" input:").append(strvar));
                                }
                                if ((vfilterOK = mc.isVFilterMatch(strvar, Env.getInstance())) && mc.isVFilterHasVariables()) {
                                    m.putOptions(mc.getVFilterVariables());
                                }
                                isOK = isOK && vfilterOK;
                            }
                        } else {
                            vfilterOK = mc.getExpected();
                        }
                        isOK = isOK == mc.getExpected();
                    }
                    catch (PatternMatchTimeout pmt) {
                        StringBuilder msgEvilPattern;
                        if (AgentHealth.isLowMemory()) break block47;
                        if (mc.isStopEvaluation()) {
                            msgEvilPattern = new StringBuilder("Slow pattern found: ").append(pmt.m_pattern).append("\nMsgPolicy: ").append(p.getName()).append("\nConditionID: ").append(mc.getConditionId()).append("\nConditionName: ").append(mc.getDescription()).append("\nText:\n{").append(pmt.m_text).append("}");
                            AgentEngine.getInstance().sendInternalMessage(msgEvilPattern.toString(), 4, "AGENT", mc.getAsSourceString(p.getName()));
                            RTLogger.print(1, msgEvilPattern);
                        } else {
                            mc.setEvilPatternDetected(true);
                            msgEvilPattern = new StringBuilder("Policy Condition disabled! Slow pattern found: ").append(pmt.m_pattern).append("\nMsgPolicy: ").append(p.getName()).append("\nConditionID: ").append(mc.getConditionId()).append("\nConditionName: ").append(mc.getDescription()).append("\nText:\n{").append(pmt.m_text).append("}");
                            AgentEngine.getInstance().sendInternalMessage(msgEvilPattern.toString(), 4, "AGENT", mc.getAsSourceString(p.getName()));
                            RTLogger.print(1, msgEvilPattern);
                        }
                    }
                    catch (MatchAllException e) {
                        if (isPolicyNameEnabled) {
                            if (m.p5_msg_text.length() > 0) {
                                isOK = true;
                            }
                        }
                        if (RTLogger.getCurrentLevel() >= 5) {
                            RTLogger.print(5, "POSTPONE ALL_MATCH RULE");
                        }
                        MATCH_ALL = mc;
                        MATCH_ALL_POLICY = p;
                        continue;
                    }
                }
                if (!isOK) continue;
                if (vfilterOK != mc.getExpected()) {
                    if (matchedMsg == 0) {
                        ++matchedMsg;
                    }
                    if (RTLogger.getCurrentLevel() < 5) continue;
                    RTLogger.print(5, "Forced VFilter suppression");
                    continue;
                }
                if (RTLogger.getCurrentLevel() >= 5) {
                    RTLogger.print(5, "Condition match: " + mc.getDescription() + " ACTION=" + mc.getActionType());
                }
                if (mc.isStopEvaluation()) {
                    if (RTLogger.getCurrentLevel() >= 5) {
                        RTLogger.print(5, "STOP action for:" + p.getName());
                    }
                    ++matchedMsg;
                    if (PLOG == null) break;
                    PLOG.print(5, mc, m);
                    break;
                }
                if (p.isEnabledCheckRuntime(Env.getInstance()) && !p.isDeactivationTime(m.p1_time)) {
                    this.checkSuppressionSendMessage(PLOG, m, p, mc);
                } else if (RTLogger.getCurrentLevel() >= 5) {
                    RTLogger.print(5, "Policy matched, but disabled:" + p.getName());
                }
                ++matchedMsg;
                break;
            }
            if (matchedMsg != prevCounter || PLOG == null) continue;
            PLOG.print(1, null, m);
        }
        if (MATCH_ALL != null) {
            if (matchedMsg == 0) {
                if (MATCH_ALL.getExpected() && !MATCH_ALL.isStopEvaluation()) {
                    if (RTLogger.getCurrentLevel() >= 5) {
                        RTLogger.print(5, "M MATCH_ALL Suppression check.");
                    }
                    try {
                        this.checkSuppressionSendMessage(PLOG, m, MATCH_ALL_POLICY, MATCH_ALL);
                    }
                    catch (Throwable e) {
                        if (RTLogger.getCurrentLevel() >= 5) {
                            RTLogger.print(5, "M MATCH_ALL Suppression check ERROR.", e);
                        }
                    }
                } else if (RTLogger.getCurrentLevel() >= 5) {
                    StringBuilder sb = new StringBuilder("M MATCH_ALL suppress. STOP=");
                    sb.append(MATCH_ALL.isStopEvaluation());
                    sb.append(" NEGATION").append(!MATCH_ALL.getExpected());
                    RTLogger.print(5, sb);
                }
            } else if (RTLogger.getCurrentLevel() >= 5) {
                RTLogger.print(5, "M MATCH_ALL skipped. Condition name: " + MATCH_ALL.getDescription());
            }
        } else if (this.m_cube.isEmpty() && matchedMsg == 0) {
            if (RTLogger.getCurrentLevel() >= 5) {
                RTLogger.print(5, "M empty CUBE.");
            }
            m.m_tempPolicyName = "";
            this.sendMessage(m);
        } else if (RTLogger.getCurrentLevel() >= 5) {
            RTLogger.print(5, "M nothing matched");
        }
        return matchedMsg;
    }

    private void checkSuppressionSendMessage(PLogger PLOG, Message m, AbstractPolicy pol, MsgCondition mc) {
        Message nm = m.getCopy(pol, mc);
        HashCode hash = this.m_suppression.checkLastMessage(nm, pol.getName(), mc, nm.p8_messageKey, nm.p9_ackKey);
        if (hash.suppressedType == 0) {
            if (mc.getInsertClosed() > 0) {
                nm.p30_state = "A";
            }
            if (!hash.isCounterOnly) {
                this.m_suppression.flushOther(hash, nm.p9_ackKey, this.m_suppression.m_messagesTimeSuppresion);
                if (nm.p8_messageKey != null && nm.p8_messageKey.length() > 0) {
                    this.m_suppression.m_key_hash.put(nm.p8_messageKey, hash);
                }
            } else {
                hash.isCounterOnly = false;
                if (nm.p8_messageKey != null && nm.p8_messageKey.length() > 0) {
                    this.m_suppression.m_key_hash.put(nm.p8_messageKey, hash);
                }
            }
            if (PLOG != null) {
                PLOG.print(2, this.m_suppression.m_messagesCountSuppresion.get(hash), mc, m);
            }
            this.sendMessage(nm);
        } else {
            if (RTLogger.getCurrentLevel() >= 5) {
                RTLogger.print(5, "M msg suppressed. Condition=" + mc.getConditionId() + " count= text: " + m.p5_msg_text);
            }
            if (PLOG != null) {
                if (hash.suppressedType >= 3) {
                    PLOG.print(6, this.m_suppression.m_messagesCountSuppresion.get(hash), mc, m);
                } else if (hash.suppressedType == 1) {
                    PLOG.print(3, this.m_suppression.m_messagesCountSuppresion.get(hash), mc, m);
                } else {
                    PLOG.print(4, this.m_suppression.m_messagesCountSuppresion.get(hash), mc, m);
                }
            }
        }
    }

    private void sendMessage(Message m) {
        try {
            if (AgentEngine.getInstance().getMessageStormFilter().filterMessage(m.m_tempPolicyName) == MessageStormFilter.PolicyState.OK) {
                AgentEngine.getInstance().getMessageQueue().put(m);
                AgentHealth.m_totalMatchedIndis.incrementAndGet();
            }
        }
        catch (InterruptedException e) {
            RTLogger.print(4, "M error submit message 1010 " + e.getMessage());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMatch(Message m, MsgCondition mc) throws MatchAllException {
        boolean isOK = false;
        if (this.m_empty.matcher(m.p5_msg_text).matches()) {
            return false;
        }
        if (!mc.isMatchALL()) {
            MsgCondition msgCondition = mc;
            synchronized (msgCondition) {
                isOK = mc.isMatch(m.p5_msg_text, m.getNode(), m.p7_msg_grp, m.p2_application, m.p3_object, Severity.getSeverity(m.p4_severity));
                if (isOK && mc.isTextPatternHasVariables()) {
                    m.putOptions(mc.getVariables());
                    AbstractCondition.lookup(m.getOptions(), Env.getInstance());
                }
            }
        } else {
            throw MATCH_ALL_EXCEPTION;
        }
        return isOK;
    }

    public PLogger getPLogger(MsgPolicy mpolicy) {
        PLogger pl;
        File dir;
        if (!mpolicy.isPlogEnabled()) {
            return null;
        }
        if (this.m_ploggers.size() == 0 && !(dir = new File("plog")).exists()) {
            dir.mkdir();
        }
        if ((pl = this.m_ploggers.get(mpolicy.getName())) == null) {
            pl = new PLogger();
            pl.setMaxCount(mpolicy.getPlogLogcount());
            pl.setMaxSize(0x100000L * (long)mpolicy.getPlogLogsize());
            pl.setDir("plog", mpolicy.getName() + "_");
            pl.print(1, "\n");
            this.m_ploggers.put(mpolicy.getName(), pl);
        }
        return pl;
    }
}

