/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.AgentHealth;
import com.blixx.agent.Env;
import com.blixx.agent.Message;
import com.blixx.agent.MsgCalcEngine;
import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractPolicy;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class MsgSubmitter
implements Runnable {
    public static final String SNMPQueueID = UUID.randomUUID().toString();
    public static final String MSGQUEUE = "MSGQUEUE";
    ConcurrentLinkedQueue<Message> queue = new ConcurrentLinkedQueue();
    Map<String, MsgSubmitter> m_subSubmitters = new ConcurrentHashMap<String, MsgSubmitter>();
    ExecutorService m_executors = Executors.newCachedThreadPool();
    private Map<String, MsgSubmitter> m_specificPool = new ConcurrentHashMap<String, MsgSubmitter>();
    private String m_name = "MSGQUEUE";
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private AbstractPolicy m_policy = null;
    private Object m_lock = new Object();

    public MsgSubmitter() {
    }

    public MsgSubmitter(String name) {
        this.m_name = name;
        this.m_policy = AgentEngine.getInstance().getPolicyRepository().getMsgPolicy(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block15: {
            try {
                if (!MSGQUEUE.equals(this.m_name)) {
                    while (!this.queue.isEmpty()) {
                        this.process();
                    }
                    break block15;
                }
                while (true) {
                    this.process();
                    Object object = this.m_lock;
                    synchronized (object) {
                        try {
                            this.m_lock.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Throwable e) {
                RTLogger.print(4, "MsgSubmitter failed", e);
            }
            finally {
                if (this.m_executors != null) {
                    this.m_executors.shutdown();
                }
                this.isRunning.set(false);
            }
        }
    }

    public void process() {
        Message m = null;
        try {
            MsgCalcEngine calcEngine = AgentEngine.getInstance().getMsgCalcEngine();
            if (calcEngine == null) {
                return;
            }
            while ((m = this.queue.poll()) != null) {
                calcEngine.checkAll(m);
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(2, "Submitter exception " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void submit(Message mv) {
        if (!AgentEngine.getInstance().getDisabled() && !AgentHealth.isLowMemory()) {
            AgentHealth.m_totalIncomingIndis.incrementAndGet();
            String policyName = mv.getOptions().get("POLICY_NAME");
            MsgSubmitter mSpecific = null;
            if (policyName != null && policyName.length() > 0) {
                mSpecific = this.m_specificPool.get(policyName);
                if (mSpecific == null) {
                    mSpecific = new MsgSubmitter(policyName);
                    this.m_specificPool.put(policyName, mSpecific);
                }
                AgentHealth.countSpecific(policyName);
                mSpecific.submitInternalWithLimit(mv, 1000);
                if (mSpecific.isRunning.compareAndSet(false, true)) {
                    this.m_executors.execute(mSpecific);
                }
                return;
            }
            if ("SNMPTrapd".equals(mv.p2_application) && "SNMP".equals(mv.p7_msg_grp)) {
                mSpecific = this.m_specificPool.get(SNMPQueueID);
                if (mSpecific == null) {
                    mSpecific = new MsgSubmitter(SNMPQueueID);
                    this.m_specificPool.put(SNMPQueueID, mSpecific);
                }
                AgentHealth.countSnmpTraps();
                mSpecific.submitInternal(mv);
                if (mSpecific.isRunning.compareAndSet(false, true)) {
                    this.m_executors.execute(mSpecific);
                }
                return;
            }
            AgentHealth.m_nonPolicySpecificIndis.incrementAndGet();
            boolean queueEmpty = this.queue.isEmpty();
            this.submitInternal(mv);
            if (queueEmpty) {
                Object object = this.m_lock;
                synchronized (object) {
                    try {
                        this.m_lock.notifyAll();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    void submitInternal(Message mv) {
        if (this.m_policy != null && !this.m_policy.isEnabledCheckRuntime(Env.getInstance())) {
            return;
        }
        if (!this.queue.offer(mv)) {
            if (RTLogger.getCurrentLevel() >= 5) {
                if (this.m_name != null) {
                    RTLogger.print(5, "M QUEUE failed " + this.m_name);
                } else {
                    RTLogger.print(5, "M QUEUE failed");
                }
            }
        } else if (this.queue.isEmpty()) {
            RTLogger.print(1, "ConcurrentLinkedQueue corrupted. Recover...");
            this.queue = new ConcurrentLinkedQueue();
        }
    }

    void submitInternalWithLimit(Message mv, int limit) {
        if (this.m_policy != null && !this.m_policy.isEnabledCheckRuntime(Env.getInstance())) {
            return;
        }
        if (!this.queue.offer(mv) && RTLogger.getCurrentLevel() >= 5) {
            if (this.m_name != null) {
                RTLogger.print(5, "M QUEUE failed " + this.m_name);
            } else {
                RTLogger.print(5, "M QUEUE failed");
            }
        }
        if (this.queue.size() > limit) {
            try {
                Thread.sleep(500L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    public int getQueueSizeAll() {
        int total = this.queue.size();
        for (Map.Entry<String, MsgSubmitter> entry : this.m_subSubmitters.entrySet()) {
            try {
                total += entry.getValue().queue.size();
            }
            catch (Throwable throwable) {}
        }
        for (Map.Entry<String, MsgSubmitter> entry : this.m_specificPool.entrySet()) {
            try {
                total += entry.getValue().queue.size();
            }
            catch (Throwable throwable) {}
        }
        return total;
    }
}

