/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.Message;
import com.blixx.log.RTLogger;
import com.blixx.sa.HashCode;
import com.blixx.shared.MsgCondition;
import com.blixx.shared.PatternB;
import com.blixx.shared.PatternMatchResult;
import com.blixx.shared.PatternMatcherThread;
import com.blixx.shared.exceptions.ConfigException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class MsgSuppressTracker {
    public ConcurrentHashMap<HashCode, Long> m_messagesTimeSuppresion = new ConcurrentHashMap(100, 0.75f, 2);
    public ConcurrentHashMap<HashCode, Long> m_messagesCountSuppresion = new ConcurrentHashMap(100, 0.75f, 2);
    public ConcurrentHashMap<String, HashCode> m_key_hash = new ConcurrentHashMap(100, 0.75f, 2);

    public HashCode checkLastMessage(Message m, String policyName, MsgCondition c, String key, String closeKey) {
        boolean isNew = false;
        boolean isCounterSuppressionOnly = false;
        HashCode hash = null;
        String fullMessage = this.getID(m, policyName, c);
        if (c.getSuppressInterval() == 0) {
            isNew = true;
            isCounterSuppressionOnly = true;
        } else {
            hash = this.getHash(fullMessage);
            Long storedExpiration = this.m_messagesTimeSuppresion.get(hash);
            if (storedExpiration == null) {
                isNew = true;
                Long expiration = System.currentTimeMillis() + (long)(c.getSuppressInterval() * 1000);
                this.setLastMessage(hash, expiration);
            } else if (System.currentTimeMillis() > storedExpiration) {
                isNew = true;
                Long expiration = System.currentTimeMillis() + (long)(c.getSuppressInterval() * 1000);
                this.setLastMessage(hash, expiration);
            } else {
                if (RTLogger.getCurrentLevel() >= 5) {
                    RTLogger.print(5, "Suppression by time: " + m.p5_msg_text);
                }
                hash.suppressedType = 1;
            }
            if (c.getSuppressCount() > 1) {
                if (hash.suppressedType > 0) {
                    hash = this.checkCount(c, closeKey, hash);
                } else {
                    this.flushOther(hash, closeKey, this.m_messagesCountSuppresion);
                    this.m_messagesCountSuppresion.put(hash, 0L);
                    hash.suppressedType = 3;
                }
                isNew = false;
            }
        }
        if (isNew) {
            if (c.getSuppressCount() > 1) {
                if (hash == null) {
                    hash = this.getHash(fullMessage);
                }
                hash.isCounterOnly = isCounterSuppressionOnly;
                hash = this.checkCount(c, closeKey, hash);
            } else if (isCounterSuppressionOnly && hash == null) {
                hash = this.getHash(fullMessage);
            }
        }
        return hash;
    }

    private HashCode checkCount(MsgCondition c, String closeKey, HashCode hash) {
        Long actCounter = this.m_messagesCountSuppresion.get(hash);
        if (actCounter == null) {
            hash.suppressedType = 0;
            this.flushOther(hash, closeKey, this.m_messagesCountSuppresion);
            this.m_messagesCountSuppresion.put(hash, 0L);
        } else {
            long updatedCount = actCounter + 1L;
            if (updatedCount >= (long)c.getSuppressCount()) {
                this.flushOther(hash, closeKey, this.m_messagesCountSuppresion);
                if (hash.suppressedType != 1) {
                    this.m_messagesCountSuppresion.put(hash, 0L);
                    hash.suppressedType = 0;
                } else {
                    if (updatedCount == (long)c.getSuppressCount()) {
                        hash.suppressedType = 0;
                    }
                    this.m_messagesCountSuppresion.put(hash, updatedCount);
                }
            } else {
                this.m_messagesCountSuppresion.put(hash, updatedCount);
                RTLogger.print(5, "Suppression by count");
                hash.suppressedType += 2;
            }
        }
        return hash;
    }

    public void flashSuppression() {
        this.m_messagesTimeSuppresion.clear();
        this.m_messagesCountSuppresion.clear();
    }

    private String getID(Message m, String policyName, MsgCondition c) {
        Long time = AgentEngine.getInstance().getPolicyRepository().getRedeploymentTime(policyName);
        StringBuffer sb = new StringBuffer();
        if (c.isDeduplKeyOnly()) {
            sb.append(m.p8_messageKey);
        } else {
            sb.append(m.getFullMessage()).append("__").append(c.getConditionId());
        }
        if (time != null) {
            sb.append("__").append(time);
        }
        return sb.toString();
    }

    public void setLastMessage(HashCode hash, Long expiration) {
        this.m_messagesTimeSuppresion.put(hash, expiration);
    }

    public void flushOther(HashCode thisMsg, String closeKey, ConcurrentHashMap<HashCode, Long> map) {
        if (closeKey == null || closeKey.length() == 0) {
            return;
        }
        try {
            PatternB pb = PatternB.getPattern(closeKey);
            Iterator it = ((ConcurrentHashMap.KeySetView)this.m_key_hash.keySet()).iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                PatternMatchResult matchesR = PatternMatcherThread.match(pb, key);
                if (matchesR == null || !matchesR.isMatch()) continue;
                HashCode hash = this.m_key_hash.get(key);
                if (hash != null && !thisMsg.equals(hash)) {
                    map.remove(hash);
                }
                it.remove();
            }
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    public HashCode getHash(String fullMessage) {
        return new HashCode(fullMessage);
    }

    public static void main(String[] args) {
    }
}

