/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.Env;
import com.blixx.agent.Tracker;
import com.blixx.log.RTLogger;
import com.blixx.sa.ExecResult;
import com.blixx.sa.ExecUtils;
import com.blixx.sa.SchedulerTask;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.Interval;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.os.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class NaginTask
extends SchedulerTask {
    public String m_exec = null;
    public String m_policyName = null;
    public long m_lastStarted = 0L;
    public AgentEngine m_agent = AgentEngine.getInstance();
    public AbstractPolicy m_policy = null;

    public NaginTask(MsgPolicy mp) {
        super(mp.getName());
        this.m_policy = mp;
        this.setInterval(Interval.parseInterval(mp.getIntervalStr(), 60));
        this.m_policyName = mp.getName();
        String exec = mp.getMonprog();
        if (exec == null || exec.length() == 0) {
            throw new RuntimeException("Nothing to execute.");
        }
        if (exec.charAt(0) == '#') {
            this.m_exec = exec.substring(1);
        } else {
            String spidir = AgentEngine.getInstance().DIR_MAIN + File.separator + "spi";
            this.m_exec = spidir + File.separator + exec;
            if (SystemUtils.OS == 1) {
                spidir = spidir.substring(0, 2) + "\"" + spidir.substring(2) + "\"";
                this.m_exec = spidir + File.separator + exec;
            }
        }
        String replace = this.m_exec.replace('\n', ' ');
        this.m_exec = replace = replace.replace("\r", "");
        try {
            this.onInit();
        }
        catch (Exception e) {
            RTLogger.print(4, "", e);
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public boolean onGetData() {
        if (!this.m_policy.isEnabledCheckRuntime(Env.getInstance()) || this.m_policy.isDeactivationTime(System.currentTimeMillis())) {
            return true;
        }
        String exec = "" + this.m_exec;
        Map<String, String> onStart = this.getOnStartExec();
        if (onStart != null && onStart.size() > 0) {
            try {
                exec = this.resolvePreExecs(onStart, exec, "onStart", AgentEngine.getInstance().FILE_SPI_DIR);
            }
            catch (Throwable e) {
                HashMap<String, String> optVars = new HashMap<String, String>();
                optVars.put("POLICY_NAME", this.m_policyName);
                optVars.put("POLICY_CALL", exec);
                this.m_agent.sendMessage(this.m_agent.getAgentHostname(), "NAGIN", "NAGIN", this.m_policyName, "Trigger " + this.m_policyName + " failed.\nCall: " + "POLICY_CALL" + "\n" + e.getMessage(), "warning", optVars);
                return false;
            }
        }
        boolean isOK = false;
        if ((this.m_flagMask & 4) != 0 || (this.m_flagMask & 8) != 0) {
            String origTextObj = null;
            String[] objects = new String[]{""};
            if ((this.m_flagMask & 4) != 0) {
                origTextObj = (String)this.m_onObjects.keySet().iterator().next();
                objects = (String[])this.m_onObjects.get(origTextObj);
            }
            String origTextNode = null;
            String[] nodes = new String[]{this.m_agent.getAgentHostname()};
            if ((this.m_flagMask & 8) != 0) {
                origTextNode = (String)this.m_onNodes.keySet().iterator().next();
                nodes = (String[])this.m_onNodes.get(origTextNode);
            }
            for (int i = 0; i < nodes.length; ++i) {
                for (int j = 0; j < objects.length; ++j) {
                    exec = "" + this.m_exec;
                    if (origTextObj != null) {
                        exec = exec.replace(origTextObj, objects[j]);
                    }
                    if (origTextNode != null) {
                        exec = exec.replace(origTextNode, nodes[i]);
                    }
                    isOK = this.execute(exec, isOK, objects[j], nodes[i]);
                }
            }
        } else {
            isOK = this.execute(exec, isOK, "", this.m_agent.getAgentHostname());
        }
        return isOK;
    }

    private boolean execute(String exec, boolean isOK, String object, String node) {
        try {
            ExecResult er = ExecUtils.exec2(exec, AgentEngine.getInstance().FILE_SPI_DIR, (int)(this.getInterval() / 1000L));
            if (er.resultCode < 0 || er.resultCode > 3) {
                int i;
                RTLogger.print(2, "Nagin " + this.getName() + " failed. " + er);
                StringBuffer err = new StringBuffer();
                err.append("STDERR:\n");
                for (i = 0; i < er.m_errorMessages.size(); ++i) {
                    err.append(er.m_errorMessages.get(i));
                    if (i >= er.m_errorMessages.size() - 1) continue;
                    err.append('\n');
                }
                for (i = 0; i < er.m_outMessages.size(); ++i) {
                    if (i == 0) {
                        err.append("STDOUT:\n");
                    }
                    err.append(er.m_outMessages.get(i));
                    if (i >= er.m_outMessages.size() - 1) continue;
                    err.append('\n');
                }
                RTLogger.print(3, err.toString());
                if (er.resultCode == -1073741502) {
                    AgentEngine.getInstance().getScheduler().repeatMe(this);
                } else {
                    HashMap<String, String> optVars = new HashMap<String, String>();
                    optVars.put("POLICY_NAME", this.m_policyName);
                    optVars.put("POLICY_CALL", exec);
                    this.m_agent.sendMessage(node == null || node.length() == 0 ? this.m_agent.getAgentHostname() : node, "NAGIN", "NAGIN", object == null || object.length() == 0 ? this.m_policyName : object, "Trigger execution failed.\nResult code: " + er.resultCode + "\nPolicy: " + this.m_policyName + "\nCall: " + "POLICY_CALL" + "\n" + err.toString(), "warning", optVars);
                }
            } else {
                String str;
                int i;
                StringBuffer sb = new StringBuffer();
                for (i = 0; i < er.m_outMessages.size(); ++i) {
                    str = er.m_outMessages.get(i);
                    if (sb.length() == 0 && str.trim().replace("\r", "").equals("")) continue;
                    sb.append(str);
                    String tail = "" + sb.charAt(sb.length() - 1) + sb.charAt(sb.length() - 2);
                    if (tail.equals("\n\n") || i >= er.m_outMessages.size() - 1) continue;
                    sb.append('\n');
                }
                for (i = 0; i < er.m_errorMessages.size(); ++i) {
                    str = er.m_errorMessages.get(i);
                    sb.append(str);
                    if (i >= er.m_errorMessages.size() - 1) continue;
                    sb.append('\n');
                }
                String msg = sb.toString();
                if (msg.length() > 2048) {
                    msg = msg.substring(0, 2042) + "@MAX@";
                }
                RTLogger.print(6, "NAGIN OUT: " + msg);
                String severity = "unknown";
                switch (er.resultCode) {
                    case 0: {
                        severity = "normal";
                        break;
                    }
                    case 1: {
                        severity = "warning";
                        break;
                    }
                    case 2: {
                        severity = "critical";
                        break;
                    }
                }
                HashMap<String, String> optVars = new HashMap<String, String>();
                optVars.put("POLICY_NAME", this.m_policyName);
                optVars.put("POLICY_CALL", exec);
                optVars.put("RESULT_CODE", "" + er.resultCode);
                this.m_agent.sendMessage(node, "NAGIN", "NAGIN", object, msg, severity, optVars);
                isOK = true;
            }
        }
        catch (IOException e) {
            RTLogger.print(1, "cant start trigger " + this.getName(), e);
        }
        return isOK;
    }

    @Override
    public boolean onInit() throws Exception {
        this.m_exec = this.m_exec.replaceAll("\\Q<$NAME>\\E", this.getName());
        this.m_exec = this.m_exec.replaceAll("\\Q<$INTERVAL>\\E", "" + this.getInterval() / 1000L);
        this.m_flagMask = this.fillInitStartExecs(this.m_exec);
        if (this.m_flagMask > 0) {
            if ((this.m_flagMask & 1) != 0) {
                this.m_exec = this.resolvePreExecs(this.getOnInitExec(), this.m_exec, "onInit", AgentEngine.getInstance().FILE_SPI_DIR);
            }
            if ((this.m_flagMask & 0x10) != 0) {
                this.m_exec = this.resolvePreExecs(this.getTriggerExec(), this.m_exec, "trigger", AgentEngine.getInstance().FILE_SPI_DIR);
            }
            if ((this.m_flagMask & 0x20) != 0) {
                this.m_exec = this.resolvePreExecs(this.getStopperExec(), this.m_exec, "stopper", AgentEngine.getInstance().FILE_SPI_DIR);
            }
        }
        return true;
    }

    @Override
    public boolean onStartRun() {
        if (this.m_policy.isEnabledCheckRuntime(Env.getInstance()) && !this.m_policy.isDeactivationTime(System.currentTimeMillis())) {
            RTLogger.print(5, "Start nagin " + this.getName());
            long l = System.currentTimeMillis() + this.getInterval() - 1000L;
        }
        return true;
    }

    @Override
    public boolean onStopRun() {
        RTLogger.print(5, "Stop nagin " + this.getName());
        if (!this.m_policy.isEnabledCheckRuntime(Env.getInstance()) || this.m_policy.isDeactivationTime(System.currentTimeMillis())) {
            long expirationTime = System.currentTimeMillis() + this.getInterval() + 50000L;
            Tracker.unregisterMonitor(this.getName(), expirationTime);
        }
        return true;
    }

    @Override
    protected boolean onStopTask() {
        return true;
    }

    @Override
    public boolean refresh() {
        return true;
    }
}

