/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AProperties;
import com.blixx.agent.AgentEngine;
import com.blixx.agent.DeploymentHelper;
import com.blixx.agent.HBNetty;
import com.blixx.agent.NettyClient;
import com.blixx.agent.NettyMode;
import com.blixx.agent.PolicyRepository;
import com.blixx.agent.SendTaskNetty;
import com.blixx.agent.netty.CSRRequestHandler;
import com.blixx.agent.netty.DeploymentCmdHandler;
import com.blixx.agent.netty.NettyBasicMessageHandler;
import com.blixx.agent.netty.RemoteCmdHandler;
import com.blixx.agent.netty.TCmdHandler;
import com.blixx.agent.netty.TldCmdRecieveHandler;
import com.blixx.log.RTLogger;
import com.blixx.sa.Scheduler;
import com.blixx.shared.ServerInfo;
import com.boom.crt.CertificateManager;
import com.boom.crt.KeyStoreClient;
import com.boom.crt.TrustStoreClient;
import com.boom.netty.client.ClientConfiguration;
import com.boom.netty.client.ClientConfigurationException;
import com.boom.netty.common.MessageSender;
import com.boom.netty.digest.HashFileWriter;
import com.boom.netty.server.IncomingConnectionVerifier;
import com.boom.netty.server.Server;
import com.boom.netty.server.ServerConnectionSettings;
import com.boom.netty.service.basic.msg.AgentInfoMsg;
import com.boom.netty.service.basic.msg.ReadyToReceiveDataMsg;
import com.boom.netty.service.cmds.RCmdMessageTypes;
import com.boom.netty.service.deploy.msg.DeploymentMessageTypes;
import com.boom.netty.service.file.FileReceiveHandler;
import com.boom.netty.service.file.FileSendHandler;
import com.boom.netty.service.file.msg.FTMessageTypes;
import com.boom.netty.service.tl.msg.TMessageTypes;
import com.boom.netty.service.util.TraceMessageHandler;
import com.boom.netty.ws.mhf.MessageTypeRegistrationException;
import com.boom.netty.ws.mhf.MessageTypesRepository;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.net.ssl.KeyManagerFactory;

public class NettyEndpoint {
    private String connectedServerId;
    private CertificateManager certificateManager;
    private AtomicBoolean isNettyClientConnected = new AtomicBoolean(false);
    private AtomicBoolean isNettyServerConnected = new AtomicBoolean(false);
    private AtomicBoolean nettyServerIsReadyToReceiveDataViaNetty = new AtomicBoolean(false);
    private AtomicBoolean nettyClientIsReadyToReceiveDataViaNetty = new AtomicBoolean(false);
    private AProperties properties;
    private Scheduler scheduler;
    private NettyClient nettyClient;
    private Server nettyServer;
    private DeploymentHelper deploymentHelper;
    private PolicyRepository policyRepository;
    private SendTaskNetty sendTaskNetty;
    private HBNetty hbNetty;
    private Supplier<ServerInfo> serverInfo;
    private AgentEngine agentEngine;
    private IncomingConnectionVerifier incomingConnectionVerifier;
    private FileSendHandler nettyClientFtSendHandler;
    private FileReceiveHandler nettyClientFtReceiveHandler;
    private FileSendHandler nettyServerFtSendHandler;
    private FileReceiveHandler nettyServerFtReceiveHandler;

    public NettyEndpoint(CertificateManager certificateManager, AProperties properties, Scheduler scheduler, DeploymentHelper deploymentHelper, PolicyRepository policyRepository, Supplier<ServerInfo> serverInfo, IncomingConnectionVerifier incomingConnectionVerifier, AgentEngine agentEngine) {
        this.certificateManager = certificateManager;
        this.properties = properties;
        this.scheduler = scheduler;
        this.deploymentHelper = deploymentHelper;
        this.policyRepository = policyRepository;
        this.serverInfo = serverInfo;
        this.agentEngine = agentEngine;
        this.incomingConnectionVerifier = incomingConnectionVerifier;
    }

    public void init() {
        try {
            HashMap typesUsedEventWithoutNetty = new HashMap();
            typesUsedEventWithoutNetty.putAll(RCmdMessageTypes.CMD_MESSAGE_TYPES);
            MessageTypesRepository.getInstance().registerMessageTypes(typesUsedEventWithoutNetty);
        }
        catch (MessageTypeRegistrationException e) {
            RTLogger.print(3, "can't register MessageBase types", e);
        }
    }

    public void start() {
        switch (this.properties.getNettyMode()) {
            case CLIENT: {
                this.startNettyClient(this.serverInfo.get());
                break;
            }
            case SERVER: {
                this.startNettyServer(this.properties.isTlsActivated());
                break;
            }
            case BOTH: {
                this.startNettyClient(this.serverInfo.get());
                this.startNettyServer(this.properties.isTlsActivated());
                break;
            }
        }
        this.startSendTaskNetty();
        this.startHbNetty();
    }

    public void stop() {
        this.stopNettyClient();
        this.stopNettyServer();
        this.stopSendTaskNetty();
        this.stopHbNetty();
    }

    private void stopNettyServer() {
        if (this.nettyServer != null) {
            try {
                this.nettyServer.shutdown();
                RTLogger.print(5, "Stopping netty server : " + this.nettyServer.getAddress());
                this.stopSendTaskNetty();
                if (this.nettyServerFtSendHandler != null) {
                    this.nettyServerFtSendHandler.stopTimeoutChecks();
                    this.nettyServerFtSendHandler.dropAllFileTransfers();
                }
                if (this.nettyServerFtReceiveHandler != null) {
                    this.nettyServerFtReceiveHandler.stopTimeoutChecks();
                    this.nettyServerFtReceiveHandler.dropAllFileTransfers();
                }
                this.nettyServer.shutdown();
            }
            finally {
                this.nettyServer = null;
            }
        }
    }

    private void stopNettyClient() {
        if (this.nettyClient != null) {
            try {
                RTLogger.print(5, "Stopping netty client : " + this.nettyClient.getAddress());
                this.stopSendTaskNetty();
                if (this.nettyClientFtSendHandler != null) {
                    this.nettyClientFtSendHandler.stopTimeoutChecks();
                    this.nettyClientFtSendHandler.dropAllFileTransfers();
                }
                if (this.nettyClientFtReceiveHandler != null) {
                    this.nettyClientFtReceiveHandler.stopTimeoutChecks();
                    this.nettyClientFtReceiveHandler.dropAllFileTransfers();
                }
                this.nettyClient.shutdown();
            }
            finally {
                this.nettyClient = null;
            }
        }
    }

    public void restart() {
        RTLogger.print(5, "Restarting netty endpoint");
        this.stop();
        this.start();
    }

    public void startNettyServer(boolean isTls) {
        if (this.nettyServer == null) {
            RTLogger.print(5, "Starting netty server!!!");
            try {
                ServerConnectionSettings serverConnectionSettings = new ServerConnectionSettings(this.properties.getAgentID(), "0.0.0.0", this.properties.getWsAgentPort());
                TrustStoreClient tsClient = this.certificateManager == null ? null : this.certificateManager.getTsClient();
                boolean useTls = isTls && this.certificateManager != null;
                this.nettyServer = new Server(serverConnectionSettings, useTls ? this.getKeyManagerFactory(this.certificateManager) : null, tsClient == null ? null : tsClient.getKeyStore(), true, 5000, 1000, null);
                this.nettyServer.setIncomingConnectionVerifier(this.incomingConnectionVerifier);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                RTLogger.print(1, "Could not start netty client", e);
            }
            try {
                this.registerHandlers(this.nettyServer, s -> this.nettyServerIsReadyToReceiveDataViaNetty.set(true));
                int ftTimout = 60000 * this.properties.getFtTimeOut();
                int ftTimoutCheck = ftTimout * 2;
                this.nettyServerFtSendHandler = new FileSendHandler(this.nettyServer, "", ftTimout, ftTimoutCheck);
                this.nettyServerFtReceiveHandler = new FileReceiveHandler(this.nettyServer, this.properties.getFtDir(), ftTimout, ftTimoutCheck, true);
                this.nettyServerFtReceiveHandler.setDevice(true);
                this.nettyServerFtReceiveHandler.setDataChunkFinishedListener((digest, fileName) -> {
                    try {
                        HashFileWriter.writeDigestToFile(digest, fileName.replace(".tmp", ".@@sha256"));
                    }
                    catch (Exception e) {
                        RTLogger.print(1, "Error writing digest file for file {}", fileName, e);
                    }
                });
                this.nettyServer.registerHandler(this.nettyServerFtSendHandler);
                this.nettyServer.registerHandler(this.nettyServerFtReceiveHandler);
                this.nettyServer.addDeviceConnectivityListener(new IncomingConnectivityListener(this.nettyServer));
                this.nettyServer.start();
                RTLogger.print(5, "Netty server started");
            }
            catch (Exception e) {
                RTLogger.print(1, "Netty server failed to start.", e);
            }
        }
    }

    public void startNettyClient(ServerInfo serverInfo) {
        if (this.nettyClient != null) {
            this.stopNettyClient();
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                RTLogger.print(1, "", e);
                Thread.currentThread().interrupt();
            }
        }
        RTLogger.print(5, "Starting netty client!!!");
        RTLogger.print(1, "Netty client connection to : " + serverInfo.getHost() + " on port : " + serverInfo.getNettyPort());
        KeyStore trustStore = null;
        try {
            if (this.certificateManager != null && this.certificateManager.getTsClient() != null) {
                trustStore = this.certificateManager.getTsClient().getKeyStore();
            }
        }
        catch (Exception e) {
            RTLogger.print(2, "truststore init error", e);
        }
        try {
            ClientConfiguration clientConf = new ClientConfiguration();
            clientConf.setDeviceId(this.properties.getAgentID());
            clientConf.setAddress(Arrays.asList(serverInfo.getHost(), serverInfo.getPublicIP()));
            clientConf.setPort(serverInfo.getNettyPort());
            clientConf.setAllowUntrustedCertificates(true);
            clientConf.setUseWss("wss".equalsIgnoreCase(serverInfo.getProtocol()));
            clientConf.setTrustStore(trustStore);
            clientConf.setKeyManagerFactory(this.certificateManager == null ? null : this.getKeyManagerFactory(this.certificateManager));
            clientConf.setMaxSendQueueSize(100);
            clientConf.setMaster(false);
            this.nettyClient = new NettyClient(clientConf);
        }
        catch (ClientConfigurationException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            RTLogger.print(1, "Could not start netty client", e);
        }
        try {
            this.registerHandlers(this.nettyClient, s -> this.nettyClientIsReadyToReceiveDataViaNetty.set(true));
            int ftTimout = 60000 * this.properties.getFtTimeOut();
            int ftTimoutCheck = ftTimout * 2;
            this.nettyClientFtSendHandler = new FileSendHandler(this.nettyClient, "", ftTimout, ftTimoutCheck);
            this.nettyClientFtReceiveHandler = new FileReceiveHandler(this.nettyClient, this.properties.getFtDir(), ftTimout, ftTimoutCheck, true);
            this.nettyClientFtReceiveHandler.setDevice(true);
            this.nettyClientFtReceiveHandler.setDataChunkFinishedListener((digest, fileName) -> {
                try {
                    HashFileWriter.writeDigestToFile(digest, fileName.replace(".tmp", ".@@sha256"));
                }
                catch (Exception e) {
                    RTLogger.print(1, "Error writing digest file for file {}", fileName, e);
                }
            });
            this.nettyClient.registerHandler(this.nettyClientFtSendHandler);
            this.nettyClient.registerHandler(this.nettyClientFtReceiveHandler);
            this.nettyClient.addDeviceConnectivityListener(new DeviceConnectivityListener(this.nettyClient));
            this.nettyClient.start();
            RTLogger.print(5, "Netty client started");
        }
        catch (Exception e) {
            RTLogger.print(1, "Netty client failed to start.", e);
        }
    }

    private void registerHandlers(MessageSender messageSender, Consumer<ReadyToReceiveDataMsg> consumer) throws MessageTypeRegistrationException {
        TCmdHandler cmdHandler = new TCmdHandler(messageSender);
        TldCmdRecieveHandler tldRecieveHandler = new TldCmdRecieveHandler(messageSender, this.properties.getFtDir());
        RemoteCmdHandler remoteCmdHandler = new RemoteCmdHandler(messageSender);
        Object deploymentCmdHandler = new Object();
        if (this.deploymentHelper != null && this.policyRepository != null) {
            deploymentCmdHandler = new DeploymentCmdHandler(messageSender, this.deploymentHelper, this.policyRepository);
        }
        NettyBasicMessageHandler basicMsgHandler = new NettyBasicMessageHandler(messageSender, consumer);
        messageSender.registerHandler(new TraceMessageHandler(messageSender.getCurrentDeviceId(), messageSender));
        messageSender.registerMessageTypes(TMessageTypes.BASIC_MESSAGE_TYPES);
        messageSender.registerMessageTypes(FTMessageTypes.FT_MESSAGE_TYPES);
        messageSender.registerMessageTypes(RCmdMessageTypes.CMD_MESSAGE_TYPES);
        messageSender.registerMessageTypes(DeploymentMessageTypes.MESSAGE_TYPES);
        messageSender.registerHandler(basicMsgHandler);
        messageSender.registerHandler(cmdHandler);
        messageSender.registerHandler(tldRecieveHandler);
        messageSender.registerHandler(remoteCmdHandler);
        messageSender.registerHandler(deploymentCmdHandler);
        messageSender.registerHandler(new CSRRequestHandler(this.agentEngine, messageSender));
    }

    private int getPortToSend() {
        int portToSend = this.properties.getNettyMode() == NettyMode.CLIENT ? (this.properties.getAgentPort() == 0 && this.properties.getMainServerPort() == 0 && this.properties.getBackupServerPort() == 0 ? -2 : -1) : -this.properties.getWsAgentPort().intValue();
        return portToSend;
    }

    public boolean isNettyConnected() {
        return this.isNettyClientConnected.get() || this.isNettyServerConnected.get();
    }

    public String getConnectedServerId() {
        return this.connectedServerId;
    }

    public MessageSender getMessageSender() {
        return Stream.of(this.nettyClient, this.nettyServer).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void startSendTaskNetty() {
        this.stopSendTaskNetty();
        if (this.properties.getMode() < 7 && this.properties.getCommType().contains("WEBSOCKET")) {
            this.sendTaskNetty = new SendTaskNetty(this.properties.getMaxMessages(), this.agentEngine, this);
            this.scheduler.addTask(this.sendTaskNetty, 0L);
            RTLogger.print(2, this.properties.getCommType() + " submitter started.");
        }
    }

    public void startHbNetty() {
        this.stopHbNetty();
        if (this.properties.getMode() < 7 && this.properties.getCommType().contains("WEBSOCKET")) {
            this.hbNetty = new HBNetty("HBNetty", this.nettyClient, this.properties.getHbInterval());
            this.scheduler.addTask(this.hbNetty, 0L);
            RTLogger.print(2, "HBNetty started.");
        }
    }

    public void stopSendTaskNetty() {
        if (this.sendTaskNetty != null) {
            this.scheduler.removeTask(this.sendTaskNetty.getName());
        }
    }

    private void stopHbNetty() {
        if (this.hbNetty != null) {
            this.scheduler.removeTask(this.hbNetty.getName());
        }
    }

    private KeyManagerFactory getKeyManagerFactory(CertificateManager certificateManager) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        KeyStoreClient ksClient = certificateManager.getKsClient();
        KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance("SunX509");
        keyMgrFactory.init(ksClient.getKeyStore(), ksClient.getPwdArray());
        return keyMgrFactory;
    }

    public boolean isAnyOneReadyToReceiveDataViaNetty() {
        return this.nettyServerIsReadyToReceiveDataViaNetty.get() || this.nettyClientIsReadyToReceiveDataViaNetty.get();
    }

    public SendTaskNetty getSendTaskNetty() {
        return this.sendTaskNetty;
    }

    private class IncomingConnectivityListener
    implements com.boom.netty.common.DeviceConnectivityListener {
        private final Server server;

        public IncomingConnectivityListener(Server server) {
            this.server = server;
        }

        @Override
        public void deviceConnected(String serverId, Certificate[] certificates) {
            NettyEndpoint.this.isNettyServerConnected.compareAndSet(false, true);
            if (!NettyEndpoint.this.isNettyClientConnected.get()) {
                NettyEndpoint.this.connectedServerId = serverId;
            }
            RTLogger.getStaticLogger().info("Server {} connected", (Object)serverId);
        }

        @Override
        public void deviceDisconnected(String serverId) {
            NettyEndpoint.this.isNettyServerConnected.compareAndSet(true, false);
            if (!NettyEndpoint.this.isNettyClientConnected.get()) {
                NettyEndpoint.this.connectedServerId = null;
            }
            RTLogger.getStaticLogger().info("Server {} disconnected", (Object)serverId);
        }
    }

    private class DeviceConnectivityListener
    implements com.boom.netty.common.DeviceConnectivityListener {
        private MessageSender clientSender;

        public DeviceConnectivityListener(MessageSender clientSender) {
            this.clientSender = clientSender;
        }

        @Override
        public void deviceConnected(String serverIdConnected, Certificate[] certificates) {
            NettyEndpoint.this.connectedServerId = serverIdConnected;
            NettyEndpoint.this.isNettyClientConnected.compareAndSet(false, true);
            if ("WEBSOCKET_ONLY".equals(NettyEndpoint.this.properties.getCommType()) || "WEBSOCKET_TLS_ONLY".equals(NettyEndpoint.this.properties.getCommType())) {
                this.clientSender.sendMessage(new AgentInfoMsg(NettyEndpoint.this.getConnectedServerId(), serverIdConnected, NettyEndpoint.this.getPortToSend(), NettyEndpoint.this.properties.getCommType(), NettyEndpoint.this.properties.getAgentOS(), !NettyEndpoint.this.agentEngine.getDisabled(), "5.11.0"));
            }
        }

        @Override
        public void deviceDisconnected(String deviceId) {
            NettyEndpoint.this.isNettyClientConnected.compareAndSet(true, false);
        }
    }
}

