/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.PerfObject;
import com.blixx.agent.SendPerfToServer;
import com.blixx.log.RTLogger;
import com.blixx.shared.CFI;
import com.boom.netty.service.events.PerfAgt;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PerfDataCollection {
    private Map<PerfObject, Map<String, Double>> m_storage = new ConcurrentHashMap<PerfObject, Map<String, Double>>(100);
    private Map<String, Long> m_nextSubmit = new ConcurrentHashMap<String, Long>();
    private Map<String, Long> m_intervals = new ConcurrentHashMap<String, Long>();
    private String agentHostname;

    public PerfDataCollection(String agentHostname) {
        this.agentHostname = agentHostname;
    }

    public void addValue(CFI cfi, String object, double value) {
        this.addValue(cfi, object, null, value);
    }

    public void addValue(CFI cfi, String object, String hostname, double value) {
        Long nextSubmit;
        if (object != null && object.length() == 0) {
            object = null;
        }
        long ms = cfi.m_interval * 1000L;
        if (!this.m_intervals.containsKey(cfi.m_class)) {
            this.m_intervals.put(cfi.m_class, ms);
            RTLogger.print(2, "PERFDATA collection add class " + cfi.m_class + " interval: " + cfi.m_interval + " sec.");
        } else {
            long stored = this.m_intervals.get(cfi.m_class);
            if (stored > ms) {
                this.m_intervals.put(cfi.m_class, ms);
                RTLogger.print(2, "PERFDATA collection CHANGED class " + cfi.m_class + " interval: " + cfi.m_interval + " sec.");
            }
        }
        PerfObject po = new PerfObject(cfi.m_class, object, hostname);
        Map<String, Double> fields = this.m_storage.get(po);
        if (fields == null) {
            fields = new HashMap<String, Double>(3);
            this.m_storage.put(po, fields);
        }
        if ((nextSubmit = this.m_nextSubmit.get(cfi.m_class)) == null) {
            nextSubmit = System.currentTimeMillis() + this.m_intervals.get(cfi.m_class);
            this.m_nextSubmit.put(cfi.m_class, nextSubmit);
        } else {
            long ct = System.currentTimeMillis();
            if (nextSubmit < ct) {
                this.m_nextSubmit.put(cfi.m_class, nextSubmit + this.m_intervals.get(cfi.m_class));
                for (PerfObject pp : this.m_storage.keySet()) {
                    Map<String, Double> fieldsToSend;
                    if (!pp.getClassName().equalsIgnoreCase(cfi.m_class) || (fieldsToSend = this.m_storage.get(pp)) == null || fieldsToSend.isEmpty()) continue;
                    PerfAgt rec = new PerfAgt(pp.getClassName(), nextSubmit);
                    PerfAgt.PerfValue val = new PerfAgt.PerfValue("HOST", "VARCHAR", 255, pp.getHost() == null ? this.agentHostname : pp.getHost());
                    rec.getRecordSet().put(val.getFieldName(), val);
                    if (pp.getObject() != null) {
                        val = new PerfAgt.PerfValue("OBJECT", "VARCHAR", 255, pp.getObject());
                        rec.getRecordSet().put(val.getFieldName(), val);
                    }
                    for (Map.Entry<String, Double> en : fieldsToSend.entrySet()) {
                        val = new PerfAgt.PerfValue(en.getKey(), "DOUBLE", 0, "" + en.getValue());
                        rec.getRecordSet().put(val.getFieldName(), val);
                    }
                    this.getSubmitter().enqueuePerfRecord(rec);
                    fieldsToSend.clear();
                }
            }
        }
        fields.put(cfi.m_filed, value);
    }

    public Map<PerfObject, Map<String, Double>> getStorage() {
        return this.m_storage;
    }

    public SendPerfToServer getSubmitter() {
        return new SendPerfToServer();
    }
}

