/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.boom.netty.common.MessageSender;
import com.boom.netty.service.basic.msg.PongMsg;
import com.boom.netty.ws.mhf.annotation.MessageHandlerMethod;
import java.util.Optional;

public class PingPongMessageTracker {
    private MessageSender messageSender;
    private PongMsg result = null;
    private String currentOperationId;
    private final Object lock = new Object();

    public PingPongMessageTracker(MessageSender messageSender) {
        this.messageSender = messageSender;
        messageSender.registerHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<PongMsg> ping(String toServerId, long timeoutMillis) {
        this.currentOperationId = this.constructOperationId(toServerId);
        this.messageSender.sendPingMessage(toServerId, this.currentOperationId);
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait(timeoutMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return Optional.ofNullable(this.result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MessageHandlerMethod
    public void handlePongMessage(PongMsg msg) {
        if (msg.getOperationId().equals(this.currentOperationId)) {
            this.result = msg;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    public String constructOperationId(String targetServerId) {
        return "Ping: " + this.messageSender.getCurrentDeviceId() + " - " + targetServerId;
    }
}

