/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.JavaMonTask;
import com.blixx.agent.MonTask;
import com.blixx.agent.MsgCalcEngine;
import com.blixx.agent.NaginTask;
import com.blixx.agent.Tracker;
import com.blixx.agent.utils.Cube;
import com.blixx.log.RTLogger;
import com.blixx.shared.AbstractPolicy;
import com.blixx.shared.MsgPolicy;
import com.blixx.shared.Policy;
import com.blixx.shared.PolicyFactory;
import com.blixx.shared.PolicyParsingException;
import com.blixx.shared.exceptions.JavaMonitorExeption;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PolicyRepository {
    public static final String DEPLOY = "DEPLOY";
    public static final String UNDEPLOY = "UNDEPLOY";
    private static volatile PolicyRepository m_instance = null;
    public Map<String, Policy> m_knownMonitors = new ConcurrentHashMap<String, Policy>(500, 0.9f, 2);
    public Map<String, MsgPolicy> m_knownMsgPolicies = new ConcurrentHashMap<String, MsgPolicy>(500, 0.9f, 2);
    public PolicyFactory policy_factory = new PolicyFactory();
    public Cube m_msgCube = new Cube();
    public Map<String, AbstractPolicy> m_allJavaMonitors = new ConcurrentHashMap<String, AbstractPolicy>(20, 0.9f, 2);
    private Map<String, Long> m_redeployedMsgPolicies = new ConcurrentHashMap<String, Long>();
    private File m_dirPolicies;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PolicyRepository getInstance() {
        if (m_instance != null) return m_instance;
        Class<PolicyRepository> clazz = PolicyRepository.class;
        synchronized (PolicyRepository.class) {
            if (m_instance != null) return m_instance;
            m_instance = new PolicyRepository();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_instance;
        }
    }

    public void init() {
        this.m_dirPolicies = new File(AgentEngine.getInstance().DIR_POLICIES);
        if (!this.m_dirPolicies.exists()) {
            this.m_dirPolicies.mkdirs();
        }
        if (this.m_dirPolicies.isDirectory()) {
            File[] farr = this.m_dirPolicies.listFiles();
            for (int i = 0; i < farr.length; ++i) {
                File file = farr[i];
                this.processFile(file, true);
            }
        } else {
            RTLogger.print(1, "No conf directory found");
        }
    }

    private void processFile(File file, boolean isInit) {
        if (file.getName().endsWith(".mon.xml")) {
            Policy p = null;
            try {
                p = this.policy_factory.initPolicy(file);
            }
            catch (PolicyParsingException policyParsingException) {
                // empty catch block
            }
            if (p == null) {
                if (!isInit) {
                    String expectedPolicyName = file.getName().replace(".mon.xml", "");
                    AgentEngine.getInstance().sendInternalMessageDupl("Deployment of Policy " + expectedPolicyName + " failed.", 5, DEPLOY, expectedPolicyName);
                }
            } else {
                this.addPolicy(p);
                this.registerMonitor(p);
                if (!isInit) {
                    String nameAndVer = p.getName() + " v" + p.getVersion();
                    AgentEngine.getInstance().sendInternalMessage("Policy " + nameAndVer + " was deployed.", 1, DEPLOY, p.getName());
                }
            }
        } else if (file.getName().endsWith(".msg.xml")) {
            MsgPolicy mp = null;
            try {
                mp = this.policy_factory.initMsgPolicy(file);
            }
            catch (PolicyParsingException nameAndVer) {
                // empty catch block
            }
            if (mp == null) {
                if (!isInit) {
                    String expectedPolicyName = file.getName().replace(".msg.xml", "");
                    AgentEngine.getInstance().sendInternalMessageDupl("Deployment of Policy file " + expectedPolicyName + " failed.", 5, DEPLOY, expectedPolicyName);
                }
            } else {
                this.addPolicy(mp);
                if (mp.isTriggerEnabled()) {
                    this.registerMonitor(mp);
                }
                if (!isInit) {
                    String nameAndVer = mp.getName() + " v" + mp.getVersion();
                    AgentEngine.getInstance().sendInternalMessage("Policy " + nameAndVer + " was deployed.", 1, DEPLOY, mp.getName());
                }
            }
        }
    }

    public void updatePolicy(File f) {
        this.processFile(f, false);
    }

    public Long getRedeploymentTime(String msgPolicyName) {
        return this.m_redeployedMsgPolicies.get(msgPolicyName);
    }

    public void removePolicy(String name) {
        RTLogger.print(3, "Removing mon " + name);
        this.removeFromFailed(name);
        Policy o = this.m_knownMonitors.remove(name);
        AgentEngine.getInstance().getMessageStormFilter().removePolicyCfg(name);
        String canonicalName = "Monitor:" + name;
        if (o != null) {
            boolean isOK = AgentEngine.getInstance().getScheduler().removeTask(name);
            if (isOK) {
                String text = "Removed mon task " + name;
                RTLogger.print(3, text);
                File f = new File(this.m_dirPolicies, name + ".mon.xml");
                if (!f.delete()) {
                    String text2 = "Policy file can't be deleted. " + f.getName();
                    AgentEngine.getInstance().sendInternalMessage(text2, 2, UNDEPLOY, canonicalName);
                }
                AgentEngine.getInstance().sendInternalMessage(text, 1, UNDEPLOY, canonicalName);
            } else {
                String text = "Can't remove mon task: " + name + "";
                RTLogger.print(3, text);
                AgentEngine.getInstance().sendInternalMessage(text, 2, UNDEPLOY, canonicalName);
            }
        } else {
            String text = "Can't remove mon " + name + ". Not assigned on this node.";
            RTLogger.print(3, text);
            AgentEngine.getInstance().sendInternalMessage(text, 2, UNDEPLOY, canonicalName);
        }
    }

    private void removeFromFailed(String name) {
        this.m_allJavaMonitors.remove(name);
    }

    public void removeMsgPolicy(String name) {
        RTLogger.print(3, "Removing msg " + name);
        this.removeFromFailed(name);
        MsgPolicy o = this.m_knownMsgPolicies.remove(name);
        AgentEngine.getInstance().getMessageStormFilter().removePolicyCfg(name);
        String canonicalName = "Message:" + name;
        if (o != null) {
            MsgCalcEngine.getInstance().unregisterMsgPolicy(name);
            AgentEngine.getInstance().getScheduler().removeTask(name);
            String text = "Removed message policy: " + name;
            RTLogger.print(3, text);
            File f = new File(this.m_dirPolicies, name + ".msg.xml");
            if (!f.delete()) {
                String text2 = "Message policy file can't be deleted. " + f.getName();
                AgentEngine.getInstance().sendInternalMessage(text2, 2, UNDEPLOY, canonicalName);
            }
            AgentEngine.getInstance().sendInternalMessage(text, 1, UNDEPLOY, canonicalName);
        } else {
            String text = "Can't remove mon " + name + ". Not assigned on this node.";
            RTLogger.print(3, text);
            AgentEngine.getInstance().sendInternalMessage(text, 2, UNDEPLOY, canonicalName);
        }
    }

    public Set<String> getAssignedMonitors() {
        return this.m_knownMonitors.keySet();
    }

    public Set<String> getAssignedMessages() {
        return this.m_knownMsgPolicies.keySet();
    }

    public void addPolicy(Policy p) {
        if (p == null) {
            return;
        }
        this.m_knownMonitors.put(p.getName(), p);
        if (p.getCallType().equals("EXTERNAL")) {
            Tracker.registerExternalMonitor(p.getName());
        }
        try {
            AgentEngine.getInstance().getCalcEngine().flashActiveStatus(p.getName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (p.getMsd_mpm() > 0) {
            try {
                AgentEngine.getInstance().getMessageStormFilter().configurePolicy(p.getName(), p.getMsd_mpm(), p.getMsd_bm(), p.getMsd_qm());
            }
            catch (Throwable throwable) {}
        } else {
            AgentEngine.getInstance().getMessageStormFilter().removePolicyCfg(p.getName());
        }
    }

    public void addPolicy(MsgPolicy p) {
        if (p == null) {
            return;
        }
        this.m_knownMsgPolicies.put(p.getName(), p);
        if (!p.isTriggerEnabled()) {
            this.m_msgCube.add(p);
        } else {
            this.m_msgCube.remove(p.getName());
        }
        if (p.getMsd_mpm() > 0) {
            AgentEngine.getInstance().getMessageStormFilter().configurePolicy(p.getName(), p.getMsd_mpm(), p.getMsd_bm(), p.getMsd_qm());
        }
        this.m_redeployedMsgPolicies.put(p.getName(), System.currentTimeMillis());
    }

    public Policy getPolicy(String monitorName) {
        return this.m_knownMonitors.get(monitorName);
    }

    public MsgPolicy getMsgPolicy(String policyName) {
        return this.m_knownMsgPolicies.get(policyName);
    }

    public void registerMonitor(final Policy p) {
        Thread tr = new Thread(){

            @Override
            public void run() {
                try {
                    if (p.getCallType().equals("EXEC")) {
                        AgentEngine.getInstance().getScheduler().removeTask(p.getName());
                        MonTask mt = new MonTask(p);
                        AgentEngine.getInstance().getScheduler().addTask(mt, System.currentTimeMillis() - mt.getInterval() + 1000L);
                        Tracker.unregisterMonitor(mt.getName(), mt.getInterval() * 2L);
                    } else if (p.getCallType().equals("JAVA")) {
                        PolicyRepository.this.registerJavaMonitor(p);
                        PolicyRepository.this.m_allJavaMonitors.put(p.getName(), p);
                    } else if (p.getCallType().equals("EXTERNAL")) {
                        Tracker.registerExternalMonitor(p.getName());
                    }
                }
                catch (Throwable e) {
                    RTLogger.print(3, "Trigger for policy " + p.getName() + " failed to init.", e);
                    AgentEngine.getInstance().sendInternalMessageDupl("Trigger can't be initialized: " + p.getMonprog() + "\n" + e.getMessage(), 2, p.getCallType(), p.getName());
                }
            }
        };
        tr.start();
    }

    public void registerMonitor(final MsgPolicy p) {
        Thread tr = new Thread(){

            @Override
            public void run() {
                try {
                    if (p.getCallType().equals("EXEC")) {
                        AgentEngine.getInstance().getScheduler().removeTask(p.getName());
                        MonTask mt = new MonTask(p);
                        AgentEngine.getInstance().getScheduler().addTask(mt, System.currentTimeMillis() - mt.getInterval() + 1000L);
                        Tracker.unregisterMonitor(mt.getName(), mt.getInterval() * 2L);
                    } else if (p.getCallType().equals("JAVA")) {
                        PolicyRepository.this.registerJavaMonitor(p);
                        PolicyRepository.this.m_allJavaMonitors.put(p.getName(), p);
                    } else if (p.getCallType().equals("NAGIN")) {
                        AgentEngine.getInstance().getScheduler().removeTask(p.getName());
                        NaginTask mt = new NaginTask(p);
                        AgentEngine.getInstance().getScheduler().addTask(mt, 0L);
                    }
                }
                catch (Throwable e) {
                    RTLogger.print(3, "Trigger for policy " + p.getName() + " failed to init.", e);
                    AgentEngine.getInstance().sendInternalMessageDupl("Trigger can't be initialized: " + p.getBinary() + "\n" + e.getMessage(), 2, p.getCallType(), p.getName());
                }
            }
        };
        tr.start();
    }

    private boolean registerJavaMonitor(MsgPolicy p) {
        boolean isRegistered = false;
        try {
            AgentEngine.getInstance().getScheduler().removeTask(p.getName());
            JavaMonTask mt = new JavaMonTask(p);
            AgentEngine.getInstance().getScheduler().addTask(mt, System.currentTimeMillis() - mt.getInterval() + 1000L);
            Tracker.unregisterMonitor(mt.getName(), mt.getInterval() * 2L);
            isRegistered = true;
        }
        catch (JavaMonitorExeption e) {
            RTLogger.print(3, "JavaMonitorPolicy can not be processed.", e);
            AgentEngine.getInstance().sendInternalMessageDupl("Trigger can't be initialized: " + p.getBinary() + "\nError:" + e.getMessage(), 2, "JAVA_MONITOR", p.getName());
        }
        return isRegistered;
    }

    private boolean registerJavaMonitor(Policy p) {
        boolean isRegistered = false;
        try {
            AgentEngine.getInstance().getScheduler().removeTask(p.getName());
            JavaMonTask mt = new JavaMonTask(p);
            AgentEngine.getInstance().getScheduler().addTask(mt, System.currentTimeMillis() - mt.getInterval() + 1000L);
            Tracker.unregisterMonitor(mt.getName(), mt.getInterval() * 2L);
            isRegistered = true;
        }
        catch (JavaMonitorExeption e) {
            RTLogger.print(3, "JavaMonitorPolicy can not be processed.", e);
            int jcfe = p.getMonprog().indexOf(32);
            String className = p.getMonprog();
            if (jcfe > 0) {
                className = p.getMonprog().substring(0, p.getMonprog().indexOf(32));
            }
            AgentEngine.getInstance().sendInternalMessageDupl("Monitor can't be initialized: " + className + "\nError:" + e.getMessage(), 2, "JAVA_MONITOR", p.getName());
        }
        return isRegistered;
    }

    public void reRegisterJavaMonitors() {
        for (AbstractPolicy o : this.m_allJavaMonitors.values()) {
            AbstractPolicy p;
            if (!o.getCallType().equals("JAVA")) continue;
            if (o instanceof Policy) {
                p = (Policy)o;
                this.registerJavaMonitor((Policy)p);
                continue;
            }
            if (!(o instanceof MsgPolicy)) continue;
            p = (MsgPolicy)o;
            this.registerJavaMonitor((MsgPolicy)p);
        }
    }

    public void storePolicy(Policy pol) {
        try {
            PolicyFactory pf = new PolicyFactory();
            pf.storePolicy(pol, new File(this.m_dirPolicies, pol.getName() + ".mon.xml"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void storePolicy(MsgPolicy pol) {
        try {
            PolicyFactory pf = new PolicyFactory();
            pf.storePolicy(pol, new File(this.m_dirPolicies, pol.getName() + ".msg.xml"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

