/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.ISendStream;
import com.blixx.agent.Message;
import com.blixx.log.RTLogger;
import com.blixx.shared.IODataStream;
import com.blixx.shared.exceptions.CommunicationException;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Queue;

public class SClient
implements ISendStream {
    public SDataInputStream is = null;
    public SDataOutputStream os = null;
    public Socket m_sock = null;

    public SClient(Socket sock, SDataInputStream dis, SDataOutputStream dos) {
        this.is = dis;
        this.os = dos;
        this.m_sock = sock;
    }

    @Override
    public void send(IODataStream[] array, char type) throws CommunicationException {
        block17: {
            long n = System.currentTimeMillis();
            if (RTLogger.getCurrentLevel() >= 5) {
                RTLogger.print(5, "Start sending... " + type);
            }
            int successSent = 0;
            int soTimeoutBefore = 60;
            try {
                soTimeoutBefore = this.m_sock.getSoTimeout();
                this.os.write(type);
                this.os.writeInt(array.length);
                this.os.flush();
                if (RTLogger.getCurrentLevel() >= 5) {
                    RTLogger.print(5, "msg::: " + array.length);
                }
                for (int i = 0; i < array.length; ++i) {
                    try {
                        array[i].send(this.os);
                        ++successSent;
                        continue;
                    }
                    catch (Throwable e) {
                        RTLogger.print(2, "error sending object,", e);
                        throw new CommunicationException(e.getMessage(), --successSent);
                    }
                }
                this.os.flush();
                this.m_sock.setSoTimeout(this.m_sock.getSoTimeout() + successSent * 100);
                char a = (char)this.is.read();
                if (a == 'T') {
                    if (successSent > 0) {
                        RTLogger.print(4, type + " block sent OK (" + successSent + ") Submit Time: " + (System.currentTimeMillis() - n));
                    }
                    break block17;
                }
                if (a != 'F' && successSent == array.length) {
                    RTLogger.print(4, type + " block sent OK. (" + successSent + ") Submit Time: " + (System.currentTimeMillis() - n));
                    break block17;
                }
                RTLogger.print(1, type + " Failed sending block: " + a);
                throw new CommunicationException("socket error.", 0);
            }
            catch (IOException e) {
                throw new CommunicationException("socket error.", e, 0);
            }
            finally {
                try {
                    this.m_sock.setSoTimeout(soTimeoutBefore);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public void send(IODataStream[] array, char type, Queue<IODataStream> emergencyMessages) throws CommunicationException {
        block18: {
            long n = System.currentTimeMillis();
            RTLogger.print(5, "Start sending... " + type);
            int successSent = 0;
            int soTimeoutBefore = 60;
            try {
                int i;
                int emerg = 0;
                if (emergencyMessages != null) {
                    emerg = emergencyMessages.size();
                }
                soTimeoutBefore = this.m_sock.getSoTimeout();
                this.os.write(type);
                this.os.writeInt(array.length + emerg);
                this.os.flush();
                if (emergencyMessages != null && emerg > 0) {
                    RTLogger.print(5, "emerg msg::: " + emerg);
                    for (i = 0; i < emerg; ++i) {
                        Message ioDataStream = (Message)emergencyMessages.peek();
                        ioDataStream.send(this.os);
                        emergencyMessages.poll();
                    }
                }
                RTLogger.print(5, "msg::: " + array.length);
                for (i = 0; i < array.length; ++i) {
                    try {
                        array[i].send(this.os);
                        ++successSent;
                        continue;
                    }
                    catch (Throwable e) {
                        RTLogger.print(2, "error sending object,", e);
                        throw new CommunicationException(e.getMessage(), --successSent);
                    }
                }
                this.os.flush();
                this.m_sock.setSoTimeout(this.m_sock.getSoTimeout() + successSent * 100);
                char a = (char)this.is.read();
                if (a == 'T') {
                    if (successSent > 0) {
                        RTLogger.print(4, type + " block sent OK (" + successSent + ") Submit Time: " + (System.currentTimeMillis() - n));
                    }
                    break block18;
                }
                if (a != 'F' && successSent == array.length) {
                    RTLogger.print(4, type + " block sent OK. (" + successSent + ") Submit Time: " + (System.currentTimeMillis() - n));
                    break block18;
                }
                RTLogger.print(1, type + " Failed sending block: " + a);
                throw new CommunicationException("socket error.", 0);
            }
            catch (IOException e) {
                throw new CommunicationException("socket error.", e, 0);
            }
            finally {
                try {
                    this.m_sock.setSoTimeout(soTimeoutBefore);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

