/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.SClient;
import com.blixx.log.RTLogger;
import com.blixx.shared.IODataStream;
import com.blixx.shared.exceptions.CommunicationException;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Queue;

public class SClient_HTTP
extends SClient {
    public SClient_HTTP(Socket sock, SDataInputStream dis, SDataOutputStream dos) {
        super(sock, dis, dos);
    }

    @Override
    public void send(IODataStream[] array, char type) throws CommunicationException {
        long n = System.currentTimeMillis();
        if (RTLogger.getCurrentLevel() >= 5) {
            RTLogger.print(5, "Start sending... " + type);
        }
        int successSent = 0;
        int soTimeoutBefore = 60;
        try {
            soTimeoutBefore = this.m_sock.getSoTimeout();
            this.os.write(type);
            this.os.writeInt(array.length);
            this.os.flush();
            if (RTLogger.getCurrentLevel() >= 5) {
                RTLogger.print(5, "msg::: " + array.length);
            }
            for (int i = 0; i < array.length; ++i) {
                try {
                    array[i].send(this.os);
                    continue;
                }
                catch (Throwable e) {
                    RTLogger.print(2, "error sending object,", e);
                    throw new CommunicationException(e.getMessage(), 0);
                }
            }
            this.os.flush();
            this.m_sock.setSoTimeout(this.m_sock.getSoTimeout() + successSent * 50);
            char a = (char)this.is.read();
            if (a == '<') {
                StringBuffer sb = new StringBuffer("<");
                byte[] arr = new byte[64000];
                int count = -1;
                while ((count = this.is.read(arr)) != -1) {
                    sb.append(new String(arr, 0, count));
                }
                RTLogger.print(4, "Error from proxy: " + sb.toString());
            }
            if (a == 'T') {
                if (RTLogger.getCurrentLevel() >= 4) {
                    RTLogger.print(4, type + " block sent OK Submit Time: " + (System.currentTimeMillis() - n));
                }
                successSent = array.length;
            } else if (a != 'F' && successSent == array.length) {
                if (RTLogger.getCurrentLevel() >= 4) {
                    RTLogger.print(4, type + " block sent OK... Submit Time: " + (System.currentTimeMillis() - n));
                }
            } else {
                RTLogger.print(1, type + " failed sending block: " + a);
                throw new CommunicationException("socket error.", 0);
            }
            if (RTLogger.getCurrentLevel() >= 4) {
                RTLogger.print(4, "Submit Time: " + (System.currentTimeMillis() - n));
            }
        }
        catch (IOException e) {
            throw new CommunicationException("socket error.", e, 0);
        }
        finally {
            try {
                this.m_sock.setSoTimeout(soTimeoutBefore);
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void send(IODataStream[] array, char type, Queue<IODataStream> emergencyMessages) throws CommunicationException {
        block21: {
            long n = System.currentTimeMillis();
            RTLogger.print(5, "Start sending... " + type);
            int successSent = 0;
            int soTimeoutBefore = 60;
            try {
                int i;
                int emerg = 0;
                if (emergencyMessages != null) {
                    emerg = emergencyMessages.size();
                }
                soTimeoutBefore = this.m_sock.getSoTimeout();
                this.os.write(type);
                this.os.writeInt(array.length + emerg);
                this.os.flush();
                if (emergencyMessages != null && emerg > 0) {
                    RTLogger.print(5, "emerg msg::: " + emerg);
                    IODataStream[] emergs = emergencyMessages.toArray(new IODataStream[0]);
                    for (i = 0; i < emerg; ++i) {
                        try {
                            emergs[i].send(this.os);
                            continue;
                        }
                        catch (Throwable e) {
                            RTLogger.print(2, "error sending object,", e);
                            throw new CommunicationException(e.getMessage(), 0);
                        }
                    }
                }
                RTLogger.print(5, "msg::: " + array.length);
                for (int i2 = 0; i2 < array.length; ++i2) {
                    try {
                        array[i2].send(this.os);
                        continue;
                    }
                    catch (Throwable e) {
                        RTLogger.print(2, "error sending object,", e);
                        throw new CommunicationException(e.getMessage(), --successSent);
                    }
                }
                this.os.flush();
                this.m_sock.setSoTimeout(this.m_sock.getSoTimeout() + successSent * 50);
                char a = (char)this.is.read();
                if (a == 'T') {
                    RTLogger.print(4, "block sent OK Submit Time: " + (System.currentTimeMillis() - n));
                    successSent = array.length;
                    if (emergencyMessages != null) {
                        for (i = 0; i < emerg; ++i) {
                            emergencyMessages.poll();
                        }
                    }
                    break block21;
                }
                if (a != 'F' && successSent == array.length) {
                    RTLogger.print(4, "block sent OK... Submit Time: " + (System.currentTimeMillis() - n));
                    break block21;
                }
                RTLogger.print(1, "Failed sending block: " + a);
                throw new CommunicationException("socket error.", 0);
            }
            catch (IOException e) {
                throw new CommunicationException("socket error.", e, 0);
            }
            finally {
                try {
                    this.m_sock.setSoTimeout(soTimeoutBefore);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

