/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.IQueueMessageToServer;
import com.blixx.agent.ISendStream;
import com.blixx.agent.Message;
import com.blixx.agent.MonitorValue;
import com.blixx.log.RTLogger;
import com.blixx.shared.IODataStream;
import com.blixx.shared.exceptions.CommunicationException;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class SendBuffer
implements IQueueMessageToServer {
    private static final String MSGBUFFER = "MSGBUFFER";
    private static final String MONBUFFER = "MONBUFFER";
    public ArrayBlockingQueue<IODataStream> m_queue = null;
    public String bufferFileName = null;
    public File bufferFile = null;
    public int m_max_messages = 3000;
    LinkedBlockingQueue<IODataStream> m_emergency = new LinkedBlockingQueue(100);
    AtomicBoolean m_msg_BufferOverflow = new AtomicBoolean(false);
    AtomicBoolean m_mon_BufferOverflow = new AtomicBoolean(false);

    protected SendBuffer() {
    }

    public SendBuffer(String filename, int maxMessages) {
        this.m_max_messages = maxMessages;
        this.m_queue = new ArrayBlockingQueue(this.m_max_messages + 1);
        this.bufferFileName = filename != null ? filename : "monq.dat";
        RTLogger.print(5, "Buffer " + this.bufferFileName + " initialized with limit:" + this.m_max_messages);
        this.bufferFile = new File(this.bufferFileName);
        this.init();
    }

    protected void init() {
        try {
            if (!this.bufferFile.exists()) {
                this.bufferFile.createNewFile();
            } else {
                this.loadQueueFromFile();
            }
        }
        catch (IOException e) {
            RTLogger.print(1, "Can't create monq.dat file", e);
        }
    }

    protected void loadQueueFromFile() throws IOException {
        if (this.bufferFile.canRead()) {
            try (SDataInputStream dis = new SDataInputStream(new FileInputStream(this.bufferFile));){
                for (int i = 0; i < this.m_max_messages; ++i) {
                    MonitorValue mv = new MonitorValue();
                    if (dis.available() == 0) {
                        break;
                    }
                    mv.read(dis);
                    while (!this.m_queue.offer(mv)) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
            catch (Throwable e) {
                RTLogger.print(5, "Send buffer file corrupted. " + this.bufferFileName);
            }
            boolean isOK = false;
            try {
                isOK = this.bufferFile.delete();
                isOK = this.bufferFile.createNewFile();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!isOK) {
                RTLogger.print(2, "can't empty file Send Buffer file: " + this.bufferFileName);
            }
        }
    }

    @Override
    public void put(IODataStream mv) throws InterruptedException {
        if (this.m_queue.size() > this.m_max_messages - 1) {
            this.m_queue.poll();
            this.createOverflowMessage(mv);
        } else if ((double)this.m_queue.size() < (double)this.m_max_messages * 0.9) {
            if (mv instanceof Message) {
                if (this.m_msg_BufferOverflow.compareAndSet(true, false)) {
                    RTLogger.print(1, "MsgBufferOverflow OFF.");
                }
            } else if (mv instanceof MonitorValue && this.m_mon_BufferOverflow.compareAndSet(true, false)) {
                RTLogger.print(1, "MonBufferOverflow OFF.");
            }
        }
        if (!this.m_queue.offer(mv, 100L, TimeUnit.MILLISECONDS)) {
            RTLogger.print(2, "M Buffer timeout. " + this.bufferFileName.replace(".dat", ""));
        }
    }

    public void putEmergency(Message msg) {
        this.m_emergency.offer(msg);
    }

    private void createOverflowMessage(IODataStream mv) {
        try {
            if (mv instanceof Message && this.m_msg_BufferOverflow.compareAndSet(false, true)) {
                Message m_msgBufferOverflow = new Message("BOOM_AGENT", MSGBUFFER, "Agent buffer overflow detected, max buffered messages: " + this.m_max_messages, System.currentTimeMillis());
                String agentHostname = AgentEngine.getInstance().getAgentHostname();
                m_msgBufferOverflow.setOptional("critical", "BOOM_AGENT", agentHostname);
                m_msgBufferOverflow.p8_messageKey = agentHostname + ":" + "BOOM_AGENT" + ":" + MSGBUFFER;
                RTLogger.print(1, "MsgBufferOverflow ON.");
                this.m_emergency.offer(m_msgBufferOverflow);
            } else if (mv instanceof MonitorValue && this.m_mon_BufferOverflow.compareAndSet(false, true)) {
                Message m_monBufferOverflow = new Message("BOOM_AGENT", MONBUFFER, "Agent buffer overflow detected, max buffered monitors: " + this.m_max_messages, System.currentTimeMillis());
                String agentHostname = AgentEngine.getInstance().getAgentHostname();
                m_monBufferOverflow.setOptional("critical", "BOOM_AGENT", agentHostname);
                m_monBufferOverflow.p8_messageKey = agentHostname + ":" + "BOOM_AGENT" + ":" + MONBUFFER;
                RTLogger.print(1, "MonBufferOverflow ON.");
                this.m_emergency.offer(m_monBufferOverflow);
            }
        }
        catch (Throwable e) {
            RTLogger.print(5, "BufferOverflow err.", e);
        }
    }

    public void storeInFile() {
        try (SDataOutputStream dos = new SDataOutputStream(new FileOutputStream(this.bufferFile, true), AgentEngine.getInstance().getProtocolVersion());){
            IODataStream mvt = null;
            while ((mvt = this.m_queue.poll()) != null) {
                mvt.send(dos);
            }
        }
        catch (Throwable e) {
            RTLogger.print(1, "can't write " + this.bufferFileName);
        }
    }

    public int sizeC1() {
        int size = this.m_queue.size() + this.m_emergency.size();
        return size;
    }

    public synchronized int sendBlock(ISendStream sc) throws CommunicationException {
        int res = -1;
        IODataStream[] array = new IODataStream[]{};
        array = this.m_queue.toArray(array);
        try {
            sc.send(array, 'S');
            res = array.length;
            for (int i = 0; i < res; ++i) {
                this.m_queue.poll();
            }
        }
        catch (CommunicationException e) {
            if (e.success > 0) {
                for (int i = 0; i < e.success; ++i) {
                    this.m_queue.poll();
                }
            }
            throw e;
        }
        return res;
    }

    public LinkedBlockingQueue<IODataStream> GetEmergencies() {
        return this.m_emergency;
    }

    public List<IODataStream> peek(int maxCount) {
        int count;
        Iterator<IODataStream> it;
        ArrayList<IODataStream> objects = new ArrayList<IODataStream>(maxCount);
        if (this.m_emergency != null && !this.m_emergency.isEmpty()) {
            it = this.m_emergency.iterator();
            for (count = 0; count < maxCount && it.hasNext(); ++count) {
                objects.add(it.next());
            }
        }
        if (count < maxCount && this.m_queue != null && !this.m_queue.isEmpty()) {
            it = this.m_queue.iterator();
            while (count < maxCount && it.hasNext()) {
                objects.add(it.next());
                ++count;
            }
        }
        return objects;
    }

    public void drop(List<?> objects) {
        this.m_emergency.removeAll(objects);
        this.m_queue.removeAll(objects);
    }
}

