/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.ISendStream;
import com.blixx.agent.PerfRecord;
import com.blixx.agent.SendBuffer;
import com.blixx.log.RTLogger;
import com.blixx.shared.BM;
import com.blixx.shared.IODataStream;
import com.blixx.shared.exceptions.CommunicationException;
import com.boom.netty.service.events.PerfAgt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.ArrayBlockingQueue;

public class SendPerfBuffer
extends SendBuffer {
    public SendPerfBuffer(String filename, int maxMessages) {
        this.m_max_messages = maxMessages;
        this.m_queue = new ArrayBlockingQueue(this.m_max_messages);
        this.bufferFileName = filename != null ? filename : BM.perfBuffer_msgq_dat;
        RTLogger.print(5, "Buffer " + this.bufferFileName + " initialized with limit:" + this.m_max_messages);
        this.bufferFile = new File(this.bufferFileName);
        this.init();
    }

    public void putPerfRecord(PerfAgt rec) throws InterruptedException {
        if (rec == null || rec.getRecordSet().isEmpty()) {
            return;
        }
        for (PerfAgt.PerfValue val : rec.getRecordSet().values()) {
            String value;
            if (!"VARCHAR".equals(val.getType()) || (value = val.getValue()) == null) continue;
            value = value.replace("<$AGENT_HOST>", AgentEngine.getInstance().getAgentHostname());
            value = value.replace("<$AGENT_IP>", AgentEngine.getInstance().getAgentIP());
            value = value.replace("<$AGENT_ID>", AgentEngine.getInstance().getAgentID());
            val.setValue(value);
        }
        PerfRecord pr = new PerfRecord(rec);
        this.put(pr);
    }

    @Override
    public synchronized int sendBlock(ISendStream sc) throws CommunicationException {
        int res = -1;
        IODataStream[] array = new IODataStream[]{};
        array = this.m_queue.toArray(array);
        try {
            sc.send(array, 'R');
            res = array.length;
            for (int i = 0; i < res; ++i) {
                this.m_queue.poll();
            }
        }
        catch (CommunicationException e) {
            if (e.success > 0) {
                for (int i = 0; i < e.success; ++i) {
                    this.m_queue.poll();
                }
            }
            throw e;
        }
        return res;
    }

    @Override
    public void storeInFile() {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.bufferFile);
            Gson gson = new GsonBuilder().create();
            gson.toJson((Object)this.m_queue.toArray(), (Appendable)writer);
        }
        catch (Exception e) {
            RTLogger.print(1, "can't write " + this.bufferFileName);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadQueueFromFile() throws FileNotFoundException, IOException {
        if (this.bufferFile.canRead()) {
            block17: {
                FileReader reader = null;
                try {
                    reader = new FileReader(this.bufferFile);
                    Gson gson = new GsonBuilder().create();
                    PerfAgt[] arr = gson.fromJson((Reader)reader, PerfAgt[].class);
                    if (arr == null) break block17;
                    for (int i = 0; i < this.m_max_messages; ++i) {
                        if (this.m_queue.offer(new PerfRecord(arr[i]))) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    RTLogger.print(5, "Send buffer file corrupted. " + this.bufferFileName);
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
            boolean isOK = false;
            try {
                isOK = this.bufferFile.delete();
                isOK = this.bufferFile.createNewFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!isOK) {
                RTLogger.print(2, "can't empty file Send Buffer file: " + this.bufferFileName);
            }
        }
    }
}

