/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.MMObject;
import com.blixx.agent.MsgBuffer;
import com.blixx.agent.SClient;
import com.blixx.agent.SendBuffer;
import com.blixx.agent.SendBufferFA;
import com.blixx.agent.SendPerfBuffer;
import com.blixx.agent.SocketFactory;
import com.blixx.log.RTLogger;
import com.blixx.sa.ExecResult;
import com.blixx.sa.ExecUtils;
import com.blixx.sa.SchedulerTask;
import com.blixx.shared.IODataStream;
import com.blixx.shared.Interval;
import com.blixx.shared.ServerInfo;
import com.blixx.shared.io.SDataInputStream;
import com.blixx.shared.io.SDataOutputStream;
import com.boom.SocketUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicBoolean;

public class SendTask
extends SchedulerTask {
    protected SendBuffer buffer = null;
    protected SClient client = null;
    protected MsgBuffer mbuffer = null;
    protected SendBufferFA finishedAlertsBuffer = null;
    protected SendPerfBuffer perfBuffer = null;
    protected AgentEngine ae;
    protected boolean isRunning = false;
    protected boolean isBuffering = false;
    protected boolean isBkpIfaceStarted = false;

    public SendTask() {
        super("sendTask__@@INTERNAL");
        this.setInterval(Interval.getSimpleInterval(2));
        this.ae = AgentEngine.getInstance();
        this.buffer = this.ae.getMonitorQueue();
        this.mbuffer = this.ae.getMessageQueue();
        this.finishedAlertsBuffer = this.ae.getFAQueue();
        this.perfBuffer = this.ae.getPerfQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean onGetData() {
        if (!AgentEngine.isPIDStored()) {
            return true;
        }
        if (!this.isBkpIfaceStarted && this.ae.m_hb != null && this.ae.m_hb.isPingNecessary()) {
            if (this.buffer.sizeC1() <= 0) {
                if (this.mbuffer.sizeC1() <= 0) return true;
            }
            this.isBuffering = true;
            return true;
        }
        int sent = 0;
        Socket s = null;
        int protocolVersion = this.ae.getProtocolVersion();
        try {
            block42: {
                SDataOutputStream os;
                SDataInputStream is;
                block40: {
                    if (this.buffer.sizeC1() <= 0 && this.mbuffer.sizeC1() <= 0 && this.finishedAlertsBuffer.sizeC1() <= 0 && this.perfBuffer.sizeC1() <= 0 && !this.ae.getAgentOutageRepository().needToSend() && !this.ae.getAgentProperties().getKeepConnectionOpen()) break block42;
                    if (this.ae.getAgentProperties().getKeepConnectionOpen()) {
                        RTLogger.print(3, this.getName() + " reconnects");
                    }
                    String localIP = null;
                    is = null;
                    os = null;
                    try {
                        s = this.socketConnect();
                        localIP = s.getLocalAddress().getHostAddress();
                        is = new SDataInputStream(s.getInputStream());
                        os = new SDataOutputStream(s.getOutputStream(), protocolVersion);
                        if (this.ae.getAgentProperties().isTlsActivated()) {
                            s = SocketFactory.upgradeToTLS(s);
                        }
                    }
                    catch (Throwable e2) {
                        if (!this.isBkpIfaceStarted) throw e2;
                        s = this.socketConnect();
                        localIP = s.getLocalAddress().getHostAddress();
                        is = new SDataInputStream(s.getInputStream());
                        os = new SDataOutputStream(s.getOutputStream(), protocolVersion);
                        if (!this.ae.getAgentProperties().isTlsActivated()) break block40;
                        s = SocketFactory.upgradeToTLS(s);
                    }
                }
                this.isRunning = true;
                os.write(86);
                os.setVersion(protocolVersion);
                os.writeInt(protocolVersion);
                os.write(70);
                os.writeUTF(this.ae.getAgentID());
                try {
                    os.write(123);
                    os.write(86);
                    os.writeInt(1);
                }
                catch (Throwable e1) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.processOldVersionProtocol();
                    boolean bl = true;
                    SocketUtils.closeSocket(s, new AutoCloseable[0]);
                    int notsent = this.buffer.sizeC1() + this.mbuffer.sizeC1();
                    if (sent != 0 || notsent != 0) {
                        if (sent > 0 && this.ae.getAgentProperties().getOldMainServer() != null) {
                            this.ae.getAgentProperties().setOldMainServer(null);
                        } else if (sent < 0) {
                            this.isBuffering = true;
                        }
                        RTLogger.print(2, "M sent: " + sent + " pending: " + notsent);
                    }
                    this.isRunning = false;
                    return bl;
                }
                AtomicBoolean isWaiting = new AtomicBoolean(false);
                long startWaiting = System.currentTimeMillis();
                do {
                    block41: {
                        block43: {
                            sent = 0;
                            if (this.ae.getAgentOutageRepository().needToSend()) {
                                this.ae.getAgentOutageRepository().send(os, is);
                            }
                            this.client = new SClient(s, is, os);
                            if (this.buffer.sizeC1() > 0) {
                                sent = this.buffer.sendBlock(this.client);
                            }
                            if (this.mbuffer.sizeC1() > 0) {
                                sent += this.mbuffer.sendBlock(this.client);
                            }
                            if (this.finishedAlertsBuffer.sizeC1() > 0) {
                                sent += this.finishedAlertsBuffer.sendBlock(this.client);
                            }
                            if (this.perfBuffer.sizeC1() > 0) {
                                this.perfBuffer.sendBlock(this.client);
                            }
                            if (sent != 0) break block43;
                            if (isWaiting.compareAndSet(false, true)) {
                                startWaiting = System.currentTimeMillis();
                                break block41;
                            } else if (System.currentTimeMillis() - startWaiting > 2000L) {
                                os.write(79);
                                os.writeUTF("P");
                                os.writeInt(-1);
                                String answer = is.readUTF();
                                startWaiting = System.currentTimeMillis();
                                break block41;
                            } else {
                                Thread.sleep(10L);
                            }
                            break block41;
                        }
                        isWaiting.set(false);
                        startWaiting = System.currentTimeMillis();
                    }
                    this.isBuffering = false;
                } while (this.ae.getAgentProperties().getKeepConnectionOpen());
                os.write(125);
                this.setInterval(Interval.getSimpleInterval(2));
                if (this.ae.getAgentProperties().getKeepConnectionOpen()) {
                    RTLogger.print(3, this.getName() + " disconnects");
                }
            }
            this.isBuffering = false;
        }
        catch (Throwable e) {
            try {
                RTLogger.print(3, "Send events failed ", e);
                this.setInterval(Interval.getSimpleInterval(10));
                this.isBuffering = true;
                return true;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                SocketUtils.closeSocket(s, new AutoCloseable[0]);
                int notsent = this.buffer.sizeC1() + this.mbuffer.sizeC1();
                if (sent != 0 || notsent != 0) {
                    if (sent > 0 && this.ae.getAgentProperties().getOldMainServer() != null) {
                        this.ae.getAgentProperties().setOldMainServer(null);
                    } else if (sent < 0) {
                        this.isBuffering = true;
                    }
                    RTLogger.print(2, "M sent: " + sent + " pending: " + notsent);
                }
                this.isRunning = false;
            }
        }
        SocketUtils.closeSocket(s, new AutoCloseable[0]);
        int notsent = this.buffer.sizeC1() + this.mbuffer.sizeC1();
        if (sent != 0 || notsent != 0) {
            if (sent > 0 && this.ae.getAgentProperties().getOldMainServer() != null) {
                this.ae.getAgentProperties().setOldMainServer(null);
            } else if (sent < 0) {
                this.isBuffering = true;
            }
            RTLogger.print(2, "M sent: " + sent + " pending: " + notsent);
        }
        this.isRunning = false;
        return true;
    }

    public Socket socketConnect() throws Exception {
        Socket s = SocketFactory.getSocket(this.ae, SendTask.getReadTimeOut());
        SocketFactory.bindSocket(this.ae, s);
        ServerInfo currentServer = this.ae.getServers().getCurrentServer();
        try {
            InetSocketAddress serverAddrByHost = new InetSocketAddress(currentServer.getHost(), currentServer.getPort());
            if (serverAddrByHost.isUnresolved()) {
                throw new SocketException("Unresolved hostname");
            }
            s.connect(serverAddrByHost, this.getConnectTimeOut());
        }
        catch (SocketException e1) {
            s = SocketFactory.getSocket(this.ae, SendTask.getReadTimeOut());
            SocketFactory.bindSocket(this.ae, s);
            s.connect(new InetSocketAddress(currentServer.getPublicIP(), currentServer.getPort()), this.getConnectTimeOut());
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOldVersionProtocol() {
        int sent;
        Socket s;
        block18: {
            s = null;
            sent = 0;
            try {
                SDataOutputStream os;
                SDataInputStream is;
                String localIP;
                if (this.mbuffer.sizeC1() > 0) {
                    s = this.socketConnect();
                    this.isRunning = true;
                    localIP = s.getLocalAddress().getHostAddress();
                    is = new SDataInputStream(s.getInputStream());
                    os = new SDataOutputStream(s.getOutputStream(), 2);
                    os.write(86);
                    os.writeInt(1);
                    os.write(70);
                    os.writeUTF(this.ae.getAgentID());
                    this.client = new SClient(s, is, os);
                    sent += this.mbuffer.sendBlock(this.client);
                    this.setInterval(Interval.getSimpleInterval(2));
                    SocketUtils.closeSocket(s, os, is);
                }
                if (this.finishedAlertsBuffer.sizeC1() > 0) {
                    s = this.socketConnect();
                    this.isRunning = true;
                    localIP = s.getLocalAddress().getHostAddress();
                    is = new SDataInputStream(s.getInputStream());
                    os = new SDataOutputStream(s.getOutputStream(), 2);
                    os.write(86);
                    os.writeInt(1);
                    os.write(70);
                    os.writeUTF(this.ae.getAgentID());
                    this.client = new SClient(s, is, os);
                    sent += this.finishedAlertsBuffer.sendBlock(this.client);
                    this.setInterval(Interval.getSimpleInterval(2));
                    SocketUtils.closeSocket(s, os, is);
                }
                if (this.perfBuffer.sizeC1() <= 0) break block18;
                s = this.socketConnect();
                this.isRunning = true;
                localIP = s.getLocalAddress().getHostAddress();
                is = new SDataInputStream(s.getInputStream());
                os = new SDataOutputStream(s.getOutputStream(), 2);
                os.write(86);
                os.writeInt(1);
                os.write(70);
                os.writeUTF(this.ae.getAgentID());
                this.client = new SClient(s, is, os);
                this.perfBuffer.sendBlock(this.client);
                this.setInterval(Interval.getSimpleInterval(2));
                SocketUtils.closeSocket(s, os, is);
                this.isBuffering = false;
            }
            catch (Throwable e) {
                try {
                    RTLogger.print(5, "Send events failed ", e);
                    this.setInterval(Interval.getSimpleInterval(2));
                    this.isBuffering = true;
                }
                catch (Throwable throwable) {
                    SocketUtils.closeSocket(s, new AutoCloseable[0]);
                    int notsent = this.buffer.sizeC1() + this.mbuffer.sizeC1();
                    if (sent != 0 || notsent != 0) {
                        if (sent > 0 && this.ae.getAgentProperties().getOldMainServer() != null) {
                            this.ae.getAgentProperties().setOldMainServer(null);
                        } else if (sent < 0) {
                            this.isBuffering = true;
                        }
                        StringBuffer sb = new StringBuffer();
                        sb.append("M sent: ").append(sent).append(" pending: ").append(notsent);
                        RTLogger.print(2, sb);
                    }
                    this.isRunning = false;
                    throw throwable;
                }
                SocketUtils.closeSocket(s, new AutoCloseable[0]);
                int notsent = this.buffer.sizeC1() + this.mbuffer.sizeC1();
                if (sent != 0 || notsent != 0) {
                    if (sent > 0 && this.ae.getAgentProperties().getOldMainServer() != null) {
                        this.ae.getAgentProperties().setOldMainServer(null);
                    } else if (sent < 0) {
                        this.isBuffering = true;
                    }
                    StringBuffer sb = new StringBuffer();
                    sb.append("M sent: ").append(sent).append(" pending: ").append(notsent);
                    RTLogger.print(2, sb);
                }
                this.isRunning = false;
            }
        }
        SocketUtils.closeSocket(s, new AutoCloseable[0]);
        int notsent = this.buffer.sizeC1() + this.mbuffer.sizeC1();
        if (sent != 0 || notsent != 0) {
            if (sent > 0 && this.ae.getAgentProperties().getOldMainServer() != null) {
                this.ae.getAgentProperties().setOldMainServer(null);
            } else if (sent < 0) {
                this.isBuffering = true;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("M sent: ").append(sent).append(" pending: ").append(notsent);
            RTLogger.print(2, sb);
        }
        this.isRunning = false;
    }

    @Override
    public boolean onInit() throws Exception {
        return true;
    }

    @Override
    public boolean onStartRun() {
        if (this.ae.getAgentProperties().isBkpInterfaceEnabled() && this.ae.getTimeFromLastServerPing() > this.ae.getAgentProperties().getBkpInterfaceTimeThreshold().getIntervalMilliseconds() && this.isBuffering && this.ae.m_hb.getTimeFromLastRealPing() > this.ae.getAgentProperties().getBkpInterfaceTimeThreshold().getIntervalMilliseconds()) {
            MMObject mmo;
            boolean isFoundAnyMessageWithAVAILABILITY = false;
            for (IODataStream obj : this.buffer.m_queue) {
                if (!(obj instanceof MMObject)) continue;
                mmo = (MMObject)obj;
                if (mmo.p21_typeA <= 0) continue;
                isFoundAnyMessageWithAVAILABILITY = true;
                break;
            }
            if (!isFoundAnyMessageWithAVAILABILITY) {
                for (IODataStream obj : this.mbuffer.m_queue) {
                    if (!(obj instanceof MMObject)) continue;
                    mmo = (MMObject)obj;
                    if (mmo.p21_typeA <= 0) continue;
                    isFoundAnyMessageWithAVAILABILITY = true;
                    break;
                }
            }
            if (isFoundAnyMessageWithAVAILABILITY) {
                try {
                    RTLogger.print(1, "BkpInterface: executing start command: " + this.ae.getAgentProperties().getBkpInterfaceStart());
                    ExecResult er = ExecUtils.exec2(this.ae.getAgentProperties().getBkpInterfaceStart(), new File("."), 120);
                    if (er.resultCode != 0) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("BkpInterface: error executing start command. RC=").append(er.resultCode).append(" ").append(er.getOutput());
                        RTLogger.print(1, sb);
                    } else {
                        RTLogger.print(1, "BkpInterface: interface started.");
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                catch (IOException e) {
                    RTLogger.print(1, "BkpInterface: Error executing start command", e);
                }
                this.isBkpIfaceStarted = true;
            }
        }
        return true;
    }

    @Override
    public boolean onStopRun() {
        if (this.isBkpIfaceStarted) {
            this.isBkpIfaceStarted = false;
            try {
                RTLogger.print(1, "BkpInterface: executing stop command: " + this.ae.getAgentProperties().getBkpInterfaceStop());
                ExecResult er = ExecUtils.exec2(this.ae.getAgentProperties().getBkpInterfaceStop(), new File("."), 120);
                if (er.resultCode != 0) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("BkpInterface: error executing stop command. RC=").append(er.resultCode).append(" ").append(er.getOutput());
                    RTLogger.print(1, sb);
                }
            }
            catch (IOException e) {
                RTLogger.print(1, "BkpInterface: error executing stop command.", e);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    protected boolean onStopTask() {
        return true;
    }

    @Override
    public boolean refresh() {
        return true;
    }

    private int getConnectTimeOut() {
        return this.ae.getAgentProperties().getHbConnectTimeoutMs();
    }

    public static int getReadTimeOut() {
        return 60000;
    }

    @Override
    public boolean iCanRunLongerThanScheduleInterval() {
        return this.ae.getAgentProperties().getKeepConnectionOpen();
    }
}

