/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.AgentOutage;
import com.blixx.agent.AgentOutageFinished;
import com.blixx.agent.MMObject;
import com.blixx.agent.MonitorValue;
import com.blixx.agent.MsgBuffer;
import com.blixx.agent.NettyEndpoint;
import com.blixx.agent.PerfRecord;
import com.blixx.agent.SendBuffer;
import com.blixx.agent.SendBufferFA;
import com.blixx.agent.SendMessageBase;
import com.blixx.agent.SendPerfBuffer;
import com.blixx.log.RTLogger;
import com.blixx.sa.FA;
import com.blixx.sa.Opts;
import com.blixx.sa.SchedulerTask;
import com.blixx.shared.IODataStream;
import com.blixx.shared.Interval;
import com.boom.netty.common.MessageSender;
import com.boom.netty.service.events.AgentMessageTypes;
import com.boom.netty.service.events.AgentOutageList;
import com.boom.netty.service.events.BoomEventAgt;
import com.boom.netty.service.events.BoomEventList;
import com.boom.netty.service.events.FinishedAlertAgt;
import com.boom.netty.service.events.FinishedAlertAgtList;
import com.boom.netty.service.events.OperationFail;
import com.boom.netty.service.events.OperationOk;
import com.boom.netty.service.events.PerfAgtList;
import com.boom.netty.ws.mhf.MessageTypeRegistrationException;
import com.boom.netty.ws.mhf.annotation.MessageHandlerMethod;
import com.boom.netty.ws.mhf.msg.MessageBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;

public class SendTaskNetty
extends SchedulerTask {
    private Pattern caAttrPattern = Pattern.compile("CA\\d+");
    private Map<String, SendMessageBase> signalsInProgress = new HashMap<String, SendMessageBase>(5);
    public SendBuffer buffer = null;
    public MsgBuffer mbuffer = null;
    public SendBufferFA fa_buffer = null;
    public SendPerfBuffer perfBuffer = null;
    private int maxMessagesInChunk = 100;
    private NettyEndpoint nettyEndpoint;
    private AgentEngine agentEngine;

    public SendTaskNetty(int maxMessages, AgentEngine agentEngine, NettyEndpoint nettyEndpoint) {
        super("sendTaskNetty__@@INTERNAL");
        this.setInterval(Interval.getSimpleInterval(1));
        this.nettyEndpoint = nettyEndpoint;
        this.agentEngine = agentEngine;
        this.buffer = agentEngine.getMonitorQueue();
        this.mbuffer = agentEngine.getMessageQueue();
        this.fa_buffer = agentEngine.getFAQueue();
        this.perfBuffer = agentEngine.getPerfQueue();
        this.ensureRegistration(nettyEndpoint.getMessageSender());
    }

    @Override
    public boolean onGetData() {
        if (!AgentEngine.isPIDStored()) {
            return true;
        }
        if (this.agentEngine.getHB() != null && this.agentEngine.getHB().isPingNecessary() && !"WEBSOCKET_ONLY".equals(this.agentEngine.getAgentProperties().getCommType()) && !"WEBSOCKET_TLS_ONLY".equals(this.agentEngine.getAgentProperties().getCommType())) {
            return true;
        }
        if (!this.nettyEndpoint.isAnyOneReadyToReceiveDataViaNetty()) {
            return true;
        }
        this.sendEvents();
        this.sendFAs();
        this.sendPerf();
        this.sendOutages();
        return true;
    }

    private void sendEvents() {
        MessageSender nettyClient = this.nettyEndpoint.getMessageSender();
        if (this.canSendNewMessage(BoomEventList.class) && (this.buffer.sizeC1() > 0 || this.mbuffer.sizeC1() > 0)) {
            BoomEventList events = new BoomEventList(this.nettyEndpoint.getConnectedServerId(), UUID.randomUUID().toString());
            List<IODataStream> objects = this.buffer.peek(this.maxMessagesInChunk);
            if (objects.size() < this.maxMessagesInChunk) {
                List<IODataStream> msgObjects = this.mbuffer.peek(this.maxMessagesInChunk - objects.size());
                objects.addAll(msgObjects);
            }
            if (!objects.isEmpty()) {
                for (IODataStream obj : objects) {
                    if (obj instanceof MMObject) {
                        events.getEvents().add(this.getBoomEventAgt((MMObject)obj));
                        continue;
                    }
                    RTLogger.print(5, "unsupported object in the indications queue " + obj);
                }
                this.sendMessage(nettyClient, events, objects);
                RTLogger.print(3, " -- netty sending events: " + objects.size());
            }
        }
    }

    private void sendFAs() {
        MessageSender nettyClient = this.nettyEndpoint.getMessageSender();
        if (this.canSendNewMessage(FinishedAlertAgtList.class) && this.fa_buffer.sizeC1() > 0) {
            FinishedAlertAgtList finishedAlerts = new FinishedAlertAgtList(this.nettyEndpoint.getConnectedServerId(), UUID.randomUUID().toString());
            List<IODataStream> objects = this.fa_buffer.peek(this.maxMessagesInChunk);
            if (!objects.isEmpty()) {
                for (IODataStream obj : objects) {
                    if (!(obj instanceof FA)) continue;
                    finishedAlerts.getElements().add(this.getFA((FA)obj));
                }
                this.sendMessage(nettyClient, finishedAlerts, objects);
                RTLogger.print(3, " -- Sending FAs: " + objects.size());
            }
        }
    }

    private void sendPerf() {
        MessageSender nettyClient = this.nettyEndpoint.getMessageSender();
        if (this.canSendNewMessage(PerfAgtList.class) && this.perfBuffer.sizeC1() > 0) {
            PerfAgtList perfs = new PerfAgtList(this.nettyEndpoint.getConnectedServerId(), UUID.randomUUID().toString());
            List<IODataStream> objects = this.perfBuffer.peek(this.maxMessagesInChunk);
            if (!objects.isEmpty()) {
                for (IODataStream obj : objects) {
                    if (!(obj instanceof PerfRecord)) continue;
                    perfs.getRecords().add(((PerfRecord)obj).rec);
                }
                this.sendMessage(nettyClient, perfs, objects);
                RTLogger.print(3, " -- Sending perfs: " + objects.size());
            }
        }
    }

    private void sendOutages() {
        MessageSender nettyClient = this.nettyEndpoint.getMessageSender();
        if (this.canSendNewMessage(AgentOutageList.class) && this.agentEngine.getAgentOutageRepository().needToSend()) {
            AgentOutageList allOutages = new AgentOutageList(this.nettyEndpoint.getConnectedServerId(), UUID.randomUUID().toString());
            ArrayList<AgentOutage> objects = new ArrayList<AgentOutage>();
            List<AgentOutage> started = this.agentEngine.getAgentOutageRepository().getAgentOutages();
            for (AgentOutage ou : started) {
                com.boom.netty.service.events.AgentOutage agentOutage = new com.boom.netty.service.events.AgentOutage();
                agentOutage.start = true;
                agentOutage.id = ou.id;
                agentOutage.action = ou.action;
                agentOutage.duration = ou.duration;
                agentOutage.interval = ou.interval;
                agentOutage.filters = ou.m_filters.toString();
                agentOutage.postactiion = ou.postactiion;
                allOutages.getOutages().add(agentOutage);
                objects.add(ou);
            }
            List<AgentOutageFinished> finished = this.agentEngine.getAgentOutageRepository().getAgentOutagesFinished();
            for (AgentOutage agentOutage : finished) {
                com.boom.netty.service.events.AgentOutage toSend = new com.boom.netty.service.events.AgentOutage();
                toSend.start = false;
                toSend.id = agentOutage.id;
                toSend.action = agentOutage.action;
                toSend.duration = agentOutage.duration;
                toSend.interval = agentOutage.interval;
                toSend.filters = agentOutage.m_filters.toString();
                toSend.postactiion = agentOutage.postactiion;
                allOutages.getOutages().add(toSend);
                objects.add(agentOutage);
            }
            if (!objects.isEmpty()) {
                this.sendMessage(nettyClient, allOutages, objects);
                RTLogger.print(3, " -- Sending outages: " + objects.size());
            }
        }
    }

    private void sendMessage(MessageSender nettyClient, MessageBase message, List<?> objects) {
        SendMessageBase currentOperation = new SendMessageBase(message, objects);
        try {
            this.signalsInProgress.put(message.getOperationId(), currentOperation);
            nettyClient.sendMessage(currentOperation.getNettyMessage());
            RTLogger.print(4, "Send operation " + currentOperation + " started");
        }
        catch (Exception e) {
            this.dropOperation(message.getOperationId());
            throw e;
        }
    }

    public SendMessageBase getRunningMessage(Class clazz) {
        for (SendMessageBase msg : this.signalsInProgress.values()) {
            if (msg.getNettyMessage().getClass() != clazz) continue;
            return msg;
        }
        return null;
    }

    public boolean canSendNewMessage(Class clazz) {
        SendMessageBase msg = this.getRunningMessage(clazz);
        if (msg != null) {
            if (msg.getTime() < System.currentTimeMillis() - 30000L) {
                this.dropOperation(msg.getNettyMessage().getOperationId());
            } else {
                return false;
            }
        }
        return true;
    }

    private void dropOperation(String id) {
        RTLogger.print(3, "operation dropped " + id);
        this.signalsInProgress.remove(id);
    }

    @Override
    public boolean onInit() throws Exception {
        return true;
    }

    private void ensureRegistration(MessageSender messageSender) {
        try {
            messageSender.registerMessageTypes(AgentMessageTypes.BASIC_MESSAGE_TYPES);
            messageSender.registerHandler(this);
            RTLogger.print(1, "Netty client registration done.");
        }
        catch (MessageTypeRegistrationException e) {
            RTLogger.print(1, "Netty client registration failed.", e);
        }
    }

    private BoomEventAgt getBoomEventAgt(MMObject msg) {
        BoomEventAgt evt = new BoomEventAgt();
        evt.uuid = msg.p00_uuid;
        evt.state = msg.p30_state == null || msg.p30_state.isEmpty() ? (char)45 : msg.p30_state.charAt(0);
        evt.time = msg.p1_time;
        evt.application = msg.m_CAs.containsKey("<$APPLICATION>") ? msg.m_CAs.remove("<$APPLICATION>") : msg.p2_application;
        evt.object = msg.p3_object;
        evt.severity = msg.p4_severity;
        evt.text = msg.p5_msg_text;
        evt.instrId = msg.p6_instructionID;
        evt.instrAction = msg.m_CAs.remove(Opts.INSTRUCTION_ACTION);
        evt.group = msg.m_CAs.containsKey("<$GROUP>") ? msg.m_CAs.remove("<$GROUP>") : msg.p7_msg_grp;
        evt.key = msg.p8_messageKey;
        evt.closeMask = msg.p9_ackKey;
        evt.node = msg.p10_node;
        evt.autoAction = msg.p11_autoAction;
        evt.autoActionNode = msg.p11_1_autoActionNode;
        evt.autoActionTimeoutSec = msg.p11_2_autoActionTimeout;
        evt.autoActionOnDuplicate = msg.px_autoActionOnDuplicate;
        evt.source = msg.p12_source;
        evt.opAction = msg.p13_opAction;
        evt.typeA = msg.p21_typeA;
        evt.typeK = msg.p22_typeK;
        evt.dedupl = msg.p23_deduplication;
        evt.deduplKeyOnly = msg.p23_deduplicationKeyOnly;
        evt.deduplAgentOnly = msg.p23_deduplicationAgentOnly;
        evt.monitor = msg.p2_policyName;
        if (msg instanceof MonitorValue) {
            evt.value = ((MonitorValue)msg).p0_value;
        }
        msg.m_CAs.remove(Opts.DEDUPL_KEYONLY);
        for (Map.Entry<String, String> en : msg.m_CAs.entrySet()) {
            if (this.caAttrPattern.matcher(en.getKey()).matches()) {
                evt.customAttributes = msg.m_CAs;
                continue;
            }
            if (evt.tmpAttributes == null) {
                evt.tmpAttributes = new LinkedHashMap<String, String>();
            }
            evt.tmpAttributes.put(en.getKey(), en.getValue());
        }
        return evt;
    }

    public FinishedAlertAgt getFA(FA fa) {
        return new FinishedAlertAgt(fa.m_uuid, fa.m_time, fa.m_value);
    }

    @MessageHandlerMethod
    public void handle(OperationFail signal) {
        this.dropOperation(signal.getOperationId());
        RTLogger.print(3, "send operation failed : " + signal.getOperationId());
    }

    @MessageHandlerMethod
    public void handle(OperationOk signal) {
        try {
            this.log(signal);
            SendMessageBase currentOperation = this.signalsInProgress.get(signal.getOperationId());
            if (currentOperation != null) {
                if (currentOperation.getNettyMessage() instanceof BoomEventList) {
                    this.buffer.drop(currentOperation.getOriginalObjects());
                    this.mbuffer.drop(currentOperation.getOriginalObjects());
                } else if (currentOperation.getNettyMessage() instanceof FinishedAlertAgtList) {
                    this.fa_buffer.drop(currentOperation.getOriginalObjects());
                } else if (currentOperation.getNettyMessage() instanceof PerfAgtList) {
                    this.perfBuffer.drop(currentOperation.getOriginalObjects());
                } else if (currentOperation.getNettyMessage() instanceof AgentOutageList) {
                    this.agentEngine.getAgentOutageRepository().remove(currentOperation.getOriginalObjects());
                } else {
                    RTLogger.print(3, "Unknown class ? " + currentOperation.getNettyMessage());
                }
                this.dropOperation(signal.getOperationId());
            }
        }
        catch (Exception e) {
            RTLogger.print(1, "", e);
        }
    }

    private void log(OperationOk signal) {
        if (RTLogger.getCurrentLevel() >= 4) {
            long delta = -1L;
            SendMessageBase currentOperation = this.signalsInProgress.get(signal.getOperationId());
            if (currentOperation != null) {
                delta = System.currentTimeMillis() - currentOperation.getTime();
                RTLogger.print(4, "Send operation " + currentOperation.getClass() + " " + signal.getOperationId() + " successfully finished. " + delta + "ms count: " + currentOperation.getOriginalObjects().size());
            }
        }
    }

    public boolean isSignalInProgress(String operationId) {
        return this.signalsInProgress.keySet().contains(operationId);
    }

    @Override
    public boolean onStartRun() {
        return true;
    }

    @Override
    public boolean onStopRun() {
        return true;
    }

    @Override
    protected boolean onStopTask() {
        return true;
    }

    @Override
    public boolean refresh() {
        return true;
    }
}

