/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.HTTPOut;
import com.blixx.agent.SClient_HTTP;
import com.blixx.agent.SendTask;
import com.blixx.agent.utils.VirtualSocketAgent;
import com.blixx.log.RTLogger;
import com.blixx.shared.Interval;
import com.blixx.shared.io.SDataOutputStream;
import java.io.ByteArrayOutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;

public class SendTask_HTTP
extends SendTask {
    public static final String COMM_AGENT_SUBMIT = "/comm/agent/submit";
    public Proxy m_proxy;
    AgentEngine m_ha = null;

    public SendTask_HTTP(AgentEngine ae) {
        this.m_ha = ae;
        this.m_proxy = Proxy.NO_PROXY;
        if (this.m_ha.getAgentProperties().getProxyType() != null && this.m_ha.getAgentProperties().getProxyType().startsWith("HTTP") && this.m_ha.getAgentProperties().getProxyHost() != null && this.m_ha.getAgentProperties().getProxyPort() != 0) {
            this.m_proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.m_ha.getAgentProperties().getProxyHost(), this.m_ha.getAgentProperties().getProxyPort()));
        }
    }

    @Override
    public boolean onInit() throws Exception {
        boolean isOK = super.onInit();
        return isOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onGetData() {
        if (!AgentEngine.isPIDStored()) {
            return true;
        }
        if (!this.isBkpIfaceStarted && AgentEngine.getInstance().m_hb != null && AgentEngine.getInstance().m_hb.isPingNecessary()) {
            if (this.buffer.sizeC1() > 0 || this.mbuffer.sizeC1() > 0) {
                this.isBuffering = true;
            }
            return true;
        }
        int sent = 0;
        if (this.buffer.sizeC1() > 0 || this.mbuffer.sizeC1() > 0 || this.finishedAlertsBuffer.sizeC1() > 0 || this.perfBuffer.sizeC1() > 0 || AgentEngine.getInstance().getAgentOutageRepository().needToSend()) {
            this.isRunning = true;
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                SDataOutputStream os = new SDataOutputStream(bos, AgentEngine.getInstance().getProtocolVersion());
                os.write(86);
                os.writeInt(1);
                os.write(123);
                HTTPOut httpOut = new HTTPOut(this.m_proxy, this.m_ha, this.m_ha.getAgentProperties().getHbConnectTimeoutMs(), this.m_ha.getAgentProperties().getHbReadTimeoutMs());
                VirtualSocketAgent vsa = new VirtualSocketAgent(null, httpOut, COMM_AGENT_SUBMIT);
                vsa.getOs().setOutputStream(bos);
                this.client = new SClient_HTTP(vsa, vsa.getIs(), vsa.getOs());
                if (AgentEngine.getInstance().getAgentOutageRepository().needToSend()) {
                    AgentEngine.getInstance().getAgentOutageRepository().send(vsa.getOs(), vsa.getIs());
                    RTLogger.print(5, "HTTPS sent OUTAGE ");
                }
                if (this.buffer.sizeC1() > 0) {
                    sent = this.buffer.sendBlock(this.client);
                    RTLogger.print(5, "HTTPS sent MON " + sent);
                }
                if (this.mbuffer.sizeC1() > 0) {
                    int msgc = this.mbuffer.sendBlock(this.client);
                    RTLogger.print(5, "HTTPS sent MSG " + msgc);
                    sent += msgc;
                }
                if (this.finishedAlertsBuffer.sizeC1() > 0) {
                    int fac = this.finishedAlertsBuffer.sendBlock(this.client);
                    RTLogger.print(5, "HTTPS sent FA " + fac);
                    sent += fac;
                }
                if (this.perfBuffer.sizeC1() > 0) {
                    int pc = this.perfBuffer.sendBlock(this.client);
                    RTLogger.print(5, "HTTPS sent PERF " + pc);
                    this.perfBuffer.sendBlock(this.client);
                }
                vsa.getOs().write(125);
                vsa.close();
            }
            catch (Throwable e) {
                RTLogger.print(5, "HTTPS Send events failed ", e);
                this.setInterval(Interval.getSimpleInterval(10));
                this.isBuffering = true;
            }
            finally {
                RTLogger.print(2, new StringBuffer("MSG pending: ").append(this.mbuffer.sizeC1()).append(" MON pending: ").append(this.buffer.sizeC1()).append(" FA pending: ").append(this.finishedAlertsBuffer.sizeC1()).append(" PERF pending: ").append(this.perfBuffer.sizeC1()));
                this.isRunning = false;
            }
        }
        return true;
    }
}

