/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AProperties;
import com.blixx.agent.AgentEngine;
import com.blixx.log.RTLogger;
import com.blixx.shared.Cryptor;
import com.boom.TlsUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.concurrent.atomic.AtomicBoolean;

public class SocketFactory {
    private static AtomicBoolean proxyAuthInit = new AtomicBoolean(false);

    private SocketFactory() {
    }

    public static Socket getSocket(InetSocketAddress socksProxyInetAddr, int timeout) throws IOException {
        Proxy proxy = Proxy.NO_PROXY;
        if (socksProxyInetAddr != null) {
            proxy = new Proxy(Proxy.Type.SOCKS, socksProxyInetAddr);
        }
        Socket sock = new Socket(proxy);
        sock.setReuseAddress(true);
        sock.setSoTimeout(timeout);
        sock.setTcpNoDelay(true);
        sock.setSoLinger(true, 1);
        return sock;
    }

    public static Socket getSocket(AgentEngine ae, int timeout) throws IOException {
        InetSocketAddress socksInetAddr = null;
        socksInetAddr = SocketFactory.addProxyAuthN(ae, socksInetAddr);
        return SocketFactory.getSocket(socksInetAddr, timeout);
    }

    private static InetSocketAddress addProxyAuthN(AgentEngine ae, InetSocketAddress socksInetAddr) {
        AProperties ap;
        if (ae != null && (ap = ae.getAgentProperties()) != null) {
            try {
                if (ap.getProxyHost() != null && ap.getProxyHost().length() > 0 && ap.getProxyPort() > 0) {
                    socksInetAddr = new InetSocketAddress(ap.getProxyHost(), ap.getProxyPort());
                    if (!proxyAuthInit.get() && ap.getProxyUser() != null && ap.getProxyUser().length() > 0) {
                        Authenticator.setDefault(new ProxyAuth(ap.getProxyUser(), Cryptor.decrypt(ap.getProxyEnPass())));
                        proxyAuthInit.set(true);
                    }
                }
            }
            catch (Exception e) {
                RTLogger.print(2, "Proxy init failed", e);
            }
        }
        return socksInetAddr;
    }

    public static Socket upgradeToTLS(Socket originalClientSocket) throws IOException, KeyManagementException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        OutputStream osTmp = originalClientSocket.getOutputStream();
        osTmp.write(43);
        osTmp.flush();
        return TlsUtils.upgradeClientSocket(originalClientSocket, AgentEngine.getInstance().getCertManager());
    }

    public static void bindSocket(AgentEngine ae, Socket s) throws IOException {
        if (ae.isFixedIPUsed()) {
            InetSocketAddress bindpoint = null;
            try {
                bindpoint = new InetSocketAddress(ae.getAgentIP(), 0);
                s.bind(bindpoint);
            }
            catch (Exception e) {
                s.bind(null);
            }
        } else {
            s.bind(null);
        }
    }

    public static class ProxyAuth
    extends Authenticator {
        private PasswordAuthentication auth;

        private ProxyAuth(String user, String password) {
            this.auth = new PasswordAuthentication(user, password == null ? new char[]{} : password.toCharArray());
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return this.auth;
        }
    }
}

