/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.AgentHealth;
import com.blixx.agent.CalcEngine;
import com.blixx.agent.MonitorValue;
import com.blixx.agent.Tracker;
import com.blixx.log.RTLogger;
import com.blixx.shared.IODataStream;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Submitter
implements Runnable {
    ConcurrentLinkedQueue<IODataStream> queue = new ConcurrentLinkedQueue();

    @Override
    public void run() {
        while (true) {
            this.process();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public synchronized void submit(IODataStream mv) {
        AgentHealth.m_totalMonitorValues.incrementAndGet();
        if (!AgentEngine.getInstance().getDisabled()) {
            this.queue.offer(mv);
        }
    }

    public void process() {
        MonitorValue mv = null;
        try {
            CalcEngine calcEngine = AgentEngine.getInstance().getCalcEngine();
            if (calcEngine == null) {
                return;
            }
            while ((mv = (MonitorValue)this.queue.peek()) != null) {
                if (Tracker.checkIfExpired(mv.p2_policyName) == -1) {
                    RTLogger.print(3, "unknown monitor " + mv.p2_policyName);
                    this.queue.poll();
                    continue;
                }
                if (Tracker.checkIfExpired(mv.p2_policyName) == 0) {
                    try {
                        calcEngine.sendValue(mv);
                        this.queue.poll();
                        Tracker.unregisterMonitor(mv.p2_policyName, 31536000000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                RTLogger.print(3, "Monitor value is expired {" + mv + "} " + System.currentTimeMillis());
                try {
                    this.queue.poll();
                    calcEngine.sendValue(mv);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(2, "Submitter exception ", e);
        }
    }
}

