/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent;

import com.blixx.agent.AgentEngine;
import com.blixx.log.RTLogger;
import com.blixx.shared.BM;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Tracker {
    public static Map<String, Long> m_expectedEvents = new ConcurrentHashMap<String, Long>(500, 0.95f, 3);
    public static Map<String, Long> m_externals = new ConcurrentHashMap<String, Long>(500, 0.95f, 3);
    static Long dummy = new Long(0L);

    public static void registerExternalMonitor(String monitorName) {
        m_externals.put(monitorName, dummy);
    }

    public static void unregisterMonitor(String monitor, long interval) {
        long newExpTime = System.currentTimeMillis() + interval;
        m_expectedEvents.put(monitor, newExpTime);
    }

    public static void registerLastMonitorCall(String taskName, long expTime) {
        if (Tracker.checkIfExpired(taskName) == 1) {
            AgentEngine.getInstance().sendInternalMessageDupl("Monitor does not submit a value during the last polling interval", 2, "MONITOR", taskName);
        }
        m_expectedEvents.put(taskName, expTime);
    }

    public static long getExpirationTime(String monitorName) {
        Long et = m_expectedEvents.get(monitorName);
        if (et == null) {
            return Long.MIN_VALUE;
        }
        return et;
    }

    public static void setExpirationTime(String monitorName, long expTime) {
        m_expectedEvents.put(monitorName, expTime);
    }

    public static int checkIfExpired(String monitorName) {
        int isExpired = -1;
        if (m_externals.containsKey(monitorName)) {
            return 0;
        }
        long et = Tracker.getExpirationTime(monitorName);
        if (et == Long.MIN_VALUE) {
            return isExpired;
        }
        if (System.currentTimeMillis() < et) {
            isExpired = 0;
        } else {
            RTLogger.print(5, monitorName + " ExpirationDate=" + BM.m_sdf.format(new Date(et)));
            isExpired = 1;
        }
        return isExpired;
    }
}

