/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.da;

import com.blixx.agent.da.DaConfig;
import com.blixx.agent.da.IDeviationAnalyzer;
import com.blixx.log.RTLogger;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviationAnalyzer
implements IDeviationAnalyzer {
    static final SeriesAlgorithm series = new SeriesAlgorithm();
    static final IncrementalWeightedAlgorithm increment = new IncrementalWeightedAlgorithm();
    private ConcurrentHashMap<String, Map<String, DataSet>> data = new ConcurrentHashMap();
    private ConcurrentHashMap<String, DaConfig> monitorCfg = new ConcurrentHashMap();
    private String workingDir = "DeviationAnalyzer";
    private double autoSaveThreshold;
    private static final String WEIGHT_SUFFIX = ".weight";
    private static final String COUNT_LIMIT_SUFFIX = ".maxCount";
    private static final String AVERAGE_SUFFIX = ".average";
    private static final String COUNT_SUFFIX = ".count";
    private static final String STDDEV_SUFFIX = ".stdDev";
    private static final String GLOBAL_PREFIX = "DA";
    private static final String OBJ_ID_PREFIX = "DA.object.";
    private static final String MONITOR = ".monitor";
    private static final String DEFAULT = ".default";

    @Override
    public void setConfig(Properties config) {
        if (config.containsKey("DA_WDIR")) {
            this.workingDir = config.getProperty("DA_WDIR");
        }
        this.autoSaveThreshold = Double.parseDouble(config.getProperty("DA_SAVE_THRESHOLD", "0"));
    }

    @Override
    public void init() throws IOException {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".properties") && file.isFile();
            }
        };
        File[] propFiles = new File(this.workingDir).listFiles(filter);
        if (propFiles != null) {
            for (File f : propFiles) {
                this.loadState(f);
            }
        }
    }

    @Override
    public double process(String monitorName, String object, double value) {
        double dist;
        DataSet ds = this.getDataSet(monitorName, object);
        if (ds.count < (long)ds.initialThreshold) {
            dist = series.process(ds, value);
        } else {
            dist = increment.process(ds, value);
            if (this.autoSaveThreshold > 0.0 && Math.abs(dist) > this.autoSaveThreshold) {
                try {
                    this.saveState(monitorName);
                }
                catch (Throwable e) {
                    RTLogger.print(4, "DAerror 102", e);
                }
            }
        }
        return dist;
    }

    @Override
    public void setSeriesDefaultConfig(String monitor, DaConfig config) {
        block2: {
            try {
                config = config.clone();
                config.objectName = null;
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.monitorCfg.put(monitor, config);
    }

    @Override
    public void setSeriesConfig(String monitorName, String object, DaConfig config) {
        this.getDataSet(monitorName, object).setCfg(config);
    }

    @Override
    public DaConfig getDefaultConfig(String monitorName) {
        return this.monitorCfg.get(monitorName);
    }

    @Override
    public List<DaConfig> getConfigs(String monitorName) {
        ArrayList<DaConfig> res = new ArrayList<DaConfig>();
        Map<String, DataSet> map = this.data.get(monitorName);
        if (map != null) {
            res.addAll(map.values());
        }
        return res;
    }

    @Override
    public DaConfig getConfig(String monitorName, String object) {
        Map<String, DataSet> map = this.data.get(monitorName);
        if (map == null) {
            return null;
        }
        return map.get(object);
    }

    @Override
    public DataSet getDataSet(String monitor, String object) {
        DataSet ds;
        Map<String, DataSet> map = this.data.get(monitor);
        if (map == null) {
            map = new HashMap<String, DataSet>();
            this.data.put(monitor, map);
        }
        if ((ds = map.get(object)) == null) {
            ds = new DataSet(monitor, object);
            DaConfig conf = this.monitorCfg.get(monitor);
            if (conf != null) {
                ds.setCfg(conf);
            }
            map.put(object, ds);
        }
        return ds;
    }

    private void saveConfig(Properties p, String prefix, DaConfig cfg) {
        p.setProperty(prefix + WEIGHT_SUFFIX, "" + cfg.weight);
        p.setProperty(prefix + COUNT_LIMIT_SUFFIX, "" + cfg.maxCount);
        p.setProperty(prefix + AVERAGE_SUFFIX, "" + cfg.average);
        p.setProperty(prefix + COUNT_SUFFIX, "" + cfg.count);
        p.setProperty(prefix + STDDEV_SUFFIX, "" + cfg.stdDev);
    }

    public void loadState(File f) throws IOException {
        if (f.canRead()) {
            FileInputStream is = new FileInputStream(f);
            Properties p = new Properties();
            p.load(is);
            ((InputStream)is).close();
            String monitorName = p.getProperty("DA.monitor");
            DaConfig defCfg = new DaConfig();
            if (this.readConfig(p, "DA.default", defCfg)) {
                this.monitorCfg.put(monitorName, defCfg);
            }
            Pattern objId = Pattern.compile("DA.object.(\\d)+");
            for (Object k : p.keySet()) {
                String key;
                Matcher m;
                if (!(k instanceof String) || !(p.get(k) instanceof String) || !(m = objId.matcher(key = (String)k)).matches()) continue;
                int id = Integer.parseInt(m.group(1));
                String objectName = id == 0 ? null : p.getProperty(key);
                DataSet cfg = this.getDataSet(monitorName, objectName);
                this.readConfig(p, "DA." + id, cfg);
            }
        }
    }

    @Override
    public void loadState(String monitorName) throws IOException {
        this.loadState(new File(this.workingDir, "DA_" + monitorName + ".properties"));
    }

    @Override
    public void saveState(String monitorName) throws IOException {
        File f = new File(this.workingDir, "DA_" + monitorName + ".properties");
        f.getParentFile().mkdirs();
        try (FileOutputStream os = new FileOutputStream(f);){
            Map<String, DataSet> map;
            Properties p = new Properties();
            DaConfig defCfg = this.monitorCfg.get(monitorName);
            if (defCfg != null) {
                this.saveConfig(p, "DA.default", defCfg);
            }
            if ((map = this.data.get(monitorName)) != null) {
                int i = 0;
                for (Map.Entry<String, DataSet> e : map.entrySet()) {
                    String prefix = GLOBAL_PREFIX;
                    if (e.getKey() != null) {
                        p.setProperty(OBJ_ID_PREFIX + ++i, e.getKey());
                        prefix = prefix + "." + i;
                    } else {
                        p.setProperty("DA.object.0", "null");
                        prefix = prefix + ".0";
                    }
                    this.saveConfig(p, prefix, e.getValue());
                }
            }
            p.setProperty("DA.monitor", monitorName);
            p.store(os, "DeviationAnalyzer configuration for " + monitorName);
            os.flush();
        }
    }

    @Override
    public void saveState() throws IOException {
        TreeSet monitors = new TreeSet();
        monitors.addAll(this.monitorCfg.keySet());
        monitors.addAll(this.data.keySet());
        for (String mon : monitors) {
            this.saveState(mon);
        }
    }

    private boolean readConfig(Properties p, String prefix, DaConfig cfg) {
        boolean success = false;
        String key = prefix + WEIGHT_SUFFIX;
        if (p.containsKey(key)) {
            cfg.weight = Double.parseDouble(p.getProperty(key));
            success = true;
        }
        if (p.containsKey(key = prefix + COUNT_LIMIT_SUFFIX)) {
            cfg.maxCount = (int)Double.parseDouble(p.getProperty(key));
            success = true;
        }
        if (p.containsKey(key = prefix + AVERAGE_SUFFIX)) {
            cfg.average = Double.parseDouble(p.getProperty(key));
            success = true;
        }
        if (p.containsKey(key = prefix + COUNT_SUFFIX)) {
            cfg.count = (int)Double.parseDouble(p.getProperty(key));
            success = true;
        }
        if (p.containsKey(key = prefix + STDDEV_SUFFIX)) {
            cfg.stdDev = Double.parseDouble(p.getProperty(key));
            success = true;
        }
        return success;
    }

    static double distance(DaConfig stat, double value) {
        return Double.compare(0.0, stat.stdDev) == 0 ? 0.0 : (value - stat.average) / stat.stdDev;
    }

    static class IncrementalWeightedAlgorithm
    implements VarianceAlgorithm {
        IncrementalWeightedAlgorithm() {
        }

        @Override
        public strictfp double process(DataSet stat, double value) {
            double count = stat.count;
            if (count <= 0.0) {
                stat.count = stat.initialThreshold;
                count = stat.count;
            }
            if (stat.count < stat.maxCount) {
                ++stat.count;
            }
            double weight = stat.weight > 0.0 ? stat.weight : (count += 1.0);
            double qDev = weight * stat.stdDev * stat.stdDev * (1.0 - 1.0 / count);
            double q = value - stat.average;
            double r = q / (weight += 1.0);
            stat.stdDev = Math.sqrt((qDev += q * (value - stat.average - r)) / weight * (count / (count - 1.0)));
            stat.average += r;
            return DeviationAnalyzer.distance(stat, value);
        }
    }

    static class SeriesAlgorithm
    implements VarianceAlgorithm {
        SeriesAlgorithm() {
        }

        @Override
        public double process(DataSet stat, double value) {
            if (stat.initialValues == null) {
                assert (stat.count == 0L);
                stat.initialValues = new double[stat.initialThreshold];
            }
            assert (stat.count < (long)stat.initialValues.length);
            stat.initialValues[(int)stat.count++] = value;
            if (stat.count == 1L) {
                stat.average = value;
                return 0.0;
            }
            double sum = 0.0;
            int i = 0;
            while ((long)i < stat.count) {
                sum += stat.initialValues[i];
                ++i;
            }
            double mean = sum / (double)stat.count;
            sum = 0.0;
            int i2 = 0;
            while ((long)i2 < stat.count) {
                double var = stat.initialValues[i2] - mean;
                sum += var * var;
                ++i2;
            }
            stat.average = mean;
            stat.stdDev = Math.sqrt(sum / (double)(stat.count - 1L));
            if ((long)stat.initialValues.length == stat.count) {
                stat.initialValues = null;
            }
            return DeviationAnalyzer.distance(stat, value);
        }
    }

    static interface VarianceAlgorithm {
        public double process(DataSet var1, double var2);
    }

    public static class DataSet
    extends DaConfig
    implements Serializable {
        double[] initialValues;
        public int initialThreshold = 10;

        public DataSet(String monitorName, String object) {
            this.monitorName = monitorName;
            this.objectName = object;
        }

        public void setCfg(DaConfig newCfg) {
            this.average = newCfg.average;
            this.count = newCfg.count;
            this.stdDev = newCfg.stdDev;
            this.maxCount = newCfg.maxCount;
            this.weight = newCfg.weight;
            if (this.count < (long)this.initialThreshold) {
                this.count = this.initialThreshold;
            }
            this.initialValues = null;
        }
    }
}

