/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.math;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class StandardDeviation {
    public static double getStandardDeviation(Collection<Double> col, double average) {
        double res = -1.0;
        Iterator<Double> it = col.iterator();
        double sum = 0.0;
        while (it.hasNext()) {
            double x = it.next();
            sum += Math.pow(x - average, 2.0);
        }
        res = Math.sqrt(sum / (double)col.size());
        return res;
    }

    public static double ajustStandardDeviation(double currentStdev, double currAvrg, double value, long count) {
        double res = -1.0;
        double prevsumd = Math.pow(currentStdev, 2.0) * (double)count;
        double averageNew = StandardDeviation.ajustAverage(currAvrg, value, count);
        double deltaAvrg = averageNew - currAvrg;
        double sum = prevsumd + Math.pow(value - averageNew, 2.0);
        res = Math.sqrt(sum / (double)(count + 1L)) + deltaAvrg * 0.1;
        return res;
    }

    public static double getAverage(Collection<Double> col) {
        Iterator<Double> it = col.iterator();
        double sum = 0.0;
        while (it.hasNext()) {
            double x = it.next();
            sum += x;
        }
        return sum / (double)col.size();
    }

    public static double ajustAverage(double currentAvrg, double value, long counter) {
        return ((double)counter * currentAvrg + value) / (double)(counter + 1L);
    }

    public static void main(String[] args) {
        ArrayList<Double> values = new ArrayList<Double>();
        values.add(2.0);
        values.add(2.0);
        values.add(2.0);
        values.add(10.0);
        values.add(10.0);
        values.add(4.0);
        double avg = StandardDeviation.getAverage(values);
        double stdev = StandardDeviation.getStandardDeviation(values, avg);
        System.out.println(avg + " +- " + stdev);
        System.out.println(StandardDeviation.ajustAverage(avg, 25.0, values.size()));
        System.out.println(StandardDeviation.ajustStandardDeviation(stdev, avg, 25.0, values.size()));
        values.add(25.0);
        avg = StandardDeviation.getAverage(values);
        System.out.println(avg);
        System.out.println(StandardDeviation.getStandardDeviation(values, avg));
        System.out.println("-----------------------------");
        System.out.println(avg + " +- " + stdev);
        values.add(5.0);
        System.out.println(avg + " +- " + stdev);
        values.add(7.0);
        System.out.println(avg + " +- " + stdev);
        values.add(9.0);
        System.out.println(avg + " +- " + stdev);
        avg = StandardDeviation.getAverage(values);
        System.out.println(avg);
        System.out.println(StandardDeviation.getStandardDeviation(values, avg));
        System.exit(0);
        values = new ArrayList();
        values.add(3.0);
        values.add(7.0);
        values.add(7.0);
        values.add(19.0);
        values.add(7.0);
        values.add(7.0);
        values.add(7.0);
        avg = StandardDeviation.getAverage(values);
        System.out.println(avg);
        System.out.println(StandardDeviation.getStandardDeviation(values, avg));
    }
}

