/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.monitors;

import com.blixx.agent.AgentEngine;
import com.blixx.agent.Env;
import com.blixx.agent.MonitorValue;
import com.blixx.agent.utils.IMonitorSubmitListener;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.IPerfMetric;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfStringMetric;
import com.blixx.log.RTLogger;
import com.blixx.shared.PatternB;
import com.blixx.shared.PatternMatchResult;
import com.blixx.shared.PatternMatchTimeout;
import com.blixx.shared.PatternMatcherThread;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Mopeli
implements IMonitorExtPerf,
IMonitorSubmitListener {
    protected static final PatternB NOMATCH = new PatternB("");
    protected static final String PERFCLASS = "@PERFCLASS";
    protected IMonitorSubmitter m_monitorSubmitter = null;
    protected Map<MonObj, Double> m_perfRawValues = new ConcurrentHashMap<MonObj, Double>();
    protected IPerfLog m_perfSubmitter = null;
    protected IMessage m_msgSubmitter = null;
    protected long m_interval = 0L;
    protected String m_monitor = "";
    protected Map<PatternB, String> m_acceptMonitors = new ConcurrentHashMap<PatternB, String>();
    protected Map<String, String> m_stringFields = new ConcurrentHashMap<String, String>();
    protected String m_class = null;
    protected Map<String, PatternB> m_matchedMonitors = new ConcurrentHashMap<String, PatternB>();

    public static Mopeli getInstance(String monitor, String[] params) {
        Mopeli mon = new Mopeli();
        mon.m_monitor = monitor;
        for (String arg : params) {
            if (arg == null) continue;
            String prefix = "@PERFCLASS=";
            if (arg.startsWith(prefix)) {
                mon.m_class = arg.substring(prefix.length());
                continue;
            }
            int eq = arg.indexOf(61);
            String fieldName = arg.substring(0, eq);
            if (fieldName.startsWith("@")) {
                mon.m_stringFields.put(fieldName.substring(1), arg.substring(eq + 1));
                continue;
            }
            PatternB p = new PatternB(arg.substring(eq + 1));
            mon.m_acceptMonitors.put(p, fieldName);
        }
        if (mon.m_class == null || mon.m_class.length() == 0) {
            mon.m_class = monitor.replaceAll("[^\\w]", "");
        }
        AgentEngine.getInstance().getCalcEngine().addMonitorSubmitListener(mon);
        return mon;
    }

    @Override
    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_monitorSubmitter = submitter;
    }

    @Override
    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfSubmitter = submitter;
    }

    @Override
    public void submitMonitorValue(MonitorValue mv) {
        PatternB pattern;
        MonObj mo = new MonObj(mv.p2_policyName, mv.p3_object);
        String mo_string = mo.toString();
        if (!this.m_matchedMonitors.containsKey(mo_string)) {
            this.m_matchedMonitors.put(mo_string, this.checkIfAccepted(mo));
        }
        if ((pattern = this.m_matchedMonitors.get(mo_string)) != NOMATCH) {
            String fieldname = this.m_acceptMonitors.get(pattern);
            mo.setFieldname(fieldname);
            this.m_perfRawValues.put(mo, mv.p0_value);
        }
    }

    public PatternB checkIfAccepted(MonObj mo) {
        String mo_string = mo.toString();
        for (Map.Entry<PatternB, String> en : this.m_acceptMonitors.entrySet()) {
            PatternB p = en.getKey();
            PatternMatchResult txt = PatternMatcherThread.match(p, mo_string, 10000L);
            if (txt == null) {
                throw new PatternMatchTimeout(p.getOvPattern(), mo_string, PatternMatchTimeout.TEXT);
            }
            if (!txt.isMatch()) continue;
            mo.setObjects(txt.getVariableMap());
            return en.getKey();
        }
        return NOMATCH;
    }

    @Override
    public String runMonitor() {
        int countOFMetrics = this.submitPerfNow();
        this.m_monitorSubmitter.submitMonitorValue(this.m_monitor, countOFMetrics, null, null);
        return null;
    }

    private int submitPerfNow() {
        Object p;
        int count = 0;
        long time = System.currentTimeMillis();
        ArrayList<IPerfMetric> metrics = new ArrayList<IPerfMetric>(this.m_perfRawValues.size());
        Iterator<Map.Entry<String, String>> itStrings = this.m_stringFields.entrySet().iterator();
        while (itStrings.hasNext()) {
            try {
                Map.Entry<String, String> en = itStrings.next();
                String rec = en.getValue();
                rec = rec.replace("<$AGENT_HOST>", AgentEngine.getInstance().getAgentHostname());
                rec = rec.replace("<$AGENT_IP>", AgentEngine.getInstance().getAgentIP());
                rec = rec.replace("<$AGENT_ID>", AgentEngine.getInstance().getAgentID());
                for (Map.Entry<String, String> env : Env.getInstance().getVariables().entrySet()) {
                    String envVal = env.getValue();
                    if (envVal == null) continue;
                    rec = rec.replace("<$" + env.getKey() + ">", envVal);
                }
                p = new PerfStringMetric(en.getKey(), rec);
                metrics.add((IPerfMetric)p);
                ++count;
            }
            catch (Throwable e) {
                RTLogger.print(4, "Mopeli Error getting string value", e);
            }
        }
        Iterator<Map.Entry<MonObj, Double>> it = this.m_perfRawValues.entrySet().iterator();
        while (it.hasNext()) {
            try {
                Map.Entry<MonObj, Double> en = it.next();
                Map<String, String> objects = en.getKey().getObjects();
                if (objects != null) {
                    for (Map.Entry<String, String> pair : objects.entrySet()) {
                        PerfStringMetric op = new PerfStringMetric(pair.getKey(), pair.getValue());
                        metrics.add(op);
                        ++count;
                    }
                }
                p = new PerfDoubleMetric(en.getKey().getFieldname(), en.getValue());
                metrics.add((IPerfMetric)p);
                en.setValue(-1.0);
                ++count;
            }
            catch (Throwable e) {
                RTLogger.print(4, "Mopeli Error getting double value", e);
            }
        }
        if (metrics.size() > 0) {
            this.m_perfSubmitter.submitPerfRow(this.m_class, time, metrics);
        }
        return count;
    }

    @Override
    public void setInterval(long ms) {
        this.m_interval = ms;
    }

    @Override
    public void setMessageSubmitter(IMessage submitter) {
        this.m_msgSubmitter = submitter;
    }

    @Override
    public void stop() {
        AgentEngine.getInstance().getCalcEngine().removeMonitorListener(this);
        this.m_acceptMonitors.clear();
        this.m_matchedMonitors.clear();
        this.m_perfRawValues.clear();
    }

    public class MonObj {
        String m_mon;
        String m_obj;
        String m_fieldname = null;
        Map<String, String> m_objects = null;

        public MonObj(String monitor, String object) {
            this.m_mon = monitor;
            this.m_obj = object;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof MonObj) {
                boolean mm;
                MonObj mobj = (MonObj)obj;
                boolean bl = this.m_mon == null ? mobj.m_mon == null : (mm = this.m_mon.equals(mobj.m_mon));
                if (mm) {
                    return this.m_obj == null ? mobj.m_obj == null : this.m_obj.equals(mobj.m_obj);
                }
            }
            return false;
        }

        public int hashCode() {
            int m = this.m_mon == null ? 0 : this.m_mon.hashCode();
            int o = this.m_obj == null ? 0 : this.m_obj.hashCode();
            return m + o;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.m_mon);
            if (this.m_obj != null) {
                sb.append('_').append(this.m_obj);
            }
            return sb.toString();
        }

        public String getMonitor() {
            return this.m_mon;
        }

        public String getObject() {
            return this.m_obj;
        }

        public String getFieldname() {
            return this.m_fieldname;
        }

        public void setFieldname(String fieldname) {
            this.m_fieldname = fieldname;
        }

        public Map<String, String> getObjects() {
            return this.m_objects;
        }

        public void setObjects(Map<String, String> objects) {
            this.m_objects = objects;
        }
    }
}

