/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.agent.netty;

import com.blixx.agent.AgentCertificateHelper;
import com.blixx.agent.AgentEngine;
import com.boom.netty.common.MessageSender;
import com.boom.netty.service.basic.msg.CsrMsg;
import com.boom.netty.service.basic.msg.GetCsrMsg;
import com.boom.netty.ws.mhf.annotation.MessageHandlerMethod;

public class CSRRequestHandler {
    private AgentEngine agentEngine;
    private MessageSender messageSender;

    public CSRRequestHandler(AgentEngine agentEngine, MessageSender messageSender) {
        this.agentEngine = agentEngine;
        this.messageSender = messageSender;
    }

    @MessageHandlerMethod
    public void handle(GetCsrMsg msg) {
        this.agentEngine.getScheduledExecutor().execute(() -> this.sendCSRResponse(msg));
    }

    private void sendCSRResponse(GetCsrMsg msg) {
        CsrMsg csr = new CsrMsg(msg.getSource(), msg.getOperationId(), AgentCertificateHelper.getCertificateRequest());
        this.messageSender.sendMessage(csr);
    }
}

